(function(){"use strict";(function(){const POLICY_READ_WRITE="rw";const POLICY_READ_ONLY="ro";const POLICY_CUSTOM="custom";const POLICY_LABELS={[POLICY_READ_WRITE]:gettext("Full access"),[POLICY_READ_ONLY]:gettext("Read-only"),[POLICY_CUSTOM]:gettext("Custom")};const APITokenItem=RB.Config.ResourceListItem.extend({defaults:_.defaults({policyType:POLICY_READ_WRITE,lastUsed:null,localSiteName:null,showRemove:true},RB.Config.ResourceListItem.prototype.defaults),syncAttrs:["deprecated","expired","expires","id","invalidReason","invalidDate","lastUsed","note","policy","tokenValue","valid"],initialize(){_super(this).initialize.apply(this,arguments);this.on("change:policyType",this._onPolicyTypeChanged,this);const policy=this.get("policy")||{};const policyType=this._guessPolicyType(policy);this._policyMenuAction={id:"policy",label:POLICY_LABELS[policyType],children:[this._makePolicyAction(POLICY_READ_WRITE),this._makePolicyAction(POLICY_READ_ONLY),this._makePolicyAction(POLICY_CUSTOM,{id:"policy-custom",dispatchOnClick:true})]};this.actions.unshift(this._policyMenuAction);this.set("policyType",policyType)},createResource(attrs){return new RB.APIToken(_.defaults({userName:RB.UserSession.instance.get("username"),localSitePrefix:this.collection.localSitePrefix},attrs))},saveExpires(expires){this._saveAttribute("expires",expires)},saveNote(note){this._saveAttribute("note",note)},savePolicy(policy){return this._saveAttribute("policy",policy)},async _saveAttribute(attr,value){await this.resource.ready();this.resource.set(attr,value);await this.resource.save()},_guessPolicyType(policy){if(_.isEqual(policy,RB.APIToken.defaultPolicies.readOnly)){return POLICY_READ_ONLY}else if(_.isEqual(policy,RB.APIToken.defaultPolicies.readWrite)){return POLICY_READ_WRITE}else{return POLICY_CUSTOM}},_makePolicyAction(policyType,options){return _.defaults({label:POLICY_LABELS[policyType],type:"radio",name:"policy-type",propName:"policyType",radioValue:policyType},options)},_onPolicyTypeChanged(){const policyType=this.get("policyType");this._policyMenuAction.label=POLICY_LABELS[policyType];this.trigger("actionsChanged");let newPolicy=null;if(policyType===POLICY_READ_ONLY){newPolicy=RB.APIToken.defaultPolicies.readOnly}else if(policyType===POLICY_READ_WRITE){newPolicy=RB.APIToken.defaultPolicies.readWrite}else{return}console.assert(newPolicy!==null);if(!_.isEqual(newPolicy,this.get("policy"))){this.savePolicy(newPolicy)}}});const APITokenItemCollection=Backbone.Collection.extend({model:APITokenItem,initialize(models,options){this.localSitePrefix=options.localSitePrefix}});const PolicyEditorView=Backbone.View.extend({id:"custom_policy_editor",template:_.template(["<p><%= instructions %></p>","<textarea/>"].join("")),initialize(options){this.prevPolicyType=options.prevPolicyType;this._codeMirror=null;this._$policy=null;this._$saveButtons=null},render(){let policy=this.model.get("policy");if(_.isEmpty(policy)){policy=RB.APIToken.defaultPolicies.custom}this.$el.html(this.template({instructions:interpolate(gettext('You can limit access to the API through a custom policy. See the <a href="%s" target="_blank">documentation</a> on how to write policies.'),[MANUAL_URL+"webapi/2.0/api-token-policy/"])}));this._$policy=this.$("textarea").val(JSON.stringify(policy,null,"  "));this.$el.modalBox({title:gettext("Custom Token Access Policy"),buttons:[$('<input type="button"/>').val(gettext("Cancel")).click(_.bind(this.cancel,this)),$('<input type="button" class="save-button"/>').val(gettext("Save and continue editing")).click(()=>{this.save(false);return false}),$('<input type="button" class="btn primary save-button"/>').val(gettext("Save")).click(()=>{this.save(true);return false})]});this._$saveButtons=this.$el.modalBox("buttons").find(".save-button");this._codeMirror=CodeMirror.fromTextArea(this._$policy[0],{mode:"application/json",lineNumbers:true,lineWrapping:true,matchBrackets:true,lint:{onUpdateLinting:_.bind(this._onUpdateLinting,this)},gutters:["CodeMirror-lint-markers"]});this._codeMirror.focus()},remove(){this.$el.modalBox("destroy")},cancel(){this.model.set("policyType",this.prevPolicyType)},async save(closeOnSave){const policyStr=this._codeMirror.getValue().strip();let policy;try{policy=JSON.parse(policyStr)}catch(e){if(e instanceof SyntaxError){alert(interpolate(gettext("There is a syntax error in your policy: %s"),[e]));return}else{throw e}}try{await this.model.savePolicy(policy);this.model.set("policyType",POLICY_CUSTOM);if(closeOnSave){this.remove()}}catch(err){if(err.xhr.errorPayload.err.code===105&&err.xhr.errorPayload.fields.policy){alert(err.xhr.errorPayload.fields.policy)}else{alert(err.xhr.errorPayload.err.msg)}}},_onUpdateLinting(annotationsNotSorted){this._$saveButtons.prop("disabled",annotationsNotSorted.length>0)}});const APITokenItemView=Djblets.Config.ListItemView.extend({EMPTY_NOTE_PLACEHOLDER:gettext("Click to describe this token"),template:_.template(gettext('<div class="rb-c-config-api-tokens__main"> <div class="rb-c-config-api-tokens__value"> <input readonly="readonly" value="<%- tokenValue %>"> </div> <span class="fa fa-clipboard js-copy-token" title="Copy to clipboard"></span> </div> <div class="rb-c-config-api-tokens__info"> <% if (deprecated) { %> <p class="rb-c-config-api-tokens__deprecation-notice"> This token uses a deprecated format. You should remove it and generate a new one. </p> <% } %> <% if (valid) { %> <% if (lastUsed) { %> <p class="rb-c-config-api-tokens__usage -has-last-used"> Last used <time class="timesince" datetime="<%= lastUsed %>"></time>. </p> <% } else { %> <p class="rb-c-config-api-tokens__usage">Never used.</p> <% } %> <% if (expired) { %> <p class="rb-c-config-api-tokens__token-state -is-expired"> <span>Expired <%= expiresTimeHTML %>.</span> </p> <% } else if (expires) { %> <p class="rb-c-config-api-tokens__token-state -has-expires"> <span>Expires <%= expiresTimeHTML %>.</span> </p> <% } else { %> <p class="rb-c-config-api-tokens__token-state"> <span>Never expires.</span> </p> <% } %> <% } else { %> <p class="rb-c-config-api-tokens__token-state -is-invalid"> Invalidated <time class="timesince" datetime="<%= invalidDate %>"></time>: <%= invalidReason %> </p> <% } %> </div> <div class="rb-c-config-api-tokens__actions"></div> <span class="rb-c-config-api-tokens__note"></span>')),events:{"click .js-copy-token":"_onCopyClicked"},actionHandlers:{delete:"_onRemoveClicked","policy-custom":"_onCustomPolicyClicked"},initialize(){_super(this).initialize.apply(this,arguments);this._$expires=null;this._$note=null;this._$tokenState=null;this.listenTo(this.model.resource,"change:expires",this._updateExpires);this.listenTo(this.model.resource,"change:note",this._updateNote)},render(){_super(this).render.call(this);this._$tokenState=this.$(".rb-c-config-api-tokens__token-state");this._$expires=this._$tokenState.not(".is-invalid").find("span");this._$note=this.$(".rb-c-config-api-tokens__note").inlineEditor({editIconClass:"rb-icon rb-icon-edit"}).on({beginEdit:()=>this._$note.inlineEditor("setValue",this.model.get("note")),complete:(e,value)=>this.model.saveNote(value)});const expires=moment(this.model.get("expires")).local().format("YYYY-MM-DDTHH:mm");const expiresView=new RB.DateTimeInlineEditorView({el:this._$expires[0],descriptorText:"Expires ",formatResult:value=>{if(value){value=moment(value).local().format();const today=moment().local();const expired=today.isAfter(value);const prefix=expired?"Expired":"Expires";if(expired){this._$tokenState.addClass("-is-expired")}return`${prefix}
<time class="timesince" datetime="${value}"></time>.`}else{this._$tokenState.removeClass("-is-expired");return"Never expires."}},rawValue:expires}).on({beginEdit:()=>this._$tokenState.removeClass("-is-expired"),cancel:()=>{if(this.model.get("expired")){this._$tokenState.addClass("-is-expired")}}});expiresView.render();this.listenTo(expiresView,"complete",value=>{value=value?moment(value).local().format():"";this.model.saveExpires(value)});this._updateExpires();this._updateNote();return this},getActionsParent(){return this.$(".rb-c-config-api-tokens__actions")},getRenderContext(){const expires=this.model.get("expires");return{expiresTimeHTML:`<time class="timesince" datetime="${expires}"></time>`}},_updateExpires(){if(this._$expires){const expires=this.model.resource.get("expires");this._$expires.find("time").attr("datetime",expires);this.$(".timesince").timesince()}},_updateNote(){if(this._$note){const note=this.model.resource.get("note");this._$note.toggleClass("empty",!note).text(note?note:this.EMPTY_NOTE_PLACEHOLDER)}},_onCopyClicked(e){e.preventDefault();e.stopPropagation();this.$(".rb-c-config-api-tokens__value input").focus().select();document.execCommand("copy")},_onCustomPolicyClicked(){const view=new PolicyEditorView({model:this.model,prevPolicyType:this.model.get("policyType")});view.render();return false},_onRemoveClicked(){$("<p/>").html(gettext("This will prevent clients using this token when authenticating.")).modalBox({title:gettext("Are you sure you want to remove this token?"),buttons:[$('<input type="button"/>').val(gettext("Cancel")),$('<input type="button" class="danger" />').val(gettext("Remove")).click(()=>this.model.resource.destroy())]})}});const SiteAPITokensView=Backbone.View.extend({className:"rb-c-config-api-tokens",template:_.template(`<% if (name) { %>
 <div class="djblets-l-config-forms-container">
  <h3><%- name %></h3>
 </div>
<% } %>
<div class="api-tokens">
</div>`),generateTokenTemplate:_.template(`<li class="generate-api-token djblets-c-config-forms-list__item">
 <a href="#"><%- generateText %></a>
</li>`),events:{"click .generate-api-token":"_onGenerateClicked"},initialize(options){this.localSiteName=options.localSiteName;this.localSitePrefix=options.localSitePrefix;this.collection=new APITokenItemCollection(options.apiTokens,{localSitePrefix:this.localSitePrefix});this.apiTokensList=new Djblets.Config.List({},{collection:this.collection});this._listView=null},render(){this._listView=new Djblets.Config.ListView({ItemView:APITokenItemView,animateItems:true,model:this.apiTokensList});this.$el.html(this.template({name:this.localSiteName}));this._listView.render().$el.prependTo(this.$(".api-tokens"));this._$generateTokenItem=$(this.generateTokenTemplate({generateText:gettext("Generate a new API token")})).appendTo(this._listView.getBody());return this},async _onGenerateClicked(e){e.preventDefault();e.stopPropagation();const apiToken=new RB.APIToken({localSitePrefix:this.localSitePrefix,userName:RB.UserSession.instance.get("username")});await apiToken.save();this.collection.add({resource:apiToken});this._$generateTokenItem.detach().appendTo(this._listView.getBody())}});RB.APITokensView=Backbone.View.extend({template:_.template(`<div class="api-tokens-list djblets-l-config-forms-container
            -is-recessed -is-top-flush">
</div>`),initialize(options){this.apiTokens=options.apiTokens;this._$listsContainer=null;this._apiTokenViews=[]},render(){this.$el.html(this.template());this._$listsContainer=this.$(".api-tokens-list");for(let[localSiteName,info]of Object.entries(this.apiTokens)){const view=new SiteAPITokensView({localSiteName:localSiteName,localSitePrefix:info.localSitePrefix,apiTokens:info.tokens});view.$el.appendTo(this._$listsContainer);view.render();this._apiTokenViews.push(view)}return this}})})();"use strict";(function(){const GroupMembershipItem=Djblets.Config.ListItem.extend({defaults:_.defaults({localSiteName:null,displayName:null,groupName:null,joined:false,showRemove:false,url:null},Djblets.Config.ListItem.prototype.defaults),initialize(){Djblets.Config.ListItem.prototype.initialize.apply(this,arguments);const name=this.get("name");const localSiteName=this.get("localSiteName");this.set({text:name,editURL:this.get("url")});this.group=new RB.ReviewGroup({id:this.get("reviewGroupID"),name:name,localSitePrefix:localSiteName?"s/"+localSiteName+"/":""});this.on("change:joined",this._updateActions,this);this._updateActions()},async joinGroup(){await this.group.addUser(RB.UserSession.instance.get("username"));this.set("joined",true)},async leaveGroup(){await this.group.removeUser(RB.UserSession.instance.get("username"));this.set("joined",false)},_updateActions(){if(this.get("joined")){this.actions=[{id:"leave",label:gettext("Leave")}]}else{this.actions=[{id:"join",label:gettext("Join")}]}this.trigger("actionsChanged")}});const GroupMembershipItemView=Djblets.Config.ListItemView.extend({actionHandlers:{join:"_onJoinClicked",leave:"_onLeaveClicked"},template:_.template(['<span class="config-group-name">',' <a href="<%- editURL %>"><%- text %></a>',"</span>",'<span class="config-group-display-name"><%- displayName %></span>'].join("")),_onJoinClicked(){this.model.joinGroup()},_onLeaveClicked(){this.model.leaveGroup()}});const SiteGroupsView=Backbone.View.extend({template:_.template(`<% if (name) { %>
 <div class="djblets-l-config-forms-container">
  <h3><%- name %></h3>
 </div>
<% } %>
<div class="groups"></div>`),initialize(options){this.name=options.name;this.collection=new RB.FilteredCollection(null,{collection:new Backbone.Collection(options.groups,{model:GroupMembershipItem})});this.groupList=new Djblets.Config.List({},{collection:this.collection})},render(){this._listView=new Djblets.Config.ListView({ItemView:GroupMembershipItemView,model:this.groupList});this.$el.html(this.template({name:this.name}));this._listView.render();this._listView.$el.appendTo(this.$(".groups"));return this},filterBy(name){this.collection.setFilters({name:name});this.$el.setVisible(this.collection.length>0)}});RB.JoinedGroupsView=Backbone.View.extend({template:_.template(`<div class="djblets-l-config-forms-container">
 <div class="rb-c-search-field">
  <span class="fa fa-search"></span>
  <input class="rb-c-search-field__input" type="search">
 </div>
</div>
<div class="group-lists"></div>`),events:{submit:"_onSubmit","keyup .rb-c-search-field__input":"_onGroupSearchChanged","change .rb-c-search-field__input":"_onGroupSearchChanged"},initialize(options){this.groups=options.groups;this._$listsContainer=null;this._$search=null;this._searchText=null;this._groupViews=[]},render(){this.$el.html(this.template());this._$listsContainer=this.$(".group-lists");this._$search=this.$(".rb-c-search-field__input");for(let[localSiteName,groups]of Object.entries(this.groups)){if(groups.length>0){const view=new SiteGroupsView({name:localSiteName,groups:groups});view.$el.appendTo(this._$listsContainer);view.render();this._groupViews.push(view)}}return this},_onGroupSearchChanged(){const text=this._$search.val();if(text!==this._searchText){this._searchText=text;this._groupViews.forEach(view=>view.filterBy(this._searchText))}},_onSubmit(e){e.preventDefault()}})})();"use strict";(function(){const addApplicationText=gettext("Add application");const disabledForSecurityText=gettext("Disabled for security.");const disabledWarningTemplate=gettext('This application has been disabled because the user "%s" has been removed from the Local Site.');const emptyText=gettext("You have not registered any OAuth2 applications.");const localSiteEmptyText=gettext("You have not registered any OAuth2 applications on %s.");const OAuthAppItem=Djblets.Config.ListItem.extend({defaults:_.defaults({apiURL:"",editURL:"",enabled:true,isDisabledForSecurity:false,localSiteName:"",name:"",originalUser:null,showRemove:true},Djblets.Config.ListItem.prototype.defaults),parse(rsp,options){const{baseEditURL,baseURL}=options;const{localSiteName}=rsp;return _.defaults(rsp,{apiURL:localSiteName?`/s/${localSiteName}${baseURL}${rsp.id}/`:`${baseURL}${rsp.id}/`,editURL:`${baseEditURL}/${rsp.id}/`})}});const OAuthAppItemView=Djblets.Config.ListItemView.extend({template:_.template(`<div class="app-entry-wrapper">
 <span class="config-app-name<% if (!enabled) {%> disabled<% } %>">
  <% if (isDisabledForSecurity) { %>
    <span class="rb-icon rb-icon-warning"
          title="${disabledForSecurityText}"></span>
  <% } %>
  <a href="<%- editURL %>"><%- name %></a>
 </span>
 <% if (isDisabledForSecurity) { %>
   <p class="disabled-warning"><%- disabledWarning %></p>
  <% } %>
 </div>`),actionHandlers:{delete:"_onDeleteClicked"},getRenderContext(){return{disabledWarning:interpolate(disabledWarningTemplate,[this.model.get("originalUser")])}},_onDeleteClicked(){RB.apiCall({url:this.model.get("apiURL"),method:"DELETE",success:()=>this.model.trigger("destroy")})}});RB.OAuthApplicationsView=Backbone.View.extend({template:_.template(`<div class="app-lists"></div>
<div class="oauth-form-buttons djblets-l-config-forms-container">
 <a class="btn oauth-add-app" href="<%- editURL %>">
  ${addApplicationText}
 </a>
</div>`),listTemplate:_.template(`<div>
 <% if (localSiteName) { %>
  <div class="djblets-l-config-forms-container">
   <h2><%- localSiteName %></h2>
  </div>
 <% } %>
 <div class="app-list">
  <div class="djblets-l-config-forms-container">
   <%- emptyText %>
  </div>
 </div>
</div>`),initialize(options){this.collections=new Map(Object.entries(options.apps).map(_ref=>{let[localSiteName,apps]=_ref;return[localSiteName||null,new Backbone.Collection(apps,{model:OAuthAppItem,parse:true,baseEditURL:options.editURL,baseURL:options.baseURL})]}));this._editURL=options.editURL;window.view=this},_renderAppList(localSiteName,collection){const $entry=$(this.listTemplate({emptyText:localSiteName?interpolate(localSiteEmptyText,[localSiteName]):emptyText,localSiteName:localSiteName}));const listView=new Djblets.Config.ListView({ItemView:OAuthAppItemView,model:new Djblets.Config.List({},{collection:collection})});listView.render().$el.prependTo($entry.find(".app-list"));return $entry},render(){this.$el.html(this.template({editURL:this._editURL}));const $lists=this.$(".app-lists");this.collections.forEach((collection,localSiteName)=>{const $entry=this._renderAppList(localSiteName,collection);if(localSiteName){$lists.append($entry)}else{$lists.prepend($entry)}});return this}})})();"use strict";(function(){const xhrUnknownErrorText=gettext("An unexpected error occurred. Could not delete OAuth2 token.");const OAuthTokenItem=Djblets.Config.ListItem.extend({defaults:_.defaults({apiURL:"",application:"",showRemove:true},Djblets.Config.ListItem.prototype.defaults)});const OAuthTokenItemView=Djblets.Config.ListItemView.extend({template:_.template(`<span class="config-token-name"><%- application %></span>`),actionHandlers:{delete:"_onDeleteClicked"},_onDeleteClicked(){RB.apiCall({url:this.model.get("apiURL"),method:"DELETE",success:()=>this.model.trigger("destroy")})}});RB.OAuthTokensView=Backbone.View.extend({template:_.template(`<div class="oauth-token-list">
 <div class="djblets-l-config-forms-container -is-top-flush">
  <%- emptyText %>
 </div>
</div>`),initialize(options){this.collection=new Backbone.Collection(options.tokens,{model:OAuthTokenItem})},render(){this.$el.html(this.template({emptyText:gettext("You do not have any OAuth2 tokens.")}));this._$list=this.$(".oauth-token-list");this._listView=new Djblets.Config.ListView({ItemView:OAuthTokenItemView,model:new Djblets.Config.List({},{collection:this.collection})});this._listView.render().$el.prependTo(this._$list);return this}})})()}).call(this);
