(function(){"use strict";(function(){if(typeof window.console==="undefined"){window.console={}}if(typeof console.log==="undefined"){console.log=function(){}}if(typeof console.warn==="undefined"){console.warn=function(){}}if(typeof console.error==="undefined"){console.error=function(){}}const _origAssert=console.assert;console.assert=function(conditional,msg){if(_origAssert&&_origAssert.call){_origAssert.call(console,conditional,msg)}if(!conditional){throw new Error(msg)}}})();"use strict";_.bindCallbacks=function(callbacks,context){let methodNames=arguments.length>2&&arguments[2]!==undefined?arguments[2]:["success","error","complete"];if(!context){return callbacks}const wrappedCallbacks={};for(let[key,value]of Object.entries(callbacks)){if(methodNames.includes(key)&&_.isFunction(value)){wrappedCallbacks[key]=_.bind(value,context)}}return _.defaults(wrappedCallbacks,callbacks)};_.deferred=function(func){return()=>{_.defer(func)}};_.throttleLayout=function(layoutFunc){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let handlingLayout=false;return function(){if(handlingLayout){return}const context=this;const args=arguments;handlingLayout=true;let cb=()=>{layoutFunc.apply(context,args);handlingLayout=false};if(options.defer){cb=_.deferred(cb)}requestAnimationFrame(cb)}};window._super=function(obj){return Object.getPrototypeOf(Object.getPrototypeOf(obj))};"use strict";window.RB={};$(document).ready(function(){$(".user").user_infobox();$(".bug").bug_infobox();$(".review-request-link").review_request_infobox();$("time.timesince").timesince();Djblets.enableRetinaImages()});"use strict";RB.APIErrors={NO_ERROR:0,SERVICE_NOT_CONFIGURED:1,DOES_NOT_EXIST:100,PERMISSION_DENIED:101,INVALID_ATTRIBUTE:102,NOT_LOGGED_IN:103,LOGIN_FAILED:104,INVALID_FORM_DATA:105,MISSING_ATTRIBUTE:105,ENABLE_EXTENSION_FAILED:107,DISABLE_EXTENSION_FAILED:108,EXTENSION_INSTALLED:109,INSTALL_EXTENSION_FAILED:110,UNSPECIFIED_DIFF_REVISION:200,INVALID_DIFF_REVISION:201,INVALID_ACTION:202,INVALID_CHANGE_NUMBER:203,CHANGE_NUMBER_IN_USE:204,MISSING_REPOSITORY:205,INVALID_REPOSITORY:206,REPO_FILE_NOT_FOUND:207,INVALID_USER:208,REPO_NOT_IMPLEMENTED:209,REPO_INFO_ERROR:210,NOTHING_TO_PUBLISH:211,EMPTY_CHANGESET:212,SERVER_CONFIG_ERROR:213,BAD_HOST_KEY:214,UNVERIFIED_HOST_KEY:215,MISSING_USER_KEY:217,REPO_AUTHENTICATION_ERROR:218,DIFF_EMPTY:219,DIFF_TOO_BIG:220,FILE_RETRIEVAL_ERROR:221,HOSTINGSVC_AUTH_ERROR:222,GROUP_ALREADY_EXISTS:223,DIFF_PARSE_ERROR:224};"use strict";$.ajaxTransport("arraybuffer blob",function(options,origOptions,jqXHR){if(!window.FormData){return null}let xhr;return{send(headers,completeCB){xhr=options.xhr();xhr.addEventListener("load",()=>{const result={};result[options.dataType]=xhr.response;completeCB(xhr.status,xhr.statusText,result,xhr.getAllResponseHeaders())});if(options.username){xhr.open(options.type,options.url,options.async,options.username,options.password)}else{xhr.open(options.type,options.url,options.async)}xhr.responseType=options.dataType;const xhrFields=options.xhrFields;if(xhrFields){for(let field in xhrFields){if(xhrFields.hasOwnProperty(field)){xhr[field]=xhrFields[field]}}}if(!options.crossDomain&&!headers["X-Requested-With"]){headers["X-Requested-With"]="XMLHttpRequest"}try{for(let key in headers){if(headers.hasOwnProperty(key)){xhr.setRequestHeader(key,headers[key])}}}catch(e){}xhr.send(options.hasContent?options.data:null)},abort(){if(xhr&&xhr.readyState!==4){xhr.abort()}}}});RB.setActivityIndicator=function(enabled,options){const $activityIndicator=options._$activityIndicator||$("#activity-indicator");if(enabled){if(RB.ajaxOptions.enableIndicator&&!options.noActivityIndicator){$activityIndicator.children(".indicator-text").text(options.type&&options.type==="GET"?gettext("Loading..."):gettext("Saving..."));$activityIndicator.removeClass("error").show()}}else if(RB.ajaxOptions.enableIndicator&&!options.noActivityIndicator&&!$activityIndicator.hasClass("error")){if(options._activityIndicatorHideImmediately){$activityIndicator.hide()}else{$activityIndicator.delay(250).fadeOut("fast")}}};RB.apiCall=function(options){const prefix=options.prefix||"";const url=options.url||SITE_ROOT+prefix+"api"+options.path;function showErrorPage(xhr,data){const $iframe=$("<iframe/>").width("100%");const requestData=options.data?$.param(options.data):"(none)";$('<div class="server-error-box"/>').appendTo(document.body).append("<p><b>"+gettext("Error Code:")+"</b> "+xhr.status+"</p>").append("<p><b>"+gettext("Error Text:")+"</b> "+xhr.statusText+"</p>").append("<p><b>"+gettext("Request URL:")+"</b> "+url+"</p>").append("<p><b>"+gettext("Request Data:")+"</b> "+requestData+"</p>").append('<p class="response-data"><b>'+gettext("Response Data:")+"</b></p>").append(gettext('<p>There may be useful error details below. The following error page may be useful to your system administrator or when <a href="https://www.reviewboard.org/bugs/new/">reporting a bug</a>. To save the page, right-click the error below and choose "Save Page As," if available, or "View Source" and save the result as a <tt>.html</tt> file.</p>')).append(gettext("<p><b>Warning:</b> Be sure to remove any sensitive material that may exist in the error page before reporting a bug!</p>")).append($iframe).on("resize",function(){$iframe.height($(this).height()-$iframe.position().top)}).modalBox({stretchX:true,stretchY:true,title:gettext("Server Error Details")});const doc=$iframe[0].contentDocument||$iframe[0].contentWindow.document;doc.open();doc.write(data);doc.close()}function doCall(){const $activityIndicator=options._$activityIndicator||$("#activity-indicator");if(options.buttons){options.buttons.attr("disabled",true)}RB.setActivityIndicator(true,options);const defaultOptions={url:url,data:options.data,dataType:options.dataType||"json",error:function(xhr,textStatus,errorThrown){const responseText=xhr.responseText;let rsp=null;try{rsp=JSON.parse(responseText)}catch(e){}if(rsp&&rsp.stat||xhr.status===204){if(_.isFunction(options.success)){options.success(rsp,xhr.status)}return}$activityIndicator.addClass("error").text(gettext("A server error occurred.")).append($('<a href="#" />').text(gettext("Show Details")).click(()=>showErrorPage(xhr,responseText))).append($('<a href="#" />').text(gettext("Dismiss")).click(function(){$activityIndicator.fadeOut("fast");return false}));if(_.isFunction(options.error)){options.error(xhr,textStatus,errorThrown)}}};const forcedOptions={complete:function(xhr,status){if(options.buttons){options.buttons.attr("disabled",false)}RB.setActivityIndicator(false,options);if(_.isFunction(options.complete)){options.complete(xhr,status)}$.funcQueue("rbapicall").next()}};const data=$.extend(true,defaultOptions,options,forcedOptions);if(data.data===null||data.data===undefined||data.data instanceof Object&&!(window.Blob&&data.data instanceof Blob)){data.data=$.extend({api_format:"json"},data.data||{})}if(options.form){options.form.ajaxSubmit(data)}else{$.ajax(data)}}options.type=options.type||"POST";if(options.type!=="GET"&&options.type!=="HEAD"&&RB.UserSession.instance.get("readOnly")){console.error("%s request not sent. Site is in read-only mode.",options.type);return}if(RB.ajaxOptions.enableQueuing&&options.type!=="GET"){$.funcQueue("rbapicall").add(doCall);$.funcQueue("rbapicall").start()}else{doCall()}};RB.storeAPIError=function(xhr){try{const rsp=JSON.parse(xhr.responseText);xhr.errorPayload=rsp;xhr.errorText=rsp.err.msg}catch(e){xhr.errorPayload=null;xhr.errorText="HTTP "+xhr.status+" "+xhr.statusText}};RB.ajaxOptions={enableQueuing:true,enableIndicator:true};Backbone.ajax=options=>RB.apiCall(options);class BackboneError extends Error{constructor(modelOrCollection,xhr,options){super(xhr.errorText);this.modelOrCollection=modelOrCollection;this.xhr=xhr;this.options=options}}RB.promiseToCallbacks=function(options,context,callable){const success=_.isFunction(options.success)?options.success:_.isFunction(options.ready)?options.ready:undefined;const error=_.isFunction(options.error)?options.error:undefined;const complete=_.isFunction(options.complete)?options.complete:undefined;callable(_.omit(options,["success","ready","error","complete"])).then(result=>{if(success){success.call(context,result)}}).catch(err=>{if(error){error.call(context,err.modelOrCollection,err.xhr,err.options)}}).finally(()=>{if(complete){complete.call(context)}})};"use strict";RB.DataUtils={ArrayBufferTypes:{int8:{size:1,funcName:"setInt8"},uint8:{size:1,funcName:"setUint8"},int16:{size:2,funcName:"setInt16"},uint16:{size:2,funcName:"setUint16"},int32:{size:4,funcName:"setInt32"},uint32:{size:4,funcName:"setUint32"},float32:{size:4,funcName:"setFloat32"},float64:{size:8,funcName:"setFloat64"}},readBlobAsArrayBuffer(blob,onLoaded){RB.DataUtils._readBlobAs("readAsArrayBuffer",blob,onLoaded)},readBlobAsString(blob,onLoaded){RB.DataUtils._readBlobAs("readAsText",blob,onLoaded)},readManyBlobsAsArrayBuffers(blobs,onLoaded){RB.DataUtils._readManyBlobsAs("readBlobAsArrayBuffer",blobs,onLoaded)},readManyBlobsAsStrings(blobs,onLoaded){RB.DataUtils._readManyBlobsAs("readBlobAsString",blobs,onLoaded)},buildArrayBuffer(schema){const ArrayBufferTypes=RB.DataUtils.ArrayBufferTypes;let arrayLen=0;for(let i=0;i<schema.length;i++){const item=schema[i];arrayLen+=ArrayBufferTypes[item.type].size*item.values.length}const arrayBuffer=new ArrayBuffer(arrayLen);const dataView=new DataView(arrayBuffer);let pos=0;for(let i=0;i<schema.length;i++){const item=schema[i];const values=item.values;const littleEndian=!item.bigEndian;const typeInfo=ArrayBufferTypes[item.type];const func=dataView[typeInfo.funcName];const size=typeInfo.size;for(let j=0;j<values.length;j++){func.call(dataView,pos,values[j],littleEndian);pos+=size}}return arrayBuffer},buildBlob(schema){const parts=[];for(let i=0;i<schema.length;i++){const schemaItem=schema[i];if(_.isArray(schemaItem)){parts.push(RB.DataUtils.buildArrayBuffer(schemaItem))}else{parts.push(schemaItem)}}return new Blob(parts)},_readBlobAs(readFuncName,blob,onLoaded){const reader=new FileReader;reader.addEventListener("loadend",()=>onLoaded(reader.result));reader[readFuncName](blob)},_readManyBlobsAs(readFuncName,blobs,onLoaded){const loadFunc=RB.DataUtils[readFuncName];let result=new Array(blobs.length);let numLoaded=0;function onBlobLoaded(i,text){result[i]=text;numLoaded++;if(numLoaded===blobs.length){onLoaded.apply(null,result)}}blobs.forEach((blob,i)=>{loadFunc(blob,text=>onBlobLoaded(i,text))})}};"use strict";RB.LinkifyUtils={URL_RE:new RegExp("\\b(("+["https://","http://","ftp://","ftps://","gopher://","mailto:","news:","sms:"].join("|")+")[\\-A-Za-z0-9+&@#/%?=~_()|!:,.;]*([\\-A-Za-z0-9+@#/%=~_();|]|))","g"),linkifyURLs(text){return text.replace(RB.LinkifyUtils.URL_RE,function(url){const parts=url.match(/^(.*)(&[a-z]+;|\))$/);const openParen=url.match(/.*\(.*/);let extra="";if(parts!==null&&openParen===null){url=parts[1];extra=parts[2]}return`<a target="_blank" href="${url}">${url}</a>${extra}`})},linkifyReviewRequests(text){return text.replace(/(^|\s|&lt;|\(|\[|{)\/(r\/\d+(\/[\-A-Za-z0-9+&@#\/%?=~_()|!:,.;]*[\-A-Za-z0-9+&@#\/%=~_()|]*)?)/g,function(text,m1,m2){const parts=m2.match(/^(.*)(&[a-z]+;|\))$/);let extra="";let url=m2;if(parts!==null){url=parts[1];extra=parts[2]}const href=SITE_ROOT+url+(url.substr(-1)==="/"?"":"/");return`${m1}<a target="_blank" href="${href}" class="review-request-link">/${url}</a>${extra}`})},linkifyBugs(text,bugTrackerURL){if(bugTrackerURL){return text.replace(/\b(bug|issue) (#([^.,)\]\s]+)|#?(\d+))/gi,function(text,m2,m3,bugnum1,bugnum2){const bugnum=bugnum1||bugnum2;const href=bugTrackerURL.replace("--bug_id--",bugnum);return`<a target="_blank" href="${href}">${text}</a>`})}else{return text}},linkifyText(text,bugTrackerURL,isHTMLEncoded){if(!isHTMLEncoded){text=text.htmlEncode()}text=RB.LinkifyUtils.linkifyURLs(text);text=RB.LinkifyUtils.linkifyReviewRequests(text);text=RB.LinkifyUtils.linkifyBugs(text,bugTrackerURL);return text},linkifyChildren(el,bugTrackerURL){for(let i=0;i<el.childNodes.length;i++){const node=el.childNodes[i];if(node.nodeType===node.TEXT_NODE){if(node.textContent){const newText=RB.LinkifyUtils.linkifyText(node.textContent,bugTrackerURL);if(newText!==node.textContent){$(node).replaceWith(newText)}}}else if(node.nodeType===node.ELEMENT_NODE){if(node.nodeName!=="PRE"&&node.nodeName!=="A"){RB.LinkifyUtils.linkifyChildren(node,bugTrackerURL)}}}}};"use strict";RB.MathUtils={clip(value,minValue,maxValue){return Math.min(maxValue,Math.max(minValue,value))}};"use strict";RB.KeyBindingsMixin={delegateKeyBindings(){this.$el.on(`keypress.keybindings.${this.cid}`,_.bind(function(evt){if(evt.altKey||evt.ctrlKey||evt.metaKey||evt.target.tagName==="INPUT"||evt.target.tagName==="TEXTAREA"||evt.target.isContentEditable){return}const keyChar=String.fromCharCode(evt.which);for(let keys of Object.keys(this.keyBindings)){if(keys.indexOf(keyChar)!==-1){evt.stopPropagation();evt.preventDefault();let func=this.keyBindings[keys];if(!_.isFunction(func)){func=this[func]}func.call(this,evt)}}},this))},undelegateKeyBindings(){if(this.$el){this.$el.off(`keypress.keybindings.${this.cid}`)}},delegateEvents(events){const result=Backbone.View.prototype.delegateEvents.call(this,events);this.delegateKeyBindings();return result},undelegateEvents(){const result=Backbone.View.prototype.undelegateEvents.call(this);this.undelegateKeyBindings();return result}};"use strict";RB.getLocationHash=function(url){if(url===undefined){url=window.location.href}const rawHash=url.split("#")[1]||"";const decodedHash=decodeURIComponent(rawHash);if(!decodedHash.match(/^[A-Za-z0-9,_\.-]*$/)){console.warn('Ignoring location hash "%s".',rawHash);return""}return decodedHash};RB.navigateTo=function(url){window.location=url};"use strict";RB.BaseCollection=Backbone.Collection.extend({fetch:function(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)){console.warn("RB.BaseCollection.fetch was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.fetch(newOptions))}return new Promise((resolve,reject)=>{Backbone.Collection.prototype.fetch.call(this,_.defaults({success:result=>resolve(result),error:(model,xhr,options)=>reject(new BackboneError(model,xhr,options))},options))})},sync(method,model){let options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};return Backbone.sync.call(this,method,model,_.defaults({error:xhr=>{RB.storeAPIError(xhr);if(_.isFunction(options.error)){options.error(xhr)}}},options))}});"use strict";RB.FilteredCollection=RB.BaseCollection.extend({initialize(models,options){this.collection=options.collection;this.filters=options.filters;this.listenTo(this.collection,"add",this._onItemAdded);this.listenTo(this.collection,"remove",this.remove);this.listenTo(this.collection,"reset",this._rebuild);this._rebuild()},setFilters(filters){this.filters=filters;this._rebuild()},_onItemAdded(item){if(this._passesFilters(item,true)){this.add(item)}},_rebuild(){if(_.isEmpty(this.filters)){this.reset(this.collection.models)}else{this.reset(this.collection.filter(this._passesFilters,this))}},_passesFilters(item,checkEmpty){if(checkEmpty&&(!this.filters||_.isEmpty(this.filters))){return true}return _.every(this.filters,(value,key)=>{const attrValue=item.get(key);if(_.isString(value)){return attrValue.indexOf(value)===0}else{return attrValue===value}})}});"use strict";RB.Extension=Djblets.Extension;RB.ExtensionHook=Djblets.ExtensionHook;RB.ExtensionHookPoint=Djblets.ExtensionHookPoint;"use strict";RB.CommentDialogHook=RB.ExtensionHook.extend({hookPoint:new RB.ExtensionHookPoint,defaults:_.defaults({viewType:null},RB.ExtensionHook.prototype.defaults),setUpHook(){console.assert(this.get("viewType"),"CommentDialogHook instance does not have a "+'"viewType" attribute set.')}});"use strict";RB.ReviewDialogCommentHook=RB.ExtensionHook.extend({hookPoint:new RB.ExtensionHookPoint,defaults:_.defaults({viewType:null},RB.ExtensionHook.prototype.defaults),setUpHook(){console.assert(this.get("viewType"),"ReviewDialogCommentHook instance does not have a "+'"viewType" attribute set.')}});"use strict";RB.ReviewDialogHook=RB.ExtensionHook.extend({hookPoint:new RB.ExtensionHookPoint,defaults:_.defaults({viewType:null},RB.ExtensionHook.prototype.defaults),setUpHook(){console.assert(this.get("viewType"),"ReviewDialogHook instance does not have a "+'"viewType" attribute set.')}});"use strict";RB.ReviewRequestActionHook=RB.ExtensionHook.extend({hookPoint:new RB.ExtensionHookPoint,defaults:_.defaults({callbacks:null},RB.ExtensionHook.prototype.defaults),setUpHook(){console.assert(this.get("callbacks"),"ReviewRequestActionHook instance does not have a "+'"callbacks" attribute set.')}});"use strict";RB.PageManager=Backbone.Model.extend({defaults:{page:null,rendered:false},initialize(){this.once("change:page",()=>{this.trigger("beforeRender");if(document.readyState==="complete"){this._renderPage()}else{$(this._renderPage.bind(this))}})},beforeRender(cb,context){console.assert(!this.get("rendered"),"beforeRender called after page was rendered");const page=this.get("page");if(page){cb.call(context,page)}else{this.once("beforeRender",()=>cb.call(context,this.get("page")))}},ready(cb,context){const page=this.get("page");if(page&&this.get("rendered")){cb.call(context,page)}else{this.once("change:rendered",()=>cb.call(context,this.get("page")))}},_renderPage(){this.get("page").render();const headerView=RB.HeaderView.instance;if(!headerView.isRendered){headerView.render()}this.set("rendered",true)}},{instance:null,setupPage(options){const curPage=this.getPage();if(curPage!==null){console.warn(["A subclass of RB.PageView has already been set up in the ","PageManager. This might be an older template manually ","instantiating a PageView.\n","\n","Please update your template to use the js-page-view-type, ","js-page-view-options, js-page-model-type, ","js-page-model-type, and js-page-model-options blocks.\n","\n","Make sure they also call the parent initialize() method and ","override renderPage() instead of render().\n","\n","Support for legacy page registration is deprecated and will ","be removed in Review Board 5.0."].join(""));if(RB.HeaderView.instance===null){new RB.HeaderView({el:$("#headerbar")})}}else{const pageView=new options.viewType(_.extend({el:document.body,model:new options.modelType(options.modelAttrs,options.modelOptions)},options.viewOptions));this.setPage(pageView)}},beforeRender(cb,context){this.instance.beforeRender(cb,context)},ready(cb,context){this.instance.ready(cb,context)},setPage(page){this.instance.set("page",page)},getPage(){return this.instance.get("page")}});RB.PageManager.instance=new RB.PageManager;"use strict";RB.Page=Backbone.Model.extend();"use strict";RB.PageView=Backbone.View.extend({windowResizeThrottleMS:100,initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this.options=options;this.$window=$(window);this.$pageContainer=null;this.$pageContent=null;this.$mainSidebar=null;this._$pageSidebar=null;this._$mainSidebarPane=null;this.hasSidebar=null;this.isFullPage=null;this.inMobileMode=null;this.isPageRendered=false;this.drawer=null;this.headerView=null},remove(){if(this.$window){this.$window.off("resize.rbPageView")}if(this.headerView){this.headerView.remove()}Backbone.View.prototype.remove.call(this)},render(){const options=this.options;const $body=options.$body||$(document.body);this.$pageContainer=options.$pageContainer||$("#page-container");this.$pageContent=options.$pageContent||$("#content");this._$pageSidebar=options.$pageSidebar||$("#page-sidebar");this._$pageSidebarPanes=this._$pageSidebar.children(".rb-c-page-sidebar__panes");this._$mainSidebarPane=this._$pageSidebarPanes.children(".rb-c-page-sidebar__pane.-is-shown");this.$mainSidebar=this._$mainSidebarPane.children(".rb-c-page-sidebar__pane-content");this.headerView=new RB.HeaderView({el:options.$headerBar||$("#headerbar"),$body:$body,$pageSidebar:this._$pageSidebar});this.headerView.render();this.hasSidebar=$body.hasClass("-has-sidebar")||$body.hasClass("has-sidebar");this.isFullPage=$body.hasClass("-is-content-full-page")||$body.hasClass("full-page-content");this.inMobileMode=this.headerView.inMobileMode;this.renderPage();if(this.isFullPage){this._$mainSidebarPane.show();this.$pageContainer.show()}this.$window.on("resize.rbPageView",_.throttle(()=>this._updateSize(),this.windowResizeThrottleMS));this.listenTo(this.headerView,"mobileModeChanged",this._onMobileModeChanged);this._onMobileModeChanged(this.inMobileMode);this.isPageRendered=true;return this},setDrawer(drawer){console.assert(this.drawer===null,"A drawer has already been set up for this page.");console.assert(this.hasSidebar,"Drawers can only be set up on pages with a sidebar.");this.drawer=drawer;drawer.render();this._reparentDrawer();this.listenTo(drawer,"visibilityChanged",this._updateSize)},renderPage(){},resizeElementForFullHeight($el,$parent){if($parent===undefined){$parent=this.$pageContainer}$el.outerHeight($parent.height()-$el.position().top)},onResize(){},onMobileModeChanged(inMobileMode){},_updateSize(){const windowHeight=this.$window.height();let pageContainerHeight=null;let sidebarHeight=null;if(this.isFullPage){pageContainerHeight=windowHeight-this.$pageContainer.offset().top}if(this.inMobileMode){if(pageContainerHeight!==null&&this.drawer!==null&&this.drawer.isVisible){pageContainerHeight-=this.drawer.$el.outerHeight()}}else{if(pageContainerHeight!==null){sidebarHeight=windowHeight-this._$pageSidebar.offset().top}}if(pageContainerHeight===null){this.$pageContainer.css("height","")}else{this.$pageContainer.outerHeight(pageContainerHeight)}if(sidebarHeight===null){this._$pageSidebar.css("height","")}else{this._$pageSidebar.outerHeight(sidebarHeight)}this.onResize()},_reparentDrawer(){const $el=this.drawer.$el.detach();if(this.inMobileMode){$el.insertBefore(this._$pageSidebar)}else{$el.appendTo(this._$pageSidebarPanes)}},_onMobileModeChanged(inMobileMode){this.inMobileMode=inMobileMode;this._updateSize();if(this.drawer!==null){this._reparentDrawer()}this.onMobileModeChanged(this.inMobileMode);this.trigger("inMobileModeChanged",this.inMobileMode)}});"use strict";RB.ExtraData=Backbone.Model.extend({toJSON(){const data={};_.each(this.attributes,(value,key)=>{data[`extra_data.${key}`]=value});return data}});"use strict";RB.ExtraDataMixin={_setupExtraData(){this.extraData=new RB.ExtraData;this.extraData.attributes=this.attributes.extraData;this.listenTo(this.extraData,"change",this._onExtraDataChanged)},set(key,value,options){let attrs;if(_.isObject(key)){attrs=key;options=value}else{attrs={};attrs[key]=value}const useExtraData=_.has(attrs,"extraData")&&_.has(this,"extraData");if(useExtraData){if(attrs.extraData instanceof RB.ExtraData){attrs.extraData=_.clone(attrs.extraData.attributes)}}Backbone.Model.prototype.set.call(this,attrs,options);if(useExtraData){this.extraData.attributes=this.attributes.extraData}return this},_onExtraDataChanged(extraData,options){this.trigger("change:extraData",this,extraData,options);this.trigger("change",this,options)},getExtraData(key){return this.extraData.get(key)},setExtraData(key,value){this.extraData.set(key,value)}};"use strict";RB.JSONSerializers={onlyIfUnloaded(value,state){return state.loaded?undefined:value},onlyIfUnloadedAndValue(value,state){return!state.loaded&&value?value:undefined},onlyIfValue(value){return value||undefined},onlyIfNew(value,state){return state.isNew?value:undefined},textType(value){return value?"markdown":"plain"}};"use strict";RB.BaseResource=Backbone.Model.extend({defaults(){return{extraData:{},links:null,loaded:false,parentObject:null}},rspNamespace:"",urlIDAttr:"id",listKey(){return this.rspNamespace+"s"},expandedFields:[],extraQueryArgs:{},supportsExtraData:false,attrToJsonMap:{},serializedAttrs:[],deserializedAttrs:[],serializers:{},deserializers:{},initialize(){if(this.supportsExtraData){this._setupExtraData()}},url(){let links=this.get("links");if(links){return links.self.href}const parentObject=this.get("parentObject");if(parentObject){links=parentObject.get("links");if(links){const key=_.result(this,"listKey");const link=links[key];if(link){const baseURL=link.href;return this.isNew()?baseURL:baseURL+this.get(this.urlIDAttr)+"/"}}}return null},async ready(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)||_.isFunction(options.ready)){console.warn("RB.BaseResource.ready was called using callbacks. "+"Callers should be updated to use promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.ready())}const success=_.isFunction(options.ready)?_.bind(options.ready,context):undefined;const error=_.isFunction(options.error)?_.bind(options.error,context):undefined;const parentObject=this.get("parentObject");if(!this.get("loaded")){if(!this.isNew()){await this.fetch({data:options.data})}else if(parentObject){await parentObject.ready()}}},async ensureCreated(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.BaseResource.ensureCreated was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.ensureCreated())}await this.ready();if(!this.get("loaded")){await this.save()}},fetch:async function(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.BaseResource.fetch was called using callbacks. "+"Callers should be updated to use promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.fetch(newOptions))}if(this.isNew()){throw new Error("fetch cannot be used on a resource without an ID")}const parentObject=this.get("parentObject");if(parentObject){await parentObject.ready()}return new Promise((resolve,reject)=>{Backbone.Model.prototype.fetch.call(this,_.extend({success:()=>resolve(),error:(model,xhr,options)=>reject(new BackboneError(model,xhr,options))},options))})},async save(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.BaseResource.save was called using callbacks. "+"Callers should be updated to use promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.save(newOptions))}this.trigger("saving",options);await this.ready();const parentObject=this.get("parentObject");if(parentObject){await parentObject.ensureCreated()}return await this._saveObject(options)},_saveObject(options){return new Promise((resolve,reject)=>{const url=_.result(this,"url");if(!url){reject(new Error("The object must either be loaded from the server or "+"have a parent object before it can be saved"));return}const saveOptions=_.defaults({success:(model,xhr)=>{this.trigger("saved",options);resolve(xhr)},error:(model,xhr,options)=>{this.trigger("saveFailed",options);reject(new BackboneError(model,xhr,options))}},options);saveOptions.attrs=options.attrs||this.toJSON(options);const files=[];const readers=[];if(!options.form){if(this.payloadFileKeys&&window.File){this.payloadFileKeys.forEach(key=>{const file=saveOptions.attrs[key];if(file){files.push(file)}})}}if(files.length>0){files.forEach(file=>{const reader=new FileReader;readers.push(reader);reader.onloadend=()=>{if(readers.every(r=>r.readyState===FileReader.DONE)){this._saveWithFiles(files,readers,saveOptions)}};reader.readAsArrayBuffer(file)})}else{Backbone.Model.prototype.save.call(this,{},saveOptions)}})},_saveWithFiles(files,fileReaders,options){const boundary=options.boundary||"-----multipartformboundary"+(new Date).getTime();const blob=[];for(let[key,file,reader]of _.zip(this.payloadFileKeys,files,fileReaders)){if(!file||!reader){continue}blob.push("--"+boundary+"\r\n");blob.push('Content-Disposition: form-data; name="'+key+'"; filename="'+file.name+'"\r\n');blob.push("Content-Type: "+file.type+"\r\n");blob.push("\r\n");blob.push(reader.result);blob.push("\r\n")}for(let[key,value]of Object.entries(options.attrs)){if(!this.payloadFileKeys.includes(key)&&value!==undefined&&value!==null){blob.push("--"+boundary+"\r\n");blob.push('Content-Disposition: form-data; name="'+key+'"\r\n');blob.push("\r\n");blob.push(value+"\r\n")}}blob.push("--"+boundary+"--\r\n\r\n");Backbone.Model.prototype.save.call(this,{},_.extend({data:new Blob(blob),processData:false,contentType:"multipart/form-data; boundary="+boundary},options))},async destroy(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.BaseResource.destroy was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.destroy(newOptions))}this.trigger("destroying",options);const parentObject=this.get("parentObject");if(!this.isNew()&&parentObject){await parentObject.ready()}await this._destroyObject(options)},async _destroyObject(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const url=_.result(this,"url");if(url){await this.ready();await this._finishDestroy(options)}else{if(this.isNew()){await this._finishDestroy(options)}else{throw new Error("The object must either be loaded from the server "+"or have a parent object before it can be deleted")}}},_finishDestroy(options){return new Promise((resolve,reject)=>{const parentObject=this.get("parentObject");Backbone.Model.prototype.destroy.call(this,{wait:true,success:()=>{this.set(_.defaults({id:null,parentObject:parentObject},_.result(this,"defaults")));this.trigger("destroyed",options);resolve()},error:(model,xhr,options)=>reject(new BackboneError(model,xhr,options))})})},parse(rsp){console.assert(this.rspNamespace,"rspNamespace must be defined on the resource model");if(rsp.stat!==undefined){rsp=rsp[this.rspNamespace]}return _.defaults({extraData:rsp.extra_data,id:rsp.id,links:rsp.links,loaded:true},this.parseResourceData(rsp))},parseResourceData(rsp){const attrs={};for(let attrName of this.deserializedAttrs){const deserializer=this.deserializers[attrName];const jsonField=this.attrToJsonMap[attrName]||attrName;let value=rsp[jsonField];if(deserializer){value=deserializer.call(this,value)}if(value!==undefined){attrs[attrName]=value}}return attrs},toJSON(){const serializerState={isNew:this.isNew(),loaded:this.get("loaded")};const data={};for(let attrName of this.serializedAttrs){const serializer=this.serializers[attrName];let value=this.get(attrName);if(serializer){value=serializer.call(this,value,serializerState)}const jsonField=this.attrToJsonMap[attrName]||attrName;data[jsonField]=value}if(this.supportsExtraData){_.extend(data,this.extraData.toJSON())}return data},sync(method,model){let options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};let data;let contentType;if(method==="read"){data=options.data||{};const extraQueryArgs=_.result(this,"extraQueryArgs",{});if(!_.isEmpty(extraQueryArgs)){data=_.extend({},extraQueryArgs,data)}}else{if(options.form){data=null}else if(options.attrs&&!_.isArray(options.attrs)){data=options.attrs}else{data=model.toJSON(options);if(options.attrs){data=_.pick(data,options.attrs.map(attr=>this.attrToJsonMap[attr]||attr))}}contentType="application/x-www-form-urlencoded"}const syncOptions=_.defaults({},options,{contentType:contentType,data:data,processData:true});if(!options.form&&this.expandedFields.length>0){syncOptions.data.expand=this.expandedFields.join(",")}syncOptions.error=xhr=>{RB.storeAPIError(xhr);const rsp=xhr.errorPayload;if(rsp&&_.has(rsp,this.rspNamespace)){this.set(this.parse(rsp))}if(_.isFunction(options.error)){options.error(xhr)}};return Backbone.sync.call(this,method,model,syncOptions)},validate(attrs){if(this.supportsExtraData&&attrs.extraData!==undefined){const strings=RB.BaseResource.strings;if(!_.isObject(attrs.extraData)){return strings.INVALID_EXTRADATA_TYPE}for(let[key,value]of Object.entries(attrs.extraData)){if(!_.isNull(value)&&(!_.isNumber(value)||_.isNaN(value))&&!_.isBoolean(value)&&!_.isString(value)){return strings.INVALID_EXTRADATA_VALUE_TYPE.replace("{key}",key)}}}}},{strings:{UNSET_PARENT_OBJECT:"parentObject must be set",INVALID_EXTRADATA_TYPE:"extraData must be an object or undefined",INVALID_EXTRADATA_VALUE_TYPE:"extraData.{key} must be null, a number, boolean, or string"}});_.extend(RB.BaseResource.prototype,RB.ExtraDataMixin);"use strict";RB.APIToken=RB.BaseResource.extend({defaults(){return _.defaults({deprecated:false,expired:false,expires:null,invalidDate:null,invalidReason:null,lastUsed:null,note:null,policy:{},tokenValue:null,userName:null,valid:true},RB.BaseResource.prototype.defaults())},rspNamespace:"api_token",url(){const url=SITE_ROOT+(this.get("localSitePrefix")||"")+"api/users/"+this.get("userName")+"/api-tokens/";return this.isNew()?url:`${url}${this.id}/`},toJSON(){return{expires:this.get("expires"),note:this.get("note"),policy:JSON.stringify(this.get("policy"))}},parseResourceData(rsp){return{deprecated:rsp.deprecated,expired:rsp.expired,expires:rsp.expires,invalidDate:rsp.invalid_date,invalidReason:rsp.invalid_reason,lastUsed:rsp.last_used,note:rsp.note,policy:rsp.policy,tokenValue:rsp.token,valid:rsp.valid}}},{defaultPolicies:{readWrite:{},readOnly:{resources:{"*":{allow:["GET","HEAD","OPTIONS"],block:["*"]}}},custom:{resources:{"*":{allow:["*"],block:[]}}}}});"use strict";RB.RepositoryBranch=RB.BaseResource.extend({defaults(){return _.defaults({name:null,commit:null,isDefault:false},RB.BaseResource.prototype.defaults())},rspNamespace:"branches",deserializedAttrs:["id","name","commit","isDefault"],serializedAttrs:["id","name","commit","isDefault"],attrToJsonMap:{isDefault:"default"},parse(rsp){return{id:rsp.id,name:rsp.name,commit:rsp.commit,isDefault:rsp["default"]}}});"use strict";RB.RepositoryCommit=RB.BaseResource.extend({defaults(){return _.defaults({accessible:true,authorName:null,date:null,parent:null,message:null,summary:null,reviewRequestURL:null},RB.BaseResource.prototype.defaults())},rspNamespace:"commits",deserializedAttrs:["authorName","date","id","parent","message","summary","reviewRequestURL"],serializedAttrs:["authorName","date","id","parent","message","reviewRequestURL"],attrToJsonMap:{authorName:"author_name",reviewRequestURL:"review_request_url",summary:"message"},deserializers:{date:date=>date?new Date(date):"",summary:message=>message.split("\n",1)[0]},serializers:{date:date=>date.toString()},parseResourceData(rsp){const data=RB.BaseResource.prototype.parseResourceData.call(this,rsp);data.accessible=rsp.date||rsp.message||rsp.author_name;return data}});"use strict";RB.DraftResourceChildModelMixin={async destroy(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.DraftResourceChildModelMixin.destroy was "+"called using callbacks. Callers should be updated "+"to use promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.destroy(newOptions))}await this.get("parentObject").ensureCreated();await _super(this).destroy.call(this,options)},async ready(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)||_.isFunction(options.ready)){console.warn("RB.DraftResourceChildModelMixin.ready was "+"called using callbacks. Callers should be updated "+"to use promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.ready())}await this.get("parentObject").ensureCreated();await _super(this).ready.call(this)}};"use strict";RB.DraftResourceModelMixin={async ready(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)||_.isFunction(options.ready)){console.warn("RB.DraftResourceModelMixin.ready was "+"called using callbacks. Callers should be updated "+"to use promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.ready(newOptions))}if(!this.get("loaded")&&this.isNew()&&this._needDraft===undefined){this._needDraft=true}await _super(this).ready.call(this);if(this._needDraft){await this._retrieveDraft(options)}},async destroy(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.DraftResourceModelMixin.destroy was "+"called using callbacks. Callers should be updated "+"to use promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.destroy(newOptions))}await this.ready();await _super(this).destroy.call(this,options);this._needDraft=true},url(){if(this._needDraft){const parentObject=this.get("parentObject");const linkName=_.result(this,"listKey");const links=parentObject.get("links");return links[linkName].href+"draft/?"+$.now()}else{return _super(this).url.call(this)}},_retrieveDraft(options){if(!RB.UserSession.instance.get("authenticated")){return Promise.reject(new BackboneError(this,{errorText:gettext("You must be logged in to retrieve the draft.")},{}))}let data=options.data||{};const extraQueryArgs=_.result(this,"extraQueryArgs",{});if(!_.isEmpty(extraQueryArgs)){data=_.extend({},extraQueryArgs,data)}return new Promise((resolve,reject)=>{Backbone.Model.prototype.fetch.call(this,{data:data,processData:true,success:()=>{this._needDraft=false;resolve()},error:(model,xhr,options)=>{if(xhr.status===404){this._needDraft=false;resolve()}else{reject(new BackboneError(model,xhr,options))}}})})}};"use strict";RB.DraftReviewRequest=RB.BaseResource.extend(_.defaults({defaults(){return _.defaults({branch:null,bugsClosed:null,changeDescription:null,changeDescriptionRichText:false,dependsOn:[],description:null,descriptionRichText:false,public:null,rawTextFields:null,submitter:null,summary:null,targetGroups:[],targetPeople:[],testingDone:null,testingDoneRichText:false},RB.BaseResource.prototype.defaults())},rspNamespace:"draft",listKey:"draft",supportsExtraData:true,expandedFields:["depends_on","target_people","target_groups"],extraQueryArgs:{"force-text-type":"html","include-text-types":"raw"},attrToJsonMap:{bugsClosed:"bugs_closed",changeDescription:"changedescription",changeDescriptionRichText:"changedescription_text_type",dependsOn:"depends_on",descriptionRichText:"description_text_type",targetGroups:"target_groups",targetPeople:"target_people",testingDone:"testing_done",testingDoneRichText:"testing_done_text_type"},deserializedAttrs:["branch","bugsClosed","changeDescription","dependsOn","description","public","summary","targetGroups","targetPeople","testingDone"],url(){return this.get("parentObject").get("links").draft.href},createFileAttachment(attributes){return new RB.DraftFileAttachment(_.defaults({parentObject:this},attributes))},async publish(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.DraftReview.publish was called using callbacks. "+"Callers should be updated to use promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.publish(newOptions))}await this.ready();const validationError=this.validate(this.attributes,{publishing:true});if(validationError){throw new BackboneError(this,{errorText:validationError},options)}await this.save(_.defaults({data:{public:1,trivial:options.trivial?1:0}},options))},parseResourceData(rsp){const rawTextFields=rsp.raw_text_fields||rsp;const data=RB.BaseResource.prototype.parseResourceData.call(this,rsp);data.submitter=rsp.links.submitter;data.changeDescriptionRichText=rawTextFields.changedescription_text_type==="markdown";data.descriptionRichText=rawTextFields.description_text_type==="markdown";data.testingDoneRichText=rawTextFields.testing_done_text_type==="markdown";data.rawTextFields=rawTextFields||null;return data}},RB.DraftResourceModelMixin));"use strict";RB.Review=RB.BaseResource.extend({defaults(){return _.defaults({forceTextType:null,shipIt:false,public:false,bodyTop:null,bodyTopRichText:false,bodyBottom:null,bodyBottomRichText:false,draftReply:null,htmlTextFields:{},includeTextTypes:null,markdownTextFields:{},rawTextFields:{},timestamp:null},RB.BaseResource.prototype.defaults())},rspNamespace:"review",attrToJsonMap:{bodyBottom:"body_bottom",bodyBottomRichText:"body_bottom_text_type",bodyTop:"body_top",bodyTopRichText:"body_top_text_type",forceTextType:"force_text_type",includeTextTypes:"include_text_types",shipIt:"ship_it"},serializedAttrs:["forceTextType","includeTextTypes","shipIt","bodyTop","bodyTopRichText","bodyBottom","bodyBottomRichText","public"],deserializedAttrs:["shipIt","bodyTop","bodyBottom","public","timestamp"],serializers:{forceTextType:RB.JSONSerializers.onlyIfValue,includeTextTypes:RB.JSONSerializers.onlyIfValue,bodyTopRichText:RB.JSONSerializers.textType,bodyBottomRichText:RB.JSONSerializers.textType,public:value=>value?1:undefined},supportsExtraData:true,parseResourceData(rsp){const rawTextFields=rsp.raw_text_fields||rsp;const data=RB.BaseResource.prototype.parseResourceData.call(this,rsp);data.bodyTopRichText=rawTextFields.body_top_text_type==="markdown";data.bodyBottomRichText=rawTextFields.body_bottom_text_type==="markdown";if(rsp.raw_text_fields){data.rawTextFields={bodyBottom:rsp.raw_text_fields.body_bottom,bodyTop:rsp.raw_text_fields.body_top}}if(rsp.markdown_text_fields){data.markdownTextFields={bodyBottom:rsp.markdown_text_fields.body_bottom,bodyTop:rsp.markdown_text_fields.body_top}}if(rsp.html_text_fields){data.htmlTextFields={bodyBottom:rsp.html_text_fields.body_bottom,bodyTop:rsp.html_text_fields.body_top}}return data},createDiffComment(){let options;if(arguments.length===1){options=arguments.length<=0?undefined:arguments[0]}else{console.warn(["RB.Review.createDiffComment(id, fileDiffID, ","interFileDiffID, beginLineNum, endLineNum) is deprecated. ","Use RB.Review.createDiffComment(options) instead."].join(""));options={id:arguments.length<=0?undefined:arguments[0],fileDiffID:arguments.length<=1?undefined:arguments[1],interFileDiffID:arguments.length<=2?undefined:arguments[2],beginLineNum:arguments.length<=3?undefined:arguments[3],endLineNum:arguments.length<=4?undefined:arguments[4]}}if(!!options.interFileDiffID&&!!options.baseFileDiffID){console.error("Options `interFileDiffID` and `baseFileDiffID` for "+"RB.Review.createDiffComment() are mutually exclusive.");return}return new RB.DiffComment(_.defaults({parentObject:this},options))},createScreenshotComment(id,screenshotID,x,y,width,height){return new RB.ScreenshotComment({parentObject:this,id:id,screenshotID:screenshotID,x:x,y:y,width:width,height:height})},createFileAttachmentComment(id,fileAttachmentID,diffAgainstFileAttachmentID){return new RB.FileAttachmentComment({parentObject:this,id:id,fileAttachmentID:fileAttachmentID,diffAgainstFileAttachmentID:diffAgainstFileAttachmentID})},createGeneralComment(id,issueOpened){return new RB.GeneralComment({parentObject:this,id:id,issueOpened:issueOpened})},createReply(){let draftReply=this.get("draftReply");if(draftReply===null){draftReply=new RB.ReviewReply({parentObject:this});this.set("draftReply",draftReply);draftReply.once("published",()=>{const reviewRequest=this.get("parentObject");reviewRequest.markUpdated(draftReply.get("timestamp"));this.set("draftReply",null)})}return draftReply}});"use strict";RB.DraftReview=RB.Review.extend(_.extend({defaults:_.defaults({publishAndArchive:false,publishToOwnerOnly:false},RB.Review.prototype.defaults()),attrToJsonMap:_.defaults({publishAndArchive:"publish_and_archive",publishToOwnerOnly:"publish_to_owner_only"},RB.Review.prototype.attrToJsonMap),serializedAttrs:["publishAndArchive","publishToOwnerOnly"].concat(RB.Review.prototype.serializedAttrs),serializers:_.defaults({publishAndArchive:RB.JSONSerializers.onlyIfValue,publishToOwnerOnly:RB.JSONSerializers.onlyIfValue},RB.Review.prototype.serializers),async publish(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.DraftReview.publish was called using callbacks. "+"Callers should be updated to use promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.publish(newOptions))}this.trigger("publishing");await this.ready();this.set("public",true);try{await this.save({attrs:options.attrs})}catch(err){this.trigger("publishError",err.xhr.errorText);throw err}this.trigger("published")}},RB.DraftResourceModelMixin));"use strict";RB.BaseComment=RB.BaseResource.extend({defaults(){return _.defaults({forceTextType:null,includeTextTypes:null,issueOpened:null,issueStatus:null,markdownTextFields:{},rawTextFields:{},richText:null,text:""},RB.BaseResource.prototype.defaults())},extraQueryArgs(){let textTypes="raw";if(RB.UserSession.instance.get("defaultUseRichText")){textTypes+=",markdown"}return{"force-text-type":"html","include-text-types":textTypes}},supportsExtraData:true,attrToJsonMap:{forceTextType:"force_text_type",includeTextTypes:"include_text_types",issueOpened:"issue_opened",issueStatus:"issue_status",richText:"text_type"},serializedAttrs:["forceTextType","includeTextTypes","issueOpened","issueStatus","richText","text"],deserializedAttrs:["issueOpened","issueStatus","text","html"],serializers:{forceTextType:RB.JSONSerializers.onlyIfValue,includeTextTypes:RB.JSONSerializers.onlyIfValue,richText:RB.JSONSerializers.textType,issueStatus:function(value){if(this.get("loaded")){const parentObject=this.get("parentObject");if(parentObject.get("public")){return value}}return undefined}},destroyIfEmpty(){if(!this.get("text")){this.destroy.apply(this,arguments)}},parseResourceData(rsp){const rawTextFields=rsp.raw_text_fields||rsp;const data=RB.BaseResource.prototype.parseResourceData.call(this,rsp);data.richText=rawTextFields.text_type==="markdown";if(rsp.raw_text_fields){data.rawTextFields={text:rsp.raw_text_fields.text}}if(rsp.markdown_text_fields){data.markdownTextFields={text:rsp.markdown_text_fields.text}}if(rsp.html_text_fields){data.html=rsp.html_text_fields.text}return data},validate(attrs){if(_.has(attrs,"parentObject")&&!attrs.parentObject){return RB.BaseResource.strings.UNSET_PARENT_OBJECT}if(attrs.issueStatus&&attrs.issueStatus!==RB.BaseComment.STATE_DROPPED&&attrs.issueStatus!==RB.BaseComment.STATE_OPEN&&attrs.issueStatus!==RB.BaseComment.STATE_RESOLVED&&attrs.issueStatus!==RB.BaseComment.STATE_VERIFYING_DROPPED&&attrs.issueStatus!==RB.BaseComment.STATE_VERIFYING_RESOLVED){return RB.BaseComment.strings.INVALID_ISSUE_STATUS}return RB.BaseResource.prototype.validate.apply(this,arguments)},requiresVerification(){const extraData=this.get("extraData");return extraData&&extraData.require_verification===true},getAuthorUsername(){const review=this.get("parentObject");return review.get("links").user.title}},{STATE_DROPPED:"dropped",STATE_OPEN:"open",STATE_RESOLVED:"resolved",STATE_VERIFYING_DROPPED:"verifying-dropped",STATE_VERIFYING_RESOLVED:"verifying-resolved",isStateOpen(state){return state===RB.BaseComment.STATE_OPEN||state===RB.BaseComment.STATE_VERIFYING_DROPPED||state===RB.BaseComment.STATE_VERIFYING_RESOLVED},strings:{INVALID_ISSUE_STATUS:"issueStatus must be one of STATE_DROPPED, "+"STATE_OPEN, STATE_RESOLVED, "+"STATE_VERIFYING_DROPPED, or "+"STATE_VERIFYING_RESOLVED"}});"use strict";RB.BaseCommentReply=RB.BaseResource.extend({defaults(){return _.defaults({forceTextType:null,includeTextTypes:null,rawTextFields:{},replyToID:null,richText:false,text:""},RB.BaseResource.prototype.defaults())},attrToJsonMap:{forceTextType:"force_text_type",includeTextTypes:"include_text_types",replyToID:"reply_to_id",richText:"text_type"},serializedAttrs:["forceTextType","includeTextTypes","replyToID","richText","text"],deserializedAttrs:["text"],serializers:{forceTextType:RB.JSONSerializers.onlyIfValue,includeTextTypes:RB.JSONSerializers.onlyIfValue,replyToID:RB.JSONSerializers.onlyIfUnloaded,richText:RB.JSONSerializers.textType},destroyIfEmpty(){if(!this.get("text")){this.destroy.apply(this,arguments)}},parseResourceData(rsp){const rawTextFields=rsp.raw_text_fields||rsp;const data=RB.BaseResource.prototype.parseResourceData.call(this,rsp);data.rawTextFields=rsp.raw_text_fields||{};data.richText=rawTextFields.text_type==="markdown";return data},validate(attrs){if(_.has(attrs,"parentObject")&&!attrs.parentObject){return RB.BaseResource.strings.UNSET_PARENT_OBJECT}}});"use strict";RB.DefaultReviewer=RB.BaseResource.extend({defaults(){return _.defaults({name:null,fileRegex:null},RB.BaseResource.prototype.defaults())},rspNamespace:"default_reviewer",attrToJsonMap:{fileRegex:"file_regex"},serializedAttrs:["fileRegex","name"],deserializedAttrs:["fileRegex","name"],url(){const url=SITE_ROOT+(this.get("localSitePrefix")||"")+"api/default-reviewers/";return this.isNew()?url:`${url}${this.id}/`}});"use strict";RB.DiffComment=RB.BaseComment.extend({defaults:_.defaults({beginLineNum:0,endLineNum:0,fileDiff:null,fileDiffID:null,interFileDiff:null,interFileDiffID:null,baseFileDiffID:null},RB.BaseComment.prototype.defaults()),rspNamespace:"diff_comment",expandedFields:["filediff","interfilediff"],attrToJsonMap:_.defaults({baseFileDiffID:"base_filediff_id",beginLineNum:"first_line",fileDiffID:"filediff_id",interFileDiffID:"interfilediff_id",numLines:"num_lines"},RB.BaseComment.prototype.attrToJsonMap),serializedAttrs:["baseFileDiffID","beginLineNum","fileDiffID","interFileDiffID","numLines"].concat(RB.BaseComment.prototype.serializedAttrs),deserializedAttrs:["beginLineNum","endLineNum"].concat(RB.BaseComment.prototype.deserializedAttrs),serializers:_.defaults({fileDiffID:RB.JSONSerializers.onlyIfUnloaded,interFileDiffID:RB.JSONSerializers.onlyIfUnloadedAndValue,baseFileDiffID:RB.JSONSerializers.onlyIfUnloadedAndValue,numLines:function(){return this.getNumLines()}},RB.BaseComment.prototype.serializers),getNumLines(){return this.get("endLineNum")-this.get("beginLineNum")+1},parseResourceData(rsp){const result=RB.BaseComment.prototype.parseResourceData.call(this,rsp);result.endLineNum=rsp.num_lines+result.beginLineNum-1;result.fileDiff=new RB.FileDiff(rsp.filediff,{parse:true});if(rsp.interfilediff){result.interFileDiff=new RB.FileDiff(rsp.interfilediff,{parse:true})}return result},validate(attrs){if(this.isNew()&&_.has(attrs,"fileDiffID")&&!attrs.fileDiffID){return RB.DiffComment.strings.INVALID_FILEDIFF_ID}const hasBeginLineNum=_.has(attrs,"beginLineNum");if(hasBeginLineNum&&attrs.beginLineNum<0){return RB.DiffComment.strings.BEGINLINENUM_GTE_0}const hasEndLineNum=_.has(attrs,"endLineNum");if(hasEndLineNum&&attrs.endLineNum<0){return RB.DiffComment.strings.ENDLINENUM_GTE_0}if(hasBeginLineNum&&hasEndLineNum&&attrs.beginLineNum>attrs.endLineNum){return RB.DiffComment.strings.BEGINLINENUM_LTE_ENDLINENUM}return RB.BaseComment.prototype.validate.apply(this,arguments)}},{strings:{INVALID_FILEDIFF_ID:"fileDiffID must be a valid ID",BEGINLINENUM_GTE_0:"beginLineNum must be >= 0",ENDLINENUM_GTE_0:"endLineNum must be >= 0",BEGINLINENUM_LTE_ENDLINENUM:"beginLineNum must be <= endLineNum"}});"use strict";RB.DiffCommentReply=RB.BaseCommentReply.extend({rspNamespace:"diff_comment"});"use strict";RB.Diff=RB.BaseResource.extend({defaults(){return _.defaults({diff:null,parentDiff:null,basedir:null},RB.BaseResource.prototype.defaults())},rspNamespace:"diff",attrToJsonMap:{diff:"path",parentDiff:"parent_diff_path"},serializedAttrs:["basedir","diff","parentDiff"].concat(RB.BaseResource.prototype.serializedAttrs),payloadFileKeys:["path","parent_diff_path"],listKey:"diffs",getErrorString(rsp){if(rsp.err.code===RB.APIErrors.REPO_FILE_NOT_FOUND){return interpolate(gettext('The file "%(file)s" (revision %(revision)s) was not found in the repository'),{file:rsp.file,revision:rsp.revision},true)}return rsp.err.msg}});"use strict";RB.FileAttachment=RB.BaseResource.extend({defaults(){return _.defaults({attachmentHistoryID:null,caption:null,downloadURL:null,file:null,filename:null,reviewURL:null,revision:null,thumbnailHTML:null},RB.BaseResource.prototype.defaults())},rspNamespace:"file_attachment",payloadFileKeys:["path"],attrToJsonMap:{attachmentHistoryID:"attachment_history_id",downloadURL:"url",file:"path",reviewURL:"review_url",thumbnailHTML:"thumbnail"},serializedAttrs:["attachmentHistoryID","caption","file"],deserializedAttrs:["attachmentHistoryID","caption","downloadURL","filename","reviewURL","revision","thumbnailHTML"],serializers:{attachmentHistoryID:RB.JSONSerializers.onlyIfNew,file:RB.JSONSerializers.onlyIfNew}});"use strict";RB.FileAttachmentComment=RB.BaseComment.extend({defaults:_.defaults({diffAgainstFileAttachmentID:null,diffAgainstFileAttachment:null,fileAttachmentID:null,fileAttachment:null,linkText:null,reviewURL:null,thumbnailHTML:null},RB.BaseComment.prototype.defaults()),rspNamespace:"file_attachment_comment",expandedFields:["diff_against_file_attachment","file_attachment"],attrToJsonMap:_.defaults({diffAgainstFileAttachmentID:"diff_against_file_attachment_id",fileAttachmentID:"file_attachment_id",linkText:"link_text",reviewURL:"review_url",thumbnailHTML:"thumbnail_html"},RB.BaseComment.prototype.attrToJsonMap),serializedAttrs:["diffAgainstFileAttachmentID","fileAttachmentID"].concat(RB.BaseComment.prototype.serializedAttrs),deserializedAttrs:["linkText","thumbnailHTML","reviewURL"].concat(RB.BaseComment.prototype.deserializedAttrs),serializers:_.defaults({fileAttachmentID:RB.JSONSerializers.onlyIfUnloaded,diffAgainstFileAttachmentID:RB.JSONSerializers.onlyIfUnloadedAndValue},RB.BaseComment.prototype.serializers),parseResourceData(rsp){const result=RB.BaseComment.prototype.parseResourceData.call(this,rsp);result.fileAttachment=new RB.FileAttachment(rsp.file_attachment,{parse:true});result.fileAttachmentID=result.fileAttachment.id;if(rsp.diff_against_file_attachment){result.diffAgainstFileAttachment=new RB.FileAttachment(rsp.diff_against_file_attachment,{parse:true});result.diffAgainstFileAttachmentID=result.diffAgainstFileAttachment.id}return result},validate(attrs,options){if(_.has(attrs,"fileAttachmentID")&&!attrs.fileAttachmentID){return RB.FileAttachmentComment.strings.INVALID_FILE_ATTACHMENT_ID}return _super(this).validate.call(this,attrs,options)}},{strings:{INVALID_FILE_ATTACHMENT_ID:"fileAttachmentID must be a valid ID"}});"use strict";RB.FileAttachmentCommentReply=RB.BaseCommentReply.extend({rspNamespace:"file_attachment_comment"});"use strict";RB.GeneralComment=RB.BaseComment.extend({rspNamespace:"general_comment"});"use strict";RB.GeneralCommentReply=RB.BaseCommentReply.extend({rspNamespace:"general_comment"});"use strict";RB.FileDiff=RB.BaseResource.extend({defaults(){return _.defaults({destFilename:null,sourceFilename:null,sourceRevision:null},RB.BaseResource.prototype.defaults())},rspNamespace:"filediff",parseResourceData:function(rsp){return{destFilename:rsp.dest_file,sourceFilename:rsp.source_file,sourceRevision:rsp.source_revision}}});"use strict";RB.DraftFileAttachment=RB.FileAttachment.extend(_.defaults({rspNamespace:"draft_file_attachment"},RB.DraftResourceChildModelMixin));"use strict";RB.Repository=RB.BaseResource.extend({defaults(){return _.defaults({filesOnly:false,localSitePrefix:null,name:null,requiresBasedir:false,requiresChangeNumber:false,scmtoolName:null,supportsPostCommit:false},RB.BaseResource.prototype.defaults())},rspNamespace:"repository",listKey:"repositories",attrToJsonMap:{name:"name",requiresBasedir:"requires_basedir",requiresChangeNumber:"requires_change_number",scmtoolName:"tool",supportsPostCommit:"supports_post_commit"},deserializedAttrs:["name","requiresBasedir","requiresChangeNumber","scmtoolName","supportsPostCommit"],initialize(){RB.BaseResource.prototype.initialize.apply(this,arguments);this.branches=new RB.RepositoryBranches;this.branches.url=_.result(this,"url")+"branches/"},getCommits(options){return new RB.RepositoryCommits([],{urlBase:_.result(this,"url")+"commits/",start:options.start,branch:options.branch})},url(){const url=SITE_ROOT+(this.get("localSitePrefix")||"")+"api/repositories/";return this.isNew()?url:`${url}${this.id}/`}});"use strict";(function(){const GroupMember=RB.BaseResource.extend({defaults(){return _.defaults({username:null,added:false,loaded:true},RB.BaseResource.prototype.defaults())},serializedAttrs:["username"],url(){let url=this.get("baseURL");if(this.get("added")){url+=this.get("username")+"/"}return url},isNew(){return!this.get("added")},parse(){}});RB.ReviewGroup=RB.BaseResource.extend({defaults(){return _.defaults({name:null},RB.BaseResource.prototype.defaults())},rspNamespace:"group",url(){let url=SITE_ROOT+(this.get("localSitePrefix")||"")+"api/groups/";if(!this.isNew()){url+=this.get("name")+"/"}return url},setStarred(starred){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let context=arguments.length>2&&arguments[2]!==undefined?arguments[2]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ReviewGroup.setStarred was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.setStarred(starred))}const watched=RB.UserSession.instance.watchedGroups;return starred?watched.addImmediately(this):watched.removeImmediately(this)},addUser(username){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let context=arguments.length>2&&arguments[2]!==undefined?arguments[2]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ReviewGroup.addUser was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.addUser(username))}const url=this.url()+"users/";if(url&&!this.isNew()){const member=new GroupMember({username:username,baseURL:url});return member.save()}else{return Promise.reject(new BackboneError(this,{errorText:"Unable to add to the group."},options))}},removeUser(username){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let context=arguments.length>2&&arguments[2]!==undefined?arguments[2]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ReviewGroup.removeUser was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.removeUser(username))}const url=this.url()+"users/";if(url&&!this.isNew()){const member=new GroupMember({username:username,baseURL:url,added:true});return member.destroy()}else{return Promise.reject(new BackboneError(this,{errorText:"Unable to remove from the group."},options))}}})})();"use strict";RB.ReviewReply=RB.BaseResource.extend({defaults(){return _.defaults({forceTextType:null,includeTextTypes:null,rawTextFields:{},review:null,public:false,bodyTop:null,bodyTopRichText:false,bodyBottom:null,bodyBottomRichText:false,timestamp:null},RB.BaseResource.prototype.defaults())},rspNamespace:"reply",listKey:"replies",extraQueryArgs:{"force-text-type":"html","include-text-types":"raw"},attrToJsonMap:{bodyBottom:"body_bottom",bodyBottomRichText:"body_bottom_text_type",bodyTop:"body_top",bodyTopRichText:"body_top_text_type",forceTextType:"force_text_type",includeTextTypes:"include_text_types"},serializedAttrs:["forceTextType","includeTextTypes","bodyTop","bodyTopRichText","bodyBottom","bodyBottomRichText","public"],deserializedAttrs:["bodyTop","bodyBottom","public","timestamp"],serializers:{forceTextType:RB.JSONSerializers.onlyIfValue,includeTextTypes:RB.JSONSerializers.onlyIfValue,bodyTopRichText:RB.JSONSerializers.textType,bodyBottomRichText:RB.JSONSerializers.textType,public:value=>value?true:undefined},COMMENT_LINK_NAMES:["diff_comments","file_attachment_comments","general_comments","screenshot_comments"],parseResourceData(rsp){const rawTextFields=rsp.raw_text_fields||rsp;const data=RB.BaseResource.prototype.parseResourceData.call(this,rsp);data.bodyTopRichText=rawTextFields.body_top_text_type==="markdown";data.bodyBottomRichText=rawTextFields.body_bottom_text_type==="markdown";data.rawTextFields=rsp.raw_text_fields||{};return data},async publish(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ReviewReply.publish was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.publish(newOptions))}this.trigger("publishing");await this.ready();this.set("public",true);try{await this.save({data:{public:1,trivial:options.trivial?1:0}})}catch(err){this.trigger("publishError",err.message);throw err}this.trigger("published")},async discardIfEmpty(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ReviewReply.discardIfEmpty was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.discardIfEmpty(newOptions))}await this.ready();if(this.isNew()||this.get("bodyTop")||this.get("bodyBottom")){return false}else{return this._checkCommentsLink(0)}},_checkCommentsLink(linkNameIndex){return new Promise((resolve,reject)=>{const linkName=this.COMMENT_LINK_NAMES[linkNameIndex];const url=this.get("links")[linkName].href;RB.apiCall({type:"GET",url:url,success:rsp=>{if(rsp[linkName].length>0){resolve(false)}else if(linkNameIndex<this.COMMENT_LINK_NAMES.length-1){resolve(this._checkCommentsLink(linkNameIndex+1))}else{resolve(this.destroy().then(()=>true))}},error:(model,xhr,options)=>reject(new BackboneError(model,xhr,options))})})}});_.extend(RB.ReviewReply.prototype,RB.DraftResourceModelMixin);"use strict";RB.ReviewRequest=RB.BaseResource.extend({defaults(){return _.defaults({approved:false,approvalFailure:null,branch:null,bugTrackerURL:null,bugsClosed:null,commitID:null,closeDescription:null,closeDescriptionRichText:false,dependsOn:[],description:null,descriptionRichText:false,draftReview:null,lastUpdated:null,localSitePrefix:null,public:null,repository:null,reviewURL:null,state:null,summary:null,targetGroups:[],targetPeople:[],testingDone:null,testingDoneRichText:false},RB.BaseResource.prototype.defaults())},rspNamespace:"review_request",extraQueryArgs:{"force-text-type":"html","include-text-types":"raw"},attrToJsonMap:{approvalFailure:"approval_failure",bugsClosed:"bugs_closed",closeDescription:"close_description",closeDescriptionRichText:"close_description_text_type",dependsOn:"depends_on",descriptionRichText:"description_text_type",lastUpdated:"last_updated",reviewURL:"url",targetGroups:"target_groups",targetPeople:"target_people",testingDone:"testing_done",testingDoneRichText:"testing_done_text_type"},deserializedAttrs:["approved","approvalFailure","branch","bugsClosed","closeDescription","dependsOn","description","lastUpdated","public","reviewURL","summary","targetGroups","targetPeople","testingDone"],initialize(attrs){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};RB.BaseResource.prototype.initialize.call(this,attrs,options);this.reviews=new Backbone.Collection([],{model:RB.Review});this.draft=new RB.DraftReviewRequest(_.defaults({parentObject:this,branch:this.get("branch"),bugsClosed:this.get("bugsClosed"),dependsOn:this.get("dependsOn"),description:this.get("description"),descriptionRichText:this.get("descriptionRichText"),summary:this.get("summary"),targetGroups:this.get("targetGroups"),targetPeople:this.get("targetPeople"),testingDone:this.get("testingDone"),testingDoneRichText:this.get("testingDoneRichText")},options.extraDraftAttrs))},url(){const url=SITE_ROOT+(this.get("localSitePrefix")||"")+"api/review-requests/";return this.isNew()?url:`${url}${this.id}/`},createFromCommit(){let optionsOrCommitID=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(_.isObject(optionsOrCommitID)){console.assert(optionsOrCommitID.commitID);console.warn("RB.ReviewRequest.createFromCommit was called "+"using callbacks. Callers should be updated to "+"use promises instead.");return RB.promiseToCallbacks(optionsOrCommitID,context,()=>this.createFromCommit(optionsOrCommitID.commitID))}console.assert(optionsOrCommitID);console.assert(this.isNew());this.set("commitID",optionsOrCommitID);return this.save({createFromCommit:true})},createDiff(){return new RB.Diff({parentObject:this})},createReview(reviewID){let extraAttrs=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let review;if(reviewID===undefined){review=this.get("draftReview");if(review===null){review=new RB.DraftReview({parentObject:this});this.set("draftReview",review)}}else{review=this.reviews.get(reviewID);if(!review){review=new RB.Review(_.defaults({parentObject:this,id:reviewID},extraAttrs));this.reviews.add(review)}}return review},createScreenshot(screenshotID){return new RB.Screenshot({parentObject:this,id:screenshotID})},createFileAttachment(attributes){return new RB.FileAttachment(_.defaults({parentObject:this},attributes))},setStarred(starred){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let context=arguments.length>2&&arguments[2]!==undefined?arguments[2]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ReviewRequest.setStarred was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.setStarred(starred))}const watched=RB.UserSession.instance.watchedReviewRequests;return starred?watched.addImmediately(this):watched.removeImmediately(this)},async close(options){let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ReviewRequest.close was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.close(newOptions))}const data={};console.assert(options);if(options.type===RB.ReviewRequest.CLOSE_DISCARDED){data.status="discarded"}else if(options.type===RB.ReviewRequest.CLOSE_SUBMITTED){data.status="submitted"}else{return Promise.reject(new Error("Invalid close type"))}if(options.description!==undefined){data.close_description=options.description}if(options.richText!==undefined){data.close_description_text_type=options.richText?"markdown":"plain"}if(options.postData!==undefined){_.extend(data,options.postData)}const changingState=options.type!==this.get("state");const saveOptions=_.defaults({data:data},options);delete saveOptions.type;delete saveOptions.description;await this.save(saveOptions);if(changingState){this.trigger("closed")}this.markUpdated(this.get("lastUpdated"))},async reopen(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ReviewRequest.reopen was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.reopen())}await this.save({data:{status:"pending"}});this.trigger("reopened");this.markUpdated(this.get("lastUpdated"))},markUpdated(timestamp){this._lastUpdateTimestamp=timestamp},async beginCheckForUpdates(type,lastUpdateTimestamp){this._checkUpdatesType=type;this._lastUpdateTimestamp=lastUpdateTimestamp;await this.ready();setTimeout(this._checkForUpdates.bind(this),RB.ReviewRequest.CHECK_UPDATES_MSECS)},_checkForUpdates(){RB.apiCall({type:"GET",prefix:this.get("sitePrefix"),noActivityIndicator:true,url:this.get("links").last_update.href,success:rsp=>{const lastUpdate=rsp.last_update;if((!this._checkUpdatesType||this._checkUpdatesType===lastUpdate.type)&&this._lastUpdateTimestamp!==lastUpdate.timestamp){this.trigger("updated",lastUpdate)}this._lastUpdateTimestamp=lastUpdate.timestamp;setTimeout(this._checkForUpdates.bind(this),RB.ReviewRequest.CHECK_UPDATES_MSECS)}})},toJSON(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(this.isNew()){const commitID=this.get("commitID");const repository=this.get("repository");const result={};if(commitID){result.commit_id=commitID;if(options.createFromCommit){result.create_from_commit_id=true}}if(repository){result.repository=repository}return result}else{return _super(this).toJSON.apply(this,arguments)}},parseResourceData(rsp){const state={pending:RB.ReviewRequest.PENDING,discarded:RB.ReviewRequest.CLOSE_DISCARDED,submitted:RB.ReviewRequest.CLOSE_SUBMITTED}[rsp.status];const rawTextFields=rsp.raw_text_fields||rsp;const data=RB.BaseResource.prototype.parseResourceData.call(this,rsp);data.state=state;data.closeDescriptionRichText=rawTextFields.close_description_text_type==="markdown";data.descriptionRichText=rawTextFields.description_text_type==="markdown";data.testingDoneRichText=rawTextFields.testing_done_text_type==="markdown";return data}},{CHECK_UPDATES_MSECS:5*60*1e3,CLOSE_DISCARDED:1,CLOSE_SUBMITTED:2,PENDING:3,VISIBILITY_VISIBLE:1,VISIBILITY_ARCHIVED:2,VISIBILITY_MUTED:3});"use strict";RB.Screenshot=RB.BaseResource.extend({defaults(){return _.defaults({caption:null,filename:null,reviewURL:null},RB.BaseResource.prototype.defaults())},rspNamespace:"screenshot",attrToJsonMap:{reviewURL:"review_url"},serializedAttrs:["caption"],deserializedAttrs:["caption","filename","reviewURL"],getDisplayName(){return this.get("caption")||this.get("filename")}});"use strict";RB.ScreenshotComment=RB.BaseComment.extend({defaults:_.defaults({x:null,y:null,width:null,height:null,screenshotID:null,screenshot:null,thumbnailURL:null},RB.BaseComment.prototype.defaults()),rspNamespace:"screenshot_comment",expandedFields:["screenshot"],attrToJsonMap:_.defaults({width:"w",height:"h",thumbnailURL:"thumbnail_url",screenshotID:"screenshot_id"},RB.BaseComment.prototype.attrToJsonMap),serializedAttrs:["x","y","width","height","screenshotID"].concat(RB.BaseComment.prototype.serializedAttrs),deserializedAttrs:["x","y","width","height","thumbnailURL"].concat(RB.BaseComment.prototype.deserializedAttrs),serializers:_.defaults({screenshotID:RB.JSONSerializers.onlyIfUnloaded},RB.BaseComment.prototype.serializers),parseResourceData(rsp){const result=RB.BaseComment.prototype.parseResourceData.call(this,rsp);result.screenshot=new RB.Screenshot(rsp.screenshot,{parse:true});result.screenshotID=result.screenshot.id;return result},validate(attrs){if(_.has(attrs,"screenshotID")&&!attrs.screenshotID){return RB.ScreenshotComment.strings.INVALID_SCREENSHOT_ID}if(_.has(attrs,"x")&&attrs.x<0){return RB.ScreenshotComment.strings.INVALID_X}if(_.has(attrs,"y")&&attrs.y<0){return RB.ScreenshotComment.strings.INVALID_Y}if(_.has(attrs,"width")&&attrs.width<=0){return RB.ScreenshotComment.strings.INVALID_WIDTH}if(_.has(attrs,"height")&&attrs.height<=0){return RB.ScreenshotComment.strings.INVALID_HEIGHT}return RB.BaseComment.prototype.validate.apply(this,arguments)}},{strings:{INVALID_SCREENSHOT_ID:"screenshotID must be a valid ID",INVALID_X:"x must be >= 0",INVALID_Y:"y must be >= 0",INVALID_WIDTH:"width must be > 0",INVALID_HEIGHT:"height must be > 0"}});"use strict";RB.ScreenshotCommentReply=RB.BaseCommentReply.extend({rspNamespace:"screenshot_comment"});"use strict";RB.UserFileAttachment=RB.BaseResource.extend({defaults(){return _.defaults({caption:null,downloadURL:null,file:null,filename:null},RB.BaseResource.prototype.defaults())},rspNamespace:"user_file_attachment",payloadFileKeys:["path"],attrToJsonMap:{downloadURL:"absolute_url",file:"path"},serializedAttrs:["caption","file"],deserializedAttrs:["caption","downloadURL","filename"],serializers:{file:RB.JSONSerializers.onlyIfValue},url(){const url=RB.UserSession.instance.get("userFileAttachmentsURL");return this.isNew()?url:`${url}${this.id}/`}});"use strict";RB.ValidateDiffModel=RB.Diff.extend({defaults:_.defaults({repository:null,localSitePrefix:""},_.result(RB.Diff.prototype,"defaults")),serializedAttrs:["repository"].concat(RB.Diff.prototype.serializedAttrs),url(){return SITE_ROOT+(this.get("localSitePrefix")||"")+"api/validation/diffs/"},parse(){}});"use strict";RB.ResourceCollection=RB.BaseCollection.extend({initialize(models,options){this.parentResource=options.parentResource;this.extraQueryData=options.extraQueryData;this.maxResults=options.maxResults;this.hasPrev=false;this.hasNext=false;this.currentPage=0;this.totalResults=undefined;this._fetchURL=null;this._links=null},url(){if(this._fetchURL){return this._fetchURL}if(this.parentResource){const links=this.parentResource.get("links");const listKey=_.result(this.model.prototype,"listKey");const link=links[listKey];return link?link.href:null}return null},parse(rsp){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};const listKey=_.result(this.model.prototype,"listKey");this._links=rsp.links||null;this.totalResults=rsp.total_results;if(options.fetchingAll){this.hasPrev=false;this.hasNext=false;this.currentPage=0}else{this.totalResults=rsp.total_results;this.hasPrev=this._links!==null&&this._links.prev!==undefined;this.hasNext=this._links!==null&&this._links.next!==undefined;this.currentPage=options.page}return rsp[listKey]},fetch:async function(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ResourceCollection.fetch was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.fetch(newOptions))}const data=_.extend({},options.data);if(options.start!==undefined){data.start=options.start}if(!this.extraQueryData||this.extraQueryData["max-results"]===undefined){if(options.maxResults!==undefined){data["max-results"]=options.maxResults}else if(this.maxResults){data["max-results"]=this.maxResults}}if(options.reset===undefined){options.reset=true}options.remove=options.reset;const expandedFields=this.model.prototype.expandedFields;if(expandedFields.length>0){data.expand=expandedFields.join(",")}if(this.extraQueryData){_.defaults(data,this.extraQueryData)}options.data=data;if(this.parentResource){await this.parentResource.ready()}await RB.BaseCollection.prototype.fetch.call(this,options)},fetchPrev(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ResourceCollection.fetchPrev was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.fetchPrev(newOptions))}if(!this.hasPrev){return Promise.resolve()}this._fetchURL=this._links.prev.href;return this.fetch(_.defaults({page:this.currentPage-1},options))},fetchNext(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ResourceCollection.fetchNext was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.fetchNext(newOptions))}if(!this.hasNext&&options.enforceHasNext!==false){return Promise.resolve()}this._fetchURL=this._links.next.href;return this.fetch(_.defaults({page:this.currentPage+1},options))},async fetchAll(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.ResourceCollection.fetchNext was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.fetchAll(newOptions))}const fetchOptions=_.defaults({reset:false,fetchingAll:true,enforceHasNext:false,maxResults:50},options);this._fetchURL=null;this.reset();await this.fetch(fetchOptions);while(this._links.next){await this.fetchNext(fetchOptions)}},_prepareModel(){const model=RB.BaseCollection.prototype._prepareModel.apply(this,arguments);model.set("parentObject",this.parentResource);return model}});"use strict";RB.RepositoryBranches=RB.BaseCollection.extend({model:RB.RepositoryBranch,parse(response){return response.branches}});"use strict";RB.RepositoryCommits=RB.BaseCollection.extend({model:RB.RepositoryCommit,initialize(models,options){Backbone.Collection.prototype.initialize.call(this,models,options);this.options=options;this.busy=false;this.complete=false;this._nextStart=null},parse(response){const commits=response.commits;this._nextStart=commits[commits.length-1].parent;this.complete=!this._nextStart;return response.commits},url(){const params={};if(this.options.start!==undefined){params.start=this.options.start}if(this.options.branch!==undefined){params.branch=this.options.branch}return this.options.urlBase+"?"+$.param(params)},canFetchNext(){return!this.busy&&!this.complete&&this.models.length>0},async fetchNext(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("RB.RepositoryCommits.fetchNext was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.fetchNext(newOptions))}if(this.canFetchNext()){this.options.start=this._nextStart;await this.fetch({remove:false});this.busy=false}}});"use strict";RB.CenteredElementManager=Backbone.View.extend({initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this._elements=options.elements||new Map;this._$window=$(window);this._updatePositionThrottled=_.throttle(()=>this.updatePosition(),10);this._$window.on("resize",this._updatePositionThrottled);this._$window.on("scroll",this._updatePositionThrottled)},remove(){Backbone.View.prototype.remove.call(this);this._$window.off("resize",this._updatePositionThrottled);this._$window.off("scroll",this._updatePositionThrottled)},setElements(elements){this._elements=elements},updatePosition(){if(this._elements.size===0){return}const windowTop=this._$window.scrollTop();const windowHeight=this._$window.height();const windowBottom=windowTop+windowHeight;this._elements.forEach((containers,el)=>{const $el=$(el);const $topContainer=containers.$top;const $bottomContainer=containers.$bottom||$topContainer;const containerTop=$topContainer.offset().top;const containerBottom=$bottomContainer.offset().top+$bottomContainer.height();if(containerTop<windowBottom&&containerBottom>windowTop){if(windowTop>=containerTop&&windowBottom<=containerBottom){if($el.css("position")!=="fixed"){$el.css({position:"fixed",left:$el.offset().left,top:Math.round((windowHeight-$el.outerHeight())/2)})}}else{const top=Math.max(windowTop,containerTop);const bottom=Math.min(windowBottom,containerBottom);const elTop=top-containerTop+Math.round((bottom-top-$el.outerHeight())/2);$el.css({position:"absolute",left:"",top:elTop})}}})}});"use strict";RB.DialogView=Backbone.View.extend({title:null,body:null,buttons:[],defaultOptions:{},events:{"submit form":"_onFormSubmit"},initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this.options=options;if(options.title){this.title=options.title}if(options.body){this.body=options.body}if(options.buttons){this.buttons=options.buttons}this.visible=false},render(){return this},show(){if(!this.visible){const body=_.result(this,"body");if(body){this.$el.append(body)}this._makeButtons();this.render();this.$el.modalBox(_.defaults({title:_.result(this,"title"),buttons:this.$buttonsList,destroy:()=>this.visible=false},this.options,this.defaultOptions));this.$el.closest(".modalbox-inner").on("keydown",this._onDialogKeyDown.bind(this));this.visible=true}},hide(){if(this.visible){if(this.$el.data("uiModalBox")){this.$el.modalBox("destroy")}this.visible=false}},remove(){this.hide();Backbone.View.prototype.remove.call(this)},_makeButtons(){this.$buttonsMap={};this.$buttonsList=this.buttons.map(buttonInfo=>{const $button=$('<input type="button" />').val(buttonInfo.label).attr("id",buttonInfo.id);if(buttonInfo.class){$button.addClass(buttonInfo.class)}if(buttonInfo.disabled){$button.attr("disabled",true)}if(buttonInfo.primary){$button.addClass("primary");this._$primaryButton=$button}if(buttonInfo.danger){$button.addClass("danger")}if(buttonInfo.onClick){if(_.isFunction(buttonInfo.onClick)){$button.click(buttonInfo.onClick)}else{$button.click(this[buttonInfo.onClick].bind(this))}}this.$buttonsMap[buttonInfo.id]=$button;return $button})},_onFormSubmit(e){if(!$(e.target).attr("action")){e.preventDefault();e.stopPropagation();if(this._$primaryButton){this._$primaryButton[0].click()}}},_onDialogKeyDown(e){if(e.which===$.ui.keyCode.ESCAPE){e.stopPropagation();e.preventDefault();this.hide()}}});"use strict";RB.FormView=Backbone.View.extend({events:{"click .rb-c-form-fieldset__toggle":"_onToggleFieldSetClicked"},initialize(){this._$subforms=null;this._subformsByGroup={};this._formWidgetsInitialized=false},render(){this._$subforms=this.$(".rb-c-form-fieldset.-is-subform");if(this._$subforms.length>0){this._setupSubforms()}this.setupFormWidgets();return this},setupFormWidgets($el){if($el===undefined){$el=this.$el}if(window.DateTimeShortcuts&&$el.find(".datetimeshortcuts").length>0){if(this._formWidgetsInitialized){$(".datetimeshortcuts").remove()}DateTimeShortcuts.init()}if(window.SelectFilter){$el.find(".selectfilter").each((i,el)=>{const parts=el.name.split("-");SelectFilter.init(el.id,parts[parts.length-1],false)});$el.find(".selectfilterstacked").each((i,el)=>{const parts=el.name.split("-");SelectFilter.init(el.id,parts[parts.length-1],true)})}this._formWidgetsInitialized=true},setSubformVisibility(options){console.assert(_.isObject(options),"An options object must be provided.");const group=options.group;const subformID=options.subformID;const visible=options.visible;console.assert(group,'Missing option "group"');const subformIDs=this._subformsByGroup[group];console.assert(subformIDs,`Invalid subform group ${group}`);if(options.hideOthers||!subformID){_.each(subformIDs,($subform,id)=>{const isHidden=subformID===undefined?!visible:id!==subformID;$subform.prop({disabled:isHidden,hidden:isHidden})})}else{console.assert(visible!==undefined,'Missing option "visible"');const $subform=subformIDs[subformID];console.assert($subform,`Invalid subform ID ${subformID}`);$subform.prop({disabled:!visible,hidden:!visible})}},_setupSubforms(){const configuredControllers={};this._$subforms.each((i,subformEl)=>{const $subform=$(subformEl);const controllerID=$subform.data("subform-controller");const subformID=$subform.data("subform-id");const enablerID=$subform.data("subform-enabler");let group=$subform.data("subform-group");let $controller;let $enabler;if(!subformID){console.error("Subform %o is missing data-subform-id=",subformEl);return}if(!group&&!controllerID&&!enablerID){console.error("Subform %o is missing data-subform-group=, "+"data-subform-controller=, or data-subform-enable=",subformEl);return}if(controllerID){$controller=this.$(`#${controllerID}`);console.assert($controller.length===1,`Missing controller #${controllerID}`);const controllerGroup=$controller.data("subform-group");if(group===undefined){group=controllerGroup}else if(controllerGroup!==group){console.error("Subform %o and controller %s have "+"different values for data-subform-group",subformEl,controllerID);return}}else if(enablerID){$enabler=this.$(`#${enablerID}`);window.$form=this.$el;console.assert($enabler.length===1,`Missing enabler #${enablerID}`)}if(!this._subformsByGroup.hasOwnProperty(group)){this._subformsByGroup[group]={}}this._subformsByGroup[group][subformID]=$subform;if($controller){this.setSubformVisibility({group:group,subformID:subformID,visible:$controller.val()===subformID});if(!configuredControllers[controllerID]){configuredControllers[controllerID]=true;$controller.on("change",()=>this.setSubformVisibility({group:group,subformID:$controller.val(),visible:true,hideOthers:true}))}}if($enabler){const enabled=$enabler.is(":checked");$subform.setVisible(enabled).prop("disabled",!enabled);$enabler.on("change",()=>{const enabled=$enabler.is(":checked");$subform.setVisible(enabled).prop("disabled",!enabled)})}})},_onToggleFieldSetClicked(e){e.preventDefault();e.stopPropagation();const $toggle=$(e.target);const $fieldset=$toggle.closest(".rb-c-form-fieldset");if($fieldset.hasClass("-is-collapsed")){$fieldset.removeClass("-is-collapsed");$toggle.text(gettext("(Hide)"))}else{$fieldset.addClass("-is-collapsed");$toggle.text(gettext("(Show)"))}}});"use strict";RB.BaseInfoboxView=Backbone.View.extend({infoboxID:null,DEFAULT_POSITIONING:{side:"tb",xOffset:-20,yDistance:10},events:{"mouseenter .infobox-hover-item-anchor":"_onHoverItemMouseEnter","mouseleave .infobox-hover-item":"_onHoverItemMouseLeave","mouseenter .infobox-scrollable-section":"_onScrollableMouseEnter","mouseleave .infobox-scrollable-section":"_onScrollableMouseLeave"},initialize(){this.positioning=this.DEFAULT_POSITIONING;this._scrollbarWidth=null},className(){return`infobox ${this.infoboxID}`},getURLForTarget($target){return`${$target.attr("href")}infobox/`},setContents(html){this.$el.html(html);this.render()},render(){this._scrollbarWidth=null;this.$el.css("width","").find(".infobox-scrollable-section").css("padding-right",this._getScrollbarWidth());_.defer(()=>this.$el.width(this.$el.width()));return this},_getScrollbarWidth(){if(this._scrollbarWidth===null){const $el=$("<div>test</div>").css({visibility:"hidden",position:"absolute",left:-1e4,top:-1e4}).appendTo(document.body);const width=$el.width();$el.css("overflow-y","scroll");const newWidth=$el.width();$el.remove();this._scrollbarWidth=newWidth-width}return this._scrollbarWidth},_onHoverItemMouseEnter(evt){$(evt.target).closest(".infobox-hover-item").addClass("infobox-hover-item-opened")},_onHoverItemMouseLeave(evt){$(evt.target).closest(".infobox-hover-item").removeClass("infobox-hover-item-opened")},_onScrollableMouseEnter(evt){$(evt.target).closest(".infobox-scrollable-section").css("padding-right",0)},_onScrollableMouseLeave(evt){$(evt.target).closest(".infobox-scrollable-section").css("padding-right",this._getScrollbarWidth())}});"use strict";RB.InfoboxManagerView=Backbone.View.extend({POPUP_DELAY_MS:700,HIDE_DELAY_MS:400,FADE_IN_MS:200,FADE_OUT_MS:150,initialize(){this._infoboxViews={};this._activeInfoboxView=null;this._cache={};this._showTimeout=null;this._hideTimeout=null},remove(){Backbone.View.prototype.remove.call(this);for(let key in this._infoboxViews){if(this._infoboxViews.hasOwnProperty(key)){this._infoboxViews[key].remove()}}this._infoboxViews={};this._cache={};this._activeInfoboxView=null},addTargets(infoboxViewType,$targets){$targets.each((idx,target)=>{const $target=$(target);if(!$target.data("has-infobox")){$target.data("has-infobox",true).on("mouseenter",this._onTargetMouseEnter.bind(this,$target,infoboxViewType)).on("mouseleave",this._onMouseLeave.bind(this))}})},setPositioning(infoboxViewType,positioning){this.getOrCreateInfobox(infoboxViewType).positioning=positioning},getOrCreateInfobox(InfoboxViewType){const infoboxID=InfoboxViewType.prototype.infoboxID;console.assert(infoboxID,"RB.BaseInfoboxView subclasses must have an "+"infoboxID defined.");let view=this._infoboxViews[infoboxID];if(view){return view}view=new InfoboxViewType;view.$el.hide().on("mouseenter",this._onInfoboxMouseEnter.bind(this)).on("mouseleave",this._onMouseLeave.bind(this)).appendTo(document.body);this._infoboxViews[infoboxID]=view;return view},_loadInfobox($target,infoboxView){console.assert($target.length===1,"Too many targets matched when fetching infobox contents");const url=infoboxView.getURLForTarget($target);const cachedData=this._cache[url];if(cachedData!==undefined){infoboxView.setContents(cachedData);this._showInfobox(infoboxView,$target)}this._fetchInfoboxContents(url,html=>{this._cache[url]=html;infoboxView.setContents(html);if(cachedData===undefined){this._showInfobox(infoboxView,$target)}})},_fetchInfoboxContents(url,onDone){$.ajax(url,{ifModified:true}).done(onDone)},_showInfobox(infoboxView,$target){infoboxView.$el.positionToSide($target,_.defaults(infoboxView.positioning,{fitOnScreen:true})).fadeIn(this.FADE_IN_MS);this._activeInfoboxView=infoboxView},_hideInfobox(){if(this._activeInfoboxView){const curInfoboxView=this._activeInfoboxView;this._activeInfoboxView.$el.fadeOut(this.FADE_OUT_MS,()=>{if(curInfoboxView===this._activeInfoboxView){this._activeInfoboxView=null}})}},_onInfoboxMouseEnter(){clearTimeout(this._hideTimeout);this._hideTimeout=null},_onTargetMouseEnter($target,InfoboxViewType){clearTimeout(this._hideTimeout);this._hideTimeout=null;this._showTimeout=setTimeout(()=>{this._showTimeout=null;this._loadInfobox($target,this.getOrCreateInfobox(InfoboxViewType))},this.POPUP_DELAY_MS)},_onMouseLeave(){clearTimeout(this._showTimeout);this._showTimeout=null;if(this._activeInfoboxView){clearTimeout(this._hideTimeout);this._hideTimeout=setTimeout(()=>{this._hideInfobox();this._hideTimeout=null},this.HIDE_DELAY_MS)}}},{_instance:null,getInstance(){let instance=RB.InfoboxManagerView._instance;if(!instance){instance=new RB.InfoboxManagerView;this._instance=instance}return instance},createJQueryFn(infoboxViewType){return function(){RB.InfoboxManagerView.getInstance().addTargets(infoboxViewType,this);return this}}});"use strict";RB.BugInfoboxView=RB.BaseInfoboxView.extend({infoboxID:"bug-infobox"});$.fn.bug_infobox=RB.InfoboxManagerView.createJQueryFn(RB.BugInfoboxView);"use strict";RB.DrawerView=Backbone.View.extend({className:"rb-c-drawer",initialize(){this.isVisible=false;this.$content=null;this._$body=null},render(){this.$content=$('<div class="rb-c-drawer__content">');this._$body=$(document.body);this.$el.empty().append(this.$content);return this},show(){this.isVisible=true;this._$body.addClass("js-rb-c-drawer-is-shown");this.trigger("visibilityChanged",true)},hide(){this.isVisible=false;this._$body.removeClass("js-rb-c-drawer-is-shown");this.trigger("visibilityChanged",false)}});"use strict";RB.InlineEditorView=Backbone.View.extend({defaultOptions:{animationSpeedMS:200,deferEventSetup:false,editIconPath:null,editIconClass:null,enabled:true,extraHeight:100,focusOnOpen:true,formatResult:value=>value.htmlEncode(),formClass:"",getFieldValue:editor=>editor.$field.val(),hasRawValue:false,isFieldDirty:(editor,initialValue)=>{const value=editor.getValue()||"";const normValue=(editor.options.hasRawValue?value:value.htmlEncode())||"";initialValue=editor.normalizeText(initialValue);return normValue.length!==initialValue.length||normValue!==initialValue},matchHeight:true,multiline:false,notifyUnchangedCompletion:false,promptOnCancel:true,rawValue:null,setFieldValue:(editor,value)=>editor.$field.val(value),showButtons:true,showEditIcon:true,showRequiredFlag:false,startOpen:false},initialize(options){this.options=_.defaults(options,this.defaultOptions);this._initialValue=null;this._editing=false;this._dirty=false;this._dirtyCalcTimeout=null},render(){this.$el.data("inline-editor",this);this._$form=$("<form>").addClass(`inline-editor-form ${this.options.formClass}`).css("display","inline").hide().insertBefore(this.$el);this.$field=this.createField().prependTo(this._$form);this._isTextArea=this.$field[0].tagName==="TEXTAREA";this.$buttons=$();if(this.options.showButtons){this.$buttons=$(this.options.multiline?"<div>":"<span>").hide().addClass("buttons").appendTo(this._$form);$('<input type="button" class="save">').val(gettext("OK")).appendTo(this.$buttons).click(this.submit.bind(this));$('<input type="button" class="cancel">').val(gettext("Cancel")).appendTo(this.$buttons).click(this.cancel.bind(this))}this._$editIcon=$();if(this.options.showEditIcon){const editText=gettext("Edit this field");this._$editIcon=$('<a class="editicon" href="#" role="button">').attr({title:editText,"aria-label":editText}).click(e=>{e.preventDefault();e.stopPropagation();this.startEdit()});if(this.options.editIconPath){this._$editIcon.append(`<img src="${this.options.editIconPath}">`)}else if(this.options.editIconClass){this._$editIcon.append(`<div class="${this.options.editIconClass}" aria-hidden="true"></div>`)}if(this.options.showRequiredFlag){const requiredText=gettext("This field is required");$('<span class="required-flag">*</span>').attr({"aria-label":requiredText,title:requiredText}).appendTo(this._$editIcon)}if(this.options.multiline&&this.$el[0].id){$(`label[for="${this.$el[0].id}"]`).append(this._$editIcon)}else{this._$editIcon.insertAfter(this.$el)}}if(!this.options.deferEventSetup){this.setupEvents()}if(this.options.startOpen){this.startEdit({preventAnimation:true})}if(this.options.enabled){this.enable()}else{this.disable()}return this},createField(){if(this.options.multiline){return $("<textarea>").autoSizeTextArea()}else{return $('<input type="text">')}},remove(){Backbone.View.prototype.remove.call(this);$(window).off(this.cid)},setupEvents(){this.$field.keydown(e=>{e.stopPropagation();switch(e.keyCode||e.charCode||e.which){case 13:if(!this.options.multiline||e.ctrlKey){this.submit()}if(!this.options.multiline){e.preventDefault()}break;case 27:this.cancel();break;case 83:case 115:if(e.ctrlKey){this.submit();e.preventDefault()}break;default:break}}).keypress(e=>e.stopPropagation()).keyup(e=>{e.stopPropagation();e.preventDefault();this._scheduleUpdateDirtyState()}).on("cut paste",()=>this._scheduleUpdateDirtyState());if(!this.options.useEditIconOnly){let isDragging=true;this.$el.on("click","a",e=>e.stopPropagation()).click(e=>{e.stopPropagation();e.preventDefault();if(!isDragging){this.startEdit()}isDragging=true}).mousedown(()=>{isDragging=false;this.$el.one("mousemove",()=>{isDragging=true})}).mouseup(()=>{this.$el.unbind("mousemove")})}$(window).on(`resize.${this.cid}`,this._fitWidthToParent())},startEdit(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(this._editing||!this.options.enabled){return}let value;if(this.options.hasRawValue){this._initialValue=this.options.rawValue;value=this._initialValue}else{this._initialValue=this.$el.text();value=this.normalizeText(this._initialValue).htmlDecode()}this._editing=true;this.options.setFieldValue(this,value);this.trigger("beginEditPreShow");this.showEditor(options);this.trigger("beginEdit")},showEditor(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(this.options.multiline&&!options.preventAnimation){this._$editIcon.fadeOut(this.options.animationSpeedMS)}else{this._$editIcon.hide()}this.$el.hide();this._$form.show();if(this.options.multiline){const elHeight=this.$el.outerHeight();const newHeight=elHeight+this.options.extraHeight;this._fitWidthToParent();if(this._isTextArea){if(this.options.matchHeight){this.$field.autoSizeTextArea("setMinHeight",newHeight).css("overflow","hidden");if(options.preventAnimation){this.$field.height(newHeight)}else{this.$field.height(elHeight).animate({height:newHeight},this.options.animationSpeedMS)}}else{this.$field.autoSizeTextArea("autoSize",true,false,elHeight)}}}this.$buttons.show();this.$field.queue(()=>{if(this.options.multiline&&this._isTextArea){this.$field.css("overflow","auto")}this._fitWidthToParent();if(this.options.focusOnOpen){this.$field.focus()}if(!this.options.multiline&&this.$field[0].tagName==="INPUT"){this.$field[0].select()}this.$field.dequeue()})},hideEditor(){this.$field.blur();this.$buttons.hide();if(this.options.multiline){this._$editIcon.fadeIn(this.options.animationSpeedMS)}else{this._$editIcon.show()}if(this.options.multiline&&this.options.matchHeight&&this._editing&&this._isTextArea){this.$field.css("overflow","hidden").animate({height:this.$el.outerHeight()},this.options.animationSpeedMS)}this.$field.queue(()=>{this.$el.show();this._$form.hide();this.$field.dequeue()});this._editing=false;this._updateDirtyState()},save(){const value=this.getValue();const initialValue=this._initialValue;const dirty=this.isDirty();if(dirty){this.$el.html(this.options.formatResult(value));this._initialValue=this.$el.text()}if(dirty||this.options.notifyUnchangedCompletion){this.trigger("complete",value,initialValue);if(this.options.hasRawValue){this.options.rawValue=value}}else{this.trigger("cancel",this._initialValue)}},submit(){this.save();this.hideEditor()},cancel(){if(!this.isDirty()||!this.options.promptOnCancel||confirm(gettext("You have unsaved changes. Are you sure you want to discard them?"))){this.hideEditor();this.trigger("cancel",this._initialValue)}},isDirty(){if(this._dirtyCalcTimeout!==null){clearTimeout(this._dirtyCalcTimeout);this._updateDirtyState()}return this._dirty},getValue(){return this.options.getFieldValue(this)},setValue(value){this.options.setFieldValue(this,value);this._updateDirtyState()},enable(){if(this._editing){this.showEditor()}this._$editIcon.show();this.options.enabled=true},disable(){if(this._editing){this.hideEditor()}this._$editIcon.hide();this.options.enabled=false},editing(){return this._editing},normalizeText(text){if(this.options.stripTags){text=text.replace(/<br>/g,"\n");text=text.stripTags().strip()}if(!this.options.multiline){text=text.replace(/\s{2,}/g," ")}return text},_scheduleUpdateDirtyState(){if(this._dirtyCalcTimeout===null){this._dirtyCalcTimeout=setTimeout(this._updateDirtyState.bind(this),200)}},_updateDirtyState(){const newDirtyState=this._editing&&this.options.isFieldDirty(this,this._initialValue);if(this._dirty!==newDirtyState){this._dirty=newDirtyState;this.trigger("dirtyStateChanged",this._dirty)}this._dirtyCalcTimeout=null},_fitWidthToParent(){if(!this._editing){return}if(this.options.multiline){this.$field.css({"-webkit-box-sizing":"border-box","-moz-box-sizing":"border-box","box-sizing":"border-box",width:"100%"});return}const $formParent=this._$form.parent();const parentTextAlign=$formParent.css("text-align");const isLeftAligned=parentTextAlign==="left";if(!isLeftAligned){$formParent.css("text-align","left")}const boxSizing=this.$field.css("box-sizing");let extentTypes;if(boxSizing==="border-box"){extentTypes="m"}else if(boxSizing==="padding-box"){extentTypes="p"}else{extentTypes="bmp"}let buttonsWidth=0;if(this.$buttons.length!==0){const buttonsDisplay=this.$buttons.css("display");if(buttonsDisplay==="inline"||buttonsDisplay==="inline-block"){buttonsWidth=this.$buttons.outerWidth()}}this.$field.width(0).outerWidth($formParent.innerWidth()-(this._$form.offset().left-$formParent.offset().left)-this.$field.getExtents(extentTypes,"lr")-buttonsWidth);if(!isLeftAligned){$formParent.css("text-align",parentTextAlign)}}});RB.RichTextInlineEditorView=RB.InlineEditorView.extend({defaultOptions:_.defaults({matchHeight:false,multiline:true,setFieldValue:(editor,value)=>editor.textEditor.setText(value||""),getFieldValue:editor=>editor.textEditor.getText(),isFieldDirty:(editor,initialValue)=>{initialValue=editor.normalizeText(initialValue);return editor.textEditor.isDirty(initialValue)}},RB.InlineEditorView.prototype.defaultOptions),createField(){let origRichText;this.textEditor=new RB.TextEditorView(this.options.textEditorOptions);this.textEditor.$el.on("resize",()=>this.trigger("resize"));this.$el.data("text-editor",this.textEditor);this.once("beginEdit",()=>{const $span=$('<span class="enable-markdown">');const $checkbox=$('<input type="checkbox">').attr("id",_.uniqueId("markdown_check")).change(()=>_.defer(()=>this._updateDirtyState())).appendTo($span);this.textEditor.bindRichTextCheckbox($checkbox);$("<label>").attr("for",$checkbox[0].id).text(gettext("Enable Markdown")).appendTo($span);this.$buttons.append($span);const $markdownRef=$('<a class="markdown-info" target="_blank">').attr("href",`${MANUAL_URL}users/markdown/`).text(gettext("Markdown Reference")).setVisible(this.textEditor.richText).appendTo(this.$buttons);this.textEditor.bindRichTextVisibility($markdownRef)});this.listenTo(this,"beginEdit",()=>{this.textEditor._showEditor();origRichText=this.textEditor.richText});this.listenTo(this,"cancel",()=>{this.textEditor._hideEditor();this.textEditor.setRichText(origRichText)});this.listenTo(this,"complete",()=>this.textEditor._hideEditor());return this.textEditor.render().$el}});RB.DateInlineEditorView=RB.InlineEditorView.extend({defaultOptions:_.defaults({descriptorText:null,editIconClass:"rb-icon rb-icon-edit",getFieldValue:editor=>editor._$datePickerInput.val(),hasRawValue:true,isFieldDirty:(editor,initialValue)=>editor.getValue()!==initialValue,minDate:null,maxDate:null,multiline:false,setFieldValue:(editor,value)=>editor._$datePickerInput.val(value),useEditIconOnly:true},RB.InlineEditorView.prototype.defaultOptions),createField(){this._$datePickerInput=$('<input type="date"/>').attr({max:this.options.maxDate,min:this.options.minDate});this._$datePicker=$('<span class="rb-c-date-inline-editor__picker">').append(this.options.descriptorText,this._$datePickerInput);return this._$datePicker},setupEvents(){RB.InlineEditorView.prototype.setupEvents.call(this);this.$field.change(e=>{e.stopPropagation();e.preventDefault();this._scheduleUpdateDirtyState()})}});RB.DateTimeInlineEditorView=RB.DateInlineEditorView.extend({defaultOptions:_.defaults({minDate:null,maxDate:null},RB.DateInlineEditorView.prototype.defaultOptions),createField(){this._$datePickerInput=$('<input type="datetime-local"/>').attr({max:this.options.maxDate,min:this.options.minDate});this._$datePicker=$('<span class="rb-c-date-time-inline-editor__picker">').append(this.options.descriptorText,this._$datePickerInput);return this._$datePicker}});"use strict";RB.MenuButtonView=Backbone.View.extend({className:"rb-c-menu-button",events:{"mouseenter .rb-c-menu-button__toggle":"_openMenu",focusout:"_onFocusOut",mouseleave:"_closeMenu","keydown .rb-c-menu-button__toggle":"_onToggleButtonKeyDown","click .rb-c-menu-button__toggle":"_onToggleClick"},template:_.template(`<% if (hasPrimaryButton) { %>
 <div class="rb-c-button-group" role="group">
  <button class="rb-c-menu-button__primary rb-c-button"
          type="button"><%- buttonText %></button>
  <button class="rb-c-menu-button__toggle rb-c-button"
          id="<%- labelID %>"
          type="button"
          aria-label="<%- menuLabel %>">
   <span class="rb-icon rb-icon-dropdown-arrow"></span>
  </button>
 </div>
<% } else { %>
 <button class="rb-c-button rb-c-menu-button__toggle"
         id="<%- labelID %>"
         type="button">
  <%- buttonText %>
  <span class="rb-icon rb-icon-dropdown-arrow"></span>
 </button>
<% } %>`),initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this._ariaMenuLabel=options.ariaMenuLabel||gettext("More options");this._menuItems=options.menuItems||[];this._menuType=options.menuType||RB.MenuView.TYPE_STANDARD_MENU;this._buttonText=options.text;this._buttonOnClick=options.onPrimaryButtonClick;this._hasPrimaryButton=!!this._buttonOnClick||options.hasPrimaryButton;this.menu=null;this.$primaryButton=null;this._$buttonGroup=null;this._openDirection="down"},remove(){this.menu.remove();Backbone.View.prototype.remove.call(this)},render(){const labelID=_.uniqueId("__rb-menubuttonview__label");const hasPrimaryButton=this._hasPrimaryButton;this.$el.addClass(this.className).attr("role","group").html(this.template({buttonText:this._buttonText,hasPrimaryButton:hasPrimaryButton,labelID:labelID,menuLabel:this._ariaMenuLabel}));if(hasPrimaryButton){this.$primaryButton=this.$(".rb-c-menu-button__primary").on("click",this._buttonOnClick.bind(this));console.assert(this.$primaryButton.length===1)}this._$dropDownButton=this.$(".rb-c-menu-button__toggle");console.assert(this._$dropDownButton.length===1);const menu=new RB.MenuView({ariaLabelledBy:labelID,$controller:this._$dropDownButton,type:this._menuType});menu.render();this.listenTo(menu,"opening",()=>{this._$dropDownButton.addClass("js-hover");this._updateMenuPosition()});this.listenTo(menu,"closing",()=>{this._$dropDownButton.removeClass("js-hover")});for(let i=0;i<this._menuItems.length;i++){menu.addItem(this._menuItems[i])}menu.$el.appendTo(this.$el);this.menu=menu;return this},_updateMenuPosition(){const $button=this._$dropDownButton;const buttonY1=$button.offset().top;const buttonY2=buttonY1+$button.innerHeight();const pageY1=window.pageYOffset;const pageY2=window.pageYOffset+window.innerHeight;let direction;if(pageY1>=buttonY1){direction="down"}else if(pageY2<=buttonY2){direction="up"}else{const menuHeight=this.menu.$el.outerHeight();if(pageY2>=buttonY2+menuHeight){direction="down"}else{direction="up"}}this._openDirection=direction;this.$el.toggleClass("-opens-up",direction==="up");this.menu.$el.css(direction==="down"?"top":"bottom",$button.innerHeight())},_openMenu(options){this.menu.open(options)},_closeMenu(options){this.menu.close(options)},_onFocusOut(evt){evt.stopPropagation();if(!evt.currentTarget.contains(evt.relatedTarget)){this._closeMenu({animate:false})}},_onToggleButtonKeyDown(evt){switch(evt.which){case $.ui.keyCode.DOWN:case $.ui.keyCode.RETURN:case $.ui.keyCode.SPACE:case $.ui.keyCode.UP:this._openMenu({animate:false});if(this._openDirection==="up"){this.menu.focusLastItem()}else if(this._openDirection==="down"){this.menu.focusFirstItem()}return false;case $.ui.keyCode.ESCAPE:this._closeMenu({animate:false});return false}},_onToggleClick(evt){return false}});"use strict";RB.MenuView=Backbone.View.extend({className:"rb-c-menu",events:{keydown:"_onKeyDown"},initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(options.type===undefined||options.type===RB.MenuView.TYPE_STANDARD_MENU){this.type=RB.MenuView.TYPE_STANDARD_MENU}else if(options.type===RB.MenuView.TYPE_BUTTON_MENU){this.type=RB.MenuView.TYPE_BUTTON_MENU}else{console.error("The provided RB.MenuView type (%s) is not "+"supported. Defaulting to a standard menu.",options.type);this.type=RB.MenuView.TYPE_STANDARD_MENU}if(!this.id){this.id=_.uniqueId("__rb-menu")}this.$controller=options.$controller;this.isOpen=false;this._ariaLabelledBy=options.ariaLabelledBy;this._ariaLabel=options.ariaLabel;this._activeItemIndex=null;this._activeItemEl=null},render(){this.$el.attr({id:this.id,tabindex:"-1"});if(this.type===RB.MenuView.TYPE_BUTTON_MENU){this.$el.addClass("rb-c-button-group -is-vertical")}this.$el.attr("role","menu");if(this._ariaLabelledBy){this.$el.attr("aria-labelledby",this._ariaLabelledBy)}else if(this._ariaLabel){this.$el.attr("aria-label",this._ariaLabel)}if(this.$controller){this.$controller.attr({"aria-controls":this.id,"aria-expanded":"false","aria-haspopup":"true"})}return this},addItem(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};let $el;if(this.type===RB.MenuView.TYPE_BUTTON_MENU){$el=$('<button class="rb-c-menu__item rb-c-button" type="button">')}else if(this.type===RB.MenuView.TYPE_STANDARD_MENU){$el=$('<div class="rb-c-menu__item">')}else{console.assert(false,"RB.MenuView type is not a supported type.")}if(options.text!==undefined){$el.text(options.text)}if(options.onClick!==undefined){$el.on("click",options.onClick)}$el.attr({role:"menuitem",tabindex:"-1"}).on("mousemove",this._onMenuItemMouseMove.bind(this)).appendTo(this.el);return $el},open(options){this._setOpened(true,options)},close(options){this._setOpened(false,options)},focusFirstItem(){if(this.el.children.length>0){this._focusItem(0)}},focusLastItem(){const numChildren=this.el.children.length;if(numChildren>0){this._focusItem(numChildren-1)}},_setOpened(opened){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(this.isOpen===opened){return}this._activeItemIndex=null;this._activeItemEl=null;if(options.animate===false){this.$el.addClass("js-no-animation");_.defer(()=>this.$el.removeClass("js-no-animation"))}this.isOpen=opened;const triggerEvents=options.triggerEvents!==false;if(triggerEvents){this.trigger(opened?"opening":"closing")}if(opened){this.$el.addClass("-is-open")}else{this.$el.removeClass("-is-open")}if(this.$controller){this.$controller.attr("aria-expanded",opened)}if(triggerEvents){this.trigger(opened?"opened":"closed")}},_focusItem(index){this._activeItemIndex=index;this._activeItemEl=this.el.children[index];this._activeItemEl.focus()},_focusPreviousItem(){if(this._activeItemIndex===null){this.focusFirstItem()}else{let index=this._activeItemIndex-1;if(index<0){index=this.el.children.length-1}this._focusItem(index)}},_focusNextItem(){if(this._activeItemIndex===null){this.focusFirstItem()}else{let index=this._activeItemIndex+1;if(index>=this.el.children.length){index=0}this._focusItem(index)}},_onKeyDown(evt){switch(evt.which){case $.ui.keyCode.ENTER:$(this._activeItemEl).triggerHandler("click");return false;case $.ui.keyCode.ESCAPE:case $.ui.keyCode.TAB:if(this.$controller){this.$controller.focus()}this.close({animate:false});return false;case $.ui.keyCode.UP:this._focusPreviousItem();return false;case $.ui.keyCode.DOWN:this._focusNextItem();return false;case $.ui.keyCode.HOME:case $.ui.keyCode.PAGE_UP:this.focusFirstItem();return false;case $.ui.keyCode.END:case $.ui.keyCode.PAGE_DOWN:this.focusLastItem();return false}},_onMenuItemMouseMove(evt){const targetEl=evt.currentTarget;if(targetEl===this._activeItemEl){return}const menuItems=this.el.children;for(let i=0;i<menuItems.length;i++){if(menuItems[i]===targetEl){this._focusItem(i);break}}}},{TYPE_STANDARD_MENU:1,TYPE_BUTTON_MENU:2});"use strict";RB.NotificationManager=Backbone.View.extend({initialize(){this._canNotify=false;this._notification=null},setup(){const Notification=RB.NotificationManager.Notification;this._canNotify=Notification!==undefined&&RB.UserSession.instance.get("enableDesktopNotifications");if(this._canNotify&&!this._haveNotificationPermissions()){Notification.requestPermission()}},_haveNotificationPermissions(){return this._canNotify&&RB.NotificationManager.Notification.permission==="granted"},shouldNotify(){return this._canNotify&&this._haveNotificationPermissions()},notify(options){if(!this._canNotify){return}if(this._notification){this._notification.close()}console.assert(options.hasOwnProperty("title"),'RB.NotificationManager.notify requires "title" property');const notification=new RB.NotificationManager.Notification(options.title,{body:options.body,icon:options.iconURL});this._notification=notification;notification.onclick=function(){if(_.isFunction(options.onClick)){options.onClick()}notification.close()};_.delay(()=>notification.close(),RB.NotificationManager.NOTIFICATION_LIFETIME_MSECS)}},{instance:null,NOTIFICATION_LIFETIME_MSECS:1e4,Notification:window.Notification||window.mozNotification||window.webkitNotification});RB.NotificationManager.instance=new RB.NotificationManager;"use strict";RB.ReviewRequestInfoboxView=RB.BaseInfoboxView.extend({infoboxID:"review-request-infobox"});$.fn.review_request_infobox=RB.InfoboxManagerView.createJQueryFn(RB.ReviewRequestInfoboxView);"use strict";RB.ScrollManagerView=Backbone.View.extend({initialize(){this.scrollYOffset=0;this.window=window;this._updateScrollPosScheduled=false;this._pendingElements=new Map;this._elements=new Map;this._oldScrollY=null;this._useScrollYOffset=false},scrollToElement($el){this.scrollToPosition($el.offset().top)},scrollToPosition(scrollY){this._oldScrollY=scrollY;this._useScrollYOffset=true;this.window.scrollTo(this.window.pageXOffset,scrollY);if("scrollRestoration"in history){history.scrollRestoration="manual"}this._scheduleUpdateScrollPos(true)},markForUpdate($el){console.assert($el.length===1);const oldOffset=$el.offset();this._pendingElements.set($el[0],{oldHeight:$el.outerHeight(),oldOffset:{left:oldOffset.left,top:oldOffset.top}});if(this._oldScrollY===null){this._oldScrollY=this.window.pageYOffset}},markUpdated($el){console.assert($el.length===1);const el=$el[0];const elInfo=this._pendingElements.get(el);if(elInfo){elInfo.newHeight=$el.outerHeight();elInfo.newOffset=$el.offset();this._elements.set(el,elInfo);this._pendingElements.delete(el)}this._scheduleUpdateScrollPos()},_scheduleUpdateScrollPos(){if(!this._updateScrollPosScheduled){this._updateScrollPosScheduled=true;this.window.requestAnimationFrame(this._updateScrollPos.bind(this))}},_updateScrollPos(){const elInfos=[];this._elements.forEach((elInfo,el)=>{if(elInfo.oldHeight!==elInfo.newHeighht){elInfo.el=el;elInfos.push(elInfo)}});let scrollY=this._oldScrollY;if(this._useScrollYOffset){scrollY-=this.scrollYOffset}if(elInfos.length>0){elInfos.sort((a,b)=>a.newOffset.top-b.newOffset.top);for(let i=0;i<elInfos.length;i++){const elInfo=elInfos[i];if(elInfo.newOffset.top+elInfo.newHeight<scrollY){scrollY+=elInfo.newHeight-elInfo.oldHeight+(elInfo.newOffset.top-elInfo.oldOffset.top)}}}this.window.scrollTo(this.window.pageXOffset,scrollY);this._elements.clear();this._oldScrollY=null;this._useScrollYOffset=false;this._updateScrollPosScheduled=false}});RB.scrollManager=new RB.ScrollManagerView;"use strict";RB.SplitButtonView=RB.MenuButtonView.extend({initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};RB.MenuButtonView.prototype.initialize.call(this,{ariaMenuLabel:options.ariaMenuLabel,hasPrimaryButton:true,menuType:RB.MenuView.TYPE_BUTTON_MENU,onPrimaryButtonClick:options.click,text:options.text});this._primaryButtonID=options.id;this._alternatives=options.alternatives},render(){RB.MenuButtonView.prototype.render.call(this);if(this._primaryButtonID){this.$primaryButton.attr("id",this._primaryButtonID)}const menu=this.menu;this._alternatives.forEach(alt=>{const $item=menu.addItem({text:alt.text,onClick:alt.click});if(alt.id){$item.attr("id",alt.id)}});return this}});"use strict";(function(){CodeMirror.defineSimpleMode("rb-text-plain",{start:[{regex:/.*/,token:"rb-cm-codeblock-plain",next:"start"}]});CodeMirror.defineMIME("text/plain","rb-text-plain");const CodeMirrorWrapper=Backbone.View.extend({initialize(options){this.options=options;const codeMirrorOptions={mode:{highlightFormatting:true,name:"gfm",tokenTypeOverrides:{code:"rb-markdown-code",list1:"rb-markdown-list1",list2:"rb-markdown-list2",list3:"rb-markdown-list3"}},theme:"rb default",lineWrapping:true,electricChars:false,styleSelectedText:true,extraKeys:{Home:"goLineLeft",End:"goLineRight",Enter:"newlineAndIndentContinueMarkdownList","Shift-Tab":false,Tab:false}};if(options.autoSize){codeMirrorOptions.viewportMargin=Infinity}this._codeMirror=new CodeMirror(options.parentEl,codeMirrorOptions);this.setElement(this._codeMirror.getWrapperElement());if(this.options.minHeight!==undefined){this.$el.css("min-height",this.options.minHeight)}this._codeMirror.on("viewportChange",()=>this.$el.triggerHandler("resize"));this._codeMirror.on("change",()=>this.trigger("change"))},isDirty(initialValue){return(initialValue||"")!==this.getText()},setText(text){this._codeMirror.setValue(text)},getText(){return this._codeMirror.getValue()},insertLine(text){let position;if(this._codeMirror.hasFocus()){const cursor=this._codeMirror.getCursor();const line=this._codeMirror.getLine(cursor.line);position=CodeMirror.Pos(cursor.line,line.length-1);if(line.length!==0){text="\n"+text}if(!text.endsWith("\n")){text+="\n"}}else{position=CodeMirror.Pos(this._codeMirror.lastLine());text="\n"+text}this._codeMirror.replaceRange(text,position)},getClientHeight(){return this._codeMirror.getScrollInfo().clientHeight},setSize(width,height){this._codeMirror.setSize(width,height);this._codeMirror.refresh()},focus(){this._codeMirror.focus()}});const TextAreaWrapper=Backbone.View.extend({tagName:"textarea",initialize(options){this.options=options;if(options.autoSize){this.$el.autoSizeTextArea()}this.$el.css("width","100%").appendTo(options.parentEl).on("change keydown keyup keypress",()=>this.trigger("change"));if(options.minHeight!==undefined){if(options.autoSize){this.$el.autoSizeTextArea("setMinHeight",options.minHeight)}else{this.$el.css("min-height",this.options.minHeight)}}},isDirty(initialValue){const value=this.el.value||"";return value.length!==initialValue.length||value!==initialValue},setText(text){this.el.value=text;if(this.options.autoSize){this.$el.autoSizeTextArea("autoSize")}},getText(){return this.el.value},insertLine(text){if(this.$el.is(":focus")){const value=this.el.value;const cursor=this.el.selectionEnd;const endOfLine=value.indexOf("\n",cursor);if(endOfLine===-1){this.el.value+="\n"+text}else{this.el.value=value.slice(0,endOfLine+1)+"\n"+text+"\n"+value.slice(endOfLine)}}else{this.el.value+="\n"+text}},getClientHeight(){return this.el.clientHeight},setSize(width,height){if(width!==null){this.$el.innerWidth(width)}if(height!==null){if(height==="auto"&&this.options.autoSize){this.$el.autoSizeTextArea("autoSize",true)}else{this.$el.innerHeight(height)}}},focus(){this.$el.focus()}});RB.TextEditorView=Backbone.View.extend({className:"text-editor",defaultOptions:{autoSize:true,minHeight:70},events:{focus:"focus",remove:"_onRemove"},initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this._files=[];this._editor=null;this._prevClientHeight=null;this.options=_.defaults(options,this.defaultOptions);this.richText=!!this.options.richText;this._dropTarget=null;this._value=this.options.text||"";this._richTextDirty=false;if(this.options.bindRichText){this.bindRichTextAttr(this.options.bindRichText.model,this.options.bindRichText.attrName)}if(RB.UserSession.instance.get("defaultUseRichText")){this.setRichText(true)}},render(){this.$el.addClass(this.className);return this},setRichText(richText){if(richText===this.richText){return}if(this._editor){this._hideEditor();this.richText=richText;this._showEditor();this._richTextDirty=true;this.$el.triggerHandler("resize")}else{this.richText=richText}this.trigger("change:richText",richText);this.trigger("change")},bindRichTextAttr(model,attrName){this.setRichText(model.get(attrName));this.listenTo(model,`change:${attrName}`,(model,value)=>this.setRichText(value))},bindRichTextCheckbox($checkbox){$checkbox.prop("checked",this.richText).on("change",()=>this.setRichText($checkbox.prop("checked")));this.on("change:richText",()=>$checkbox.prop("checked",this.richText))},bindRichTextVisibility($el){$el.setVisible(this.richText);this.on("change:richText",()=>$el.setVisible(this.richText))},isDirty(initialValue){return this._editor!==null&&(this._richTextDirty||this._editor.isDirty(initialValue||""))},setText(text){if(text!==this.getText()){if(this._editor){this._editor.setText(text)}else{this._value=text}}},getText(){return this._editor?this._editor.getText():this._value},insertLine(text){if(this._editor){this._editor.insertLine(text)}else{if(this._value.endsWith("\n")){this._value+=text+"\n"}else{this._value+="\n"+text}}},setSize(width,height){if(this._editor){this._editor.setSize(width,height)}},show(){this.$el.show();this._showEditor()},hide(){this._hideEditor();this.$el.hide()},focus(){if(this._editor){this._editor.focus()}},_onRemove(){RB.DnDUploader.instance.unregisterDropTarget(this.$el)},_showEditor(){const EditorCls=this.richText?CodeMirrorWrapper:TextAreaWrapper;if(this.richText){RB.DnDUploader.instance.registerDropTarget(this.$el,gettext("Drop to add an image"),this._uploadImage.bind(this))}this._editor=new EditorCls({parentEl:this.el,autoSize:this.options.autoSize,minHeight:this.options.minHeight});this._editor.setText(this._value);this._value="";this._richTextDirty=false;this._prevClientHeight=null;this._editor.$el.on("resize",_.throttle(()=>this.$el.triggerHandler("resize"),250));this.listenTo(this._editor,"change",_.throttle(()=>{if(this._editor===null){return}const clientHeight=this._editor.getClientHeight();if(clientHeight!==this._prevClientHeight){this._prevClientHeight=clientHeight;this.$el.triggerHandler("resize")}this.trigger("change")},500));this.focus()},_hideEditor(){RB.DnDUploader.instance.unregisterDropTarget(this.$el);if(this._editor){this._value=this._editor.getText();this._richTextDirty=false;this._editor.remove();this._editor=null;this.$el.empty()}},_isImage(file){if(file.type){return file.type.split("/")[0]==="image"}const filename=file.name.toLowerCase();return[".jpeg",".jpg",".png",".gif",".bmp",".tiff",".svg"].some(extension=>filename.endsWith(extension))},_uploadImage(file){if(!this._isImage(file)){return}const userFileAttachment=new RB.UserFileAttachment({caption:file.name});userFileAttachment.save().then(()=>{this.insertLine(`![Image](${userFileAttachment.get("downloadURL")})`);userFileAttachment.set("file",file);userFileAttachment.save().catch(err=>alert(err.message))}).catch(err=>alert(err.message))}},{getInlineEditorOptions(options){let textEditor;return{matchHeight:false,multiline:true,createMultilineField(editor){const $editor=editor.element;let origRichText;textEditor=new RB.TextEditorView(options);textEditor.render();$editor.one("beginEdit",function(){const $buttons=$editor.inlineEditor("buttons");const $span=$('<span class="enable-markdown" />');const $checkbox=$("<input/>").attr({id:_.uniqueId("markdown_check"),type:"checkbox"}).appendTo($span);textEditor.bindRichTextCheckbox($checkbox);$span.append($("<label/>").attr("for",$checkbox[0].id).text(gettext("Enable Markdown")));$buttons.append($span);const $markdownRef=$("<a/>").addClass("markdown-info").attr({href:MANUAL_URL+"users/markdown/",target:"_blank"}).text(gettext("Markdown Reference")).setVisible(textEditor.richText).appendTo($buttons);textEditor.bindRichTextVisibility($markdownRef)});$editor.on("beginEdit",function(){textEditor._showEditor();origRichText=textEditor.richText});$editor.on("cancel",function(){textEditor._hideEditor();textEditor.setRichText(origRichText)});$editor.on("complete",function(){textEditor._hideEditor()});textEditor.$el.data("text-editor",textEditor);return textEditor.$el},setFieldValue(editor,value){textEditor.setText(value||"")},getFieldValue(){return textEditor.getText()},isFieldDirty(editor,initialValue){return textEditor.isDirty(initialValue)}}},getFromInlineEditor($editor){return $editor.inlineEditor("field").data("text-editor")}})})();"use strict";RB.UserInfoboxView=RB.BaseInfoboxView.extend({infoboxID:"user-infobox",render(){RB.BaseInfoboxView.prototype.render.call(this);const $localTime=this.$(".localtime").children("time");if($localTime.length>0){const timezone=$localTime.data("timezone");const now=moment.tz(timezone);$localTime.text(now.format("LT"))}this.$(".timesince").timesince();return this}});$.fn.user_infobox=RB.InfoboxManagerView.createJQueryFn(RB.UserInfoboxView);"use strict";RB.StarManager=Backbone.Model.extend({defaults(){return{objects:{},starred:{}}}});"use strict";(function(){const Item=RB.BaseResource.extend({defaults(){return _.defaults({baseURL:null,loaded:true,objectID:null,stored:false},RB.BaseResource.prototype.defaults())},url(){let url=this.get("baseURL");if(this.get("stored")){url+=this.get("objectID")+"/"}return url},isNew(){return!this.get("stored")},toJSON(){return{object_id:this.get("objectID")||undefined}},parse(){}});const StoredItems=RB.BaseResource.extend({defaults(){return _.defaults({addError:"",removeError:""},RB.BaseResource.prototype.defaults())},url(){return this.get("url")},addImmediately(obj){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let context=arguments.length>2&&arguments[2]!==undefined?arguments[2]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("StoredItems.addImmediately was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.addImmediately(obj))}const url=this.url();if(url){const item=new Item({objectID:obj.id,baseURL:url});return item.save()}else{return Promise.reject(new Error(this.addError))}},removeImmediately(obj){let options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let context=arguments.length>2&&arguments[2]!==undefined?arguments[2]:undefined;if(_.isFunction(options.success)||_.isFunction(options.error)||_.isFunction(options.complete)){console.warn("StoredItems.removeImmediately was called using "+"callbacks. Callers should be updated to use "+"promises instead.");return RB.promiseToCallbacks(options,context,newOptions=>this.removeImmediately(obj))}const url=this.url();return new Promise((resolve,reject)=>{if(url){const item=new Item({objectID:obj.id,baseURL:url,stored:true});resolve(item.destroy())}else{reject(new Error(this.removeError))}})}});RB.UserSession=Backbone.Model.extend({defaults:{archivedReviewRequestsURL:null,authenticated:false,diffsShowExtraWhitespace:false,fullName:null,loginURL:null,mutedReviewRequestsURL:null,readOnly:false,sessionURL:null,timezoneOffset:"0",userFileAttachmentsURL:null,userPageURL:null,username:null,watchedReviewGroupsURL:null,watchedReviewRequestsURL:null},initialize(){this.watchedGroups=new StoredItems({url:this.get("watchedReviewGroupsURL"),addError:gettext("Must log in to add a watched item."),removeError:gettext("Must log in to remove a watched item.")});this.watchedReviewRequests=new StoredItems({url:this.get("watchedReviewRequestsURL"),addError:gettext("Must log in to add a watched item."),removeError:gettext("Must log in to remove a watched item.")});this.archivedReviewRequests=new StoredItems({url:this.get("archivedReviewRequestsURL"),removeError:gettext("Must log in to remove a archived item."),addError:gettext("Must log in to add an archived item.")});this.mutedReviewRequests=new StoredItems({url:this.get("mutedReviewRequestsURL"),removeError:gettext("Must log in to remove a muted item."),addError:gettext("Must log in to add a muted item.")});this._bindCookie({attr:"diffsShowExtraWhitespace",cookieName:"show_ew",deserialize:value=>value!=="false"})},toggleAttr(attr){this.set(attr,!this.get(attr))},getAvatarHTML:function(size){var urls=this.get("avatarHTML")||{};return urls[size]||""},getAvatarURLs(size){const urls=this.get("avatarURLs")||{};return urls[size]||{}},_bindCookie(options){const deserialize=options.deserialize||_.identity;const serialize=options.serialize||(value=>value.toString());this.set(options.attr,deserialize($.cookie(options.cookieName)));this.on(`change:${options.attr}`,(model,value)=>{$.cookie(options.cookieName,serialize(value),{path:SITE_ROOT})})}},{instance:null,ARCHIVED:"A",MUTED:"M",create(options){console.assert(!RB.UserSession.instance,"UserSession.create can only be called once.");RB.UserSession.instance=new RB.UserSession(options);return RB.UserSession.instance}})})();"use strict";RB.HeaderView=Backbone.View.extend({SEARCH_SUMMARY_TRIM_LEN:28,DESKTOP_SEARCH_RESULTS_WIDTH:350,events:{"click #nav_toggle":"_handleNavClick","touchstart #nav_toggle":"_handleNavClick","focus #search_field":"_closeMobileMenu"},_ensureSingleton(){if(RB.HeaderView.instance!==null){console.warn("There are two instances of RB.HeaderView on the "+"page. Make sure only one RB.PageView is "+"instantiated and registered through "+"RB.PageManager.setupPage().")}else{RB.HeaderView.instance=this}},initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this._ensureSingleton();this.options=options;this.isRendered=false;this._mobileMenuOpened=false;this._$window=null;this._$body=null;this._$navToggle=null;this._$mobileMenuMask=null},remove(){if(RB.HeaderView.instance===this){RB.HeaderView.instance=null}if(this._$window){this._$window.off("resize.rbHeaderView",this._recalcFunc)}Backbone.View.prototype.remove.call(this)},render(){const options=this.options;this._$window=$(window);this._$body=options.body||$(document.body);this._$navToggle=$("#nav_toggle");this._$mobileMenuMask=$('<div id="mobile_menu_mask"/>').on("click touchstart",this._closeMobileMenu.bind(this)).insertAfter(options.$pageSidebar||$("#page-sidebar"));this._recalcFunc=_.throttle(this._recalcMobileMode.bind(this),100);this._$window.on("resize.rbHeaderView",this._recalcFunc);this._recalcMobileMode();this._setupSearch();this.isRendered=true;return this},_handleNavClick(e){e.stopPropagation();e.preventDefault();this._setMobileMenuOpened(!this._mobileMenuOpened)},_recalcMobileMode(){const inMobileMode=this._$navToggle.is(":visible");if(inMobileMode===this.inMobileMode){return}if(!inMobileMode){this._setMobileMenuOpened(false)}this.inMobileMode=inMobileMode;this.trigger("mobileModeChanged",inMobileMode)},_closeMobileMenu(){this._setMobileMenuOpened(false);return false},_setupSearch(){this._$search=$("#search_field").rbautocomplete({formatItem:data=>{let s;if(data.username){s=data.username;if(data.fullname){s+=` <span>(${_.escape(data.fullname)})</span>`}}else if(data.name){const displayName=_.escape(data.display_name);s=`${data.name} <span>(${displayName})</span>`}else if(data.summary){if(data.summary.length<this.SEARCH_SUMMARY_TRIM_LEN){s=data.summary}else{s=data.summary.substring(0,this.SEARCH_SUMMARY_TRIM_LEN)}s+=` <span>(${_.escape(data.id)})</span>`}return s},matchCase:false,multiple:false,clickToURL:true,selectFirst:false,width:this.DESKTOP_SEARCH_RESULTS_WIDTH,enterToURL:true,resultsParentEl:$("#page-container"),resultsClass:"ui-autocomplete-results search-results",parse:data=>{const objects=["users","groups","review_requests"];const keys=["username","name","summary"];const parsed=[];for(let j=0;j<objects.length;j++){const object=objects[j];const items=data.search[object];for(let i=0;i<items.length;i++){const value=items[i];const key=keys[j];if(j!==2){parsed.push({data:value,value:value[key],result:value[key]})}else if(value.public){parsed.push({data:value,value:value[key],result:value[key]})}}}return parsed},url:`${SITE_ROOT}api/search/`,extraParams:{"only-fields":"display_name,fullname,id,name,public,summary,url,username","only-links":""}})},_setMobileMenuOpened(opened){if(opened===this._mobileMenuOpened){return}if(opened){this._$mobileMenuMask.show();_.defer(()=>this._$body.addClass("js-mobile-menu-open"))}else{this._$body.removeClass("js-mobile-menu-open");_.delay(()=>this._$mobileMenuMask.hide(),300)}this._mobileMenuOpened=opened}},{instance:null});"use strict";RB.CollectionView=Backbone.View.extend({itemViewType:null,initialize(options){if(options.itemViewType){this.itemViewType=options.itemViewType}this.itemViewOptions=options.itemViewOptions||{};const collection=options.collection;this.collection=collection;this.views=[];this._viewsByModelID={};collection.each(this._onAdded,this);this.listenTo(collection,"add",this._onAdded);this.listenTo(collection,"remove",this._onRemoved);this.listenTo(collection,"sort",this._onSorted);this.listenTo(collection,"reset",this._onReset);this.$container=this.$el},render(){this._rendered=true;this.$container.empty();this._addCollectionViews();return this},_addCollectionViews(){this.views.forEach(view=>this.$container.append(view.render().el))},_onAdded(item){console.assert(this.itemViewType,"itemViewType must be defined by the subclass");const view=new this.itemViewType(_.defaults({model:item},this.itemViewOptions));this.views.push(view);this._viewsByModelID[item.cid]=view;if(this._rendered){this.$container.append(view.render().el)}},_onRemoved(item){const toRemove=this._viewsByModelID[item.cid];if(toRemove){delete this._viewsByModelID[item.cid];this.views=_.without(this.views,toRemove);if(this._rendered){toRemove.remove()}}},_onSorted(){let views=this.views;const models=this.collection.models;const oldViews=this.views;let orderChanged=false;if(models.length===oldViews.length){for(let i=0;i<oldViews.length;i++){if(oldViews[i].model!==models[i]){orderChanged=true;break}}}else{orderChanged=true}if(!orderChanged){return}this.views=this.collection.map(model=>this._viewsByModelID[model.cid]);if(this._rendered){this.$container.children().detach();this._addCollectionViews()}},_onReset(){this.views.forEach(view=>view.remove());this.views=[];this._viewsByModelID={};this.collection.each(this._onAdded,this)}});"use strict";RB.StarManagerView=Backbone.View.extend({initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const objects=this.model.get("objects");const starred=this.model.get("starred");this._datagridMode=options.datagridMode;this.$("div.star").on("click",this._toggleStar.bind(this)).each((idx,el)=>{const $el=$(el);const objType=$el.attr("data-object-type");const objID=$el.attr("data-object-id");const objStarred=parseInt($el.attr("data-starred"),10)===1;let obj;if(objType==="reviewrequests"){obj=new RB.ReviewRequest({id:objID})}else if(objType==="groups"){obj=new RB.ReviewGroup({id:objID})}else if(objType!==undefined){console.assert("Unknown star object type: %s",objType)}else{return}objects[objID]=obj;starred[objID]=objStarred});this._watchUpdates=false;this._toUpdate={};if(this._datagridMode){this.$el.on("datagridDisplayModeChanged",($grid,options)=>{if(options.mode==="desktop"){for(let objID in this._toUpdate){if(this._toUpdate.hasOwnProperty(objID)){this._updateStarColumn(objID)}}this._watchUpdates=false;this._toUpdate={}}else if(options.mode==="mobile"){this._watchUpdates=true}});if(this.$el.attr("data-datagrid-display-mode")==="mobile"){this._watchUpdates=true}}},_updateStarColumn(objID){const $el=this.$(`.star[data-object-id="${objID}"]`);const starred=this.model.get("starred")[objID];$el.toggleClass("rb-icon-star-on",starred).toggleClass("rb-icon-star-off",!starred).attr("title",starred?gettext("Starred"):gettext("Click to star"))},_toggleStar(e){const $target=$(e.target);const objID=$target.attr("data-object-id");const obj=this.model.get("objects")[objID];const starred=this.model.get("starred");const objStarred=!starred[objID];e.preventDefault();e.stopPropagation();if(RB.UserSession.instance.get("readOnly")){return}obj.setStarred(objStarred);starred[objID]=objStarred;if(this._watchUpdates){if(this._toUpdate.hasOwnProperty(objID)){delete this._toUpdate[objID]}else{this._toUpdate[objID]=true}}$target.toggleClass("rb-icon-star-on",objStarred).toggleClass("rb-icon-star-off",!objStarred).attr("title",objStarred?gettext("Starred"):gettext("Click to star"))}})}).call(this);
