(function(){"use strict";RB.DatagridPage=RB.Page.extend({defaults:_.defaults({count:0,localSiteName:null},RB.Page.prototype.defaults),rowObjectType:null,initialize(){this.selection=new Backbone.Collection([],{model:this.rowObjectType});this.listenTo(this.selection,"add remove reset",()=>this.set("count",this.selection.length))},select(id){const localSiteName=this.get("localSiteName");this.selection.add({id:id,localSitePrefix:localSiteName?`s/${localSiteName}/`:null})},unselect(id){this.selection.remove(this.selection.get(id))},clearSelection(){this.selection.reset()}});"use strict";RB.Dashboard=RB.DatagridPage.extend({rowObjectType:RB.ReviewRequest,closeReviewRequests(options){const reviewRequests=this.selection.clone();const successes=[];const failures=[];function closeNext(){if(reviewRequests.length===0){this.selection.reset();this.trigger("refresh");options.onDone(successes,failures);return}const reviewRequest=reviewRequests.shift();reviewRequest.close({type:options.closeType,success:()=>successes.push(reviewRequest),error:()=>failures.push(reviewRequest),complete:closeNext.bind(this)})}closeNext.call(this)},updateVisibility(visibilityFunc){const reviewRequests=this.selection.clone();const successes=[];const failures=[];function hideNext(){if(reviewRequests.length===0){this.selection.reset();this.trigger("refresh");return}const reviewRequest=reviewRequests.shift();visibilityFunc(reviewRequest).then(()=>{successes.push(reviewRequest);hideNext.call(this)}).catch(()=>{failures.push(reviewRequest);hideNext.call(this)})}hideNext.call(this)}});"use strict";RB.DatagridPageView=RB.PageView.extend({RELOAD_INTERVAL_MS:5*60*1e3,actionsViewType:null,events:{"change tbody input[data-checkbox-name=select]":"_onRowSelected","reloaded .datagrid-wrapper":"_setupDatagrid"},initialize(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};RB.PageView.prototype.initialize.call(this,options);this.periodicReload=!!options.periodicReload;this._reloadTimer=null;this._datagrid=null;this._$wrapper=null;this._$datagridBody=null;this._$datagridBodyContainer=null;this._menuShown=false},renderPage(){RB.InfoboxManagerView.getInstance().setPositioning(RB.ReviewRequestInfoboxView,{side:"Ll",LDistance:300,lDistance:20,yOffset:-20});if(this.actionsViewType){this._setupActionsDrawer()}this.listenTo(this.model,"refresh",()=>this._reload(false));this._setupDatagrid();if(this.periodicReload){this._startReloadTimer()}return this},onResize(){if(this._datagrid!==null){this._datagrid.resizeToFit()}},_setupActionsDrawer(){const drawer=new RB.DrawerView;this.setDrawer(drawer);this._actionsView=new this.actionsViewType({model:this.model,datagridView:this});this._actionsView.render().$el.appendTo(drawer.$content);this.listenTo(this.model,"change:count",(model,count)=>{const showMenu=count>0;if(showMenu===this._menuShown){return}if(showMenu){this._showActions();this._stopReloadTimer()}else{this._hideActions();if(this.periodicReload){this._startReloadTimer()}}this._menuShown=showMenu})},_setupDatagrid(){this._$wrapper=this.$("#content_container");this._$datagrid=this._$wrapper.find(".datagrid-wrapper");this._datagrid=this._$datagrid.data("datagrid");this._$main=this._$wrapper.find(".datagrid-main");this.$("time.timesince").timesince();this.$(".user").user_infobox();this.$(".bugs").find("a").bug_infobox();this.$(".review-request-link").review_request_infobox();this.model.clearSelection();_.each(this.$("input[data-checkbox-name=select]:checked"),checkbox=>this.model.select($(checkbox).data("object-id")));if(RB.UserSession.instance.get("authenticated")){this._starManager=new RB.StarManagerView({model:new RB.StarManager,el:this._$main,datagridMode:true})}this._$datagrid.on("reloaded",this._setupDatagrid.bind(this)).on("datagridDisplayModeChanged",this._reselectBatchCheckboxes.bind(this));this._datagrid.resizeToFit()},_reselectBatchCheckboxes(){const checkboxMap={};this.$("input[data-checkbox-name=select]").each((idx,checkboxEl)=>{if(checkboxEl.checked){checkboxEl.checked=false}checkboxMap[checkboxEl.dataset.objectId]=checkboxEl});this.model.selection.each(selection=>{checkboxMap[selection.id].checked=true})},_showActions(){this.drawer.show()},_hideActions(){this.drawer.hide()},_startReloadTimer(){if(!this._reloadTimer){this._reloadTimer=setInterval(this._reload.bind(this),this.RELOAD_INTERVAL_MS)}},_stopReloadTimer(){if(this._reloadTimer){window.clearInterval(this._reloadTimer);this._reloadTimer=null}},_reload(periodicReload){const $editCols=this.$(".edit-columns");if(periodicReload===false){this._stopReloadTimer()}this.model.clearSelection();$editCols.width($editCols.width()-$editCols.getExtents("b","lr")).html('<span class="fa fa-spinner fa-pulse"></span>');this._$wrapper.load(window.location+" #content_container",()=>{this.$(".datagrid-wrapper").datagrid();this._setupDatagrid();if(periodicReload!==false){this._startReloadTimer()}})},_onRowSelected(e){const $checkbox=$(e.target);const objectID=$checkbox.data("object-id");if($checkbox.prop("checked")){this.model.select(objectID)}else{this.model.unselect(objectID)}}});"use strict";(function(){const DashboardActionsView=Backbone.View.extend({template:_.template(`<p class="rb-c-drawer__summary"></p>
<% if (!read_only) { %>
 <div class="rb-c-drawer__actions">
  <ul class="rb-c-drawer__action-group">
   <li class="rb-c-drawer__action js-action-discard">
    <%= close_discarded_text %>
   </li>
   <li class="rb-c-drawer__action js-action-submit">
    <%= close_submitted_text %>
   </li>
  </ul>
  <ul class="rb-c-drawer__action-group">
   <li class="rb-c-drawer__action js-action-archive">
    <%= archive_text %>
   </li>
   <% if (show_archived) { %>
    <li class="rb-c-drawer__action
               js-action-unarchive">
     <%= unarchive_text %>
    </li>
   <% } %>
  </ul>
  <ul class="rb-c-drawer__action-group">
   <li class="rb-c-drawer__action js-action-mute">
    <%= mute_text %></a></li>
   </li>
   <% if (show_archived) { %>
    <li class="rb-c-drawer__action js-action-unmute">
     <%= unmute_text %>
    </li>
   <% } %>
  </ul>
 </div>
<% } %>`),events:{"click .js-action-discard":"_onCloseDiscardedClicked","click .js-action-submit":"_onCloseSubmittedClicked","click .js-action-archive":"_onArchiveClicked","click .js-action-unarchive":"_onUnarchiveClicked","click .js-action-mute":"_onMuteClicked","click .js-action-unmute":"_onUnmuteClicked"},render(){const show_archived=(this.model.get("data")||{}).show_archived;this.$el.html(this.template({close_discarded_text:gettext("<b>Close</b> Discarded"),close_submitted_text:gettext("<b>Close</b> Submitted"),archive_text:gettext("<b>Archive</b>"),mute_text:gettext("<b>Mute</b>"),read_only:RB.UserSession.instance.get("readOnly"),unarchive_text:gettext("<b>Unarchive</b>"),unmute_text:gettext("<b>Unmute</b>"),show_archived:show_archived}));const $summary=this.$(".rb-c-drawer__summary");this.listenTo(this.model,"change:count",(model,count)=>{$summary.text(interpolate(ngettext("%s review request selected","%s review requests selected",count),[count]))});return this},_onCloseDiscardedClicked(ev){ev.stopPropagation();ev.preventDefault();this._closeReviewRequests(RB.ReviewRequest.CLOSE_DISCARDED)},_onCloseSubmittedClicked(ev){ev.stopPropagation();ev.preventDefault();this._closeReviewRequests(RB.ReviewRequest.CLOSE_SUBMITTED)},_closeReviewRequests(closeType){this._confirmClose(()=>{this.model.closeReviewRequests({closeType:closeType,onDone:this._showCloseResults.bind(this)})})},_showCloseResults(successes,failures){const numSuccesses=successes.length;const numFailures=failures.length;const $dlg=$("<div/>").append($("<p/>").text(interpolate(ngettext("%s review request has been closed.","%s review requests have been closed.",numSuccesses),[numSuccesses])));if(numFailures>0){$dlg.append($("<p/>").text(interpolate(ngettext("%s review request could not be closed.","%s review requests could not be closed.",numFailures),[numFailures]))).append($("<p/>").text(gettext("You may not have permission to close them.")))}$dlg.modalBox({title:gettext("Close review requests"),buttons:[$('<input type="button"/>').val(gettext("Thanks!"))]})},_confirmClose:function(onConfirmed){$("<div/>").append($("<p/>").text(gettext("If these review requests have unpublished drafts, they will be discarded."))).append($("<p/>").text(gettext("Are you sure you want to close these review requests?"))).modalBox({title:gettext("Close review requests"),buttons:[$('<input type="button"/>').val(gettext("Cancel")),$('<input type="button"/>').val(gettext("Close Review Requests")).click(onConfirmed.bind(this))]})},_onArchiveClicked(ev){ev.stopPropagation();ev.preventDefault();const collection=RB.UserSession.instance.archivedReviewRequests;this._updateVisibility(collection.addImmediately.bind(collection))},_onUnarchiveClicked(ev){ev.stopPropagation();ev.preventDefault();const collection=RB.UserSession.instance.archivedReviewRequests;this._updateVisibility(collection.removeImmediately.bind(collection))},_onMuteClicked(ev){ev.stopPropagation();ev.preventDefault();const collection=RB.UserSession.instance.mutedReviewRequests;const visibilityFunc=collection.addImmediately.bind(collection);$("<div/>").append($("<p/>").text(gettext("Are you sure you want to mute these review requests?"))).modalBox({title:gettext("Mute review requests"),buttons:[$('<input type="button"/>').val(gettext("Cancel")),$('<input type="button"/>').val(gettext("Mute Review Requests")).click(this._updateVisibility.bind(this,visibilityFunc))]})},_onUnmuteClicked(ev){ev.stopPropagation();ev.preventDefault();const collection=RB.UserSession.instance.mutedReviewRequests;this._updateVisibility(collection.removeImmediately.bind(collection))},_updateVisibility(visibilityFunc){this.model.updateVisibility(visibilityFunc)}});RB.DashboardView=RB.DatagridPageView.extend({actionsViewType:DashboardActionsView})})()}).call(this);
