(function(){"use strict";RB.ReviewRequestPage={};"use strict";RB.ReviewRequestPage.Entry=Backbone.Model.extend({defaults:{addedTimestamp:null,collapsed:false,etag:null,page:null,reviewRequestEditor:null,typeID:null,updatedTimestamp:null},parse(attrs){return{id:attrs.id,collapsed:attrs.collapsed,addedTimestamp:_.isDate(attrs.addedTimestamp)?attrs.addedTimestamp:moment.utc(attrs.addedTimestamp).toDate(),etag:attrs.etag||null,updatedTimestamp:_.isDate(attrs.updatedTimestamp)?attrs.updatedTimestamp:moment.utc(attrs.updatedTimestamp).toDate(),typeID:attrs.typeID,reviewRequestEditor:attrs.reviewRequestEditor}},isUpdated(metadata){const newTimestamp=moment.utc(metadata.updatedTimestamp).toDate();const newETag=metadata.etag||null;const entryETag=this.get("etag")||null;return newTimestamp>this.get("updatedTimestamp")||newETag!==entryETag},beforeApplyUpdate(entryData){},afterApplyUpdate(entryData){},watchUpdates(periodMS){this.get("page").watchEntryUpdates(this,periodMS)},stopWatchingUpdates(){this.get("page").stopWatchingEntryUpdates(this)}});"use strict";RB.ReviewRequestPage.ReviewEntry=RB.ReviewRequestPage.Entry.extend({defaults:_.defaults({diffCommentsData:[],review:null},RB.ReviewRequestPage.Entry.prototype.defaults),parse(attrs){const reviewRequest=attrs.reviewRequestEditor.get("reviewRequest");const reviewData=attrs.reviewData;return _.extend(RB.ReviewRequestPage.Entry.prototype.parse.call(this,attrs),{diffCommentsData:attrs.diffCommentsData,review:reviewRequest.createReview(reviewData.id,{bodyBottom:reviewData.bodyBottom,bodyTop:reviewData.bodyTop,public:reviewData.public,shipIt:reviewData.shipIt})})}});"use strict";RB.ReviewRequestPage.ReviewReplyEditor=Backbone.Model.extend({defaults:{anchorPrefix:null,contextID:null,contextType:null,commentID:null,hasDraft:false,replyObject:null,review:null,reviewReply:null,richText:null,text:""},replyClasses:{diff_comments:RB.DiffCommentReply,screenshot_comments:RB.ScreenshotCommentReply,file_attachment_comments:RB.FileAttachmentCommentReply,general_comments:RB.GeneralCommentReply},initialize(){this.on("change:reviewReply",this._setupReviewReply,this);this._setupReviewReply()},async save(){const contextType=this.get("contextType");const reviewReply=this.get("reviewReply");let valueAttr;let richTextAttr;let obj;if(contextType==="body_top"){valueAttr="bodyTop";richTextAttr="bodyTopRichText";obj=reviewReply}else if(contextType==="body_bottom"){valueAttr="bodyBottom";richTextAttr="bodyBottomRichText";obj=reviewReply}else{valueAttr="text";richTextAttr="richText";obj=this.get("replyObject");if(!obj){const ReplyClass=this.replyClasses[contextType];console.assert(ReplyClass,"Unexpected context type '%s'",contextType);obj=new ReplyClass({parentObject:reviewReply,replyToID:this.get("contextID"),id:this.get("commentID")})}}this.set("replyObject",obj);this.trigger("saving");await obj.ready();const text=this.get("text");if(text){obj.set(valueAttr,text);obj.set(richTextAttr,this.get("richText"));obj.set({forceTextType:"html",includeTextTypes:"raw"});await obj.save({attrs:[valueAttr,richTextAttr,"forceTextType","includeTextTypes","replyToID"]});this.set({hasDraft:true,text:obj.get(valueAttr),richText:true});this.trigger("textUpdated");this.trigger("saved")}else{await this.resetStateIfEmpty()}},async resetStateIfEmpty(){const text=this.get("text");if(text.strip()!==""){return}const replyObject=this.get("replyObject");if(!replyObject||replyObject.isNew()){await this._resetState()}else{const contextType=this.get("contextType");if(contextType==="body_top"||contextType==="body_bottom"){await this._resetState(true)}else{await replyObject.destroy();await this._resetState()}}},_setupReviewReply(){const reviewReply=this.get("reviewReply");const oldReviewReply=this.previous("reviewReply");if(oldReviewReply){oldReviewReply.off(null,null,this)}this.listenTo(reviewReply,"destroyed",async()=>{this.trigger("discarded");await this._resetState();this.trigger("discarded-finished")});this.listenTo(reviewReply,"published",async()=>{this.trigger("published");await this._resetState(false);this.trigger("published-finished")})},async _resetState(shouldDiscardIfEmpty){this.set({commentID:null,hasDraft:false,replyObject:null});if(shouldDiscardIfEmpty===false){this.trigger("resetState")}else{await this.get("reviewReply").discardIfEmpty();this.trigger("resetState")}}});"use strict";RB.ReviewRequestPage.ReviewRequestPage=RB.ReviewablePage.extend({defaults:_.defaults({updatesURL:null},RB.ReviewablePage.prototype.defaults),initialize(){RB.ReviewablePage.prototype.initialize.apply(this,arguments);this._watchedEntries={};this._watchedUpdatesPeriodMS=null;this._watchedUpdatesTimeout=null;this._watchedUpdatesLastScheduleTime=null;this.entries=new Backbone.Collection([],{model:RB.ReviewRequestPage.Entry})},parse(rsp){return _.extend({updatesURL:rsp.updatesURL},RB.ReviewablePage.prototype.parse.call(this,rsp))},addEntry(entry){entry.set("page",this);this.entries.add(entry)},watchEntryUpdates(entry,periodMS){if(this._watchedUpdatesPeriodMS===null||periodMS<this._watchedUpdatesPeriodMS){if(this._watchedUpdatesTimeout!==null&&Date.now()-this._watchedUpdatesLastScheduleTime>periodMS){clearTimeout(this._watchedUpdatesTimeout);this._watchedUpdatesTimeout=null}this._watchedUpdatesPeriodMS=periodMS}this._watchedEntries[entry.id]={entry:entry,periodMS:periodMS};this._scheduleCheckUpdates()},stopWatchingEntryUpdates(entry){if(!this._watchedEntries.hasOwnProperty(entry.id)){return}delete this._watchedEntries[entry.id];this._watchedUpdatesPeriodMS=null;if(_.isEmpty(this._watchedEntries)){if(this._watchedUpdatesTimeout!==null){clearTimeout(this._watchedUpdatesTimeout);this._watchedUpdatesTimeout=null}this._watchedUpdatesLastScheduleTime=null}else{for(let key in this._watchedEntries){if(this._watchedEntries.hasOwnProperty(key)){const periodMS=this._watchedEntries[key].periodMS;this._watchedUpdatesPeriodMS=this._watchedUpdatesPeriodMS===null?periodMS:Math.min(this._watchedUpdatesPeriodMS,periodMS)}}}},_scheduleCheckUpdates(){if(this._watchedUpdatesTimeout!==null||this._watchedUpdatesPeriodMS===null){return}this._watchedUpdatesLastScheduleTime=Date.now();this._watchedUpdatesTimeout=setTimeout(()=>{this._watchedUpdatesTimeout=null;this._loadUpdates({entries:_.pluck(this._watchedEntries,"entry"),onDone:this._scheduleCheckUpdates.bind(this)})},this._watchedUpdatesPeriodMS)},_loadUpdates(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const updatesURL=this.get("updatesURL");const allEntryIDs={};const entries=options.entries||[];const urlQuery=[];if(entries.length>0){for(let i=0;i<entries.length;i++){const entry=entries[i];const typeID=entry.get("typeID");if(!allEntryIDs.hasOwnProperty(typeID)){allEntryIDs[typeID]=[]}allEntryIDs[typeID].push(entry.id)}const urlEntryTypeIDs=[];for(let entryTypeID in allEntryIDs){if(allEntryIDs.hasOwnProperty(entryTypeID)){allEntryIDs[entryTypeID].sort((a,b)=>a-b);const entryIDs=allEntryIDs[entryTypeID].join(",");urlEntryTypeIDs.push(`${entryTypeID}:${entryIDs}`)}}urlQuery.push(`entries=${urlEntryTypeIDs.join(";")}`)}urlQuery.sort();const urlQueryStr=urlQuery.length>0?`?${urlQuery.join("&")}`:"";Backbone.sync("read",this,{url:`${updatesURL}${urlQueryStr}`,dataType:"arraybuffer",noActivityIndicator:true,success:arrayBuffer=>this._processUpdatesFromPayload(arrayBuffer,options.onDone)})},_processUpdatesFromPayload(arrayBuffer,onDone){const dataView=new DataView(arrayBuffer);const len=dataView.byteLength;let pos=0;let totalUpdates=0;let totalApplied=0;let done=false;const onUpdateLoaded=(metadata,html)=>{if(metadata.type==="entry"){this._processEntryUpdate(metadata,html)}else{this._reloadFromUpdate(null,metadata,html)}totalApplied++;if(done&&totalApplied===totalUpdates){this.trigger("updatesProcessed");if(_.isFunction(onDone)){onDone()}}};while(!done){const parsed=this._processUpdateFromPayload(arrayBuffer,dataView,pos);totalUpdates++;pos=parsed.pos;done=pos>=len;parsed.load(onUpdateLoaded)}},_processUpdateFromPayload(arrayBuffer,dataView,pos){const metadataLen=dataView.getUint32(pos,true);pos+=4;const metadataStart=pos;pos+=metadataLen;const htmlLen=dataView.getUint32(pos,true);pos+=4;const htmlStart=pos;pos+=htmlLen;return{pos:pos,load(cb){const metadataBlob=new Blob([arrayBuffer.slice(metadataStart,metadataStart+metadataLen)]);const htmlBlob=new Blob([arrayBuffer.slice(htmlStart,htmlStart+htmlLen)]);RB.DataUtils.readManyBlobsAsStrings([metadataBlob,htmlBlob],(metadata,html)=>cb(JSON.parse(metadata),html))}}},_processEntryUpdate(metadata,html){const entry=this.entries.get(metadata.entryID);if(!entry){return}console.assert(entry.get("typeID")===metadata.entryType);if(entry.isUpdated(metadata)){this._reloadFromUpdate(entry,metadata,html)}},_reloadFromUpdate(model,metadata,html){this.trigger(`applyingUpdate:${metadata.type}`,metadata,html);if(model){this.trigger(`applyingUpdate:${metadata.type}:${model.id}`,metadata,html);if(_.isFunction(model.beforeApplyUpdate)){model.beforeApplyUpdate(metadata)}model.set(model.parse(_.extend({},model.attributes,metadata.modelData,{etag:metadata.etag,updatedTimestamp:metadata.updatedTimestamp})));this.trigger(`appliedModelUpdate:${metadata.type}:${model.id}`,metadata,html);if(_.isFunction(model.afterApplyUpdate)){model.afterApplyUpdate(metadata)}this.trigger(`appliedUpdate:${metadata.type}:${model.id}`,metadata,html)}this.trigger(`appliedUpdate:${metadata.type}`,metadata,html)}});"use strict";RB.ReviewRequestPage.StatusUpdatesEntry=RB.ReviewRequestPage.Entry.extend({defaults(){return _.defaults({diffCommentsData:[],localSitePrefix:null,pendingStatusUpdates:false,reviewRequestId:null,reviews:[]},RB.ReviewRequestPage.Entry.prototype.defaults)},parse(attrs){const reviewRequest=attrs.reviewRequestEditor.get("reviewRequest");const reviewsData=attrs.reviewsData||[];const reviews=reviewsData.map(reviewData=>reviewRequest.createReview(reviewData.id,{bodyBottom:reviewData.bodyBottom,bodyTop:reviewData.bodyTop,public:reviewData.public,shipIt:reviewData.shipIt}));return _.extend(RB.ReviewRequestPage.Entry.prototype.parse.call(this,attrs),{diffCommentsData:attrs.diffCommentsData,localSitePrefix:reviewRequest.get("localSitePrefix"),pendingStatusUpdates:attrs.pendingStatusUpdates,reviewRequestId:reviewRequest.id,reviews:reviews})}});"use strict";(function(){const parentModel=RB.ReviewRequestPage.StatusUpdatesEntry;RB.ReviewRequestPage.ChangeEntry=parentModel.extend({defaults(){return _.defaults({commits:null},parentModel.prototype.defaults.call(this))},parse(attrs){const commits=attrs.commits?new RB.DiffCommitCollection(attrs.commits,{parse:true}):null;return _.extend(parentModel.prototype.parse.call(this,attrs),{commits:commits})}})})();"use strict";RB.ReviewRequestPage.EntryView=Backbone.View.extend({events:{"click .collapse-button":"_onToggleCollapseClicked"},render(){this._$box=this.$(".review-request-page-entry-contents");this._$expandCollapseButton=this.$(".collapse-button .rb-icon");if(this._$box.hasClass("collapsed")){this._$expandCollapseButton.addClass("rb-icon-expand-review")}else{this._$expandCollapseButton.addClass("rb-icon-collapse-review")}return this},isCollapsed(){return this._$box.hasClass("collapsed")},expand(){this._$box.removeClass("collapsed");this._$expandCollapseButton.removeClass("rb-icon-expand-review").addClass("rb-icon-collapse-review");this.model.set("collapsed",false)},collapse(){this._$box.addClass("collapsed");this._$expandCollapseButton.removeClass("rb-icon-collapse-review").addClass("rb-icon-expand-review");this.model.set("collapsed",true)},beforeApplyUpdate(entryData){},afterApplyUpdate(entryData){},_onToggleCollapseClicked(){if(this.isCollapsed()){this.expand()}else{this.collapse()}}});"use strict";(function(){const ParentView=RB.ReviewRequestPage.EntryView;RB.ReviewRequestPage.BaseStatusUpdatesEntryView=ParentView.extend({CHECK_UPDATES_MS:10*1e3,events:_.defaults({"click .status-update-request-run":"_onRequestRunClicked"},ParentView.prototype.events),initialize(){ParentView.prototype.initialize.apply(this,arguments);this._reviewViews=null},beforeApplyUpdate(){this.model.stopWatchingUpdates();const diffFragmentQueue=RB.PageManager.getPage().diffFragmentQueue;const diffCommentsData=this.model.get("diffCommentsData")||[];for(let i=0;i<diffCommentsData.length;i++){diffFragmentQueue.saveFragment(diffCommentsData[i][0])}},render(){ParentView.prototype.render.call(this);this._reviewViews=this.model.get("reviews").map(review=>{const $reviewEl=this.$(`#review${review.id}`);const view=new RB.ReviewRequestPage.ReviewView({el:$reviewEl,model:review,entryModel:this.model,$bannerFloatContainer:$reviewEl,$bannerParent:$reviewEl.children(".banners"),bannerNoFloatContainerClass:"collapsed"});view.render();this.setupReviewView(view);return view});if(this.model.get("pendingStatusUpdates")){this.model.watchUpdates(this.CHECK_UPDATES_MS)}return this},setupReviewView(view){},_onRequestRunClicked(e){const $target=$(e.target);const updateId=$target.data("statusUpdateId");const reviewRequestId=this.model.get("reviewRequestId");RB.apiCall({type:"PUT",prefix:this.model.get("localSitePrefix")||"",path:`/review-requests/${reviewRequestId}/status-updates/${updateId}/`,buttons:$target,data:{state:"request-run"},success:()=>{this.model.stopWatchingUpdates();this.model.watchUpdates(0)}})}})})();"use strict";(function(){const ParentView=RB.ReviewRequestPage.BaseStatusUpdatesEntryView;RB.ReviewRequestPage.ChangeEntryView=ParentView.extend({initialize(options){ParentView.prototype.initialize.apply(this,arguments);const reviewRequestEditor=this.model.get("reviewRequestEditor");this.reviewRequest=reviewRequestEditor.get("reviewRequest");this.reviewRequestEditorView=options.reviewRequestEditorView;this._commitListView=null;this._$boxStatus=null;this._$fixItLabel=null},render(){ParentView.prototype.render.call(this);this._$boxStatus=this.$(".box-status");this._$fixItLabel=$('<label class="fix-it-label">').hide().appendTo(this.$(".labels-container"));RB.formatText(this.$(".changedesc-text"),{bugTrackerURL:this.reviewRequest.get("bugTrackerURL"),isHTMLEncoded:true});this._updateLabels();_.each(this.$(".diff-index tr"),rowEl=>{const $row=$(rowEl);const iconView=new RB.DiffComplexityIconView({numInserts:$row.data("insert-count"),numDeletes:$row.data("delete-count"),numReplaces:$row.data("replace-count"),totalLines:$row.data("total-line-count")});$row.find(".diff-file-icon").empty().append(iconView.$el);iconView.render()});_.each(this.$(".file-container"),thumbnailEl=>{const $thumbnail=$(thumbnailEl);const $caption=$thumbnail.find(".file-caption .edit");const model=this.reviewRequest.draft.createFileAttachment({id:$thumbnail.data("file-id")});if(!$caption.hasClass("empty-caption")){model.set("caption",$caption.text())}this.reviewRequestEditorView.buildFileAttachmentThumbnail(model,null,{$el:$thumbnail,canEdit:false})});const commits=this.model.get("commits");if(commits){this._commitListView=new RB.DiffCommitListView({el:this.$(".commit-list-container"),model:new RB.DiffCommitList({commits:commits,diffHistory:new RB.CommitHistoryDiffEntryCollection})})}return this},setupReviewView(view){this.listenTo(view,"openIssuesChanged",this._updateLabels)},_updateLabels(){if(this._reviewViews.some(view=>view.hasOpenIssues())){const openIssueCount=this._reviewViews.reduce((sum,view)=>sum+view.getOpenIssueCount(),0);this._$boxStatus.addClass("has-issues");this._$fixItLabel.empty().append($('<span class="open-issue-count">').text(interpolate(gettext("%s failed"),[openIssueCount]))).append(document.createTextNode(gettext("Fix it!"))).show().css({opacity:1,left:0})}else{this._$fixItLabel.css({opacity:0,left:"-100px"});this._$boxStatus.removeClass("has-issues")}}})})();"use strict";RB.ReviewRequestPage.InitialStatusUpdatesEntryView=RB.ReviewRequestPage.BaseStatusUpdatesEntryView.extend();"use strict";RB.ReviewRequestPage.IssueSummaryTableView=Backbone.View.extend({events:{"change .rb-c-issue-summary-table__reviewer-filter":"_onReviewerChanged","click thead th":"_onHeaderClicked","click .rb-c-tabs__tab":"_onTabChanged","click tbody tr[data-issue-id]":"_onIssueClicked"},stateToSelectorMap:{open:".-is-open",dropped:".-is-dropped",resolved:".-is-resolved",verifying:".-is-verifying-resolved, .-is-verifying-dropped",all:""},statusIconsMap:{open:"rb-icon-issue-open",dropped:"rb-icon-issue-dropped",resolved:"rb-icon-issue-resolved",verifying:"rb-icon-issue-verifying"},COLUMN_DESCRIPTION:1,COLUMN_REVIEWER:2,COLUMN_LAST_UPDATED:3,_noIssuesTemplate:_.template(`<tr class="rb-c-issue-summary-table__no-issues">
 <td colspan="5"><em><%- text %></em></td>
</tr>`),initialize(){this.statusFilterState=null;this.reviewerFilterState=null;this.reviewerToSelectorMap=null;this.commentIDToRowMap={};this._lastWindowWidth=null;this._$window=$(window);this._$currentTab=null;_.bindAll(this,"_onWindowResize")},render(){const $issueSummaryTable=this.$el.children(".rb-c-issue-summary-table");this._$header=$issueSummaryTable.children(".rb-c-review-request-field-tabular__header");this._$tabs=this._$header.children(".rb-c-tabs");this._$filters=this._$header.children(".rb-c-review-request-field-tabular__filters");this._$reviewerFilter=this._$filters.children(".rb-c-issue-summary-table__reviewer-filter");this._$table=$issueSummaryTable.children(".rb-c-review-request-field-tabular__data");this._$thead=this._$table.children("thead");this._$tbody=this._$table.children("tbody");this._$reviewerHeader=this._$thead.find(`tr :nth-child(${this.COLUMN_REVIEWER})`);this._$noIssues=null;let hasExistingState=false;if(this.statusFilterState===null){this._$currentTab=this.$(".rb-c-tabs__tab.-is-active");console.assert(this._$currentTab.length===1);this.statusFilterState=this._$currentTab.data("issue-state")}else{this.$(".rb-c-tabs__tab.-is-active").removeClass("-is-active");this._$currentTab=this.$(".rb-c-tabs__tab"+`[data-issue-state=${this.statusFilterState}]`).addClass("-is-active");hasExistingState=true}this._buildMaps();if(this.reviewerFilterState===null){this.reviewerFilterState=this._$reviewerFilter.val()}else{this._$reviewerFilter.val(this.reviewerFilterState);hasExistingState=true}if(hasExistingState){this._resetFilters();this._applyFilters()}else{this._checkIssues()}this.stopListening(this.model,"issueStatusUpdated");this.listenTo(this.model,"issueStatusUpdated",this._onIssueStatusChanged);this._$window.off("resize",this._onWindowResize);this._$window.on("resize",this._onWindowResize);this._onWindowResize();this.$(".user").user_infobox();this.$("time.timesince").timesince();Djblets.enableRetinaImages(this.$el);return this},_resetFilters(){this._getIssueRows().filter(".-is-hidden").removeClass("-is-hidden")},_applyFilters(){const sel=this.stateToSelectorMap[this.statusFilterState]+this.reviewerToSelectorMap[this.reviewerFilterState];if(sel){this._getIssueRows().not(sel).addClass("-is-hidden")}this._checkIssues();this._updateReviewersPos()},_updateReviewersPos(){if(this._$reviewerHeader.is(":visible")){this._$filters.css({left:this._$reviewerHeader.offset().left-this._$table.offset().left+this._$reviewerHeader.getExtents("p","l")})}else{this._$filters.css("left","")}},_checkIssues(){if(this._$noIssues!==null){this._$noIssues.remove();this._$noIssues=null}this._$thead.show();if(this._getIssueRows().not(".-is-hidden").length===0){const reviewerFilter=this.reviewerFilterState;const statusFilter=this.statusFilterState;let text;if(reviewerFilter!=="all"){if(statusFilter==="open"){text=interpolate(gettext("There are no open issues from %s"),[reviewerFilter])}else if(statusFilter==="verifying"){text=interpolate(gettext("There are no issues waiting for verification from %s"),[reviewerFilter])}else if(statusFilter==="dropped"){text=interpolate(gettext("There are no dropped issues from %s"),[reviewerFilter])}else if(statusFilter==="resolved"){text=interpolate(gettext("There are no resolved issues from %s"),[reviewerFilter])}}else{if(statusFilter==="open"){text=gettext("There are no open issues")}else if(statusFilter==="verifying"){text=gettext("There are no issues waiting for verification")}else if(statusFilter==="dropped"){text=gettext("There are no dropped issues")}else if(statusFilter==="resolved"){text=gettext("There are no resolved issues")}}this._$thead.hide();this._$noIssues=$(this._noIssuesTemplate({text:text})).appendTo(this._$tbody)}},_getIssueRows(){return this._$tbody.children().not(".rb-c-issue-summary-table__no-issues")},_sortByCol(colIndex,ascending){this._$tbody.html(this._getIssueRows().sort((issueA,issueB)=>{const $issueA=$(issueA);const $issueB=$(issueB);const $columnA=$issueA.children(`td:nth-child(${colIndex})`);const $columnB=$issueB.children(`td:nth-child(${colIndex})`);let value1;let value2;if(colIndex===this.COLUMN_LAST_UPDATED){value1=$columnB.children("time").attr("datetime");value2=$columnA.children("time").attr("datetime")}else{value1=$columnA.text().strip().toLowerCase();value2=$columnB.text().strip().toLowerCase()}if(value1===value2){const issueID1=$issueA.data("issue-id");const issueID2=$issueB.data("issue-id");if(ascending){value1=issueID1;value2=issueID2}else{value1=issueID2;value2=issueID1}}let result;if(value1<value2){result=-1}else if(value1>value2){result=1}else{result=0}if(!ascending){result=-result}return result}))},_buildMaps(){this._$reviewerFilter.children().not('[value="all"]').remove();this.reviewerToSelectorMap={all:""};_.each(this._getIssueRows(),issueEl=>{const $issue=$(issueEl);this.commentIDToRowMap[$issue.data("issue-id")]=$issue;const reviewer=$issue.data("reviewer");if(!_.has(this.reviewerToSelectorMap,reviewer)){this.reviewerToSelectorMap[reviewer]=`[data-reviewer="${reviewer}"]`;this._$reviewerFilter.append($("<option>").text(reviewer).val(reviewer))}})},_onIssueStatusChanged(comment,oldStatus,timestamp){const $entry=this.commentIDToRowMap[comment.id];const newStatus=comment.get("issueStatus");RB.scrollManager.markForUpdate(this.$el);$entry.removeClass(`-is-${oldStatus}`).addClass(`-is-${newStatus}`).find(".rb-icon").removeClass(this.statusIconsMap[oldStatus]).addClass(this.statusIconsMap[newStatus]);if(this.statusFilterState!==newStatus&&this.statusFilterState!=="all"){$entry.addClass("-is-hidden")}else{$entry.removeClass("-is-hidden")}const $oldCounter=this._$tabs.children(`[data-issue-state=${oldStatus}]`).find(".rb-c-issue-summary-table__counter");const $newCounter=this._$tabs.children(`[data-issue-state=${newStatus}]`).find(".rb-c-issue-summary-table__counter");$oldCounter.text(parseInt($oldCounter.text(),10)-1);$newCounter.text(parseInt($newCounter.text(),10)+1);$entry.find("time").attr("datetime",new Date(timestamp).toISOString()).text(timestamp).timesince();this._checkIssues();this._updateReviewersPos();RB.scrollManager.markUpdated(this.$el)},_onHeaderClicked(evt){evt.stopPropagation();if(this._getIssueRows().not(".-is-hidden").length!==0){this._sortByCol($(evt.target).parent().children().index(evt.target)+1,!evt.shiftKey)}},_onIssueClicked(evt){if(evt.target.tagName==="A"){return}evt.stopPropagation();const $el=$(evt.currentTarget);this.trigger("issueClicked",{commentType:$el.data("comment-type"),commentID:$el.data("issue-id"),commentURL:$el.data("comment-href")})},_onTabChanged(evt){const $tab=$(evt.currentTarget);this._$currentTab.removeClass("-is-active");this._resetFilters();this.statusFilterState=$tab.data("issue-state");this._applyFilters();$tab.addClass("-is-active");this._$currentTab=$tab},_onReviewerChanged(){this._resetFilters();this.reviewerFilterState=this._$reviewerFilter.val();this._applyFilters()},_onWindowResize(){const winWidth=this._$window.width();if(winWidth!==this._lastWindowWidth){this._updateReviewersPos()}this._lastWindowWidth=winWidth}});"use strict";(function(){const ParentView=RB.ReviewRequestPage.EntryView;RB.ReviewRequestPage.ReviewEntryView=ParentView.extend({events:_.defaults({"click .revoke-ship-it":"_revokeShipIt"},ParentView.prototype.events),initialize(){ParentView.prototype.initialize.call(this);this._reviewView=null;this._draftBannerShown=false;this._$boxStatus=null;this._$fixItLabel=null;this._$shipItLabel=null},beforeApplyUpdate(){const diffFragmentQueue=RB.PageManager.getPage().diffFragmentQueue;const diffCommentsData=this.model.get("diffCommentsData");for(let i=0;i<diffCommentsData.length;i++){diffFragmentQueue.saveFragment(diffCommentsData[i][0])}},render(){ParentView.prototype.render.call(this);this._reviewView=new RB.ReviewRequestPage.ReviewView({el:this.el,model:this.model.get("review"),entryModel:this.model,$bannerFloatContainer:this._$box,$bannerParent:this.$(".banners"),bannerNoFloatContainerClass:"collapsed"});this._$boxStatus=this.$(".box-status");this._$fixItLabel=this._$boxStatus.find(".fix-it-label");this._$shipItLabel=this._$boxStatus.find(".ship-it-label");this.listenTo(this._reviewView,"hasDraftChanged",hasDraft=>this.$el.toggleClass("has-draft",hasDraft));this.listenTo(this._reviewView,"openIssuesChanged",this._updateLabels);this._reviewView.render();this._updateLabels();return this},getReviewReplyEditorView(contextType,contextID){return this._reviewView.getReviewReplyEditorView(contextType,contextID)},_updateLabels(){this._updateLabel(this._$fixItLabel,this._reviewView.hasOpenIssues(),"has-issues");this._updateLabel(this._$shipItLabel,this.model.get("review").get("shipIt"),"ship-it")},_updateLabel($label,visible,boxClassName){if(visible){this._$boxStatus.addClass(boxClassName);$label.show().css({opacity:1,left:0})}else{$label.css({opacity:0,left:"-100px"});this._$boxStatus.removeClass(boxClassName)}},async _revokeShipIt(){this._$boxStatus.addClass("revoking-ship-it");const confirmation=RB.ReviewRequestPage.ReviewEntryView.strings.revokeShipItConfirm;if(!confirm(confirmation)){this._clearRevokingShipIt();return}const review=this.model.get("review");await review.ready();review.set("shipIt",false);try{await review.save({attrs:["shipIt","includeTextTypes"]})}catch(err){review.set("shipIt",true);this._clearRevokingShipIt();alert(err.xhr.responseJSON.err.msg);return}this._updateLabels();setTimeout(()=>this._clearRevokingShipIt(),900)},_clearRevokingShipIt(){this._$boxStatus.removeClass("revoking-ship-it")}},{strings:{revokeShipItConfirm:gettext("Are you sure you want to revoke this Ship It?\n\nThis cannot be undone.")}})})();"use strict";RB.ReviewRequestPage.ReviewReplyDraftBannerView=RB.FloatingBannerView.extend({className:"banner",template:_.template(`<h1><%- draftText %></h1>
<p><%- reminderText %></p>
<span class="banner-actions">
 <input type="button" value="<%- publishText %>"
        class="publish-button" />
 <input type="button" value="<%- discardText %>"
        class="discard-button" />
</span>
<% if (showSendEmail) { %>
 <label>
  <input type="checkbox" class="send-email" checked />
  <%- sendEmailText %>
</label>
<% } %>`),events:{"click .publish-button":"_onPublishClicked","click .discard-button":"_onDiscardClicked"},render(){RB.FloatingBannerView.prototype.render.call(this);const reviewRequestEditor=this.options.reviewRequestEditor;this.$el.html(this.template({draftText:gettext("This reply is a draft."),reminderText:gettext("Be sure to publish when finished."),publishText:gettext("Publish"),discardText:gettext("Discard"),sendEmailText:gettext("Send E-Mail"),showSendEmail:reviewRequestEditor.get("showSendEmail")}));this.listenTo(this.model,"saving destroying",()=>this.$("input").prop("disabled",true));this.listenTo(this.model,"saved",()=>this.$("input").prop("disabled",false));this.listenTo(this.model,"publishError",errorText=>alert(errorText));return this},_onPublishClicked(){const $sendEmail=this.$(".send-email");this.model.publish({trivial:$sendEmail.length===1&&!$sendEmail.is(":checked")})},_onDiscardClicked(){this.model.destroy()}});"use strict";RB.ReviewRequestPage.ReviewReplyEditorView=Backbone.View.extend({commentTemplate:_.template(`<li <% if (isDraft) { %>class="draft"<% } %>
    <% if (commentID) { %>data-comment-id="<%= commentID %>"<% } %>>
 <% if (anchorName) { %>
  <a class="comment-anchor" name="<%- anchorName %>"></a>
  <div class="floating-anchor">
   <a href="#<%- anchorName %>"
      class="fa fa-link fa-flip-horizontal"></a>
  </div>
 <% } %>
 <div class="comment-author">
  <label for="<%= id %>">
   <div class="avatar-container"><%= avatarHTML %></div>
   <div class="user-reply-info">
    <a href="<%= userPageURL %>" class="user"><%- fullName %></a>
<% if (timestamp) { %>
    <span class="timestamp">
     <time class="timesince" datetime="<%= timestampISO %>">
<%= timestamp %></time>
    </span>
<% } %>
   </div>
  </label>
 </div>
 <div>
  <pre id="<%= id %>" class="comment-text reviewtext"><%- text %></pre>
 </div>
</li>`),events:{"click .add_comment_link":"_onAddCommentClicked"},initialize(options){this.options=options;this._$addCommentLink=null;this._$draftComment=null;this._$editor=null;this._$commentsList=null},render(){this._$addCommentLink=this.$(".add_comment_link");this._$commentsList=this.$(".reply-comments");const $draftComment=this._$commentsList.children(".draft");if($draftComment.length!==0){const $time=$draftComment.find("time");const $reviewText=$draftComment.find(".reviewtext");this.model.set({commentID:$draftComment.data("comment-id"),text:$reviewText.html(),timestamp:new Date($time.attr("datetime")),richText:$reviewText.hasClass("rich-text"),hasDraft:true});this._createCommentEditor($draftComment)}this.listenTo(this.model,"textUpdated",()=>{if(this._$editor){const reviewRequest=this.model.get("review").get("parentObject");RB.formatText(this._$editor,{newText:this.model.get("text"),richText:this.model.get("richText"),bugTrackerURL:reviewRequest.get("bugTrackerURL")})}});this.model.on("resetState",()=>{if(this._$draftComment){this._$draftComment.fadeOut(()=>{this._$draftComment.remove();this._$draftComment=null})}this._$addCommentLink.fadeIn()});this.model.on("published",this._onPublished,this)},openCommentEditor(){this._createCommentEditor(this._makeCommentElement());this._$editor.inlineEditor("startEdit")},_createCommentEditor($draftComment){const reviewRequestEditor=this.options.reviewRequestEditor;this._$draftComment=$draftComment;this._$editor=$draftComment.find("pre.reviewtext");this._$editor.inlineEditor(_.extend({cls:"inline-comment-editor",editIconClass:"rb-icon rb-icon-edit",notifyUnchangedCompletion:true,multiline:true,hasRawValue:true,rawValue:this._$editor.data("raw-value")||""},RB.TextEditorView.getInlineEditorOptions({richText:this._$editor.hasClass("rich-text")}))).removeAttr("data-raw-value").on({beginEdit:()=>{if(reviewRequestEditor){reviewRequestEditor.incr("editCount")}},complete:(e,value)=>{const textEditor=RB.TextEditorView.getFromInlineEditor(this._$editor);if(reviewRequestEditor){reviewRequestEditor.decr("editCount")}this.model.set({text:value,richText:textEditor.richText});this.model.save()},cancel:()=>{if(reviewRequestEditor){reviewRequestEditor.decr("editCount")}this.model.resetStateIfEmpty()}});this._$addCommentLink.hide()},_makeCommentElement(){let options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const userSession=RB.UserSession.instance;const reviewRequest=this.model.get("review").get("parentObject");const now=options.now||moment().utcOffset(userSession.get("timezoneOffset"));const $el=$(this.commentTemplate(_.extend({anchorName:null,id:_.uniqueId("draft_comment_"),text:"",commentID:null,userPageURL:userSession.get("userPageURL"),fullName:userSession.get("fullName"),avatarHTML:userSession.getAvatarHTML(32),isDraft:true,timestampISO:now.format(),timestamp:now.format("MMMM Do, YYYY, h:mm ")+(now.hour()<12?"a.m.":"p.m.")},options))).find(".user").user_infobox().end().find("time.timesince").timesince().end();Djblets.enableRetinaImages($el);if(options.text){RB.formatText($el.find(".reviewtext"),{newText:options.text,richText:options.richText,bugTrackerURL:reviewRequest.get("bugTrackerURL")})}$el.appendTo(this._$commentsList);return $el},_onAddCommentClicked(e){e.preventDefault();e.stopPropagation();this.openCommentEditor()},_onPublished(){if(this._$draftComment){const model=this.model;const contextType=model.get("contextType");this._$draftComment.replaceWith(this._makeCommentElement({anchorName:model.get("anchorPrefix")+model.get("replyObject").id,commentID:model.get("commentID"),text:model.get("text"),richText:model.get("richText"),isDraft:false}));this._$draftComment=null}}});"use strict";(function(){const commentTypeToIDPrefix={diff:"",file:"f",screenshot:"s"};RB.ReviewRequestPage.ReviewRequestPageView=RB.ReviewablePageView.extend({events:_.extend({"click #collapse-all":"_onCollapseAllClicked","click #expand-all":"_onExpandAllClicked"},RB.ReviewablePageView.prototype.events),initialize(){RB.ReviewablePageView.prototype.initialize.apply(this,arguments);this._entryViews=[];this._entryViewsByID={};this._rendered=false;this._issueSummaryTableView=null;const reviewRequest=this.model.get("reviewRequest");this.diffFragmentQueue=new RB.DiffFragmentQueueView({reviewRequestPath:reviewRequest.get("reviewURL"),containerPrefix:"comment_container",queueName:"diff_fragments",el:document.getElementById("content"),diffFragmentViewOptions:{collapsible:true}});this.listenTo(this.model,"updatesProcessed",()=>this.diffFragmentQueue.loadFragments());this.listenTo(this.model,"applyingUpdate:entry",(metadata,html)=>{const entryID=metadata.entryID;const entryView=this._entryViewsByID[entryID];const collapsed=entryView.isCollapsed();this._onApplyingUpdate(entryView,metadata);this.listenToOnce(this.model,`appliedModelUpdate:entry:${entryID}`,(metadata,html)=>this._reloadView(entryView,html));this.listenToOnce(this.model,`appliedUpdate:entry:${entryID}`,metadata=>{this._onAppliedUpdate(entryView,metadata);if(collapsed){entryView.collapse()}else{entryView.expand()}})})},render(){RB.ReviewablePageView.prototype.render.call(this);this._entryViews.forEach(entryView=>entryView.render());this._onHashChanged();if("onhashchange"in window){window.onhashchange=this._onHashChanged.bind(this)}this.diffFragmentQueue.loadFragments();this._issueSummaryTableView=new RB.ReviewRequestPage.IssueSummaryTableView({el:$("#issue-summary"),model:this.model.commentIssueManager});this._issueSummaryTableView.render();this.listenTo(this._issueSummaryTableView,"issueClicked",this._onIssueClicked);this.listenTo(this.model,"appliedUpdate:issue-summary-table",(metadata,html)=>{this._reloadView(this._issueSummaryTableView,html)});this._rendered=true;return this},addEntryView(entryView){const entry=entryView.model;this._entryViews.push(entryView);this._entryViewsByID[entry.id]=entryView;this.model.addEntry(entry);if(this._rendered){entryView.render()}},queueLoadDiff(commentID,key,onFragmentRendered){this.diffFragmentQueue.queueLoad(commentID,key,onFragmentRendered)},openCommentEditor(contextType,contextID){for(let i=0;i<this._entryViews.length;i++){const entryView=this._entryViews[i];const reviewReplyEditorView=_.isFunction(entryView.getReviewReplyEditorView)?entryView.getReviewReplyEditorView(contextType,contextID):null;if(reviewReplyEditorView){reviewReplyEditorView.openCommentEditor();break}}},_reloadView(view,html){const $oldEl=view.$el;const $newEl=$(html);view.setElement($newEl);$oldEl.replaceWith($newEl);view.render()},_onApplyingUpdate(view,metadata){if(view&&_.isFunction(view.beforeApplyUpdate)){view.beforeApplyUpdate(metadata)}},_onAppliedUpdate(view,metadata){if(view&&_.isFunction(view.afterApplyUpdate)){view.afterApplyUpdate(metadata)}},_onHashChanged(){const hash=RB.getLocationHash();let selector=null;if(hash!==""){if(hash.includes("comment")){selector=`a[name=${hash}]`}else{selector=`#${hash}`}}if(!selector){return}for(let i=0;i<this._entryViews.length;i++){const entryView=this._entryViews[i];const $anchor=entryView.$(selector);if($anchor.length>0){entryView.expand();RB.scrollManager.scrollToElement($anchor);break}}},_onCollapseAllClicked(e){e.preventDefault();e.stopPropagation();this._entryViews.forEach(entryView=>entryView.collapse())},_onExpandAllClicked(e){e.preventDefault();e.stopPropagation();this._entryViews.forEach(entryView=>entryView.expand())},_onIssueClicked(params){const prefix=commentTypeToIDPrefix[params.commentType];const selector=`#${prefix}comment${params.commentID}`;this._entryViews.forEach(entryView=>{if(entryView.$el.find(selector).length>0){entryView.expand()}});window.location=params.commentURL}})})();"use strict";RB.ReviewRequestPage.ReviewView=Backbone.View.extend({initialize(options){this.options=options;this.entryModel=options.entryModel;this._bannerView=null;this._draftBannerShown=false;this._openIssueCount=0;this._reviewReply=null;this._replyEditors=[];this._replyEditorViews=[];this._replyDraftsCount=0;this._diffFragmentViews=[];this._$reviewComments=null;this._$bodyTop=null;this._$bodyBottom=null;this.model.set("includeTextTypes","html,raw,markdown");this._setupNewReply();this.listenTo(this.entryModel,"change:collapsed",()=>{if(!this.entryModel.get("collapsed")){this._diffFragmentViews.forEach(view=>view.hideControls(false))}})},render(){const reviewRequestEditor=this.entryModel.get("reviewRequestEditor");this._$reviewComments=this.$(".review-comments");const $comment=this._$reviewComments.find(".review-comment-details .review-comment");this._$bodyTop=$comment.find(".body_top");this._$bodyBottom=$comment.find(".body_bottom");this._replyDraftsCount=0;this.on("hasDraftChanged",hasDraft=>{if(hasDraft){this._showReplyDraftBanner()}else{this._hideReplyDraftBanner()}});_.each(this._$reviewComments.find(".issue-indicator"),el=>{const $issueState=$(".issue-state",el);if($issueState.length>0){const issueStatus=$issueState.data("issue-status");if(RB.BaseComment.isStateOpen(issueStatus)){this._openIssueCount++}const issueBar=new RB.CommentIssueBarView({el:el,reviewID:this.model.id,canVerify:$issueState.data("can-verify"),commentID:$issueState.data("comment-id"),commentType:$issueState.data("comment-type"),interactive:$issueState.data("interactive"),issueStatus:issueStatus});issueBar.render();this.listenTo(issueBar,"statusChanged",(oldStatus,newStatus)=>{const oldOpen=RB.BaseComment.isStateOpen(oldStatus);const newOpen=RB.BaseComment.isStateOpen(newStatus);if(oldOpen!==newOpen){if(newOpen){this._openIssueCount++}else{this._openIssueCount--}}this.trigger("openIssuesChanged")})}});_.each(this.$(".comment-section"),el=>{const $el=$(el);const editor=new RB.ReviewRequestPage.ReviewReplyEditor({anchorPrefix:$el.data("reply-anchor-prefix"),contextID:$el.data("context-id"),contextType:$el.data("context-type"),review:this.model,reviewReply:this._reviewReply});const view=new RB.ReviewRequestPage.ReviewReplyEditorView({el:el,model:editor,reviewRequestEditor:reviewRequestEditor});view.render();this.listenTo(editor,"change:hasDraft",(model,hasDraft)=>{if(hasDraft){this._replyDraftsCount++;this.trigger("hasDraftChanged",true)}else{this._replyDraftsCount--;if(this._replyDraftsCount===0){this.trigger("hasDraftChanged",false)}}});this._replyEditors.push(editor);this._replyEditorViews.push(view);if(editor.get("hasDraft")){this._replyDraftsCount++}});if(this._replyDraftsCount>0){this.trigger("hasDraftChanged",true)}this._diffFragmentViews=[];const page=RB.PageManager.getPage();const diffCommentsData=this.entryModel.get("diffCommentsData");for(let i=0;i<diffCommentsData.length;i++){const diffCommentData=diffCommentsData[i];page.queueLoadDiff(diffCommentData[0],diffCommentData[1],view=>this._diffFragmentViews.push(view))}const reviewRequest=this.model.get("parentObject");const bugTrackerURL=reviewRequest.get("bugTrackerURL");_.each(this.$("pre.reviewtext"),el=>{RB.formatText($(el),{bugTrackerURL:bugTrackerURL})});this.listenTo(this.model,"change:bodyTop",this._onBodyTopChanged);this.listenTo(this.model,"change:bodyBottom",this._onBodyBottomChanged);this.listenTo(this.model,"change:bodyTopRichText",this._onBodyTopRichTextChanged);this.listenTo(this.model,"change:bodyBottomRichText",this._onBodyBottomRichTextChanged);return this},_onBodyTopChanged(){this._$bodyTop.html(this.model.get("htmlTextFields").bodyTop)},_onBodyTopRichTextChanged(){if(this.model.get("bodyTopRichText")){this._$bodyTop.addClass("rich-text")}else{this._$bodyTop.removeClass("rich-text")}},_onBodyBottomChanged(){const html=this.model.get("htmlTextFields").bodyBottom;this._$bodyBottom.html(html).closest("li").setVisible(html&&html.length>0)},_onBodyBottomRichTextChanged(){if(this.model.get("bodyBottomRichText")){this._$bodyBottom.addClass("rich-text")}else{this._$bodyBottom.removeClass("rich-text")}},hasOpenIssues(){return this._openIssueCount>0},getOpenIssueCount(){return this._openIssueCount},getReviewReplyEditorView(contextType,contextID){if(contextID===undefined){contextID=null}return _.find(this._replyEditorViews,view=>{const editor=view.model;return editor.get("contextID")===contextID&&editor.get("contextType")===contextType})},getReviewReply(){return this._reviewReply},_setupNewReply(reviewReply){if(!reviewReply){reviewReply=this.model.createReply()}if(this._reviewReply!==null){this.stopListening(this._reviewReply);this._replyEditors.forEach(editor=>editor.set("reviewReply",reviewReply));this.trigger("hasDraftChanged",false)}this.listenTo(reviewReply,"destroyed published",()=>this._setupNewReply());this._reviewReply=reviewReply},_showReplyDraftBanner(){if(!this._draftBannerShown){this._bannerView=new RB.ReviewRequestPage.ReviewReplyDraftBannerView({model:this._reviewReply,$floatContainer:this.options.$bannerFloatContainer,noFloatContainerClass:this.options.bannerNoFloatContainerClass,reviewRequestEditor:this.entryModel.get("reviewRequestEditor")});this._bannerView.render();this._bannerView.$el.appendTo(this.options.$bannerParent);this._draftBannerShown=true}},_hideReplyDraftBanner(){if(this._draftBannerShown){this._bannerView.remove();this._bannerView=null;this._draftBannerShown=false}}})}).call(this);
