# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class AppApiRestV1AnnSchemaANNFunction(BaseModel):
    """
    AppApiRestV1AnnSchemaANNFunction
    """ # noqa: E501
    result_per_function: Optional[Annotated[int, Field(le=20, strict=True)]] = None
    distance: Optional[Union[StrictFloat, StrictInt]] = None
    function_id_list: List[Optional[StrictInt]] = Field(description="List of function ids to compare")
    speculative_function_ids: Optional[List[Any]] = None
    collection: Optional[List[Optional[StrictStr]]] = Field(default=None, description="Perform a search on functions within a list of collections")
    collection_search_list: Optional[List[Optional[StrictInt]]] = Field(default=None, description="Perform a search on functions within a list of collections")
    debug_mode: Optional[StrictBool] = None
    debug_types: Optional[List[StrictStr]] = Field(default=None, description="If limiting results to functions with debug names, which type of debug names to include?")
    binaries_search_list: Optional[List[Optional[StrictInt]]] = Field(default=None, description="Perform a search on functions within a list of analyses")
    __properties: ClassVar[List[str]] = ["result_per_function", "distance", "function_id_list", "speculative_function_ids", "collection", "collection_search_list", "debug_mode", "debug_types", "binaries_search_list"]

    @field_validator('debug_types')
    def debug_types_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['USER', 'SYSTEM', 'EXTERNAL']):
                raise ValueError("each list item must be one of ('USER', 'SYSTEM', 'EXTERNAL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppApiRestV1AnnSchemaANNFunction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if result_per_function (nullable) is None
        # and model_fields_set contains the field
        if self.result_per_function is None and "result_per_function" in self.model_fields_set:
            _dict['result_per_function'] = None

        # set to None if distance (nullable) is None
        # and model_fields_set contains the field
        if self.distance is None and "distance" in self.model_fields_set:
            _dict['distance'] = None

        # set to None if speculative_function_ids (nullable) is None
        # and model_fields_set contains the field
        if self.speculative_function_ids is None and "speculative_function_ids" in self.model_fields_set:
            _dict['speculative_function_ids'] = None

        # set to None if debug_mode (nullable) is None
        # and model_fields_set contains the field
        if self.debug_mode is None and "debug_mode" in self.model_fields_set:
            _dict['debug_mode'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppApiRestV1AnnSchemaANNFunction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "result_per_function": obj.get("result_per_function"),
            "distance": obj.get("distance"),
            "function_id_list": obj.get("function_id_list"),
            "speculative_function_ids": obj.get("speculative_function_ids"),
            "collection": obj.get("collection"),
            "collection_search_list": obj.get("collection_search_list"),
            "debug_mode": obj.get("debug_mode"),
            "debug_types": obj.get("debug_types"),
            "binaries_search_list": obj.get("binaries_search_list")
        })
        return _obj


