# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from revengai.models.app_services_binary_ann_schema_tag_item import AppServicesBinaryAnnSchemaTagItem
from typing import Optional, Set
from typing_extensions import Self

class ExportedBinaryAnnResult(BaseModel):
    """
    ExportedBinaryAnnResult
    """ # noqa: E501
    analysis_id: StrictInt
    binary_id: StrictInt
    binary_name: StrictStr
    sha_256_hash: StrictStr
    analysis_scope: StrictStr
    embedding_3d: List[Union[StrictFloat, StrictInt]]
    embedding_1d: List[Union[StrictFloat, StrictInt]]
    confidence: Union[StrictFloat, StrictInt]
    tags: Optional[List[AppServicesBinaryAnnSchemaTagItem]] = None
    __properties: ClassVar[List[str]] = ["analysis_id", "binary_id", "binary_name", "sha_256_hash", "analysis_scope", "embedding_3d", "embedding_1d", "confidence", "tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExportedBinaryAnnResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExportedBinaryAnnResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "analysis_id": obj.get("analysis_id"),
            "binary_id": obj.get("binary_id"),
            "binary_name": obj.get("binary_name"),
            "sha_256_hash": obj.get("sha_256_hash"),
            "analysis_scope": obj.get("analysis_scope"),
            "embedding_3d": obj.get("embedding_3d"),
            "embedding_1d": obj.get("embedding_1d"),
            "confidence": obj.get("confidence"),
            "tags": [AppServicesBinaryAnnSchemaTagItem.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None
        })
        return _obj


