# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.function_info_output import FunctionInfoOutput
from typing import Optional, Set
from typing_extensions import Self

class FunctionDataTypes(BaseModel):
    """
    FunctionDataTypes
    """ # noqa: E501
    completed: StrictBool = Field(description="Whether the service has completed data types generation")
    status: StrictStr = Field(description="The current status of the data types service")
    data_types: Optional[FunctionInfoOutput] = None
    data_types_version: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["completed", "status", "data_types", "data_types_version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionDataTypes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data_types
        if self.data_types:
            _dict['data_types'] = self.data_types.to_dict()
        # set to None if data_types (nullable) is None
        # and model_fields_set contains the field
        if self.data_types is None and "data_types" in self.model_fields_set:
            _dict['data_types'] = None

        # set to None if data_types_version (nullable) is None
        # and model_fields_set contains the field
        if self.data_types_version is None and "data_types_version" in self.model_fields_set:
            _dict['data_types_version'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionDataTypes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "completed": obj.get("completed"),
            "status": obj.get("status"),
            "data_types": FunctionInfoOutput.from_dict(obj["data_types"]) if obj.get("data_types") is not None else None,
            "data_types_version": obj.get("data_types_version")
        })
        return _obj


