# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/wandb.ipynb.

# %% auto 0
__all__ = ['log', 'fetch_wandb_run', 'fetch_wandb_config', 'generate_run_id']

# %% ../nbs/wandb.ipynb 3
import wandb
from .logging import get_logger

log = get_logger(__name__)

# %% ../nbs/wandb.ipynb 4
def fetch_wandb_run(*, entity: str, project: str, run_id: str):
    return wandb.Api().run(f"{entity}/{project}/{run_id}")

def fetch_wandb_config(*, entity: str, project: str, run_id: str):
    run = fetch_wandb_run(entity=entity, project=project, run_id=run_id)
    return run.config

# %% ../nbs/wandb.ipynb 5
def generate_run_id(length: int=8):
    import random
    import string

    assert length >= 8 and length <= 64
    chars = string.ascii_lowercase + string.digits
    return ''.join(random.choice(chars) for _ in range(length))
