# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/jerx.utils.ipynb.

# %% auto 0
__all__ = ['log', 'Entity', 'Relation', 'Triplet', 'remove_enumeration', 'parse_triplet_strings', 'parse_triplets']

# %% ../../nbs/jerx.utils.ipynb 3
import re
from typing import TypeAlias, Iterable, Callable, Any, Generator

from ..logging import get_logger

log = get_logger(__name__)

# %% ../../nbs/jerx.utils.ipynb 4
Entity: TypeAlias = str|tuple[str, str]
Relation: TypeAlias = str
Triplet: TypeAlias = tuple[Entity, Relation, Entity]

# %% ../../nbs/jerx.utils.ipynb 5
def remove_enumeration(s):
    # This pattern matches any leading digits followed by a dot and a space
    pattern = r'^\d+\.\s'
    # Use re.sub to replace the matched pattern with an empty string
    return re.sub(pattern, '', s)

def parse_triplet_strings(text: str, delimiter: str="|") -> list[str]:
    return [remove_enumeration(line) for line in text.splitlines() if line and line.count(delimiter) == 2]

def parse_triplets(text: str, delimiter: str="|") -> list[Triplet]:
    return [tuple([s.strip() for s in triplet_string.split(delimiter)]) for triplet_string in parse_triplet_strings(text, delimiter=delimiter)]
