/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.config;

import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;
import org.linqs.psl.config.Config;

public class Option
implements Comparable<Option> {
    public static final int FLAG_NON_NEGATIVE = 1;
    public static final int FLAG_POSITIVE = 2;
    public static final int FLAG_LT_ONE = 4;
    public static final int FLAG_LTE_ONE = 8;
    private static Set<String> seenNames = new HashSet<String>();
    private String name;
    private Object defaultValue;
    private String description;
    private Class<?> type;
    private int flags;

    public Option(String name, boolean defaultValue, String description) {
        this(name, defaultValue, Boolean.TYPE, description, 0);
    }

    public Option(String name, String defaultValue, String description) {
        this(name, defaultValue, String.class, description, 0);
    }

    public Option(String name, int defaultValue, String description) {
        this(name, defaultValue, Integer.TYPE, description, 0);
    }

    public Option(String name, int defaultValue, String description, int flags) {
        this(name, defaultValue, Integer.TYPE, description, flags);
    }

    public Option(String name, long defaultValue, String description) {
        this(name, defaultValue, Long.TYPE, description, 0);
    }

    public Option(String name, long defaultValue, String description, int flags) {
        this(name, defaultValue, Long.TYPE, description, flags);
    }

    public Option(String name, float defaultValue, String description) {
        this(name, Float.valueOf(defaultValue), Float.TYPE, description, 0);
    }

    public Option(String name, float defaultValue, String description, int flags) {
        this(name, Float.valueOf(defaultValue), Float.TYPE, description, flags);
    }

    public Option(String name, double defaultValue, String description) {
        this(name, defaultValue, Double.TYPE, description, 0);
    }

    public Option(String name, double defaultValue, String description, int flags) {
        this(name, defaultValue, Double.TYPE, description, flags);
    }

    public Option(String name, Object defaultValue, Class<?> type, String description, int flags) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.description = description;
        this.type = type;
        this.flags = flags;
        if (seenNames.contains(name)) {
            throw new RuntimeException("Option with name '" + name + "' already seen.");
        }
        seenNames.add(name);
    }

    public String name() {
        return this.name;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public String description() {
        return this.description;
    }

    public int flags() {
        return this.flags;
    }

    public void set(Object value) {
        Config.setProperty(this.name, value, true);
    }

    public void clear() {
        Config.clearProperty(this.name, true);
    }

    public Object get() {
        return Config.getProperty(this.name, null, true);
    }

    public boolean isSet() {
        return Config.hasProperty(this.name);
    }

    public Object getUnlogged() {
        return Config.getProperty(this.name, null, false);
    }

    public boolean getBoolean() {
        return Config.getBoolean(this.name, (Boolean)this.defaultValue);
    }

    public String getString() {
        if (this.defaultValue == null) {
            return Config.getString(this.name, null);
        }
        return Config.getString(this.name, this.defaultValue.toString());
    }

    public int getInt() {
        int value = Config.getInteger(this.name, (Number)this.defaultValue);
        this.checkNumericFlags(value, "" + value);
        return value;
    }

    public long getLong() {
        long value = Config.getLong(this.name, (Number)this.defaultValue);
        this.checkNumericFlags(value, "" + value);
        return value;
    }

    public float getFloat() {
        float value = Config.getFloat(this.name, (Number)this.defaultValue).floatValue();
        this.checkNumericFlags(value, "" + value);
        return value;
    }

    public double getDouble() {
        double value = Config.getDouble(this.name, (Number)this.defaultValue);
        this.checkNumericFlags(value, "" + value);
        return value;
    }

    public Object getNewObject() {
        return Config.getNewObject(this.name, (String)this.defaultValue);
    }

    @Override
    public int compareTo(Option other) {
        if (other == null) {
            return -1;
        }
        return this.name().compareTo(other.name());
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return this.name.equals(((Option)other).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        boolean hasDefault;
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        boolean hasType = this.type != null;
        boolean bl = hasDefault = this.defaultValue != null;
        if (hasType || hasDefault) {
            builder.append("(");
            if (hasType) {
                builder.append("Type: " + this.type.getName().toString());
            }
            if (hasType && hasDefault) {
                builder.append(", ");
            }
            if (hasDefault) {
                builder.append("Default Value: " + this.defaultValue.toString());
            }
            builder.append(")");
        }
        if (this.description != null) {
            builder.append(" - " + this.description);
        }
        return builder.toString();
    }

    private void checkNumericFlags(double value, String displayValue) {
        if ((this.flags & 1) != 0 && value < 0.0) {
            throw new IllegalArgumentException("Property " + this.name + " must be non-negative, found value: " + displayValue);
        }
        if ((this.flags & 2) != 0 && value <= 0.0) {
            throw new IllegalArgumentException("Property " + this.name + " must be positive, found value: " + displayValue);
        }
        if ((this.flags & 4) != 0 && value >= 1.0) {
            throw new IllegalArgumentException("Property " + this.name + " must be < 1, found value: " + displayValue);
        }
        if ((this.flags & 8) != 0 && value > 1.0) {
            throw new IllegalArgumentException("Property " + this.name + " must be <= 1, found value: " + displayValue);
        }
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("name", this.name);
        json.put("flags", this.flags);
        if (this.type != null) {
            json.put("type", this.type.getName());
        }
        if (this.defaultValue != null) {
            if (this.type == Float.TYPE && ((Float)this.defaultValue).floatValue() == Float.POSITIVE_INFINITY) {
                json.put("default", "+Infinity");
            } else if (this.type == Float.TYPE && ((Float)this.defaultValue).floatValue() == Float.NEGATIVE_INFINITY) {
                json.put("default", "-Infinity");
            } else if (this.type == Double.TYPE && (Double)this.defaultValue == Double.POSITIVE_INFINITY) {
                json.put("default", "+Infinity");
            } else if (this.type == Double.TYPE && (Double)this.defaultValue == Double.NEGATIVE_INFINITY) {
                json.put("default", "-Infinity");
            } else {
                json.put("default", this.defaultValue);
            }
        }
        if (this.description != null) {
            json.put("description", this.description);
        }
        return json;
    }
}

