/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.linqs.psl.database.AtomStore;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.database.DatabaseQuery;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.QueryResultIterable;
import org.linqs.psl.database.RawQuery;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.util.FileUtils;

public abstract class Database {
    protected final DataStore parentDataStore;
    private final Set<Predicate> closedPredicates;
    protected final Partition writePartition;
    protected final short writeID;
    protected final List<Partition> readPartitions;
    protected final List<Short> readIDs;
    protected final List<Short> allPartitionIDs;
    protected AtomStore atomStore;
    protected boolean closed;

    public Database(DataStore parent, Partition write, Partition[] read, Set<StandardPredicate> closed) {
        this.parentDataStore = parent;
        this.writePartition = write;
        this.writeID = write.getID();
        this.closedPredicates = new HashSet<Predicate>();
        if (closed != null) {
            this.closedPredicates.addAll(closed);
        }
        this.readPartitions = Arrays.asList(read);
        this.readIDs = new ArrayList<Short>(read.length);
        for (int i = 0; i < read.length; ++i) {
            this.readIDs.add(read[i].getID());
        }
        if (this.readIDs.contains(this.writeID)) {
            this.readIDs.remove((Object)this.writeID);
        }
        this.allPartitionIDs = new ArrayList<Short>(this.readIDs.size() + 1);
        this.allPartitionIDs.addAll(this.readIDs);
        this.allPartitionIDs.add(this.writeID);
        this.atomStore = null;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.atomStore != null) {
            this.atomStore.close();
            this.atomStore = null;
        }
        this.parentDataStore.releasePartitions(this);
        this.closed = true;
    }

    public abstract void commit(Iterable<? extends GroundAtom> var1);

    public abstract QueryResultIterable executeGroundingQuery(Formula var1);

    public abstract ResultList executeQuery(DatabaseQuery var1);

    public abstract QueryResultIterable executeQueryIterator(RawQuery var1);

    public abstract ResultList executeSQL(RawQuery var1);

    public abstract int countAllGroundAtoms(StandardPredicate var1, List<Short> var2);

    public abstract List<GroundAtom> getAllGroundAtoms(StandardPredicate var1, List<Short> var2);

    public int countAllGroundAtoms(StandardPredicate predicate) {
        return this.countAllGroundAtoms(predicate, this.allPartitionIDs);
    }

    public List<GroundAtom> getAllGroundAtoms(StandardPredicate predicate) {
        return this.getAllGroundAtoms(predicate, this.allPartitionIDs);
    }

    public AtomStore getAtomStore() {
        if (this.closed) {
            throw new IllegalStateException("Cannot get an AtomStore from a closed database.");
        }
        if (this.atomStore == null) {
            this.initAtomStore();
        }
        return this.atomStore;
    }

    public DataStore getDataStore() {
        return this.parentDataStore;
    }

    public List<Partition> getReadPartitions() {
        return Collections.unmodifiableList(this.readPartitions);
    }

    public Partition getWritePartition() {
        return this.writePartition;
    }

    public boolean isClosed(Predicate predicate) {
        return this.closedPredicates.contains(predicate);
    }

    public void outputRandomVariableAtoms() {
        for (StandardPredicate openPredicate : this.parentDataStore.getRegisteredPredicates()) {
            for (GroundAtom groundAtom : this.getAtomStore().getRandomVariableAtoms(openPredicate)) {
                System.out.println(groundAtom.toString() + " = " + groundAtom.getValue());
            }
        }
    }

    public void outputRandomVariableAtoms(String outputDirectoryPath) {
        File outputDirectory = new File(outputDirectoryPath);
        FileUtils.mkdir(outputDirectory);
        for (StandardPredicate predicate : this.parentDataStore.getRegisteredPredicates()) {
            Iterator<RandomVariableAtom> atoms;
            if (this.isClosed(predicate) || !(atoms = this.getAtomStore().getRandomVariableAtoms(predicate).iterator()).hasNext()) continue;
            File outputFile = new File(outputDirectory, predicate.getName() + ".txt");
            try {
                BufferedWriter bufferedPredWriter = FileUtils.getBufferedWriter(outputFile);
                Throwable throwable = null;
                try {
                    StringBuilder row = new StringBuilder();
                    while (atoms.hasNext()) {
                        GroundAtom atom = atoms.next();
                        row.setLength(0);
                        for (Constant term : atom.getArguments()) {
                            row.append(term.rawToString());
                            row.append("\t");
                        }
                        row.append(atom.getValue());
                        row.append(System.lineSeparator());
                        bufferedPredWriter.write(row.toString());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bufferedPredWriter == null) continue;
                    if (throwable != null) {
                        try {
                            bufferedPredWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bufferedPredWriter.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Error writing predicate " + predicate + ".", ex);
            }
        }
    }

    private synchronized void initAtomStore() {
        if (this.atomStore != null) {
            return;
        }
        this.atomStore = new AtomStore(this);
    }
}

