/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database;

import java.util.HashSet;
import java.util.Map;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.DatabaseQuery;
import org.linqs.psl.database.rdbms.Formula2SQL;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.model.term.VariableTypeMap;

public class RawQuery {
    private String sql;
    private Map<Variable, Integer> projectionMap;
    private VariableTypeMap variableTypes;

    public RawQuery(Database database, Formula formula) {
        this(database, formula, false);
    }

    public RawQuery(Database database, Formula formula, boolean isDistinct) {
        this(database, new DatabaseQuery(formula, isDistinct));
    }

    public RawQuery(Database database, DatabaseQuery query) {
        Formula formula = query.getFormula();
        VariableTypeMap variableTypes = formula.collectVariables(new VariableTypeMap());
        HashSet<Variable> projectTo = new HashSet<Variable>(variableTypes.getVariables());
        projectTo.removeAll(query.getIgnoreVariables());
        Formula2SQL sqler = new Formula2SQL(projectTo, database, query.getDistinct());
        this.sql = sqler.getSQL(formula);
        this.projectionMap = sqler.getProjectionMap();
        this.variableTypes = variableTypes;
    }

    public RawQuery(String sql, Map<Variable, Integer> projectionMap, VariableTypeMap variableTypes) {
        this.sql = sql;
        this.projectionMap = projectionMap;
        this.variableTypes = variableTypes;
    }

    public String getSQL() {
        return this.sql;
    }

    public Map<Variable, Integer> getProjectionMap() {
        return this.projectionMap;
    }

    public VariableTypeMap getVariableTypes() {
        return this.variableTypes;
    }
}

