/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.rdbms.PredicateInfo;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.formula.Conjunction;
import org.linqs.psl.model.formula.Disjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.Negation;
import org.linqs.psl.model.predicate.ExternalFunctionalPredicate;
import org.linqs.psl.model.predicate.FunctionalPredicate;
import org.linqs.psl.model.predicate.GroundingOnlyPredicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Attribute;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.UniqueIntID;
import org.linqs.psl.model.term.UniqueStringID;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.model.term.VariableTypeMap;

public class Formula2SQL {
    private static final String TABLE_ALIAS_PREFIX = "T";
    private final Set<Variable> projection;
    private final Database database;
    private final Map<Variable, String> joins;
    private final Map<Atom, String> tableAliases;
    private final List<Atom> functionalAtoms;
    private final SelectQuery query;
    private final Map<Variable, Integer> projectionMap;
    private final List<Short> partitions;
    private final List<Atom> partialTargets;
    private int tableCounter;

    public Formula2SQL(Set<Variable> projection, Database database) {
        this(projection, database, true);
    }

    public Formula2SQL(Set<Variable> projection, Database database, boolean isDistinct) {
        this(projection, database, isDistinct, null);
    }

    public Formula2SQL(Set<Variable> projection, Database database, boolean isDistinct, List<Atom> partialTargets) {
        this.projection = projection;
        this.database = database;
        this.partialTargets = partialTargets;
        this.joins = new HashMap<Variable, String>();
        this.tableAliases = new HashMap<Atom, String>();
        this.projectionMap = new HashMap<Variable, Integer>();
        this.functionalAtoms = new ArrayList<Atom>();
        this.tableCounter = 0;
        this.query = new SelectQuery();
        this.query.setIsDistinct(isDistinct);
        if (projection == null) {
            projection = new HashSet<Variable>(0);
        }
        if (projection.isEmpty()) {
            this.query.addAllColumns();
        }
        this.partitions = new ArrayList<Short>(database.getReadPartitions().size() + 1);
        for (Partition partition : database.getReadPartitions()) {
            this.partitions.add(partition.getID());
        }
        this.partitions.add(database.getWritePartition().getID());
    }

    public List<Atom> getFunctionalAtoms() {
        return this.functionalAtoms;
    }

    public Map<Variable, Integer> getProjectionMap() {
        return Collections.unmodifiableMap(this.projectionMap);
    }

    public Map<Atom, String> getTableAliases() {
        return Collections.unmodifiableMap(this.tableAliases);
    }

    public SelectQuery getQuery(Formula formula) {
        this.traverse(formula);
        for (Atom atom : this.functionalAtoms) {
            this.visitFunctionalAtom(atom);
        }
        return (SelectQuery)this.query.validate();
    }

    public String getSQL(Formula formula) {
        return this.getQuery(formula).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void visitFunctionalAtom(Atom atom) {
        assert (atom.getPredicate() instanceof FunctionalPredicate);
        Object[] convert = this.convertArguments(atom.getArguments());
        if (atom.getPredicate() instanceof ExternalFunctionalPredicate) return;
        if (!(atom.getPredicate() instanceof GroundingOnlyPredicate)) throw new UnsupportedOperationException("Unrecognized FunctionalPredicate: " + atom.getPredicate());
        GroundingOnlyPredicate predicate = (GroundingOnlyPredicate)atom.getPredicate();
        if (predicate.equals(GroundingOnlyPredicate.NotEqual)) {
            this.query.addCondition(BinaryCondition.notEqualTo(convert[0], convert[1]));
            return;
        } else if (predicate.equals(GroundingOnlyPredicate.Equal)) {
            this.query.addCondition(BinaryCondition.equalTo(convert[0], convert[1]));
            return;
        } else {
            if (!predicate.equals(GroundingOnlyPredicate.NonSymmetric)) throw new UnsupportedOperationException("Unrecognized GroundingOnlyPredicate: " + predicate);
            this.query.addCondition(BinaryCondition.lessThan(convert[0], convert[1], false));
        }
    }

    private Object[] convertArguments(Term[] arguments) {
        Object[] convert = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Term arg = arguments[i];
            if (arg instanceof Variable) {
                assert (this.joins.containsKey((Variable)arg));
                convert[i] = new CustomSql(this.joins.get((Variable)arg));
                continue;
            }
            if (arg instanceof Attribute) {
                convert[i] = ((Attribute)arg).getValue();
                continue;
            }
            if (arg instanceof UniqueIntID) {
                convert[i] = ((UniqueIntID)arg).getID();
                continue;
            }
            if (arg instanceof UniqueStringID) {
                convert[i] = ((UniqueStringID)arg).getID();
                continue;
            }
            throw new IllegalArgumentException("Unknown argument type: " + arg.getClass().getName());
        }
        return convert;
    }

    private void visitAtom(Atom atom) {
        if (atom.getPredicate() instanceof FunctionalPredicate) {
            this.functionalAtoms.add(atom);
            return;
        }
        assert (atom.getPredicate() instanceof StandardPredicate);
        PredicateInfo predicateInfo = this.database.getDataStore().getPredicateInfo(atom.getPredicate());
        String tableAlias = String.format("%s_%03d", TABLE_ALIAS_PREFIX, this.tableCounter);
        this.tableAliases.put(atom, tableAlias);
        this.query.addCustomFromTable(predicateInfo.tableName() + " " + tableAlias);
        Term[] arguments = atom.getArguments();
        List<String> columnNames = predicateInfo.argumentColumns();
        assert (arguments.length == columnNames.size());
        for (int i = 0; i < arguments.length; ++i) {
            Term arg = arguments[i];
            String columnReference = tableAlias + "." + columnNames.get(i);
            if (arg instanceof Variable) {
                Variable var = (Variable)arg;
                if (this.joins.containsKey(var)) {
                    this.query.addCondition(BinaryCondition.equalTo(new CustomSql(columnReference), new CustomSql(this.joins.get(var))));
                } else {
                    if (this.projection.contains(var)) {
                        this.query.addAliasedColumn(new CustomSql(columnReference), var.getName());
                        this.projectionMap.put(var, this.projectionMap.size());
                    }
                    this.joins.put(var, columnReference);
                }
            }
            if (arg instanceof Attribute || arg instanceof UniqueIntID || arg instanceof UniqueStringID) {
                Object value = null;
                value = arg instanceof Attribute ? ((Attribute)arg).getValue() : (arg instanceof UniqueIntID ? Integer.valueOf(((UniqueIntID)arg).getID()) : ((UniqueStringID)arg).getID());
                if (value instanceof String) {
                    value = this.escapeSingleQuotes((String)value);
                }
                this.query.addCondition(BinaryCondition.equalTo(new CustomSql(columnReference), value));
                continue;
            }
            assert (arg instanceof Variable);
        }
        CustomSql partitionColumn = new CustomSql(tableAlias + "." + "partition_id");
        if (this.partialTargets != null && this.partialTargets.contains(atom)) {
            this.query.addCondition(BinaryCondition.lessThan(partitionColumn, 0));
        } else {
            this.query.addCondition(new InCondition((Object)partitionColumn, this.partitions));
        }
        ++this.tableCounter;
    }

    private void traverse(Formula formula) {
        if (formula instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)formula;
            for (int i = 0; i < conjunction.length(); ++i) {
                this.traverse(conjunction.get(i));
            }
        } else if (formula instanceof Atom) {
            this.visitAtom((Atom)formula);
        } else {
            if (formula instanceof Negation) {
                throw new IllegalArgumentException("Negations in formula are not supported in database queries.");
            }
            if (formula instanceof Disjunction) {
                throw new IllegalArgumentException("Disjunctions in formula are not supported in database queries.");
            }
            throw new IllegalArgumentException("Unsupported Formula: " + formula.getClass().getName());
        }
    }

    private String escapeSingleQuotes(String s2) {
        return s2.replaceAll("'", "''");
    }

    public static String getQuery(Formula formula, Database database, boolean isDistinct) {
        VariableTypeMap varTypes = formula.collectVariables(new VariableTypeMap());
        HashSet<Variable> projection = new HashSet<Variable>(varTypes.getVariables());
        Formula2SQL sqler = new Formula2SQL(projection, database, isDistinct, null);
        return sqler.getSQL(formula);
    }
}

