/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.CreateIndexQuery;
import com.healthmarketscience.sqlbuilder.CreateTableQuery;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.QueryPreparer;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.UpdateQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.linqs.psl.database.rdbms.driver.DatabaseDriver;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.util.Hash;
import org.linqs.psl.util.ListUtils;
import org.linqs.psl.util.Logger;

public class PredicateInfo {
    private static final Logger log = Logger.getLogger(PredicateInfo.class);
    public static final String PREDICATE_TABLE_SUFFIX = "_PREDICATE";
    public static final String PARTITION_COLUMN_NAME = "partition_id";
    public static final String VALUE_COLUMN_NAME = "truth_value";
    public static final int MAX_TABLE_NAME_LENGTH = 63 - "IX__UniqueStringID_99".length();
    public static final String HASH_PREFIX = "H";
    private final Predicate predicate;
    private final List<String> argCols;
    private final String tableName;
    private Map<String, String> cachedSQL;
    private boolean indexed;
    private int count;

    public PredicateInfo(Predicate predicate) {
        assert (predicate != null);
        this.predicate = predicate;
        this.tableName = PredicateInfo.constructTableName(predicate.getName());
        this.argCols = new ArrayList<String>(predicate.getArity());
        for (int i = 0; i < predicate.getArity(); ++i) {
            this.argCols.add(predicate.getArgumentType(i).getName() + "_" + i);
        }
        this.cachedSQL = new HashMap<String, String>();
        this.indexed = false;
        this.count = -1;
    }

    public List<String> argumentColumns() {
        return Collections.unmodifiableList(this.argCols);
    }

    public String tableName() {
        return this.tableName;
    }

    public Predicate predicate() {
        return this.predicate;
    }

    public boolean indexed() {
        return this.indexed;
    }

    public void setupTable(Connection connection, DatabaseDriver dbDriver) {
        this.createTable(connection, dbDriver);
    }

    public PreparedStatement createCountAllStatement(Connection connection, List<Short> partitions) {
        return this.prepareSQL(connection, this.buildCountAllStatement(partitions));
    }

    public PreparedStatement createQueryAllStatement(Connection connection, List<Short> partitions) {
        return this.prepareSQL(connection, this.buildQueryAllStatement(partitions));
    }

    public PreparedStatement createQueryAllWriteStatement(Connection connection, short writePartition) {
        ArrayList<Short> partitions = new ArrayList<Short>(1);
        partitions.add(writePartition);
        return this.createQueryAllStatement(connection, partitions);
    }

    public PreparedStatement createQueryStatement(Connection connection, List<Short> readPartitions) {
        return this.prepareSQL(connection, this.buildQueryStatement(readPartitions));
    }

    public PreparedStatement createUpsertStatement(Connection connection, DatabaseDriver dbDriver) {
        return this.prepareSQL(connection, this.buildUpsertStatement(dbDriver));
    }

    public PreparedStatement createDeleteStatement(Connection connection, List<Short> partitions) {
        return this.prepareSQL(connection, this.buildDeleteStatement(partitions));
    }

    public PreparedStatement createPartitionMoveStatement(Connection connection, short oldPartition, short newPartition) {
        return this.prepareSQL(connection, this.buildPartitionMoveStatement(oldPartition, newPartition));
    }

    public int getCount(Connection connection) {
        if (this.count != -1) {
            return this.count;
        }
        String sql = "SELECT COUNT(*) FROM " + this.tableName;
        try (PreparedStatement statement = connection.prepareStatement(sql);
             ResultSet result = statement.executeQuery();){
            result.next();
            this.count = result.getInt(1);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to get count from table: " + this.tableName, ex);
        }
        return this.count;
    }

    private void createTable(Connection connection, DatabaseDriver dbDriver) {
        CreateTableQuery createTable = new CreateTableQuery(this.tableName);
        createTable.addCustomColumns("partition_id INT NOT NULL");
        createTable.addCustomColumns("truth_value " + dbDriver.getDoubleTypeName() + " NOT NULL DEFAULT 1.0");
        ArrayList<String> uniqueColumns = new ArrayList<String>();
        for (int i = 0; i < this.argCols.size(); ++i) {
            String colName = this.argCols.get(i);
            ConstantType type = this.predicate.getArgumentType(i);
            String typeName = dbDriver.getTypeName(type);
            if (type == ConstantType.UniqueIntID || type == ConstantType.UniqueStringID) {
                uniqueColumns.add(colName);
            }
            createTable.addCustomColumns(colName + " " + typeName + " NOT NULL");
        }
        uniqueColumns.add(PARTITION_COLUMN_NAME);
        if (uniqueColumns.size() > 1) {
            createTable.addCustomConstraints("UNIQUE(" + ListUtils.join(", ", uniqueColumns) + ")");
        }
        if (uniqueColumns.size() < this.argCols.size() + 1) {
            uniqueColumns.remove(PARTITION_COLUMN_NAME);
            for (String colName : this.argCols) {
                if (uniqueColumns.contains(colName)) continue;
                uniqueColumns.add(colName);
            }
            uniqueColumns.add(0, PARTITION_COLUMN_NAME);
            createTable.addCustomConstraints("UNIQUE(" + ListUtils.join(", ", uniqueColumns) + ")");
        }
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(dbDriver.finalizeCreateTable(createTable));
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error creating table for predicate: " + this.predicate.getName(), ex);
        }
    }

    public synchronized void index(Connection connection, DatabaseDriver dbDriver) {
        if (this.indexed) {
            return;
        }
        this.indexed = true;
        ArrayList<String> indexes = new ArrayList<String>();
        CreateIndexQuery createIndex = new CreateIndexQuery(this.tableName, (Object)("IX_" + this.tableName + "_GROUNDING"));
        for (String colName : this.argCols) {
            createIndex.addCustomColumns(colName);
        }
        createIndex.addCustomColumns(PARTITION_COLUMN_NAME);
        indexes.add(((CreateIndexQuery)createIndex.validate()).toString());
        for (String colName : this.argCols) {
            createIndex = new CreateIndexQuery(this.tableName, (Object)("IX_" + this.tableName + "_" + colName));
            createIndex.addCustomColumns(colName);
            indexes.add(((CreateIndexQuery)createIndex.validate()).toString());
        }
        createIndex = new CreateIndexQuery(this.tableName, (Object)("IX_" + this.tableName + "_" + PARTITION_COLUMN_NAME));
        createIndex.addCustomColumns(PARTITION_COLUMN_NAME);
        indexes.add(((CreateIndexQuery)createIndex.validate()).toString());
        try (Statement statement = connection.createStatement();){
            for (String index : indexes) {
                statement.executeUpdate(index);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error creating index on table for predicate: " + this.predicate.getName(), ex);
        }
    }

    private synchronized String buildCountAllStatement(List<Short> partitions) {
        assert (partitions != null);
        String key = "countAll_" + partitions.toString();
        if (this.cachedSQL.containsKey(key)) {
            return this.cachedSQL.get(key);
        }
        SelectQuery query = new SelectQuery();
        query.addCustomColumns(new CustomSql("COUNT(*)"));
        query.addCustomFromTable(this.tableName);
        if (partitions.size() == 1) {
            query.addCondition(BinaryCondition.equalTo(new CustomSql(PARTITION_COLUMN_NAME), partitions.get(0)));
        } else if (partitions.size() > 1) {
            query.addCondition(new InCondition((Object)new CustomSql(PARTITION_COLUMN_NAME), partitions));
        }
        String sql = ((SelectQuery)query.validate()).toString();
        this.cachedSQL.put(key, sql);
        return sql;
    }

    private synchronized String buildQueryAllStatement(List<Short> partitions) {
        assert (partitions != null);
        String key = "queryAll_" + partitions.toString();
        if (this.cachedSQL.containsKey(key)) {
            return this.cachedSQL.get(key);
        }
        SelectQuery query = new SelectQuery();
        query.addCustomColumns(new CustomSql(PARTITION_COLUMN_NAME));
        query.addCustomColumns(new CustomSql(VALUE_COLUMN_NAME));
        for (String colName : this.argCols) {
            query.addCustomColumns(new CustomSql(colName));
        }
        query.addCustomFromTable(this.tableName);
        if (partitions.size() == 1) {
            query.addCondition(BinaryCondition.equalTo(new CustomSql(PARTITION_COLUMN_NAME), partitions.get(0)));
        } else if (partitions.size() > 1) {
            query.addCondition(new InCondition((Object)new CustomSql(PARTITION_COLUMN_NAME), partitions));
        }
        String sql = ((SelectQuery)query.validate()).toString();
        this.cachedSQL.put(key, sql);
        return sql;
    }

    private synchronized String buildQueryStatement(List<Short> readPartitions) {
        String key = "query_" + readPartitions.toString();
        if (this.cachedSQL.containsKey(key)) {
            return this.cachedSQL.get(key);
        }
        SelectQuery query = new SelectQuery();
        QueryPreparer.MultiPlaceHolder placeHolder = new QueryPreparer().getNewMultiPlaceHolder();
        query.addAllColumns();
        query.addCustomFromTable(this.tableName);
        query.addCondition(new InCondition((Object)new CustomSql(PARTITION_COLUMN_NAME), readPartitions));
        for (String colName : this.argCols) {
            query.addCondition(BinaryCondition.equalTo(new CustomSql(colName), placeHolder));
        }
        String sql = ((SelectQuery)query.validate()).toString();
        this.cachedSQL.put(key, sql);
        return sql;
    }

    private synchronized String buildUpsertStatement(DatabaseDriver dbDriver) {
        String key = "upsert";
        if (this.cachedSQL.containsKey(key)) {
            return this.cachedSQL.get(key);
        }
        String[] columns = new String[2 + this.argCols.size()];
        String[] keyColumns = new String[1 + this.argCols.size()];
        columns[0] = PARTITION_COLUMN_NAME;
        columns[1] = VALUE_COLUMN_NAME;
        keyColumns[0] = PARTITION_COLUMN_NAME;
        for (int i = 0; i < this.argCols.size(); ++i) {
            columns[2 + i] = this.argCols.get(i);
            keyColumns[1 + i] = this.argCols.get(i);
        }
        String sql = dbDriver.getUpsert(this.tableName, columns, keyColumns);
        this.cachedSQL.put(key, sql);
        return sql;
    }

    private synchronized String buildDeleteStatement(List<Short> partitions) {
        String key = "delete_" + partitions.toString();
        if (this.cachedSQL.containsKey(key)) {
            return this.cachedSQL.get(key);
        }
        DeleteQuery delete = new DeleteQuery(this.tableName);
        QueryPreparer.MultiPlaceHolder placeHolder = new QueryPreparer().getNewMultiPlaceHolder();
        delete.addCondition(new InCondition((Object)new CustomSql(PARTITION_COLUMN_NAME), partitions));
        for (String colName : this.argCols) {
            delete.addCondition(BinaryCondition.equalTo(new CustomSql(colName), placeHolder));
        }
        String sql = ((DeleteQuery)delete.validate()).toString();
        this.cachedSQL.put(key, sql);
        return sql;
    }

    private synchronized String buildPartitionMoveStatement(short oldPartition, short newPartition) {
        String key = "movePartition_" + oldPartition + "_" + newPartition;
        if (this.cachedSQL.containsKey(key)) {
            return this.cachedSQL.get(key);
        }
        UpdateQuery update = new UpdateQuery(this.tableName);
        update.addCondition(BinaryCondition.equalTo(new CustomSql(PARTITION_COLUMN_NAME), oldPartition));
        update.addCustomSetClause(new CustomSql(PARTITION_COLUMN_NAME), newPartition);
        String sql = ((UpdateQuery)update.validate()).toString();
        this.cachedSQL.put(key, sql);
        return sql;
    }

    private PreparedStatement prepareSQL(Connection connection, String sql) {
        try {
            return connection.prepareStatement(sql);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Could not create prepared statement from (" + sql + ").", ex);
        }
    }

    private static String constructTableName(String predicateName) {
        String tableName = predicateName + PREDICATE_TABLE_SUFFIX;
        if (tableName.length() <= MAX_TABLE_NAME_LENGTH) {
            return tableName;
        }
        tableName = HASH_PREFIX + Hash.sha(predicateName) + PREDICATE_TABLE_SUFFIX;
        if (tableName.length() > MAX_TABLE_NAME_LENGTH) {
            int truncateSize = tableName.length() - MAX_TABLE_NAME_LENGTH + HASH_PREFIX.length();
            tableName = HASH_PREFIX + tableName.substring(truncateSize, tableName.length());
        }
        return tableName;
    }
}

