/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.evaluation;

import org.linqs.psl.application.learning.weight.TrainingMap;
import org.linqs.psl.database.Database;
import org.linqs.psl.evaluation.statistics.Evaluator;
import org.linqs.psl.model.predicate.StandardPredicate;

public class EvaluationInstance {
    private StandardPredicate predicate;
    private Evaluator evaluator;
    private boolean primary;

    public EvaluationInstance(StandardPredicate predicate, Evaluator evaluator, boolean primary) {
        this.predicate = predicate;
        this.evaluator = evaluator;
        this.primary = primary;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public StandardPredicate getPredicate() {
        return this.predicate;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void compute(TrainingMap trainingMap) {
        this.evaluator.compute(trainingMap, this.predicate);
    }

    public void compute(Database targets, Database truth) {
        this.evaluator.compute(targets, truth, this.predicate);
    }

    public double getNormalizedRepMetric() {
        return this.evaluator.getNormalizedRepMetric();
    }

    public double getNormalizedMaxRepMetric() {
        return this.evaluator.getNormalizedMaxRepMetric();
    }

    public String getOutput() {
        return String.format("Evaluator: %s, Predicate: %s, Results -- %s", this.evaluator.getClass().getSimpleName(), this.predicate.getName(), this.evaluator.getAllStats());
    }

    public String toString() {
        return String.format("Evaluator: %s, Predicate: %s", this.evaluator.getClass().getSimpleName(), this.predicate.getName());
    }
}

