/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.predicate;

import org.linqs.psl.database.Database;
import org.linqs.psl.model.function.ExternalFunction;
import org.linqs.psl.model.predicate.FunctionalPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.term.Constant;

public class ExternalFunctionalPredicate
extends FunctionalPredicate {
    private final ExternalFunction extFun;

    private ExternalFunctionalPredicate(String name, ExternalFunction extFun) {
        super(name, extFun.getArgumentTypes());
        this.extFun = extFun;
    }

    @Override
    public float computeValue(Database db, Constant ... args) {
        return this.extFun.getValue(db, args);
    }

    public ExternalFunction getExternalFunction() {
        return this.extFun;
    }

    public static ExternalFunctionalPredicate get(String name) {
        Predicate predicate = Predicate.get(name);
        if (predicate == null) {
            return null;
        }
        if (!(predicate instanceof ExternalFunctionalPredicate)) {
            throw new ClassCastException("Predicate (" + name + ") is not a ExternalFunctionalPredicate.");
        }
        return (ExternalFunctionalPredicate)predicate;
    }

    public static ExternalFunctionalPredicate get(String name, ExternalFunction extFun) {
        ExternalFunctionalPredicate predicate = ExternalFunctionalPredicate.get(name);
        if (predicate == null) {
            return new ExternalFunctionalPredicate(name, extFun);
        }
        if (!predicate.getExternalFunction().equals(extFun)) {
            throw new IllegalArgumentException("External function mismatch for predicate " + predicate.getName() + " Existing predicate: " + predicate.getExternalFunction() + ", Query Predicate: " + extFun);
        }
        return predicate;
    }
}

