/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.linqs.psl.model.rule.Rule;

public abstract class AbstractRule
implements Rule {
    private static final Map<Integer, Rule> rules = new HashMap<Integer, Rule>();
    protected String name;
    protected Boolean active;
    protected int hashcode;

    public static Rule getRule(int hashcode) {
        return rules.get(hashcode);
    }

    protected AbstractRule() {
        this.name = null;
        this.hashcode = 0;
        this.active = true;
    }

    protected AbstractRule(String name, int hashcode) {
        this.name = name;
        this.hashcode = hashcode;
        this.active = true;
        this.ensureRegistration();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static void registerRule(Rule rule) {
        rules.put(rule.hashCode(), rule);
    }

    private static void unregisterRule(Rule rule) {
        rules.remove(rule.hashCode());
    }

    public static void unregisterAllRulesForTesting() {
        rules.clear();
    }

    @Override
    public boolean isRegistered() {
        return rules.containsKey(this.hashcode);
    }

    @Override
    public void ensureRegistration() {
        if (!this.isRegistered()) {
            AbstractRule.registerRule(this);
        }
    }

    @Override
    public void unregister() {
        if (this.isRegistered()) {
            AbstractRule.unregisterRule(this);
        }
    }

    public int hashCode() {
        return this.hashcode;
    }

    public abstract boolean equals(Object var1);

    @Override
    public boolean requiresSplit() {
        return false;
    }

    @Override
    public List<Rule> split() {
        throw new UnsupportedOperationException();
    }
}

