/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic;

import java.util.List;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.predicate.GroundingOnlyPredicate;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.model.rule.arithmetic.AbstractArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.AbstractGroundArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.WeightedArithmeticRule;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.function.GeneralFunction;

public class WeightedGroundArithmeticRule
extends AbstractGroundArithmeticRule
implements WeightedGroundRule {
    public WeightedGroundArithmeticRule(WeightedArithmeticRule rule, List<Float> coefficients, List<GroundAtom> atoms, FunctionComparator comparator, float constant) {
        super((AbstractArithmeticRule)rule, coefficients, atoms, comparator, constant);
        this.validate();
    }

    public WeightedGroundArithmeticRule(WeightedArithmeticRule rule, float[] coefficients, GroundAtom[] atoms, FunctionComparator comparator, float constant) {
        super((AbstractArithmeticRule)rule, coefficients, atoms, comparator, constant);
        this.validate();
    }

    private void validate() {
        if (FunctionComparator.EQ.equals((Object)this.comparator)) {
            throw new IllegalArgumentException("WeightedGroundArithmeticRules do not support equality comparators. Create two ground rules instead, one with " + (Object)((Object)FunctionComparator.LTE) + " and one with " + (Object)((Object)FunctionComparator.GTE) + ".");
        }
        if (!FunctionComparator.LTE.equals((Object)this.comparator) && !FunctionComparator.GTE.equals((Object)this.comparator)) {
            throw new IllegalArgumentException("Unrecognized comparator: " + (Object)((Object)this.comparator));
        }
    }

    @Override
    public WeightedRule getRule() {
        return (WeightedRule)((Object)this.rule);
    }

    @Override
    public boolean isSquared() {
        return ((WeightedRule)((Object)this.rule)).isSquared();
    }

    @Override
    public float getWeight() {
        return ((WeightedRule)((Object)this.rule)).getWeight();
    }

    @Override
    public void setWeight(float weight) {
        ((WeightedRule)((Object)this.rule)).setWeight(weight);
    }

    @Override
    public GeneralFunction getFunctionDefinition(boolean mergeConstants) {
        GeneralFunction sum = new GeneralFunction(true, this.isSquared(), this.coefficients.length, mergeConstants);
        float termSign = FunctionComparator.GTE.equals((Object)this.comparator) ? -1.0f : 1.0f;
        for (int i = 0; i < this.coefficients.length; ++i) {
            if (this.atoms[i].getPredicate() instanceof GroundingOnlyPredicate) continue;
            sum.add(termSign * this.coefficients[i], this.atoms[i]);
        }
        sum.add(-1.0f * termSign * this.constant);
        return sum;
    }

    @Override
    public float getIncompatibility() {
        return this.getIncompatibility(null, 0.0f);
    }

    @Override
    public float getIncompatibility(GroundAtom replacementAtom, float replacementValue) {
        float sum = 0.0f;
        for (int i = 0; i < this.coefficients.length; ++i) {
            if (this.atoms[i].getPredicate() instanceof GroundingOnlyPredicate) continue;
            if (this.atoms[i] == replacementAtom) {
                sum += this.coefficients[i] * replacementValue;
                continue;
            }
            sum += this.coefficients[i] * this.atoms[i].getValue();
        }
        sum -= this.constant;
        if (FunctionComparator.GTE.equals((Object)this.comparator)) {
            sum *= -1.0f;
        }
        return (float)(this.isSquared() ? Math.pow(Math.max(sum, 0.0f), 2.0) : (double)Math.max(sum, 0.0f));
    }

    @Override
    public String toString() {
        return "" + this.getWeight() + ": " + this.baseToString() + (this.isSquared() ? " ^2" : "");
    }
}

