/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic.expression.coefficient;

import java.util.Map;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariable;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.BinaryCoefficient;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Coefficient;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.ConstantNumber;
import org.linqs.psl.util.MathUtils;

public class Add
extends BinaryCoefficient {
    public Add(Coefficient c1, Coefficient c2) {
        super(c1, c2);
    }

    @Override
    public float getValue(Map<SummationVariable, Integer> subs) {
        return this.c1.getValue(subs) + this.c2.getValue(subs);
    }

    public String toString() {
        return "(" + this.c1.toString() + " + " + this.c2.toString() + ")";
    }

    @Override
    public Coefficient simplify() {
        Coefficient lhs = this.c1.simplify();
        Coefficient rhs = this.c2.simplify();
        if (lhs instanceof ConstantNumber && rhs instanceof ConstantNumber) {
            return new ConstantNumber(this.getValue(null));
        }
        if (lhs instanceof ConstantNumber && MathUtils.isZero(((ConstantNumber)lhs).value)) {
            return rhs;
        }
        if (rhs instanceof ConstantNumber && MathUtils.isZero(((ConstantNumber)rhs).value)) {
            return lhs;
        }
        return new Add(lhs, rhs);
    }
}

