/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.term;

import org.linqs.psl.model.term.Term;

public class Variable
implements Term {
    private final String name;
    private final int hashcode;

    public Variable(String name) {
        if (name == null || !name.matches("^[a-zA-Z]\\w*")) {
            throw new IllegalArgumentException("Variable name must begin with a-z or A-Z and contain only [a-zA-Z0-9_]. Invalid name: " + name);
        }
        this.name = name;
        this.hashcode = this.name.hashCode() * 1163;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof Variable)) {
            return false;
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        return this.getName().equals(((Variable)other).getName());
    }

    @Override
    public int compareTo(Term other) {
        if (other == null) {
            return -1;
        }
        if (!(other instanceof Variable)) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        return this.name.compareTo(((Variable)other).name);
    }
}

