/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.TermState;
import org.linqs.psl.util.FloatMatrix;
import org.linqs.psl.util.HashCode;

public class ADMMObjectiveTerm
extends ReasonerTerm {
    private final float[] variableValues;
    private final float[] variableLagranges;
    private float[] consensusOptimizer;
    private float[] unitNormal;
    private static final Map<Integer, FloatMatrix> lowerTriangleCache = new HashMap<Integer, FloatMatrix>();

    public ADMMObjectiveTerm(Hyperplane hyperplane, Rule rule, boolean squared, boolean hinge, FunctionComparator comparator) {
        super(hyperplane, rule, squared, hinge, comparator);
        this.variableValues = new float[this.size];
        this.variableLagranges = new float[this.size];
        GroundAtom[] consensusVariables = hyperplane.getVariables();
        for (int i = 0; i < this.size; ++i) {
            this.variableValues[i] = consensusVariables[i].getValue();
            this.variableLagranges[i] = 0.0f;
        }
        if (this.termType == ReasonerTerm.TermType.HingeLossTerm || this.termType == ReasonerTerm.TermType.LinearConstraintTerm) {
            this.initUnitNormal();
        }
    }

    public static ADMMObjectiveTerm createLinearConstraintTerm(Hyperplane hyperplane, Rule rule, FunctionComparator comparator) {
        return new ADMMObjectiveTerm(hyperplane, rule, false, false, comparator);
    }

    public static ADMMObjectiveTerm createLinearLossTerm(Hyperplane hyperplane, Rule rule) {
        return new ADMMObjectiveTerm(hyperplane, rule, false, false, null);
    }

    public static ADMMObjectiveTerm createHingeLossTerm(Hyperplane hyperplane, Rule rule) {
        return new ADMMObjectiveTerm(hyperplane, rule, false, true, null);
    }

    public static ADMMObjectiveTerm createSquaredLinearLossTerm(Hyperplane hyperplane, Rule rule) {
        return new ADMMObjectiveTerm(hyperplane, rule, true, false, null);
    }

    public static ADMMObjectiveTerm createSquaredHingeLossTerm(Hyperplane hyperplane, Rule rule) {
        return new ADMMObjectiveTerm(hyperplane, rule, true, true, null);
    }

    public void updateLagrange(float stepSize, float[] consensusValues) {
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.variableLagranges[n] = this.variableLagranges[n] + stepSize * (this.variableValues[i] - consensusValues[this.atomIndexes[i]]);
        }
    }

    public void setLocalValue(short index, float value, float lagrange) {
        this.variableValues[index] = value;
        this.variableLagranges[index] = lagrange;
    }

    public float getVariableValue(short index) {
        return this.variableValues[index];
    }

    public float getVariableLagrange(short index) {
        return this.variableLagranges[index];
    }

    public void minimize(float stepSize, float[] consensusValues) {
        float weight = this.getWeight();
        switch (this.termType) {
            case LinearConstraintTerm: {
                this.minimizeConstraint(stepSize, consensusValues);
                break;
            }
            case LinearLossTerm: {
                this.minimizeLinearLoss(stepSize, weight, consensusValues);
                break;
            }
            case HingeLossTerm: {
                this.minimizeHingeLoss(stepSize, weight, consensusValues);
                break;
            }
            case SquaredLinearLossTerm: {
                this.minimizeSquaredLinearLoss(stepSize, weight, consensusValues);
                break;
            }
            case SquaredHingeLossTerm: {
                this.minimizeSquaredHingeLoss(stepSize, weight, consensusValues);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown term type.");
            }
        }
    }

    private void minimizeConstraint(float stepSize, float[] consensusValues) {
        if (!this.comparator.equals((Object)FunctionComparator.EQ)) {
            float total = 0.0f;
            for (int i = 0; i < this.size; ++i) {
                float newValue;
                this.variableValues[i] = newValue = consensusValues[this.atomIndexes[i]] - this.variableLagranges[i] / stepSize;
                total += this.coefficients[i] * newValue;
            }
            if (this.comparator.equals((Object)FunctionComparator.LTE) && total <= this.constant || this.comparator.equals((Object)FunctionComparator.GTE) && total >= this.constant) {
                return;
            }
        }
        this.project(stepSize, consensusValues);
    }

    private void minimizeLinearLoss(float stepSize, float weight, float[] consensusValues) {
        for (int i = 0; i < this.size; ++i) {
            float value;
            this.variableValues[i] = value = consensusValues[this.atomIndexes[i]] - this.variableLagranges[i] / stepSize - weight * this.coefficients[i] / stepSize;
        }
    }

    private void minimizeHingeLoss(float stepSize, float weight, float[] consensusValues) {
        float newValue;
        int i;
        float total = 0.0f;
        for (i = 0; i < this.size; ++i) {
            this.variableValues[i] = newValue = consensusValues[this.atomIndexes[i]] - this.variableLagranges[i] / stepSize;
            total += this.coefficients[i] * newValue;
        }
        if (total <= this.constant) {
            return;
        }
        total = 0.0f;
        for (i = 0; i < this.size; ++i) {
            this.variableValues[i] = newValue = consensusValues[this.atomIndexes[i]] - this.variableLagranges[i] / stepSize - weight * this.coefficients[i] / stepSize;
            total += this.coefficients[i] * newValue;
        }
        if (total >= this.constant) {
            return;
        }
        this.project(stepSize, consensusValues);
    }

    private void minimizeSquaredLinearLoss(float stepSize, float weight, float[] consensusValues) {
        this.minWeightedSquaredHyperplane(stepSize, weight, consensusValues);
    }

    private void minimizeSquaredHingeLoss(float stepSize, float weight, float[] consensusValues) {
        float total = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            float newValue;
            this.variableValues[i] = newValue = consensusValues[this.atomIndexes[i]] - this.variableLagranges[i] / stepSize;
            total += this.coefficients[i] * newValue;
        }
        if (total <= this.constant) {
            return;
        }
        this.minWeightedSquaredHyperplane(stepSize, weight, consensusValues);
    }

    private void initUnitNormal() {
        int i;
        if (this.size == 1) {
            this.consensusOptimizer = null;
            this.unitNormal = null;
            return;
        }
        this.consensusOptimizer = new float[this.size];
        this.unitNormal = new float[this.size];
        float length = 0.0f;
        for (i = 0; i < this.size; ++i) {
            length += this.coefficients[i] * this.coefficients[i];
        }
        length = (float)Math.sqrt(length);
        for (i = 0; i < this.size; ++i) {
            this.unitNormal[i] = this.coefficients[i] / length;
        }
    }

    private void project(float stepSize, float[] consensusValues) {
        int i;
        if (this.size == 1) {
            this.variableValues[0] = this.constant / this.coefficients[0];
            return;
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.consensusOptimizer[i2] = consensusValues[this.atomIndexes[i2]] - this.variableLagranges[i2] / stepSize;
        }
        float length = this.coefficients[0] / this.unitNormal[0];
        float multiplier = -1.0f * this.constant / length;
        for (i = 0; i < this.size; ++i) {
            multiplier += this.consensusOptimizer[i] * this.unitNormal[i];
        }
        for (i = 0; i < this.size; ++i) {
            this.variableValues[i] = this.consensusOptimizer[i] - multiplier * this.unitNormal[i];
        }
    }

    private void minWeightedSquaredHyperplane(float stepSize, float weight, float[] consensusValues) {
        int j;
        float newValue;
        int i;
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.variableValues[i2] = stepSize * consensusValues[this.atomIndexes[i2]] - this.variableLagranges[i2] + 2.0f * weight * this.coefficients[i2] * this.constant;
        }
        if (this.size == 1) {
            this.variableValues[0] = this.variableValues[0] / (2.0f * weight * this.coefficients[0] * this.coefficients[0] + stepSize);
            return;
        }
        if (this.size == 2) {
            float variableValue0 = this.variableValues[0];
            float variableValue1 = this.variableValues[1];
            float coefficient0 = this.coefficients[0];
            float coefficient1 = this.coefficients[1];
            float a0 = 2.0f * weight * coefficient0 * coefficient0 + stepSize;
            float b1 = 2.0f * weight * coefficient1 * coefficient1 + stepSize;
            float a1b0 = 2.0f * weight * coefficient0 * coefficient1;
            variableValue1 -= a1b0 * variableValue0 / a0;
            this.variableValues[0] = variableValue0 = (variableValue0 - a1b0 * (variableValue1 /= b1 - a1b0 * a1b0 / a0)) / a0;
            this.variableValues[1] = variableValue1;
            return;
        }
        FloatMatrix lowerTriangle = this.fetchLowerTriangle(stepSize, weight);
        for (i = 0; i < this.size; ++i) {
            newValue = this.variableValues[i];
            for (j = 0; j < i; ++j) {
                newValue -= lowerTriangle.get(i, j) * this.variableValues[j];
            }
            this.variableValues[i] = newValue / lowerTriangle.get(i, i);
        }
        for (i = this.size - 1; i >= 0; --i) {
            newValue = this.variableValues[i];
            for (j = this.size - 1; j > i; --j) {
                newValue -= lowerTriangle.get(j, i) * this.variableValues[j];
            }
            this.variableValues[i] = newValue / lowerTriangle.get(i, i);
        }
    }

    private FloatMatrix fetchLowerTriangle(float stepSize, float weight) {
        int hash = HashCode.build(Float.valueOf(weight));
        hash = HashCode.build(hash, Float.valueOf(stepSize));
        for (int i = 0; i < this.size; ++i) {
            hash = HashCode.build(hash, Float.valueOf(this.coefficients[i]));
        }
        FloatMatrix lowerTriangle = lowerTriangleCache.get(hash);
        if (lowerTriangle != null) {
            return lowerTriangle;
        }
        return this.computeLowerTriangle(stepSize, weight, hash);
    }

    private synchronized FloatMatrix computeLowerTriangle(float stepSize, float weight, int hash) {
        if (lowerTriangleCache.containsKey(hash)) {
            return lowerTriangleCache.get(hash);
        }
        float coefficient = 0.0f;
        FloatMatrix matrix = FloatMatrix.zeroes(this.size, this.size);
        for (int i = 0; i < this.size; ++i) {
            for (int j = i; j < this.size; ++j) {
                if (i == j) {
                    coefficient = 2.0f * weight * this.coefficients[i] * this.coefficients[i] + stepSize;
                    matrix.set(i, i, coefficient);
                    continue;
                }
                coefficient = 2.0f * weight * this.coefficients[i] * this.coefficients[j];
                matrix.set(i, j, coefficient);
                matrix.set(j, i, coefficient);
            }
        }
        matrix.choleskyDecomposition(true);
        lowerTriangleCache.put(hash, matrix);
        return matrix;
    }

    @Override
    public void loadState(TermState termState) {
        assert (termState instanceof ADMMObjectiveTermState);
        ADMMObjectiveTermState objectiveTermState = (ADMMObjectiveTermState)termState;
        System.arraycopy(objectiveTermState.variableValues, 0, this.variableValues, 0, this.variableValues.length);
        System.arraycopy(objectiveTermState.variableLagranges, 0, this.variableLagranges, 0, this.variableLagranges.length);
    }

    @Override
    public TermState saveState() {
        return new ADMMObjectiveTermState(this.variableValues, this.variableLagranges);
    }

    @Override
    public void saveState(TermState termState) {
        assert (termState instanceof ADMMObjectiveTermState);
        ADMMObjectiveTermState objectiveTermState = (ADMMObjectiveTermState)termState;
        System.arraycopy(this.variableValues, 0, objectiveTermState.variableValues, 0, this.variableValues.length);
        System.arraycopy(this.variableLagranges, 0, objectiveTermState.variableLagranges, 0, this.variableLagranges.length);
    }

    public static final class ADMMObjectiveTermState
    extends TermState {
        public float[] variableValues;
        public float[] variableLagranges;

        public ADMMObjectiveTermState(float[] variableValues, float[] variableLagranges) {
            this.variableValues = Arrays.copyOf(variableValues, variableValues.length);
            this.variableLagranges = Arrays.copyOf(variableLagranges, variableLagranges.length);
        }
    }
}

