/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import java.util.ArrayList;
import java.util.List;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.admm.term.ADMMObjectiveTerm;
import org.linqs.psl.reasoner.admm.term.ADMMTermGenerator;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.SimpleTermStore;

public class ADMMTermStore
extends SimpleTermStore<ADMMObjectiveTerm> {
    private List[] localRecords = null;
    private int numLocalVariables = 0;

    public ADMMTermStore(Database database) {
        super(database, new ADMMTermGenerator());
    }

    public List<LocalRecord> getLocalRecords(int variableIndex) {
        if (this.localRecords == null || variableIndex >= this.localRecords.length) {
            return null;
        }
        return this.localRecords[variableIndex];
    }

    public int getNumLocalVariables() {
        return this.numLocalVariables;
    }

    @Override
    protected synchronized int add(GroundRule groundRule, ADMMObjectiveTerm term, Hyperplane hyperplane) {
        this.init();
        long termIndex = this.size();
        super.add(groundRule, term, hyperplane);
        for (int i = 0; i < hyperplane.size(); ++i) {
            int atomIndex = hyperplane.getVariable(i).getIndex();
            if (this.localRecords[atomIndex] == null) {
                this.localRecords[atomIndex] = new ArrayList();
            }
            List records = this.localRecords[atomIndex];
            records.add(new LocalRecord(termIndex, (short)i));
            ++this.numLocalVariables;
        }
        return 1;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.localRecords != null) {
            for (int i = 0; i < this.localRecords.length; ++i) {
                if (this.localRecords[i] == null) continue;
                this.localRecords[i].clear();
                this.localRecords[i] = null;
            }
        }
        this.numLocalVariables = 0;
    }

    @Override
    public void close() {
        super.close();
        this.localRecords = null;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.localRecords != null) {
            float[] consensusValues = this.database.getAtomStore().getAtomValues();
            for (int i = 0; i < this.localRecords.length; ++i) {
                if (this.localRecords[i] == null) continue;
                List records = this.localRecords[i];
                for (LocalRecord local : records) {
                    ((ADMMObjectiveTerm)this.get(local.termIndex)).setLocalValue(local.variableIndex, consensusValues[i], 0.0f);
                }
            }
        }
    }

    private synchronized void init() {
        if (this.localRecords == null) {
            this.localRecords = new List[this.database.getAtomStore().getMaxRVAIndex() + 1];
        }
    }

    public static final class LocalRecord {
        public long termIndex;
        public short variableIndex;

        public LocalRecord(long termIndex, short variableIndex) {
            this.termIndex = termIndex;
            this.variableIndex = variableIndex;
        }
    }
}

