/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.duallcqp;

import org.linqs.psl.reasoner.duallcqp.DualBCDReasoner;
import org.linqs.psl.reasoner.duallcqp.term.DualLCQPObjectiveTerm;
import org.linqs.psl.reasoner.duallcqp.term.DualLCQPTermStore;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.Parallel;

public class DistributedDualBCDReasoner
extends DualBCDReasoner {
    private static final Logger log = Logger.getLogger(DistributedDualBCDReasoner.class);
    private int blockSize = -1;
    private int numTermBlocks = -1;

    @Override
    protected void internalOptimize(DualLCQPTermStore termStore) {
        Parallel.count(this.numTermBlocks, new BlockUpdateWorker(termStore, this.blockSize, this.regularizationParameter));
    }

    @Override
    protected void initForOptimization(TermStore<DualLCQPObjectiveTerm> termStore) {
        super.initForOptimization(termStore);
        this.blockSize = (int)(termStore.size() / (long)(Parallel.getNumThreads() * 4) + 1L);
        this.numTermBlocks = (int)Math.ceil((double)termStore.size() / (double)this.blockSize);
    }

    private static class BlockUpdateWorker
    extends Parallel.Worker<Long> {
        private final DualLCQPTermStore termStore;
        private final int blockSize;
        private final double regularizationParameter;

        public BlockUpdateWorker(DualLCQPTermStore termStore, int blockSize, double regularizationParameter) {
            this.termStore = termStore;
            this.blockSize = blockSize;
            this.regularizationParameter = regularizationParameter;
        }

        public Object clone() {
            return new BlockUpdateWorker(this.termStore, this.blockSize, this.regularizationParameter);
        }

        @Override
        public void work(long blockIndex, Long ignore) {
            int termIndex;
            long numTerms = this.termStore.size();
            for (int innerBlockIndex = 0; innerBlockIndex < this.blockSize && (long)(termIndex = (int)(blockIndex * (long)this.blockSize + (long)innerBlockIndex)) < numTerms; ++innerBlockIndex) {
                DualLCQPObjectiveTerm term = (DualLCQPObjectiveTerm)this.termStore.get(termIndex);
                if (!term.isActive()) continue;
                DualBCDReasoner.dualBlockUpdate(term, this.termStore, this.regularizationParameter);
            }
        }
    }
}

