/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.duallcqp;

import java.util.Arrays;
import java.util.List;
import org.linqs.psl.application.learning.weight.TrainingMap;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.AtomStore;
import org.linqs.psl.evaluation.EvaluationInstance;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.predicate.DeepPredicate;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.duallcqp.term.DualLCQPAtom;
import org.linqs.psl.reasoner.duallcqp.term.DualLCQPObjectiveTerm;
import org.linqs.psl.reasoner.duallcqp.term.DualLCQPTermStore;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.MathUtils;
import org.linqs.psl.util.Parallel;

public class DualBCDReasoner
extends Reasoner<DualLCQPObjectiveTerm> {
    private static final Logger log = Logger.getLogger(DualBCDReasoner.class);
    public final double regularizationParameter = Options.DUAL_LCQP_REGULARIZATION.getDouble();
    protected final int computePeriod;
    private final boolean firstOrderBreak;
    private final double firstOrderTolerance;
    private final boolean primalDualBreak;
    private final double primalDualTolerance;

    public DualBCDReasoner() {
        this.maxIterations = Options.DUAL_LCQP_MAX_ITER.getInt();
        this.computePeriod = Options.DUAL_LCQP_COMPUTE_PERIOD.getInt();
        this.firstOrderBreak = Options.DUAL_LCQP_FIRST_ORDER_BREAK.getBoolean();
        this.firstOrderTolerance = Options.DUAL_LCQP_FIRST_ORDER_THRESHOLD.getDouble();
        this.primalDualBreak = Options.DUAL_LCQP_PRIMAL_DUAL_BREAK.getBoolean();
        this.primalDualTolerance = Options.DUAL_LCQP_PRIMAL_DUAL_THRESHOLD.getDouble();
    }

    @Override
    public double optimize(TermStore<DualLCQPObjectiveTerm> baseTermStore, List<EvaluationInstance> evaluations, TrainingMap trainingMap) {
        if (!(baseTermStore instanceof DualLCQPTermStore)) {
            throw new IllegalArgumentException("DualBCDReasoner requires an DualLCQPTermStore (found " + baseTermStore.getClass().getName() + ").");
        }
        DualLCQPTermStore termStore = (DualLCQPTermStore)baseTermStore;
        termStore.initForOptimization();
        this.initForOptimization(termStore);
        Reasoner.ObjectiveResult objective = null;
        Reasoner.ObjectiveResult oldObjective = null;
        long totalTime = 0L;
        boolean breakDualBCD = false;
        int iteration = 1;
        while (!breakDualBCD) {
            long start = System.currentTimeMillis();
            this.internalOptimize(termStore);
            long end = System.currentTimeMillis();
            totalTime += end - start;
            if ((iteration - 1) % this.computePeriod == 0) {
                this.primalVariableUpdate(termStore);
                oldObjective = objective;
                objective = this.parallelComputeObjective(termStore);
                Reasoner.ObjectiveResult dualObjectiveResult = new Reasoner.ObjectiveResult(0.0f, 0L);
                double dualGradientNorm = this.parallelComputeDualObjectiveAndGradientNorm(termStore, dualObjectiveResult);
                breakDualBCD = this.breakOptimization(iteration, termStore, objective, oldObjective, dualObjectiveResult, dualGradientNorm);
                log.trace("Iteration {} -- Primal Objective: {}, Violated Constraints: {}, Dual Objective: {}, Primal-dual gap: {}, Iteration Time: {}, Total Optimization Time: {}.", iteration, Float.valueOf(objective.objective), objective.violatedConstraints, Float.valueOf(dualObjectiveResult.objective), Float.valueOf(objective.objective - dualObjectiveResult.objective), end - start, totalTime);
                this.evaluate(termStore, iteration, evaluations, trainingMap);
            }
            ++iteration;
        }
        this.optimizationComplete(termStore, objective, totalTime, iteration - 1);
        return super.parallelComputeObjective(termStore).objective;
    }

    protected void internalOptimize(DualLCQPTermStore termStore) {
        for (DualLCQPObjectiveTerm term : termStore) {
            if (!term.isActive()) continue;
            DualBCDReasoner.dualBlockUpdate(term, termStore, this.regularizationParameter);
        }
    }

    protected void primalVariableUpdate(DualLCQPTermStore termStore) {
        AtomStore atomStore = termStore.getDatabase().getAtomStore();
        GroundAtom[] atoms = atomStore.getAtoms();
        float[] atomValues = atomStore.getAtomValues();
        for (int i = 0; i < atomStore.size(); ++i) {
            if (atoms[i].isFixed()) continue;
            atomValues[i] = termStore.getDualLCQPAtom(i).getPrimal(this.regularizationParameter);
        }
    }

    protected boolean breakOptimization(int iteration, TermStore<DualLCQPObjectiveTerm> termStore, Reasoner.ObjectiveResult objective, Reasoner.ObjectiveResult oldObjective, Reasoner.ObjectiveResult dualObjectiveResult, double dualGradientNorm) {
        if (super.breakOptimization(iteration, termStore, objective, oldObjective)) {
            return true;
        }
        if (this.runFullIterations) {
            return false;
        }
        if (objective != null && objective.violatedConstraints > 0L) {
            return false;
        }
        if (this.firstOrderBreak && MathUtils.isZero(dualGradientNorm, this.firstOrderTolerance)) {
            log.trace("Breaking optimization. Dual gradient magnitude: {} below tolerance: {}.", dualGradientNorm, this.firstOrderTolerance);
            return true;
        }
        if (this.primalDualBreak && objective != null && MathUtils.compare((double)objective.objective, (double)dualObjectiveResult.objective, this.primalDualTolerance) <= 0) {
            log.trace("Breaking optimization. Primal-dual gap: {} below tolerance: {}.", Float.valueOf(objective.objective - dualObjectiveResult.objective), this.primalDualTolerance);
            return true;
        }
        return false;
    }

    protected static void dualBlockUpdate(DualLCQPObjectiveTerm term, DualLCQPTermStore termStore, double regularizationParameter) {
        double termDualPartial = DualBCDReasoner.computeTermDualPartial(term, termStore, regularizationParameter);
        double slackLowerDualPartial = DualBCDReasoner.computeSlackLowerBoundDualPartial(term, regularizationParameter);
        double stepSize = DualBCDReasoner.computeStepSize(term, termStore, termDualPartial, slackLowerDualPartial, regularizationParameter);
        double updatedTermDualVariable = term.getDualVariable() - stepSize * termDualPartial;
        if (!term.isEqualityConstraint()) {
            updatedTermDualVariable = Math.max(0.0, term.getDualVariable() - stepSize * termDualPartial);
        }
        double termDualDelta = updatedTermDualVariable - term.getDualVariable();
        term.setDualVariable(updatedTermDualVariable);
        float[] coefficients = term.getCoefficients();
        int[] atomIndexes = term.getAtomIndexes();
        GroundAtom[] atoms = termStore.getDatabase().getAtomStore().getAtoms();
        DualLCQPAtom[] dualLCQPAtoms = termStore.getDualLCQPAtoms();
        for (int i = 0; i < term.size(); ++i) {
            if (atoms[atomIndexes[i]].isFixed()) continue;
            dualLCQPAtoms[atomIndexes[i]].update(termDualDelta, coefficients[i], regularizationParameter, stepSize);
        }
        if (term.termType.equals((Object)ReasonerTerm.TermType.HingeLossTerm)) {
            term.setSlackBoundDualVariable(Math.max(0.0, term.getSlackBoundDualVariable() - stepSize * slackLowerDualPartial));
        }
    }

    protected static double computeStepSize(DualLCQPObjectiveTerm term, DualLCQPTermStore termStore, double termDualPartial, double slackLowerDualPartial, double regularizationParameter) {
        double slackLowerDualGradientRatio;
        double subproblemMinimizer = DualBCDReasoner.computeStepSizeSubproblemMinimizer(term, termStore, termDualPartial, slackLowerDualPartial, regularizationParameter);
        double minDualGradientRatio = Double.POSITIVE_INFINITY;
        if (termDualPartial > 0.0 && !term.isEqualityConstraint()) {
            minDualGradientRatio = term.getDualVariable() / termDualPartial;
        }
        if (slackLowerDualPartial > 0.0 && (slackLowerDualGradientRatio = term.getSlackBoundDualVariable() / slackLowerDualPartial) < minDualGradientRatio) {
            minDualGradientRatio = slackLowerDualGradientRatio;
        }
        int[] atomIndexes = term.getAtomIndexes();
        GroundAtom[] atoms = termStore.getDatabase().getAtomStore().getAtoms();
        DualLCQPAtom[] dualLCQPAtoms = termStore.getDualLCQPAtoms();
        for (int i = 0; i < term.size(); ++i) {
            double atomUpperBoundDualGradientRatio;
            double upperBoundDualGradient;
            double atomLowerBoundDualGradientRatio;
            if (atoms[atomIndexes[i]].isFixed()) continue;
            DualLCQPAtom dualLCQPAtom = dualLCQPAtoms[atomIndexes[i]];
            double lowerBoundDualGradient = dualLCQPAtom.getLowerBoundPartial(regularizationParameter);
            if (lowerBoundDualGradient > 0.0 && (atomLowerBoundDualGradientRatio = dualLCQPAtom.getLowerBoundDualVariable() / lowerBoundDualGradient) < minDualGradientRatio) {
                minDualGradientRatio = atomLowerBoundDualGradientRatio;
            }
            if (!((upperBoundDualGradient = dualLCQPAtom.getUpperBoundPartial(regularizationParameter)) > 0.0) || !((atomUpperBoundDualGradientRatio = dualLCQPAtom.getUpperBoundDualVariable() / upperBoundDualGradient) < minDualGradientRatio)) continue;
            minDualGradientRatio = atomUpperBoundDualGradientRatio;
        }
        return Math.min(minDualGradientRatio, subproblemMinimizer);
    }

    protected static double computeStepSizeSubproblemMinimizer(DualLCQPObjectiveTerm term, DualLCQPTermStore termStore, double termDualPartial, double slackLowerDualPartial, double regularizationParameter) {
        double numerator = 0.0;
        double denominator = 0.0;
        double potentialAtomLowerBoundSum = 0.0;
        double potentialAtomUpperBoundSum = 0.0;
        float[] coefficients = term.getCoefficients();
        int[] atomIndexes = term.getAtomIndexes();
        GroundAtom[] atoms = termStore.getDatabase().getAtomStore().getAtoms();
        DualLCQPAtom[] dualLCQPAtoms = termStore.getDualLCQPAtoms();
        for (int i = 0; i < term.size(); ++i) {
            if (atoms[atomIndexes[i]].isFixed()) continue;
            DualLCQPAtom dualLCQPAtom = dualLCQPAtoms[atomIndexes[i]];
            double atomLowerBoundPartial = dualLCQPAtom.getLowerBoundPartial(regularizationParameter);
            double atomUpperBoundPartial = dualLCQPAtom.getUpperBoundPartial(regularizationParameter);
            potentialAtomLowerBoundSum += (double)coefficients[i] * atomLowerBoundPartial;
            potentialAtomUpperBoundSum += (double)coefficients[i] * atomUpperBoundPartial;
            numerator += Math.pow(atomLowerBoundPartial, 2.0);
            numerator += Math.pow(atomUpperBoundPartial, 2.0);
            denominator += (atomLowerBoundPartial - atomUpperBoundPartial - (double)coefficients[i] * termDualPartial) * atomLowerBoundPartial;
            denominator += (atomUpperBoundPartial - atomLowerBoundPartial + (double)coefficients[i] * termDualPartial) * atomUpperBoundPartial;
        }
        denominator /= regularizationParameter;
        double potentDualUpdateStat = (termDualPartial * term.computeSelfInnerProduct() - potentialAtomLowerBoundSum + potentialAtomUpperBoundSum) / regularizationParameter;
        if (term.termType.equals((Object)ReasonerTerm.TermType.SquaredHingeLossTerm)) {
            potentDualUpdateStat += termDualPartial / (regularizationParameter + (double)term.getWeight());
        } else if (term.termType.equals((Object)ReasonerTerm.TermType.HingeLossTerm)) {
            potentDualUpdateStat += termDualPartial / regularizationParameter;
        }
        if (term.termType.equals((Object)ReasonerTerm.TermType.HingeLossTerm)) {
            potentDualUpdateStat += slackLowerDualPartial / regularizationParameter;
            numerator += Math.pow(slackLowerDualPartial, 2.0);
            denominator += (slackLowerDualPartial + termDualPartial) / regularizationParameter * slackLowerDualPartial;
        }
        if ((numerator += Math.pow(termDualPartial, 2.0)) == 0.0 || (denominator += potentDualUpdateStat * termDualPartial) == 0.0) {
            return 0.0;
        }
        return numerator / denominator;
    }

    protected static double computeTermDualPartial(DualLCQPObjectiveTerm term, DualLCQPTermStore termStore, double regularizationParameter) {
        double termDualPartial = 0.0;
        double observedConstant = 0.0;
        GroundAtom[] atoms = termStore.getDatabase().getAtomStore().getAtoms();
        DualLCQPAtom[] dualLCQPAtoms = termStore.getDualLCQPAtoms();
        float[] coefficients = term.getCoefficients();
        int[] atomIndexes = term.getAtomIndexes();
        for (int i = 0; i < term.size(); ++i) {
            if (atoms[atomIndexes[i]].isFixed()) {
                observedConstant += (double)(coefficients[i] * atoms[atomIndexes[i]].getValue());
                continue;
            }
            termDualPartial += (double)coefficients[i] * dualLCQPAtoms[atomIndexes[i]].getMessage();
        }
        termDualPartial /= regularizationParameter;
        if (term.termType.equals((Object)ReasonerTerm.TermType.SquaredHingeLossTerm)) {
            termDualPartial += 1.0 / (regularizationParameter + (double)term.getWeight()) * term.getDualVariable();
        } else if (term.termType.equals((Object)ReasonerTerm.TermType.HingeLossTerm)) {
            termDualPartial += 1.0 / regularizationParameter * term.getDualVariable();
            termDualPartial += 1.0 / regularizationParameter * term.getSlackBoundDualVariable();
            termDualPartial += -1.0 / regularizationParameter * (double)term.getWeight();
        }
        termDualPartial += 2.0 * ((double)term.getConstant() - observedConstant);
        if (!term.isEqualityConstraint() && termDualPartial > 0.0 && MathUtils.isZero(term.getDualVariable(), 1.0E-8)) {
            termDualPartial = 0.0;
        }
        return termDualPartial;
    }

    protected static double computeSlackLowerBoundDualPartial(DualLCQPObjectiveTerm term, double regularizationParameter) {
        double slackLowerDualPartial = 0.0;
        if (term.termType.equals((Object)ReasonerTerm.TermType.HingeLossTerm) && (slackLowerDualPartial = (term.getSlackBoundDualVariable() + term.getDualVariable() - (double)term.getWeight()) / regularizationParameter) > 0.0 && MathUtils.isZero(term.getSlackBoundDualVariable(), 1.0E-8)) {
            slackLowerDualPartial = 0.0;
        }
        return slackLowerDualPartial;
    }

    protected static double evaluateDualTerm(DualLCQPObjectiveTerm term, DualLCQPTermStore termStore, double regularizationParameter) {
        double potentialDualObjective = 0.0;
        double observedConstant = 0.0;
        GroundAtom[] atoms = termStore.getDatabase().getAtomStore().getAtoms();
        DualLCQPAtom[] dualLCQPAtoms = termStore.getDualLCQPAtoms();
        float[] coefficients = term.getCoefficients();
        int[] atomIndexes = term.getAtomIndexes();
        for (int i = 0; i < term.size(); ++i) {
            if (atoms[atomIndexes[i]].isFixed()) {
                observedConstant += (double)(coefficients[i] * atoms[atomIndexes[i]].getValue());
                continue;
            }
            potentialDualObjective += (double)coefficients[i] * dualLCQPAtoms[atomIndexes[i]].getMessage();
        }
        potentialDualObjective = term.getDualVariable() * potentialDualObjective / (2.0 * regularizationParameter);
        if (term.termType.equals((Object)ReasonerTerm.TermType.SquaredHingeLossTerm)) {
            potentialDualObjective += 1.0 / (2.0 * (regularizationParameter + (double)term.getWeight())) * Math.pow(term.getDualVariable(), 2.0);
        } else if (term.termType.equals((Object)ReasonerTerm.TermType.HingeLossTerm)) {
            potentialDualObjective += 1.0 / (2.0 * regularizationParameter) * Math.pow(term.getDualVariable(), 2.0);
            potentialDualObjective += 1.0 / (2.0 * regularizationParameter) * term.getDualVariable() * term.getSlackBoundDualVariable();
            potentialDualObjective += -1.0 / regularizationParameter * (double)term.getWeight() * term.getDualVariable();
            potentialDualObjective += 1.0 / (2.0 * regularizationParameter) * Math.pow(term.getWeight(), 2.0);
        }
        return potentialDualObjective += 2.0 * ((double)term.getConstant() - observedConstant) * term.getDualVariable();
    }

    @Override
    public void computeOptimalValueGradient(TermStore<DualLCQPObjectiveTerm> termStore, float[] rvAtomGradient, float[] deepAtomGradient) {
        AtomStore atomStore = termStore.getDatabase().getAtomStore();
        GroundAtom[] atoms = atomStore.getAtoms();
        Arrays.fill(rvAtomGradient, 0.0f);
        Arrays.fill(deepAtomGradient, 0.0f);
        for (DualLCQPObjectiveTerm term : termStore) {
            if (!term.isActive()) continue;
            float[] coefficients = term.getCoefficients();
            int[] atomIndexes = term.getAtomIndexes();
            for (int i = 0; i < term.size(); ++i) {
                GroundAtom atom = atoms[atomIndexes[i]];
                if (atom instanceof ObservedAtom || !(atoms[atomIndexes[i]].getPredicate() instanceof DeepPredicate)) continue;
                int n = atomIndexes[i];
                deepAtomGradient[n] = deepAtomGradient[n] + (float)(term.getDualVariable() * (double)coefficients[i]);
            }
        }
    }

    protected static double evaluateDualSlackLowerBound(DualLCQPObjectiveTerm term, double regularizationParameter) {
        double slackLowerBoundDualObjective = 0.0;
        if (term.termType.equals((Object)ReasonerTerm.TermType.HingeLossTerm)) {
            slackLowerBoundDualObjective += term.getSlackBoundDualVariable() * term.getDualVariable() / (2.0 * regularizationParameter);
            slackLowerBoundDualObjective += Math.pow(term.getSlackBoundDualVariable(), 2.0) / (2.0 * regularizationParameter);
            slackLowerBoundDualObjective -= term.getSlackBoundDualVariable() * (double)term.getWeight() / regularizationParameter;
        }
        return slackLowerBoundDualObjective;
    }

    @Override
    protected Reasoner.ObjectiveResult parallelComputeObjective(TermStore<DualLCQPObjectiveTerm> termStore) {
        Reasoner.ObjectiveResult objectiveResult = super.parallelComputeObjective(termStore);
        objectiveResult.objective = (float)((double)objectiveResult.objective + this.computePrimalVariableRegularization(termStore));
        return objectiveResult;
    }

    private double computePrimalVariableRegularization(TermStore<DualLCQPObjectiveTerm> termStore) {
        AtomStore atomStore = termStore.getDatabase().getAtomStore();
        GroundAtom[] atoms = atomStore.getAtoms();
        float[] atomValues = atomStore.getAtomValues();
        double atomValueRegularization = 0.0;
        for (int i = 0; i < atomStore.size(); ++i) {
            if (atoms[i].isFixed()) continue;
            atomValueRegularization += this.regularizationParameter * Math.pow(atomValues[i], 2.0);
        }
        return atomValueRegularization;
    }

    protected double parallelComputeDualObjectiveAndGradientNorm(DualLCQPTermStore termStore, Reasoner.ObjectiveResult objectiveResult) {
        int blockSize = (int)(termStore.size() / (long)(Parallel.getNumThreads() * 4) + 1L);
        int numTermBlocks = (int)Math.ceil((float)termStore.size() / (float)blockSize);
        double[] workerGradientMagnitudes = new double[numTermBlocks];
        double[] workerObjectives = new double[numTermBlocks];
        Parallel.count(numTermBlocks, new DualTermObjectiveAndGradientMagnitudeWorker(termStore, workerGradientMagnitudes, workerObjectives, blockSize, this.regularizationParameter));
        double maxAbsGradient = 0.0;
        double objectiveValue = 0.0;
        for (int i = 0; i < numTermBlocks; ++i) {
            objectiveValue += workerObjectives[i];
            if (!(maxAbsGradient < workerGradientMagnitudes[i])) continue;
            maxAbsGradient = workerGradientMagnitudes[i];
        }
        GroundAtom[] atoms = termStore.getDatabase().getAtomStore().getAtoms();
        DualLCQPAtom[] dualLCQPAtoms = termStore.getDualLCQPAtoms();
        for (int i = 0; i < dualLCQPAtoms.length; ++i) {
            if (atoms[i] == null || atoms[i].isFixed()) continue;
            objectiveValue += dualLCQPAtoms[i].getLowerBoundObjective(this.regularizationParameter);
            double absLowerBoundPartial = Math.abs(dualLCQPAtoms[i].getLowerBoundPartial(this.regularizationParameter));
            if (maxAbsGradient < absLowerBoundPartial) {
                maxAbsGradient = absLowerBoundPartial;
            }
            objectiveValue += dualLCQPAtoms[i].getUpperBoundObjective(this.regularizationParameter);
            double absUpperBoundPartial = Math.abs(dualLCQPAtoms[i].getUpperBoundPartial(this.regularizationParameter));
            if (!(maxAbsGradient < absUpperBoundPartial)) continue;
            maxAbsGradient = absUpperBoundPartial;
        }
        objectiveResult.objective = (float)(-0.5 * objectiveValue);
        return maxAbsGradient;
    }

    private static class DualTermObjectiveAndGradientMagnitudeWorker
    extends Parallel.Worker<Long> {
        private final DualLCQPTermStore termStore;
        private final int blockSize;
        private final double regularizationParameter;
        private final double[] maxAbsGradients;
        private final double[] objectives;

        public DualTermObjectiveAndGradientMagnitudeWorker(DualLCQPTermStore termStore, double[] maxAbsGradients, double[] objectives, int blockSize, double regularizationParameter) {
            this.termStore = termStore;
            this.maxAbsGradients = maxAbsGradients;
            this.objectives = objectives;
            this.blockSize = blockSize;
            this.regularizationParameter = regularizationParameter;
        }

        public Object clone() {
            return new DualTermObjectiveAndGradientMagnitudeWorker(this.termStore, this.maxAbsGradients, this.objectives, this.blockSize, this.regularizationParameter);
        }

        @Override
        public void work(long blockIndex, Long ignore) {
            int termIndex;
            long numTerms = this.termStore.size();
            int blockIntIndex = (int)blockIndex;
            this.maxAbsGradients[blockIntIndex] = 0.0;
            this.objectives[blockIntIndex] = 0.0;
            for (int innerBlockIndex = 0; innerBlockIndex < this.blockSize && (long)(termIndex = blockIntIndex * this.blockSize + innerBlockIndex) < numTerms; ++innerBlockIndex) {
                double slackLowerBoundDualVariable;
                DualLCQPObjectiveTerm term = (DualLCQPObjectiveTerm)this.termStore.get(termIndex);
                if (!term.isActive()) continue;
                int n = blockIntIndex;
                this.objectives[n] = this.objectives[n] + DualBCDReasoner.evaluateDualTerm(term, this.termStore, this.regularizationParameter);
                int n2 = blockIntIndex;
                this.objectives[n2] = this.objectives[n2] + DualBCDReasoner.evaluateDualSlackLowerBound(term, this.regularizationParameter);
                double potentialDualAbsGradient = Math.abs(DualBCDReasoner.computeTermDualPartial(term, this.termStore, this.regularizationParameter));
                if (this.maxAbsGradients[blockIntIndex] < potentialDualAbsGradient) {
                    this.maxAbsGradients[blockIntIndex] = potentialDualAbsGradient;
                }
                if (!(this.maxAbsGradients[blockIntIndex] < (slackLowerBoundDualVariable = Math.abs(DualBCDReasoner.computeSlackLowerBoundDualPartial(term, this.regularizationParameter))))) continue;
                this.maxAbsGradients[blockIntIndex] = slackLowerBoundDualVariable;
            }
        }
    }
}

