/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import java.util.Collection;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.function.ConstraintTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.function.FunctionTerm;
import org.linqs.psl.reasoner.function.GeneralFunction;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.MathUtils;

public abstract class TermGenerator<T extends ReasonerTerm> {
    private static final Logger log = Logger.getLogger(TermGenerator.class);
    protected boolean mergeConstants;

    public TermGenerator(boolean mergeConstants) {
        this.mergeConstants = mergeConstants;
    }

    public void setMergeConstants(boolean mergeConstants) {
        this.mergeConstants = mergeConstants;
    }

    public boolean getMergeConstants() {
        return this.mergeConstants;
    }

    public int createTerm(GroundRule groundRule, Collection<T> newTerms, Collection<Hyperplane> newHyperplanes) {
        int count = 0;
        Hyperplane hyperplane = null;
        if (groundRule instanceof WeightedGroundRule) {
            GeneralFunction function = ((WeightedGroundRule)groundRule).getFunctionDefinition(this.mergeConstants);
            hyperplane = this.processHyperplane(function);
            if (hyperplane == null) {
                return 0;
            }
            count = this.createLossTerm(newTerms, function.isNonNegative(), function.isSquared(), groundRule, hyperplane);
        } else if (groundRule instanceof UnweightedGroundRule) {
            ConstraintTerm constraint = ((UnweightedGroundRule)groundRule).getConstraintDefinition(this.mergeConstants);
            GeneralFunction function = constraint.getFunction();
            hyperplane = this.processHyperplane(function);
            if (hyperplane == null) {
                return 0;
            }
            hyperplane.setConstant(constraint.getValue() + hyperplane.getConstant());
            count = this.createLinearConstraintTerm(newTerms, groundRule, hyperplane, constraint.getComparator());
        } else {
            throw new IllegalArgumentException("Unsupported ground rule: " + groundRule);
        }
        if (newHyperplanes != null) {
            for (int i = 0; i < count; ++i) {
                newHyperplanes.add(hyperplane);
            }
        }
        return count;
    }

    private Hyperplane processHyperplane(GeneralFunction sum) {
        Hyperplane hyperplane = new Hyperplane(sum.size(), -1.0f * sum.getConstant());
        for (int i = 0; i < sum.size(); ++i) {
            float coefficient = sum.getCoefficient(i);
            FunctionTerm term = sum.getTerm(i);
            if (term instanceof RandomVariableAtom || !this.mergeConstants && term instanceof ObservedAtom) {
                GroundAtom variable = (GroundAtom)term;
                int localIndex = hyperplane.indexOfVariable(variable);
                if (localIndex != -1) {
                    if (sum.isNonNegative() && !MathUtils.signsMatch(hyperplane.getCoefficient(localIndex), coefficient)) {
                        return null;
                    }
                    hyperplane.appendCoefficient(localIndex, coefficient);
                    continue;
                }
                hyperplane.addTerm(variable, coefficient);
                continue;
            }
            if (term.isConstant()) {
                hyperplane.setConstant(hyperplane.getConstant() - coefficient * term.getValue());
                continue;
            }
            throw new IllegalArgumentException("Unexpected summand: " + sum + "[" + i + "] (" + term + ").");
        }
        if (hyperplane.size() == 0) {
            return null;
        }
        return hyperplane;
    }

    public abstract int createLossTerm(Collection<T> var1, boolean var2, boolean var3, GroundRule var4, Hyperplane var5);

    public abstract int createLinearConstraintTerm(Collection<T> var1, GroundRule var2, Hyperplane var3, FunctionComparator var4);
}

