/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.reasoner.term.TermState;
import org.linqs.psl.util.IteratorUtils;
import org.linqs.psl.util.Parallel;

public abstract class TermStore<T extends ReasonerTerm>
implements Iterable<T> {
    protected Database database;
    protected TermGenerator<T> termGenerator;
    private final String threadResourceKey;

    public TermStore(Database database, TermGenerator<T> termGenerator) {
        this.database = database;
        this.termGenerator = termGenerator;
        this.threadResourceKey = "termstore::objectid::" + System.identityHashCode(this);
    }

    protected abstract int add(GroundRule var1, T var2, Hyperplane var3);

    public abstract void clear();

    public abstract void ensureCapacity(long var1);

    public abstract T get(long var1);

    @Override
    public abstract Iterator<T> iterator();

    public abstract long size();

    public Database getDatabase() {
        return this.database;
    }

    public TermGenerator<T> getTermGenerator() {
        return this.termGenerator;
    }

    public void setTermGenerator(TermGenerator<T> termGenerator) {
        this.termGenerator = termGenerator;
    }

    public int add(GroundRule groundRule) {
        if (!Parallel.hasThreadObject(this.threadResourceKey)) {
            Parallel.putThreadObject(this.threadResourceKey, new ThreadResources());
        }
        ThreadResources resources = (ThreadResources)Parallel.getThreadObject(this.threadResourceKey);
        resources.newTerms.clear();
        resources.newHyperplane.clear();
        this.termGenerator.createTerm(groundRule, resources.newTerms, resources.newHyperplane);
        int count = 0;
        for (int i = 0; i < resources.newTerms.size(); ++i) {
            count += this.add(groundRule, (ReasonerTerm)resources.newTerms.get(i), resources.newHyperplane.get(i));
        }
        resources.newTerms.clear();
        resources.newHyperplane.clear();
        return count;
    }

    public void reset() {
        this.database.getAtomStore().resetValues();
    }

    public double sync() {
        return this.database.getAtomStore().sync();
    }

    public void close() {
        this.clear();
        this.termGenerator = null;
        this.database = null;
    }

    public void initForOptimization() {
    }

    public void loadState(TermState[] termStates) {
        for (int i = 0; i < termStates.length; ++i) {
            ((ReasonerTerm)this.get(i)).loadState(termStates[i]);
        }
    }

    public TermState[] saveState() {
        TermState[] termStates = new TermState[(int)this.size()];
        int i = 0;
        while ((long)i < this.size()) {
            termStates[i] = ((ReasonerTerm)this.get(i)).saveState();
            ++i;
        }
        return termStates;
    }

    public void saveState(TermState[] termStates) {
        int i = 0;
        while ((long)i < this.size()) {
            ((ReasonerTerm)this.get(i)).saveState(termStates[i]);
            ++i;
        }
    }

    public Iterable<T> getTerms(Rule rule) {
        final Rule finalRule = rule;
        return IteratorUtils.filter(this, new IteratorUtils.FilterFunction<T>(){

            @Override
            public boolean keep(T term) {
                return finalRule.equals(((ReasonerTerm)term).getRule());
            }
        });
    }

    public GroundAtom[] getVariableAtoms() {
        return this.database.getAtomStore().getAtoms();
    }

    public float[] getVariableValues() {
        return this.database.getAtomStore().getAtomValues();
    }

    public int getNumVariables() {
        return this.database.getAtomStore().size();
    }

    public AtomCount getVariableCounts() {
        AtomCount count = new AtomCount();
        for (GroundAtom atom : this.database.getAtomStore()) {
            if (atom instanceof ObservedAtom) {
                ++count.observed;
                continue;
            }
            ++count.unobserved;
        }
        return count;
    }

    public long count(Rule rule) {
        int count = 0;
        for (ReasonerTerm term : this.getTerms(rule)) {
            ++count;
        }
        return count;
    }

    public class AtomCount {
        public int observed = 0;
        public int unobserved = 0;

        public String toString() {
            return String.format("%d unobserved and %d observed", this.unobserved, this.observed);
        }
    }

    private class ThreadResources {
        public List<T> newTerms = new ArrayList();
        public List<Hyperplane> newHyperplane = new ArrayList<Hyperplane>();
    }
}

