/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.runtime;

import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.List;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.model.term.Constant;

public class RuntimeResult {
    private List<Rule> rules = new ArrayList<Rule>();
    private List<GroundAtom> atoms = new ArrayList<GroundAtom>();
    private List<String> evaluations = new ArrayList<String>();

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void addAtom(GroundAtom atom) {
        this.atoms.add(atom);
    }

    public void addEvaluation(String evaluation) {
        this.evaluations.add(evaluation);
    }

    public String toString() {
        return this.toJSON();
    }

    public String toJSON() {
        JSONRuntimeResult result = new JSONRuntimeResult(this);
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter().withObjectIndenter(new DefaultIndenter("    ", "\n"));
        try {
            return mapper.writer(printer).writeValueAsString(result);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class JSONAtom {
        public String predicate;
        public String[] arguments;
        public float value;
        public boolean observed;

        public JSONAtom(GroundAtom atom) {
            this.predicate = atom.getPredicate().getName();
            this.value = atom.getValue();
            this.observed = atom instanceof ObservedAtom;
            this.arguments = new String[atom.getArity()];
            Constant[] terms = atom.getArguments();
            for (int i = 0; i < terms.length; ++i) {
                this.arguments[i] = terms[i].rawToString();
            }
        }
    }

    private static class JSONRule {
        public String text;
        public Float weight;
        public boolean squared;
        public int ruleIndex;

        public JSONRule(Rule rule, int ruleIndex) {
            this.text = rule.toString();
            this.ruleIndex = ruleIndex;
            this.weight = null;
            this.squared = false;
            if (rule instanceof WeightedRule) {
                this.weight = Float.valueOf(((WeightedRule)rule).getWeight());
                this.squared = ((WeightedRule)rule).isSquared();
            }
        }
    }

    private static class JSONRuntimeResult {
        public JSONRule[] rules;
        public JSONAtom[] atoms;
        public String[] evaluations;

        public JSONRuntimeResult(RuntimeResult result) {
            int i;
            this.rules = new JSONRule[result.rules.size()];
            for (i = 0; i < this.rules.length; ++i) {
                this.rules[i] = new JSONRule((Rule)result.rules.get(i), i);
            }
            this.atoms = new JSONAtom[result.atoms.size()];
            for (i = 0; i < this.atoms.length; ++i) {
                this.atoms[i] = new JSONAtom((GroundAtom)result.atoms.get(i));
            }
            this.evaluations = new String[result.evaluations.size()];
            for (i = 0; i < this.evaluations.length; ++i) {
                this.evaluations[i] = (String)result.evaluations.get(i);
            }
        }
    }
}

