from io import StringIO
from typing import Any, Self

from rich.console import Console
from rich.text import Text
from rich.theme import Theme
from rich.traceback import Traceback
from singleton_base import SingletonBase

from bear_utils.logger_manager._constants import ExecValues
from bear_utils.logger_manager._log_level import LogLevel
from bear_utils.logger_manager._stack_tracker import StackLevelTracker

from .sub_logger import SubConsoleLogger

class BaseLogger(SingletonBase):
    output_handler: Any
    stack_tracker: StackLevelTracker
    theme: Theme
    _level: LogLevel
    style_disabled: bool
    console: Console
    console_buffer: StringIO
    logger_mode: bool
    sub_logger: dict[str, SubConsoleLogger]
    # fmt: off
    def __init__(self, output_handler: Any  = None, theme: Theme | None = ..., style_disabled: bool = ..., logger_mode: bool = ..., **kwargs) -> None: ...
    @staticmethod
    def get_console(theme: Theme, style_disabled: bool) -> Console: ...
    def __enter__(self) -> Self: ...
    def __exit__(self, exc_type: object, exc_value: object, traceback: object) -> None: ...
    def _generate_style_methods(self, **kwargs) -> None: ...
    def get_sub_logger(self, namespace: str, **kwargs: Any) -> SubConsoleLogger: ...
    def replacement_method(self, msg: object, *args: Any, **kwargs: Any) -> None: ...
    def print(self, msg: object, end: str="\n", exc_info:str|None=None, extra: dict | None = None, *args, **kwargs) -> None | str: ...
    def print_json(self, data: Any | None = ..., indent: int = ..., sort: bool = ...) -> None: ...
    def set_base_level(self, level: int) -> None: ...
    def filter_by_level(self, level: int) -> bool: ...
    def trigger_buffer_flush(self) -> str | Text: ...
    def _print(self, msg: object, end: str, json: bool = ..., *args: Any, **kwargs: Any) -> None: ...
    def _get_exception(self, manual: bool = ..., exec_values: ExecValues | None = ...) -> Traceback: ...
    def _extract_exception_values(self, exc_info: str | None) -> ExecValues | None: ...
    def _reset_buffer(self) -> None: ...
    def exit(self) -> None: ...
    def debug(self, msg: object, *args: Any, **kwargs: Any) -> None: ...
    def info(self, msg: object, *args: Any, **kwargs: Any) -> None: ...
    def exception(self, msg: object, *args: Any, **kwargs: Any) -> None: ...
    def warning(self, msg: object, *args: Any, **kwargs: Any) -> None: ...
    def error(self, msg: object, *args: Any, **kwargs: Any) -> None: ...
    def critical(self, msg: object, *args: Any, **kwargs: Any) -> None: ...
    def success(self, msg: object, *args: Any, **kwargs: Any) -> None: ...
    def failure(self, msg: object, *args: Any, **kwargs: Any) -> None: ...
    def verbose(self, msg: object, *args: Any, **kwargs: Any) -> None: ...
