from typing import Any, Generic, TypeVar

from bear_utils.logger_manager._log_level import LogLevel

from .base_logger import BaseLogger

_T = TypeVar("_T", bound=BaseLogger)

class SubConsoleLogger(Generic[_T]):  # noqa: UP046
    logger: _T
    _level: int | str | LogLevel
    namespace: str
    extra: dict[str, Any] | None
    log_level: int
    # fmt: off
    def __init__(self, logger: _T, namespace: str, **kwargs) -> None: ...
    def set_sub_level(self, level: int) -> None: ...
    def success(self, msg: object, *args, **kwargs) -> None: ...
    def failure(self, msg: object, *args, **kwargs) -> None: ...
    def verbose(self, msg: object, *args, **kwargs) -> None: ...
    def info(self, msg: object, *args, **kwargs) -> None: ...
    def debug(self, msg: object, *args, **kwargs) -> None: ...
    def warning(self, msg: object, *args, **kwargs) -> None: ...
    def error(self, msg: object, *args, **kwargs) -> None: ...
    def print(self, msg: object, end: str = "\n", exc_info: Any = None, extra: dict | None = None, *args, **kwargs: Any) -> None | str: ...
