# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: d41e262
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class RespGetKSThreadTokenIdentity(BaseModel):
    """
    Schema for KS Thread token validation response.
    """ # noqa: E501
    thread_id: UUID = Field(description="ID of the thread")
    agent_id: UUID = Field(description="ID of the agent")
    tenant_id: UUID = Field(description="ID of the tenant")
    participant_id: UUID = Field(description="ID of the participant")
    exp: StrictInt = Field(description="Expiration timestamp of the token")
    __properties: ClassVar[List[str]] = ["thread_id", "agent_id", "tenant_id", "participant_id", "exp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespGetKSThreadTokenIdentity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespGetKSThreadTokenIdentity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "thread_id": obj.get("thread_id"),
            "agent_id": obj.get("agent_id"),
            "tenant_id": obj.get("tenant_id"),
            "participant_id": obj.get("participant_id"),
            "exp": obj.get("exp")
        })
        return _obj


