# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]


## [0.2.10] - 2021-07-27
### Added
- #14 Virtual datasheet for IGBT and MOSFET types which collects all the plot and data of transistor switch and diode and presents a HTMl file. Use 'transistor.export_datasheet()'
### Bugfixes
- fix #32: incorrect template paths in PLECS exporter

## [0.2.9] - 2021-07-14
### Bugfixes
- fix #30: Bad package dependency in setup.py

## [0.2.8] - 2021-07-14
### Added 
- #25 Allows only positive channel data to be stored or created for both switch and diode types, added mirror_xy_data attribute in csv2array function to do so. 
- #28 Integrated calculating curve characteristics at different r_g values into simuliunk exporter and added exception handlers
- #29 Code cleanup and added recheck functionality for plecs exporter to find new gate voltage 
- #29 Added plecs exporter for MOSFET and IGBT modules (outputs separate switch type and diode type xmls)

### Changed
- #22 Moved exporter functions to transistor classes and removed exportFunctions.py

## [0.2.7] - 2021-06-28
### Added
- Module manufacturers, fix compatibility problem in 0.2.6


## [0.2.6] - 2021-06-27
### Bugfixes
- #3, #8 : fixes to avoid typo errors in manufacturer and housing types along with comment line additions
### Added
- method 'parallel_transistors()' to parallel transistors object of same type 
### Changed
- rewrite export_to_matlab() function
### Removed
- remove dependency from matlab-pip-package

## [0.2.5] - 2021-06-10
## Added
- export_simulink_loss_model using new functions to search transistor elements (incl. fix #17)

### Removed
- export_simulink_v1 (outdated)


## [0.2.4] - 2021-05-28
### Added
- #13: GeckoCircuits Exporter exports mirrowed conducting characterisitc for negative currents
### Bugfixes
- #11, #12: Path displays when export to gecko (.scl) or to .json

## [0.2.3] - 2021-05-21
### Added
- Simple calculation method for mosfet gate resistor (Paper PCIM 2006: D.Kübrich 'Invetsigation of Turn-Off Behaviour under the Assumption of Linear Capacitances')
### Bugfix
- bug #7: was not fully fixed. Fixed now.
- bug #9: in case of no err-data, fill working point with object instead of list

## [0.2.2] - 2021-05-11
### Added
- print_TDB() returns a list with transistor names
- add some CREE power module housing types

### Bugfix
- fix #6: Avoid KeyError when using devices without err-losscurves
- fix #7: wrong fill of wp.xxx_r_channel/xxx_v_channel when using transistor.update_wp() or transistor.quickstart_wp()

## [0.2.1] - 2021-05-06
### Bugfix
- Problem when reading .csv-files generated by english-language systems

## [0.2.0] - 2021-05-04
### Added
- Example template to generate a transistor object
- transistor method: linearize_switch_ui_graph
- transistor.switch methods: print_all_channel_data, print_channel_data_vge, print_channel_data_temp
- New class LinearizedModel: Contains data for a linearized Switch/Diode depending on given operating point.
- New class to store c_iss, c_oss, c_rss in Transistor.
- New Transistor attribute: e_coss
- Documentation drawing
- Exporter: GeckoCIRCUITS
- calc_object_i_e to calculate loss loss curves for other gate resistors/voltage levels
- New class 'wp' to store local calculation parameters to use in your program
- automatically fill 'wp' objects when using functions like find_approx_wp()
- added a quick start to fill in 'wp' values quick and easy
- New housing types
- .json exporter

### Removed
- Removed Metadata class. Added its attributes to Transistor class instead
### Changed
- Restructured foster thermal model argument handover
- Rename package to transistordatabase (instead of transistor_database) due to pip package rules
- csv2array callable with options
- move some functionality out of transistor class (tdb.Transistor. -> tdb.)

## [0.1.0] - 2021-02-04
### Added
- Construct a Transistor-object and save relevant data in its attributes and subclasses
- Class structure documented in a class UML diagram
- Save Transistor-object in an object database created with mongodb
- Mandatory attributes and restricted types/values to guarantee only valid and functional Transistors can be added to
  the database
- Matlab-Exporter

[Unreleased]: https://github.com/upb-lea/transistordatabase/compare/0.2.10...HEAD
[0.2.10]: https://github.com/upb-lea/transistordatabase/compare/0.2.9...0.2.10
[0.2.9]: https://github.com/upb-lea/transistordatabase/compare/0.2.8...0.2.9
[0.2.8]: https://github.com/upb-lea/transistordatabase/compare/0.2.7...0.2.8
[0.2.7]: https://github.com/upb-lea/transistordatabase/compare/0.2.6...0.2.7
[0.2.6]: https://github.com/upb-lea/transistordatabase/compare/0.2.5...0.2.6
[0.2.5]: https://github.com/upb-lea/transistordatabase/compare/0.2.4...0.2.5
[0.2.4]: https://github.com/upb-lea/transistordatabase/compare/0.2.3...0.2.4
[0.2.3]: https://github.com/upb-lea/transistordatabase/compare/0.2.2...0.2.3
[0.2.2]: https://github.com/upb-lea/transistordatabase/compare/0.2.1...0.2.2
[0.2.1]: https://github.com/upb-lea/transistordatabase/compare/0.2.0...0.2.1
[0.2.0]: https://github.com/upb-lea/transistordatabase/compare/0.1.0...0.2.0
[0.1.0]: https://github.com/upb-lea/transistordatabase/compare/0.1.0...0.1.0
