# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualCircuitArgs', 'VirtualCircuit']

@pulumi.input_type
class VirtualCircuitArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 bandwidth_shape_name: Optional[pulumi.Input[str]] = None,
                 bgp_admin_state: Optional[pulumi.Input[str]] = None,
                 cross_connect_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitCrossConnectMappingArgs']]]] = None,
                 customer_asn: Optional[pulumi.Input[str]] = None,
                 customer_bgp_asn: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 gateway_id: Optional[pulumi.Input[str]] = None,
                 ip_mtu: Optional[pulumi.Input[str]] = None,
                 is_bfd_enabled: Optional[pulumi.Input[bool]] = None,
                 is_transport_mode: Optional[pulumi.Input[bool]] = None,
                 provider_service_id: Optional[pulumi.Input[str]] = None,
                 provider_service_key_name: Optional[pulumi.Input[str]] = None,
                 public_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitPublicPrefixArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a VirtualCircuit resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the virtual circuit.
        :param pulumi.Input[str] type: The type of IP addresses used in this virtual circuit. PRIVATE means [RFC 1918](https://tools.ietf.org/html/rfc1918) addresses (10.0.0.0/8, 172.16/12, and 192.168/16). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] bandwidth_shape_name: (Updatable) The provisioned data rate of the connection. To get a list of the available bandwidth levels (that is, shapes), see [ListFastConnectProviderServiceVirtualCircuitBandwidthShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderVirtualCircuitBandwidthShapes).  Example: `10 Gbps`
        :param pulumi.Input[str] bgp_admin_state: (Updatable) Set to `ENABLED` (the default) to activate the BGP session of the virtual circuit, set to `DISABLED` to deactivate the virtual circuit.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualCircuitCrossConnectMappingArgs']]] cross_connect_mappings: (Updatable) Create a `CrossConnectMapping` for each cross-connect or cross-connect group this virtual circuit will run on.
        :param pulumi.Input[str] customer_asn: (Updatable) Your BGP ASN (either public or private). Provide this value only if there's a BGP session that goes from your edge router to Oracle. Otherwise, leave this empty or null. Can be a 2-byte or 4-byte ASN. Uses "asplain" format.  Example: `12345` (2-byte) or `1587232876` (4-byte)
        :param pulumi.Input[int] customer_bgp_asn: (Updatable) Deprecated. Instead use `customerAsn`. If you specify values for both, the request will be rejected.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gateway_id: (Updatable) For private virtual circuits only. The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [dynamic routing gateway (DRG)](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Drg) that this virtual circuit uses.
        :param pulumi.Input[str] ip_mtu: (Updatable) The layer 3 IP MTU to use with this virtual circuit.
        :param pulumi.Input[bool] is_bfd_enabled: (Updatable) Set to `true` to enable BFD for IPv4 BGP peering, or set to `false` to disable BFD. If this is not set, the default is `false`.
        :param pulumi.Input[bool] is_transport_mode: (Updatable) Set to `true` for the virtual circuit to carry only encrypted traffic, or set to `false` for the virtual circuit to carry unencrypted traffic. If this is not set, the default is `false`.
        :param pulumi.Input[str] provider_service_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the service offered by the provider (if you're connecting via a provider). To get a list of the available service offerings, see [ListFastConnectProviderServices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderServices).
        :param pulumi.Input[str] provider_service_key_name: (Updatable) The service key name offered by the provider (if the customer is connecting via a provider).
        :param pulumi.Input[Sequence[pulumi.Input['VirtualCircuitPublicPrefixArgs']]] public_prefixes: (Updatable) For a public virtual circuit. The public IP prefixes (CIDRs) the customer wants to advertise across the connection.
        :param pulumi.Input[str] region: The Oracle Cloud Infrastructure region where this virtual circuit is located. Example: `phx`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] routing_policies: (Updatable) The routing policy sets how routing information about the Oracle cloud is shared over a public virtual circuit. Policies available are: `ORACLE_SERVICE_NETWORK`, `REGIONAL`, `MARKET_LEVEL`, and `GLOBAL`. See [Route Filtering](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/routingonprem.htm#route_filtering) for details. By default, routing information is shared for all routes in the same market.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if bandwidth_shape_name is not None:
            pulumi.set(__self__, "bandwidth_shape_name", bandwidth_shape_name)
        if bgp_admin_state is not None:
            pulumi.set(__self__, "bgp_admin_state", bgp_admin_state)
        if cross_connect_mappings is not None:
            pulumi.set(__self__, "cross_connect_mappings", cross_connect_mappings)
        if customer_asn is not None:
            pulumi.set(__self__, "customer_asn", customer_asn)
        if customer_bgp_asn is not None:
            warnings.warn("""The 'customer_bgp_asn' field has been deprecated. Please use 'customer_asn' instead.""", DeprecationWarning)
            pulumi.log.warn("""customer_bgp_asn is deprecated: The 'customer_bgp_asn' field has been deprecated. Please use 'customer_asn' instead.""")
        if customer_bgp_asn is not None:
            pulumi.set(__self__, "customer_bgp_asn", customer_bgp_asn)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if ip_mtu is not None:
            pulumi.set(__self__, "ip_mtu", ip_mtu)
        if is_bfd_enabled is not None:
            pulumi.set(__self__, "is_bfd_enabled", is_bfd_enabled)
        if is_transport_mode is not None:
            pulumi.set(__self__, "is_transport_mode", is_transport_mode)
        if provider_service_id is not None:
            pulumi.set(__self__, "provider_service_id", provider_service_id)
        if provider_service_key_name is not None:
            pulumi.set(__self__, "provider_service_key_name", provider_service_key_name)
        if public_prefixes is not None:
            pulumi.set(__self__, "public_prefixes", public_prefixes)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routing_policies is not None:
            pulumi.set(__self__, "routing_policies", routing_policies)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the virtual circuit.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of IP addresses used in this virtual circuit. PRIVATE means [RFC 1918](https://tools.ietf.org/html/rfc1918) addresses (10.0.0.0/8, 172.16/12, and 192.168/16). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="bandwidthShapeName")
    def bandwidth_shape_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The provisioned data rate of the connection. To get a list of the available bandwidth levels (that is, shapes), see [ListFastConnectProviderServiceVirtualCircuitBandwidthShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderVirtualCircuitBandwidthShapes).  Example: `10 Gbps`
        """
        return pulumi.get(self, "bandwidth_shape_name")

    @bandwidth_shape_name.setter
    def bandwidth_shape_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_shape_name", value)

    @property
    @pulumi.getter(name="bgpAdminState")
    def bgp_admin_state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Set to `ENABLED` (the default) to activate the BGP session of the virtual circuit, set to `DISABLED` to deactivate the virtual circuit.
        """
        return pulumi.get(self, "bgp_admin_state")

    @bgp_admin_state.setter
    def bgp_admin_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_admin_state", value)

    @property
    @pulumi.getter(name="crossConnectMappings")
    def cross_connect_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitCrossConnectMappingArgs']]]]:
        """
        (Updatable) Create a `CrossConnectMapping` for each cross-connect or cross-connect group this virtual circuit will run on.
        """
        return pulumi.get(self, "cross_connect_mappings")

    @cross_connect_mappings.setter
    def cross_connect_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitCrossConnectMappingArgs']]]]):
        pulumi.set(self, "cross_connect_mappings", value)

    @property
    @pulumi.getter(name="customerAsn")
    def customer_asn(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Your BGP ASN (either public or private). Provide this value only if there's a BGP session that goes from your edge router to Oracle. Otherwise, leave this empty or null. Can be a 2-byte or 4-byte ASN. Uses "asplain" format.  Example: `12345` (2-byte) or `1587232876` (4-byte)
        """
        return pulumi.get(self, "customer_asn")

    @customer_asn.setter
    def customer_asn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_asn", value)

    @property
    @pulumi.getter(name="customerBgpAsn")
    @_utilities.deprecated("""The 'customer_bgp_asn' field has been deprecated. Please use 'customer_asn' instead.""")
    def customer_bgp_asn(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Deprecated. Instead use `customerAsn`. If you specify values for both, the request will be rejected.
        """
        return pulumi.get(self, "customer_bgp_asn")

    @customer_bgp_asn.setter
    def customer_bgp_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "customer_bgp_asn", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) For private virtual circuits only. The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [dynamic routing gateway (DRG)](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Drg) that this virtual circuit uses.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_id", value)

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The layer 3 IP MTU to use with this virtual circuit.
        """
        return pulumi.get(self, "ip_mtu")

    @ip_mtu.setter
    def ip_mtu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_mtu", value)

    @property
    @pulumi.getter(name="isBfdEnabled")
    def is_bfd_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to `true` to enable BFD for IPv4 BGP peering, or set to `false` to disable BFD. If this is not set, the default is `false`.
        """
        return pulumi.get(self, "is_bfd_enabled")

    @is_bfd_enabled.setter
    def is_bfd_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_bfd_enabled", value)

    @property
    @pulumi.getter(name="isTransportMode")
    def is_transport_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to `true` for the virtual circuit to carry only encrypted traffic, or set to `false` for the virtual circuit to carry unencrypted traffic. If this is not set, the default is `false`.
        """
        return pulumi.get(self, "is_transport_mode")

    @is_transport_mode.setter
    def is_transport_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_transport_mode", value)

    @property
    @pulumi.getter(name="providerServiceId")
    def provider_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the service offered by the provider (if you're connecting via a provider). To get a list of the available service offerings, see [ListFastConnectProviderServices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderServices).
        """
        return pulumi.get(self, "provider_service_id")

    @provider_service_id.setter
    def provider_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_service_id", value)

    @property
    @pulumi.getter(name="providerServiceKeyName")
    def provider_service_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The service key name offered by the provider (if the customer is connecting via a provider).
        """
        return pulumi.get(self, "provider_service_key_name")

    @provider_service_key_name.setter
    def provider_service_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_service_key_name", value)

    @property
    @pulumi.getter(name="publicPrefixes")
    def public_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitPublicPrefixArgs']]]]:
        """
        (Updatable) For a public virtual circuit. The public IP prefixes (CIDRs) the customer wants to advertise across the connection.
        """
        return pulumi.get(self, "public_prefixes")

    @public_prefixes.setter
    def public_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitPublicPrefixArgs']]]]):
        pulumi.set(self, "public_prefixes", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Cloud Infrastructure region where this virtual circuit is located. Example: `phx`
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routingPolicies")
    def routing_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The routing policy sets how routing information about the Oracle cloud is shared over a public virtual circuit. Policies available are: `ORACLE_SERVICE_NETWORK`, `REGIONAL`, `MARKET_LEVEL`, and `GLOBAL`. See [Route Filtering](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/routingonprem.htm#route_filtering) for details. By default, routing information is shared for all routes in the same market.
        """
        return pulumi.get(self, "routing_policies")

    @routing_policies.setter
    def routing_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "routing_policies", value)


@pulumi.input_type
class _VirtualCircuitState:
    def __init__(__self__, *,
                 bandwidth_shape_name: Optional[pulumi.Input[str]] = None,
                 bgp_admin_state: Optional[pulumi.Input[str]] = None,
                 bgp_ipv6session_state: Optional[pulumi.Input[str]] = None,
                 bgp_management: Optional[pulumi.Input[str]] = None,
                 bgp_session_state: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cross_connect_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitCrossConnectMappingArgs']]]] = None,
                 customer_asn: Optional[pulumi.Input[str]] = None,
                 customer_bgp_asn: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 gateway_id: Optional[pulumi.Input[str]] = None,
                 ip_mtu: Optional[pulumi.Input[str]] = None,
                 is_bfd_enabled: Optional[pulumi.Input[bool]] = None,
                 is_transport_mode: Optional[pulumi.Input[bool]] = None,
                 oracle_bgp_asn: Optional[pulumi.Input[int]] = None,
                 provider_service_id: Optional[pulumi.Input[str]] = None,
                 provider_service_key_name: Optional[pulumi.Input[str]] = None,
                 provider_state: Optional[pulumi.Input[str]] = None,
                 public_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitPublicPrefixArgs']]]] = None,
                 reference_comment: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 virtual_circuit_redundancy_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitVirtualCircuitRedundancyMetadataArgs']]]] = None):
        """
        Input properties used for looking up and filtering VirtualCircuit resources.
        :param pulumi.Input[str] bandwidth_shape_name: (Updatable) The provisioned data rate of the connection. To get a list of the available bandwidth levels (that is, shapes), see [ListFastConnectProviderServiceVirtualCircuitBandwidthShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderVirtualCircuitBandwidthShapes).  Example: `10 Gbps`
        :param pulumi.Input[str] bgp_admin_state: (Updatable) Set to `ENABLED` (the default) to activate the BGP session of the virtual circuit, set to `DISABLED` to deactivate the virtual circuit.
        :param pulumi.Input[str] bgp_ipv6session_state: The state of the Ipv6 BGP session associated with the virtual circuit.
        :param pulumi.Input[str] bgp_management: Deprecated. Instead use the information in [FastConnectProviderService](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/).
        :param pulumi.Input[str] bgp_session_state: The state of the Ipv4 BGP session associated with the virtual circuit.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the virtual circuit.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualCircuitCrossConnectMappingArgs']]] cross_connect_mappings: (Updatable) Create a `CrossConnectMapping` for each cross-connect or cross-connect group this virtual circuit will run on.
        :param pulumi.Input[str] customer_asn: (Updatable) Your BGP ASN (either public or private). Provide this value only if there's a BGP session that goes from your edge router to Oracle. Otherwise, leave this empty or null. Can be a 2-byte or 4-byte ASN. Uses "asplain" format.  Example: `12345` (2-byte) or `1587232876` (4-byte)
        :param pulumi.Input[int] customer_bgp_asn: (Updatable) Deprecated. Instead use `customerAsn`. If you specify values for both, the request will be rejected.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gateway_id: (Updatable) For private virtual circuits only. The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [dynamic routing gateway (DRG)](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Drg) that this virtual circuit uses.
        :param pulumi.Input[str] ip_mtu: (Updatable) The layer 3 IP MTU to use with this virtual circuit.
        :param pulumi.Input[bool] is_bfd_enabled: (Updatable) Set to `true` to enable BFD for IPv4 BGP peering, or set to `false` to disable BFD. If this is not set, the default is `false`.
        :param pulumi.Input[bool] is_transport_mode: (Updatable) Set to `true` for the virtual circuit to carry only encrypted traffic, or set to `false` for the virtual circuit to carry unencrypted traffic. If this is not set, the default is `false`.
        :param pulumi.Input[int] oracle_bgp_asn: The Oracle BGP ASN.
        :param pulumi.Input[str] provider_service_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the service offered by the provider (if you're connecting via a provider). To get a list of the available service offerings, see [ListFastConnectProviderServices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderServices).
        :param pulumi.Input[str] provider_service_key_name: (Updatable) The service key name offered by the provider (if the customer is connecting via a provider).
        :param pulumi.Input[str] provider_state: The provider's state in relation to this virtual circuit (if the customer is connecting via a provider). ACTIVE means the provider has provisioned the virtual circuit from their end. INACTIVE means the provider has not yet provisioned the virtual circuit, or has de-provisioned it.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualCircuitPublicPrefixArgs']]] public_prefixes: (Updatable) For a public virtual circuit. The public IP prefixes (CIDRs) the customer wants to advertise across the connection.
        :param pulumi.Input[str] reference_comment: Provider-supplied reference information about this virtual circuit (if the customer is connecting via a provider).
        :param pulumi.Input[str] region: The Oracle Cloud Infrastructure region where this virtual circuit is located. Example: `phx`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] routing_policies: (Updatable) The routing policy sets how routing information about the Oracle cloud is shared over a public virtual circuit. Policies available are: `ORACLE_SERVICE_NETWORK`, `REGIONAL`, `MARKET_LEVEL`, and `GLOBAL`. See [Route Filtering](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/routingonprem.htm#route_filtering) for details. By default, routing information is shared for all routes in the same market.
        :param pulumi.Input[str] service_type: Provider service type.
        :param pulumi.Input[str] state: The virtual circuit's current state. For information about the different states, see [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).
        :param pulumi.Input[str] time_created: The date and time the virtual circuit was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] type: The type of IP addresses used in this virtual circuit. PRIVATE means [RFC 1918](https://tools.ietf.org/html/rfc1918) addresses (10.0.0.0/8, 172.16/12, and 192.168/16). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['VirtualCircuitVirtualCircuitRedundancyMetadataArgs']]] virtual_circuit_redundancy_metadatas: This resource provides redundancy level details for the virtual circuit. For more about redundancy, see [FastConnect Redundancy Best Practices](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnectresiliency.htm).
        """
        if bandwidth_shape_name is not None:
            pulumi.set(__self__, "bandwidth_shape_name", bandwidth_shape_name)
        if bgp_admin_state is not None:
            pulumi.set(__self__, "bgp_admin_state", bgp_admin_state)
        if bgp_ipv6session_state is not None:
            pulumi.set(__self__, "bgp_ipv6session_state", bgp_ipv6session_state)
        if bgp_management is not None:
            warnings.warn("""The 'bgp_management' field has been deprecated. Please use the 'oci_core_fast_connect_provider_service' data source instead.""", DeprecationWarning)
            pulumi.log.warn("""bgp_management is deprecated: The 'bgp_management' field has been deprecated. Please use the 'oci_core_fast_connect_provider_service' data source instead.""")
        if bgp_management is not None:
            pulumi.set(__self__, "bgp_management", bgp_management)
        if bgp_session_state is not None:
            pulumi.set(__self__, "bgp_session_state", bgp_session_state)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if cross_connect_mappings is not None:
            pulumi.set(__self__, "cross_connect_mappings", cross_connect_mappings)
        if customer_asn is not None:
            pulumi.set(__self__, "customer_asn", customer_asn)
        if customer_bgp_asn is not None:
            warnings.warn("""The 'customer_bgp_asn' field has been deprecated. Please use 'customer_asn' instead.""", DeprecationWarning)
            pulumi.log.warn("""customer_bgp_asn is deprecated: The 'customer_bgp_asn' field has been deprecated. Please use 'customer_asn' instead.""")
        if customer_bgp_asn is not None:
            pulumi.set(__self__, "customer_bgp_asn", customer_bgp_asn)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if ip_mtu is not None:
            pulumi.set(__self__, "ip_mtu", ip_mtu)
        if is_bfd_enabled is not None:
            pulumi.set(__self__, "is_bfd_enabled", is_bfd_enabled)
        if is_transport_mode is not None:
            pulumi.set(__self__, "is_transport_mode", is_transport_mode)
        if oracle_bgp_asn is not None:
            pulumi.set(__self__, "oracle_bgp_asn", oracle_bgp_asn)
        if provider_service_id is not None:
            pulumi.set(__self__, "provider_service_id", provider_service_id)
        if provider_service_key_name is not None:
            pulumi.set(__self__, "provider_service_key_name", provider_service_key_name)
        if provider_state is not None:
            pulumi.set(__self__, "provider_state", provider_state)
        if public_prefixes is not None:
            pulumi.set(__self__, "public_prefixes", public_prefixes)
        if reference_comment is not None:
            pulumi.set(__self__, "reference_comment", reference_comment)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routing_policies is not None:
            pulumi.set(__self__, "routing_policies", routing_policies)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if virtual_circuit_redundancy_metadatas is not None:
            pulumi.set(__self__, "virtual_circuit_redundancy_metadatas", virtual_circuit_redundancy_metadatas)

    @property
    @pulumi.getter(name="bandwidthShapeName")
    def bandwidth_shape_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The provisioned data rate of the connection. To get a list of the available bandwidth levels (that is, shapes), see [ListFastConnectProviderServiceVirtualCircuitBandwidthShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderVirtualCircuitBandwidthShapes).  Example: `10 Gbps`
        """
        return pulumi.get(self, "bandwidth_shape_name")

    @bandwidth_shape_name.setter
    def bandwidth_shape_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_shape_name", value)

    @property
    @pulumi.getter(name="bgpAdminState")
    def bgp_admin_state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Set to `ENABLED` (the default) to activate the BGP session of the virtual circuit, set to `DISABLED` to deactivate the virtual circuit.
        """
        return pulumi.get(self, "bgp_admin_state")

    @bgp_admin_state.setter
    def bgp_admin_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_admin_state", value)

    @property
    @pulumi.getter(name="bgpIpv6sessionState")
    def bgp_ipv6session_state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the Ipv6 BGP session associated with the virtual circuit.
        """
        return pulumi.get(self, "bgp_ipv6session_state")

    @bgp_ipv6session_state.setter
    def bgp_ipv6session_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_ipv6session_state", value)

    @property
    @pulumi.getter(name="bgpManagement")
    @_utilities.deprecated("""The 'bgp_management' field has been deprecated. Please use the 'oci_core_fast_connect_provider_service' data source instead.""")
    def bgp_management(self) -> Optional[pulumi.Input[str]]:
        """
        Deprecated. Instead use the information in [FastConnectProviderService](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/).
        """
        return pulumi.get(self, "bgp_management")

    @bgp_management.setter
    def bgp_management(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_management", value)

    @property
    @pulumi.getter(name="bgpSessionState")
    def bgp_session_state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the Ipv4 BGP session associated with the virtual circuit.
        """
        return pulumi.get(self, "bgp_session_state")

    @bgp_session_state.setter
    def bgp_session_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_session_state", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the virtual circuit.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="crossConnectMappings")
    def cross_connect_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitCrossConnectMappingArgs']]]]:
        """
        (Updatable) Create a `CrossConnectMapping` for each cross-connect or cross-connect group this virtual circuit will run on.
        """
        return pulumi.get(self, "cross_connect_mappings")

    @cross_connect_mappings.setter
    def cross_connect_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitCrossConnectMappingArgs']]]]):
        pulumi.set(self, "cross_connect_mappings", value)

    @property
    @pulumi.getter(name="customerAsn")
    def customer_asn(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Your BGP ASN (either public or private). Provide this value only if there's a BGP session that goes from your edge router to Oracle. Otherwise, leave this empty or null. Can be a 2-byte or 4-byte ASN. Uses "asplain" format.  Example: `12345` (2-byte) or `1587232876` (4-byte)
        """
        return pulumi.get(self, "customer_asn")

    @customer_asn.setter
    def customer_asn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_asn", value)

    @property
    @pulumi.getter(name="customerBgpAsn")
    @_utilities.deprecated("""The 'customer_bgp_asn' field has been deprecated. Please use 'customer_asn' instead.""")
    def customer_bgp_asn(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Deprecated. Instead use `customerAsn`. If you specify values for both, the request will be rejected.
        """
        return pulumi.get(self, "customer_bgp_asn")

    @customer_bgp_asn.setter
    def customer_bgp_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "customer_bgp_asn", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) For private virtual circuits only. The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [dynamic routing gateway (DRG)](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Drg) that this virtual circuit uses.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_id", value)

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The layer 3 IP MTU to use with this virtual circuit.
        """
        return pulumi.get(self, "ip_mtu")

    @ip_mtu.setter
    def ip_mtu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_mtu", value)

    @property
    @pulumi.getter(name="isBfdEnabled")
    def is_bfd_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to `true` to enable BFD for IPv4 BGP peering, or set to `false` to disable BFD. If this is not set, the default is `false`.
        """
        return pulumi.get(self, "is_bfd_enabled")

    @is_bfd_enabled.setter
    def is_bfd_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_bfd_enabled", value)

    @property
    @pulumi.getter(name="isTransportMode")
    def is_transport_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to `true` for the virtual circuit to carry only encrypted traffic, or set to `false` for the virtual circuit to carry unencrypted traffic. If this is not set, the default is `false`.
        """
        return pulumi.get(self, "is_transport_mode")

    @is_transport_mode.setter
    def is_transport_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_transport_mode", value)

    @property
    @pulumi.getter(name="oracleBgpAsn")
    def oracle_bgp_asn(self) -> Optional[pulumi.Input[int]]:
        """
        The Oracle BGP ASN.
        """
        return pulumi.get(self, "oracle_bgp_asn")

    @oracle_bgp_asn.setter
    def oracle_bgp_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "oracle_bgp_asn", value)

    @property
    @pulumi.getter(name="providerServiceId")
    def provider_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the service offered by the provider (if you're connecting via a provider). To get a list of the available service offerings, see [ListFastConnectProviderServices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderServices).
        """
        return pulumi.get(self, "provider_service_id")

    @provider_service_id.setter
    def provider_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_service_id", value)

    @property
    @pulumi.getter(name="providerServiceKeyName")
    def provider_service_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The service key name offered by the provider (if the customer is connecting via a provider).
        """
        return pulumi.get(self, "provider_service_key_name")

    @provider_service_key_name.setter
    def provider_service_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_service_key_name", value)

    @property
    @pulumi.getter(name="providerState")
    def provider_state(self) -> Optional[pulumi.Input[str]]:
        """
        The provider's state in relation to this virtual circuit (if the customer is connecting via a provider). ACTIVE means the provider has provisioned the virtual circuit from their end. INACTIVE means the provider has not yet provisioned the virtual circuit, or has de-provisioned it.
        """
        return pulumi.get(self, "provider_state")

    @provider_state.setter
    def provider_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_state", value)

    @property
    @pulumi.getter(name="publicPrefixes")
    def public_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitPublicPrefixArgs']]]]:
        """
        (Updatable) For a public virtual circuit. The public IP prefixes (CIDRs) the customer wants to advertise across the connection.
        """
        return pulumi.get(self, "public_prefixes")

    @public_prefixes.setter
    def public_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitPublicPrefixArgs']]]]):
        pulumi.set(self, "public_prefixes", value)

    @property
    @pulumi.getter(name="referenceComment")
    def reference_comment(self) -> Optional[pulumi.Input[str]]:
        """
        Provider-supplied reference information about this virtual circuit (if the customer is connecting via a provider).
        """
        return pulumi.get(self, "reference_comment")

    @reference_comment.setter
    def reference_comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_comment", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Cloud Infrastructure region where this virtual circuit is located. Example: `phx`
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routingPolicies")
    def routing_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The routing policy sets how routing information about the Oracle cloud is shared over a public virtual circuit. Policies available are: `ORACLE_SERVICE_NETWORK`, `REGIONAL`, `MARKET_LEVEL`, and `GLOBAL`. See [Route Filtering](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/routingonprem.htm#route_filtering) for details. By default, routing information is shared for all routes in the same market.
        """
        return pulumi.get(self, "routing_policies")

    @routing_policies.setter
    def routing_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "routing_policies", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[str]]:
        """
        Provider service type.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual circuit's current state. For information about the different states, see [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the virtual circuit was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP addresses used in this virtual circuit. PRIVATE means [RFC 1918](https://tools.ietf.org/html/rfc1918) addresses (10.0.0.0/8, 172.16/12, and 192.168/16). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="virtualCircuitRedundancyMetadatas")
    def virtual_circuit_redundancy_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitVirtualCircuitRedundancyMetadataArgs']]]]:
        """
        This resource provides redundancy level details for the virtual circuit. For more about redundancy, see [FastConnect Redundancy Best Practices](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnectresiliency.htm).
        """
        return pulumi.get(self, "virtual_circuit_redundancy_metadatas")

    @virtual_circuit_redundancy_metadatas.setter
    def virtual_circuit_redundancy_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualCircuitVirtualCircuitRedundancyMetadataArgs']]]]):
        pulumi.set(self, "virtual_circuit_redundancy_metadatas", value)


class VirtualCircuit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_shape_name: Optional[pulumi.Input[str]] = None,
                 bgp_admin_state: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cross_connect_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitCrossConnectMappingArgs', 'VirtualCircuitCrossConnectMappingArgsDict']]]]] = None,
                 customer_asn: Optional[pulumi.Input[str]] = None,
                 customer_bgp_asn: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 gateway_id: Optional[pulumi.Input[str]] = None,
                 ip_mtu: Optional[pulumi.Input[str]] = None,
                 is_bfd_enabled: Optional[pulumi.Input[bool]] = None,
                 is_transport_mode: Optional[pulumi.Input[bool]] = None,
                 provider_service_id: Optional[pulumi.Input[str]] = None,
                 provider_service_key_name: Optional[pulumi.Input[str]] = None,
                 public_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitPublicPrefixArgs', 'VirtualCircuitPublicPrefixArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Virtual Circuit resource in Oracle Cloud Infrastructure Core service.

        Creates a new virtual circuit to use with Oracle Cloud
        Infrastructure FastConnect. For more information, see
        [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).

        For the purposes of access control, you must provide the OCID of the
        compartment where you want the virtual circuit to reside. If you're
        not sure which compartment to use, put the virtual circuit in the
        same compartment with the DRG it's using. For more information about
        compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
        For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the virtual circuit.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        **Important:** When creating a virtual circuit, you specify a DRG for
        the traffic to flow through. Make sure you attach the DRG to your
        VCN and confirm the VCN's routing sends traffic to the DRG. Otherwise
        traffic will not flow. For more information, see
        [Route Tables](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingroutetables.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_virtual_circuit = oci.core.VirtualCircuit("test_virtual_circuit",
            compartment_id=compartment_id,
            type=virtual_circuit_type,
            bandwidth_shape_name=virtual_circuit_bandwidth_shape_name,
            bgp_admin_state=virtual_circuit_bgp_admin_state,
            cross_connect_mappings=[{
                "bgp_md5auth_key": virtual_circuit_cross_connect_mappings_bgp_md5auth_key,
                "cross_connect_or_cross_connect_group_id": test_cross_connect_or_cross_connect_group["id"],
                "customer_bgp_peering_ip": virtual_circuit_cross_connect_mappings_customer_bgp_peering_ip,
                "customer_bgp_peering_ipv6": virtual_circuit_cross_connect_mappings_customer_bgp_peering_ipv6,
                "oracle_bgp_peering_ip": virtual_circuit_cross_connect_mappings_oracle_bgp_peering_ip,
                "oracle_bgp_peering_ipv6": virtual_circuit_cross_connect_mappings_oracle_bgp_peering_ipv6,
                "vlan": virtual_circuit_cross_connect_mappings_vlan,
            }],
            customer_asn=virtual_circuit_customer_asn,
            customer_bgp_asn=virtual_circuit_customer_bgp_asn,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=virtual_circuit_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            ip_mtu=virtual_circuit_ip_mtu,
            is_bfd_enabled=virtual_circuit_is_bfd_enabled,
            is_transport_mode=virtual_circuit_is_transport_mode,
            gateway_id=test_gateway["id"],
            provider_service_id=test_fast_connect_provider_services["fastConnectProviderServices"][0]["id"],
            provider_service_key_name=virtual_circuit_provider_service_key_name,
            public_prefixes=[{
                "cidr_block": virtual_circuit_public_prefixes_cidr_block,
            }],
            region=virtual_circuit_region,
            routing_policies=virtual_circuit_routing_policy)
        ```

        ## Import

        VirtualCircuits can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/virtualCircuit:VirtualCircuit test_virtual_circuit "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bandwidth_shape_name: (Updatable) The provisioned data rate of the connection. To get a list of the available bandwidth levels (that is, shapes), see [ListFastConnectProviderServiceVirtualCircuitBandwidthShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderVirtualCircuitBandwidthShapes).  Example: `10 Gbps`
        :param pulumi.Input[str] bgp_admin_state: (Updatable) Set to `ENABLED` (the default) to activate the BGP session of the virtual circuit, set to `DISABLED` to deactivate the virtual circuit.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the virtual circuit.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitCrossConnectMappingArgs', 'VirtualCircuitCrossConnectMappingArgsDict']]]] cross_connect_mappings: (Updatable) Create a `CrossConnectMapping` for each cross-connect or cross-connect group this virtual circuit will run on.
        :param pulumi.Input[str] customer_asn: (Updatable) Your BGP ASN (either public or private). Provide this value only if there's a BGP session that goes from your edge router to Oracle. Otherwise, leave this empty or null. Can be a 2-byte or 4-byte ASN. Uses "asplain" format.  Example: `12345` (2-byte) or `1587232876` (4-byte)
        :param pulumi.Input[int] customer_bgp_asn: (Updatable) Deprecated. Instead use `customerAsn`. If you specify values for both, the request will be rejected.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gateway_id: (Updatable) For private virtual circuits only. The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [dynamic routing gateway (DRG)](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Drg) that this virtual circuit uses.
        :param pulumi.Input[str] ip_mtu: (Updatable) The layer 3 IP MTU to use with this virtual circuit.
        :param pulumi.Input[bool] is_bfd_enabled: (Updatable) Set to `true` to enable BFD for IPv4 BGP peering, or set to `false` to disable BFD. If this is not set, the default is `false`.
        :param pulumi.Input[bool] is_transport_mode: (Updatable) Set to `true` for the virtual circuit to carry only encrypted traffic, or set to `false` for the virtual circuit to carry unencrypted traffic. If this is not set, the default is `false`.
        :param pulumi.Input[str] provider_service_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the service offered by the provider (if you're connecting via a provider). To get a list of the available service offerings, see [ListFastConnectProviderServices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderServices).
        :param pulumi.Input[str] provider_service_key_name: (Updatable) The service key name offered by the provider (if the customer is connecting via a provider).
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitPublicPrefixArgs', 'VirtualCircuitPublicPrefixArgsDict']]]] public_prefixes: (Updatable) For a public virtual circuit. The public IP prefixes (CIDRs) the customer wants to advertise across the connection.
        :param pulumi.Input[str] region: The Oracle Cloud Infrastructure region where this virtual circuit is located. Example: `phx`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] routing_policies: (Updatable) The routing policy sets how routing information about the Oracle cloud is shared over a public virtual circuit. Policies available are: `ORACLE_SERVICE_NETWORK`, `REGIONAL`, `MARKET_LEVEL`, and `GLOBAL`. See [Route Filtering](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/routingonprem.htm#route_filtering) for details. By default, routing information is shared for all routes in the same market.
        :param pulumi.Input[str] type: The type of IP addresses used in this virtual circuit. PRIVATE means [RFC 1918](https://tools.ietf.org/html/rfc1918) addresses (10.0.0.0/8, 172.16/12, and 192.168/16). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualCircuitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Virtual Circuit resource in Oracle Cloud Infrastructure Core service.

        Creates a new virtual circuit to use with Oracle Cloud
        Infrastructure FastConnect. For more information, see
        [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).

        For the purposes of access control, you must provide the OCID of the
        compartment where you want the virtual circuit to reside. If you're
        not sure which compartment to use, put the virtual circuit in the
        same compartment with the DRG it's using. For more information about
        compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
        For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the virtual circuit.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        **Important:** When creating a virtual circuit, you specify a DRG for
        the traffic to flow through. Make sure you attach the DRG to your
        VCN and confirm the VCN's routing sends traffic to the DRG. Otherwise
        traffic will not flow. For more information, see
        [Route Tables](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingroutetables.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_virtual_circuit = oci.core.VirtualCircuit("test_virtual_circuit",
            compartment_id=compartment_id,
            type=virtual_circuit_type,
            bandwidth_shape_name=virtual_circuit_bandwidth_shape_name,
            bgp_admin_state=virtual_circuit_bgp_admin_state,
            cross_connect_mappings=[{
                "bgp_md5auth_key": virtual_circuit_cross_connect_mappings_bgp_md5auth_key,
                "cross_connect_or_cross_connect_group_id": test_cross_connect_or_cross_connect_group["id"],
                "customer_bgp_peering_ip": virtual_circuit_cross_connect_mappings_customer_bgp_peering_ip,
                "customer_bgp_peering_ipv6": virtual_circuit_cross_connect_mappings_customer_bgp_peering_ipv6,
                "oracle_bgp_peering_ip": virtual_circuit_cross_connect_mappings_oracle_bgp_peering_ip,
                "oracle_bgp_peering_ipv6": virtual_circuit_cross_connect_mappings_oracle_bgp_peering_ipv6,
                "vlan": virtual_circuit_cross_connect_mappings_vlan,
            }],
            customer_asn=virtual_circuit_customer_asn,
            customer_bgp_asn=virtual_circuit_customer_bgp_asn,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=virtual_circuit_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            ip_mtu=virtual_circuit_ip_mtu,
            is_bfd_enabled=virtual_circuit_is_bfd_enabled,
            is_transport_mode=virtual_circuit_is_transport_mode,
            gateway_id=test_gateway["id"],
            provider_service_id=test_fast_connect_provider_services["fastConnectProviderServices"][0]["id"],
            provider_service_key_name=virtual_circuit_provider_service_key_name,
            public_prefixes=[{
                "cidr_block": virtual_circuit_public_prefixes_cidr_block,
            }],
            region=virtual_circuit_region,
            routing_policies=virtual_circuit_routing_policy)
        ```

        ## Import

        VirtualCircuits can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/virtualCircuit:VirtualCircuit test_virtual_circuit "id"
        ```

        :param str resource_name: The name of the resource.
        :param VirtualCircuitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualCircuitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_shape_name: Optional[pulumi.Input[str]] = None,
                 bgp_admin_state: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cross_connect_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitCrossConnectMappingArgs', 'VirtualCircuitCrossConnectMappingArgsDict']]]]] = None,
                 customer_asn: Optional[pulumi.Input[str]] = None,
                 customer_bgp_asn: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 gateway_id: Optional[pulumi.Input[str]] = None,
                 ip_mtu: Optional[pulumi.Input[str]] = None,
                 is_bfd_enabled: Optional[pulumi.Input[bool]] = None,
                 is_transport_mode: Optional[pulumi.Input[bool]] = None,
                 provider_service_id: Optional[pulumi.Input[str]] = None,
                 provider_service_key_name: Optional[pulumi.Input[str]] = None,
                 public_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitPublicPrefixArgs', 'VirtualCircuitPublicPrefixArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualCircuitArgs.__new__(VirtualCircuitArgs)

            __props__.__dict__["bandwidth_shape_name"] = bandwidth_shape_name
            __props__.__dict__["bgp_admin_state"] = bgp_admin_state
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["cross_connect_mappings"] = cross_connect_mappings
            __props__.__dict__["customer_asn"] = customer_asn
            __props__.__dict__["customer_bgp_asn"] = customer_bgp_asn
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["gateway_id"] = gateway_id
            __props__.__dict__["ip_mtu"] = ip_mtu
            __props__.__dict__["is_bfd_enabled"] = is_bfd_enabled
            __props__.__dict__["is_transport_mode"] = is_transport_mode
            __props__.__dict__["provider_service_id"] = provider_service_id
            __props__.__dict__["provider_service_key_name"] = provider_service_key_name
            __props__.__dict__["public_prefixes"] = public_prefixes
            __props__.__dict__["region"] = region
            __props__.__dict__["routing_policies"] = routing_policies
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["bgp_ipv6session_state"] = None
            __props__.__dict__["bgp_management"] = None
            __props__.__dict__["bgp_session_state"] = None
            __props__.__dict__["oracle_bgp_asn"] = None
            __props__.__dict__["provider_state"] = None
            __props__.__dict__["reference_comment"] = None
            __props__.__dict__["service_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["virtual_circuit_redundancy_metadatas"] = None
        super(VirtualCircuit, __self__).__init__(
            'oci:Core/virtualCircuit:VirtualCircuit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth_shape_name: Optional[pulumi.Input[str]] = None,
            bgp_admin_state: Optional[pulumi.Input[str]] = None,
            bgp_ipv6session_state: Optional[pulumi.Input[str]] = None,
            bgp_management: Optional[pulumi.Input[str]] = None,
            bgp_session_state: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            cross_connect_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitCrossConnectMappingArgs', 'VirtualCircuitCrossConnectMappingArgsDict']]]]] = None,
            customer_asn: Optional[pulumi.Input[str]] = None,
            customer_bgp_asn: Optional[pulumi.Input[int]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            gateway_id: Optional[pulumi.Input[str]] = None,
            ip_mtu: Optional[pulumi.Input[str]] = None,
            is_bfd_enabled: Optional[pulumi.Input[bool]] = None,
            is_transport_mode: Optional[pulumi.Input[bool]] = None,
            oracle_bgp_asn: Optional[pulumi.Input[int]] = None,
            provider_service_id: Optional[pulumi.Input[str]] = None,
            provider_service_key_name: Optional[pulumi.Input[str]] = None,
            provider_state: Optional[pulumi.Input[str]] = None,
            public_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitPublicPrefixArgs', 'VirtualCircuitPublicPrefixArgsDict']]]]] = None,
            reference_comment: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            service_type: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            virtual_circuit_redundancy_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitVirtualCircuitRedundancyMetadataArgs', 'VirtualCircuitVirtualCircuitRedundancyMetadataArgsDict']]]]] = None) -> 'VirtualCircuit':
        """
        Get an existing VirtualCircuit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bandwidth_shape_name: (Updatable) The provisioned data rate of the connection. To get a list of the available bandwidth levels (that is, shapes), see [ListFastConnectProviderServiceVirtualCircuitBandwidthShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderVirtualCircuitBandwidthShapes).  Example: `10 Gbps`
        :param pulumi.Input[str] bgp_admin_state: (Updatable) Set to `ENABLED` (the default) to activate the BGP session of the virtual circuit, set to `DISABLED` to deactivate the virtual circuit.
        :param pulumi.Input[str] bgp_ipv6session_state: The state of the Ipv6 BGP session associated with the virtual circuit.
        :param pulumi.Input[str] bgp_management: Deprecated. Instead use the information in [FastConnectProviderService](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/).
        :param pulumi.Input[str] bgp_session_state: The state of the Ipv4 BGP session associated with the virtual circuit.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the virtual circuit.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitCrossConnectMappingArgs', 'VirtualCircuitCrossConnectMappingArgsDict']]]] cross_connect_mappings: (Updatable) Create a `CrossConnectMapping` for each cross-connect or cross-connect group this virtual circuit will run on.
        :param pulumi.Input[str] customer_asn: (Updatable) Your BGP ASN (either public or private). Provide this value only if there's a BGP session that goes from your edge router to Oracle. Otherwise, leave this empty or null. Can be a 2-byte or 4-byte ASN. Uses "asplain" format.  Example: `12345` (2-byte) or `1587232876` (4-byte)
        :param pulumi.Input[int] customer_bgp_asn: (Updatable) Deprecated. Instead use `customerAsn`. If you specify values for both, the request will be rejected.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gateway_id: (Updatable) For private virtual circuits only. The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [dynamic routing gateway (DRG)](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Drg) that this virtual circuit uses.
        :param pulumi.Input[str] ip_mtu: (Updatable) The layer 3 IP MTU to use with this virtual circuit.
        :param pulumi.Input[bool] is_bfd_enabled: (Updatable) Set to `true` to enable BFD for IPv4 BGP peering, or set to `false` to disable BFD. If this is not set, the default is `false`.
        :param pulumi.Input[bool] is_transport_mode: (Updatable) Set to `true` for the virtual circuit to carry only encrypted traffic, or set to `false` for the virtual circuit to carry unencrypted traffic. If this is not set, the default is `false`.
        :param pulumi.Input[int] oracle_bgp_asn: The Oracle BGP ASN.
        :param pulumi.Input[str] provider_service_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the service offered by the provider (if you're connecting via a provider). To get a list of the available service offerings, see [ListFastConnectProviderServices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderServices).
        :param pulumi.Input[str] provider_service_key_name: (Updatable) The service key name offered by the provider (if the customer is connecting via a provider).
        :param pulumi.Input[str] provider_state: The provider's state in relation to this virtual circuit (if the customer is connecting via a provider). ACTIVE means the provider has provisioned the virtual circuit from their end. INACTIVE means the provider has not yet provisioned the virtual circuit, or has de-provisioned it.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitPublicPrefixArgs', 'VirtualCircuitPublicPrefixArgsDict']]]] public_prefixes: (Updatable) For a public virtual circuit. The public IP prefixes (CIDRs) the customer wants to advertise across the connection.
        :param pulumi.Input[str] reference_comment: Provider-supplied reference information about this virtual circuit (if the customer is connecting via a provider).
        :param pulumi.Input[str] region: The Oracle Cloud Infrastructure region where this virtual circuit is located. Example: `phx`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] routing_policies: (Updatable) The routing policy sets how routing information about the Oracle cloud is shared over a public virtual circuit. Policies available are: `ORACLE_SERVICE_NETWORK`, `REGIONAL`, `MARKET_LEVEL`, and `GLOBAL`. See [Route Filtering](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/routingonprem.htm#route_filtering) for details. By default, routing information is shared for all routes in the same market.
        :param pulumi.Input[str] service_type: Provider service type.
        :param pulumi.Input[str] state: The virtual circuit's current state. For information about the different states, see [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).
        :param pulumi.Input[str] time_created: The date and time the virtual circuit was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] type: The type of IP addresses used in this virtual circuit. PRIVATE means [RFC 1918](https://tools.ietf.org/html/rfc1918) addresses (10.0.0.0/8, 172.16/12, and 192.168/16). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualCircuitVirtualCircuitRedundancyMetadataArgs', 'VirtualCircuitVirtualCircuitRedundancyMetadataArgsDict']]]] virtual_circuit_redundancy_metadatas: This resource provides redundancy level details for the virtual circuit. For more about redundancy, see [FastConnect Redundancy Best Practices](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnectresiliency.htm).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualCircuitState.__new__(_VirtualCircuitState)

        __props__.__dict__["bandwidth_shape_name"] = bandwidth_shape_name
        __props__.__dict__["bgp_admin_state"] = bgp_admin_state
        __props__.__dict__["bgp_ipv6session_state"] = bgp_ipv6session_state
        __props__.__dict__["bgp_management"] = bgp_management
        __props__.__dict__["bgp_session_state"] = bgp_session_state
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["cross_connect_mappings"] = cross_connect_mappings
        __props__.__dict__["customer_asn"] = customer_asn
        __props__.__dict__["customer_bgp_asn"] = customer_bgp_asn
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gateway_id"] = gateway_id
        __props__.__dict__["ip_mtu"] = ip_mtu
        __props__.__dict__["is_bfd_enabled"] = is_bfd_enabled
        __props__.__dict__["is_transport_mode"] = is_transport_mode
        __props__.__dict__["oracle_bgp_asn"] = oracle_bgp_asn
        __props__.__dict__["provider_service_id"] = provider_service_id
        __props__.__dict__["provider_service_key_name"] = provider_service_key_name
        __props__.__dict__["provider_state"] = provider_state
        __props__.__dict__["public_prefixes"] = public_prefixes
        __props__.__dict__["reference_comment"] = reference_comment
        __props__.__dict__["region"] = region
        __props__.__dict__["routing_policies"] = routing_policies
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["type"] = type
        __props__.__dict__["virtual_circuit_redundancy_metadatas"] = virtual_circuit_redundancy_metadatas
        return VirtualCircuit(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bandwidthShapeName")
    def bandwidth_shape_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The provisioned data rate of the connection. To get a list of the available bandwidth levels (that is, shapes), see [ListFastConnectProviderServiceVirtualCircuitBandwidthShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderVirtualCircuitBandwidthShapes).  Example: `10 Gbps`
        """
        return pulumi.get(self, "bandwidth_shape_name")

    @property
    @pulumi.getter(name="bgpAdminState")
    def bgp_admin_state(self) -> pulumi.Output[str]:
        """
        (Updatable) Set to `ENABLED` (the default) to activate the BGP session of the virtual circuit, set to `DISABLED` to deactivate the virtual circuit.
        """
        return pulumi.get(self, "bgp_admin_state")

    @property
    @pulumi.getter(name="bgpIpv6sessionState")
    def bgp_ipv6session_state(self) -> pulumi.Output[str]:
        """
        The state of the Ipv6 BGP session associated with the virtual circuit.
        """
        return pulumi.get(self, "bgp_ipv6session_state")

    @property
    @pulumi.getter(name="bgpManagement")
    @_utilities.deprecated("""The 'bgp_management' field has been deprecated. Please use the 'oci_core_fast_connect_provider_service' data source instead.""")
    def bgp_management(self) -> pulumi.Output[str]:
        """
        Deprecated. Instead use the information in [FastConnectProviderService](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/).
        """
        return pulumi.get(self, "bgp_management")

    @property
    @pulumi.getter(name="bgpSessionState")
    def bgp_session_state(self) -> pulumi.Output[str]:
        """
        The state of the Ipv4 BGP session associated with the virtual circuit.
        """
        return pulumi.get(self, "bgp_session_state")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the virtual circuit.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="crossConnectMappings")
    def cross_connect_mappings(self) -> pulumi.Output[Sequence['outputs.VirtualCircuitCrossConnectMapping']]:
        """
        (Updatable) Create a `CrossConnectMapping` for each cross-connect or cross-connect group this virtual circuit will run on.
        """
        return pulumi.get(self, "cross_connect_mappings")

    @property
    @pulumi.getter(name="customerAsn")
    def customer_asn(self) -> pulumi.Output[str]:
        """
        (Updatable) Your BGP ASN (either public or private). Provide this value only if there's a BGP session that goes from your edge router to Oracle. Otherwise, leave this empty or null. Can be a 2-byte or 4-byte ASN. Uses "asplain" format.  Example: `12345` (2-byte) or `1587232876` (4-byte)
        """
        return pulumi.get(self, "customer_asn")

    @property
    @pulumi.getter(name="customerBgpAsn")
    @_utilities.deprecated("""The 'customer_bgp_asn' field has been deprecated. Please use 'customer_asn' instead.""")
    def customer_bgp_asn(self) -> pulumi.Output[int]:
        """
        (Updatable) Deprecated. Instead use `customerAsn`. If you specify values for both, the request will be rejected.
        """
        return pulumi.get(self, "customer_bgp_asn")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Output[str]:
        """
        (Updatable) For private virtual circuits only. The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [dynamic routing gateway (DRG)](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Drg) that this virtual circuit uses.
        """
        return pulumi.get(self, "gateway_id")

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> pulumi.Output[str]:
        """
        (Updatable) The layer 3 IP MTU to use with this virtual circuit.
        """
        return pulumi.get(self, "ip_mtu")

    @property
    @pulumi.getter(name="isBfdEnabled")
    def is_bfd_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to `true` to enable BFD for IPv4 BGP peering, or set to `false` to disable BFD. If this is not set, the default is `false`.
        """
        return pulumi.get(self, "is_bfd_enabled")

    @property
    @pulumi.getter(name="isTransportMode")
    def is_transport_mode(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to `true` for the virtual circuit to carry only encrypted traffic, or set to `false` for the virtual circuit to carry unencrypted traffic. If this is not set, the default is `false`.
        """
        return pulumi.get(self, "is_transport_mode")

    @property
    @pulumi.getter(name="oracleBgpAsn")
    def oracle_bgp_asn(self) -> pulumi.Output[int]:
        """
        The Oracle BGP ASN.
        """
        return pulumi.get(self, "oracle_bgp_asn")

    @property
    @pulumi.getter(name="providerServiceId")
    def provider_service_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the service offered by the provider (if you're connecting via a provider). To get a list of the available service offerings, see [ListFastConnectProviderServices](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/FastConnectProviderService/ListFastConnectProviderServices).
        """
        return pulumi.get(self, "provider_service_id")

    @property
    @pulumi.getter(name="providerServiceKeyName")
    def provider_service_key_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The service key name offered by the provider (if the customer is connecting via a provider).
        """
        return pulumi.get(self, "provider_service_key_name")

    @property
    @pulumi.getter(name="providerState")
    def provider_state(self) -> pulumi.Output[str]:
        """
        The provider's state in relation to this virtual circuit (if the customer is connecting via a provider). ACTIVE means the provider has provisioned the virtual circuit from their end. INACTIVE means the provider has not yet provisioned the virtual circuit, or has de-provisioned it.
        """
        return pulumi.get(self, "provider_state")

    @property
    @pulumi.getter(name="publicPrefixes")
    def public_prefixes(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualCircuitPublicPrefix']]]:
        """
        (Updatable) For a public virtual circuit. The public IP prefixes (CIDRs) the customer wants to advertise across the connection.
        """
        return pulumi.get(self, "public_prefixes")

    @property
    @pulumi.getter(name="referenceComment")
    def reference_comment(self) -> pulumi.Output[str]:
        """
        Provider-supplied reference information about this virtual circuit (if the customer is connecting via a provider).
        """
        return pulumi.get(self, "reference_comment")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The Oracle Cloud Infrastructure region where this virtual circuit is located. Example: `phx`
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routingPolicies")
    def routing_policies(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The routing policy sets how routing information about the Oracle cloud is shared over a public virtual circuit. Policies available are: `ORACLE_SERVICE_NETWORK`, `REGIONAL`, `MARKET_LEVEL`, and `GLOBAL`. See [Route Filtering](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/routingonprem.htm#route_filtering) for details. By default, routing information is shared for all routes in the same market.
        """
        return pulumi.get(self, "routing_policies")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[str]:
        """
        Provider service type.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The virtual circuit's current state. For information about the different states, see [FastConnect Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnect.htm).
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the virtual circuit was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of IP addresses used in this virtual circuit. PRIVATE means [RFC 1918](https://tools.ietf.org/html/rfc1918) addresses (10.0.0.0/8, 172.16/12, and 192.168/16). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualCircuitRedundancyMetadatas")
    def virtual_circuit_redundancy_metadatas(self) -> pulumi.Output[Sequence['outputs.VirtualCircuitVirtualCircuitRedundancyMetadata']]:
        """
        This resource provides redundancy level details for the virtual circuit. For more about redundancy, see [FastConnect Redundancy Best Practices](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/fastconnectresiliency.htm).
        """
        return pulumi.get(self, "virtual_circuit_redundancy_metadatas")

