# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModelArgs', 'Model']

@pulumi.input_type
class ModelArgs:
    def __init__(__self__, *,
                 artifact_content_length: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 model_artifact: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 artifact_content_disposition: Optional[pulumi.Input[str]] = None,
                 backup_setting: Optional[pulumi.Input['ModelBackupSettingArgs']] = None,
                 custom_metadata_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ModelCustomMetadataListArgs']]]] = None,
                 defined_metadata_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ModelDefinedMetadataListArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input_schema: Optional[pulumi.Input[str]] = None,
                 model_version_set_id: Optional[pulumi.Input[str]] = None,
                 model_version_set_name: Optional[pulumi.Input[str]] = None,
                 output_schema: Optional[pulumi.Input[str]] = None,
                 retention_setting: Optional[pulumi.Input['ModelRetentionSettingArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 version_label: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Model resource.
        :param pulumi.Input[str] artifact_content_length: The content length of the model_artifact.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the model in.
        :param pulumi.Input[str] model_artifact: The model artifact to upload. It is a ZIP archive of the files necessary to run the model. This can be done in a separate step or using cli/sdk. The Model will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input[str] artifact_content_disposition: This allows to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=model-artifact.zip`
        :param pulumi.Input['ModelBackupSettingArgs'] backup_setting: (Updatable) Back up setting details of the model.
        :param pulumi.Input[Sequence[pulumi.Input['ModelCustomMetadataListArgs']]] custom_metadata_lists: (Updatable) An array of custom metadata details for the model.
        :param pulumi.Input[Sequence[pulumi.Input['ModelDefinedMetadataListArgs']]] defined_metadata_lists: (Updatable) An array of defined metadata details for the model.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My Model`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] input_schema: Input schema file content in String format
        :param pulumi.Input[str] model_version_set_id: The OCID of the model version set that the model is associated to.
        :param pulumi.Input[str] model_version_set_name: The name of the model version set that the model is associated to.
        :param pulumi.Input[str] output_schema: Output schema file content in String format
        :param pulumi.Input['ModelRetentionSettingArgs'] retention_setting: (Updatable) Retention setting details of the model.
        :param pulumi.Input[str] state: The state of the model.
        :param pulumi.Input[str] version_label: (Updatable) The version label can add an additional description of the lifecycle state of the model or the application using/training the model.
        """
        pulumi.set(__self__, "artifact_content_length", artifact_content_length)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "model_artifact", model_artifact)
        pulumi.set(__self__, "project_id", project_id)
        if artifact_content_disposition is not None:
            pulumi.set(__self__, "artifact_content_disposition", artifact_content_disposition)
        if backup_setting is not None:
            pulumi.set(__self__, "backup_setting", backup_setting)
        if custom_metadata_lists is not None:
            pulumi.set(__self__, "custom_metadata_lists", custom_metadata_lists)
        if defined_metadata_lists is not None:
            pulumi.set(__self__, "defined_metadata_lists", defined_metadata_lists)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if input_schema is not None:
            pulumi.set(__self__, "input_schema", input_schema)
        if model_version_set_id is not None:
            pulumi.set(__self__, "model_version_set_id", model_version_set_id)
        if model_version_set_name is not None:
            pulumi.set(__self__, "model_version_set_name", model_version_set_name)
        if output_schema is not None:
            pulumi.set(__self__, "output_schema", output_schema)
        if retention_setting is not None:
            pulumi.set(__self__, "retention_setting", retention_setting)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if version_label is not None:
            pulumi.set(__self__, "version_label", version_label)

    @property
    @pulumi.getter(name="artifactContentLength")
    def artifact_content_length(self) -> pulumi.Input[str]:
        """
        The content length of the model_artifact.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "artifact_content_length")

    @artifact_content_length.setter
    def artifact_content_length(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_content_length", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the model in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="modelArtifact")
    def model_artifact(self) -> pulumi.Input[str]:
        """
        The model artifact to upload. It is a ZIP archive of the files necessary to run the model. This can be done in a separate step or using cli/sdk. The Model will remain in "Creating" state until its artifact is uploaded.
        """
        return pulumi.get(self, "model_artifact")

    @model_artifact.setter
    def model_artifact(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_artifact", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="artifactContentDisposition")
    def artifact_content_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        This allows to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=model-artifact.zip`
        """
        return pulumi.get(self, "artifact_content_disposition")

    @artifact_content_disposition.setter
    def artifact_content_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_content_disposition", value)

    @property
    @pulumi.getter(name="backupSetting")
    def backup_setting(self) -> Optional[pulumi.Input['ModelBackupSettingArgs']]:
        """
        (Updatable) Back up setting details of the model.
        """
        return pulumi.get(self, "backup_setting")

    @backup_setting.setter
    def backup_setting(self, value: Optional[pulumi.Input['ModelBackupSettingArgs']]):
        pulumi.set(self, "backup_setting", value)

    @property
    @pulumi.getter(name="customMetadataLists")
    def custom_metadata_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelCustomMetadataListArgs']]]]:
        """
        (Updatable) An array of custom metadata details for the model.
        """
        return pulumi.get(self, "custom_metadata_lists")

    @custom_metadata_lists.setter
    def custom_metadata_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelCustomMetadataListArgs']]]]):
        pulumi.set(self, "custom_metadata_lists", value)

    @property
    @pulumi.getter(name="definedMetadataLists")
    def defined_metadata_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelDefinedMetadataListArgs']]]]:
        """
        (Updatable) An array of defined metadata details for the model.
        """
        return pulumi.get(self, "defined_metadata_lists")

    @defined_metadata_lists.setter
    def defined_metadata_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelDefinedMetadataListArgs']]]]):
        pulumi.set(self, "defined_metadata_lists", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My Model`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="inputSchema")
    def input_schema(self) -> Optional[pulumi.Input[str]]:
        """
        Input schema file content in String format
        """
        return pulumi.get(self, "input_schema")

    @input_schema.setter
    def input_schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_schema", value)

    @property
    @pulumi.getter(name="modelVersionSetId")
    def model_version_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the model version set that the model is associated to.
        """
        return pulumi.get(self, "model_version_set_id")

    @model_version_set_id.setter
    def model_version_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version_set_id", value)

    @property
    @pulumi.getter(name="modelVersionSetName")
    def model_version_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the model version set that the model is associated to.
        """
        return pulumi.get(self, "model_version_set_name")

    @model_version_set_name.setter
    def model_version_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version_set_name", value)

    @property
    @pulumi.getter(name="outputSchema")
    def output_schema(self) -> Optional[pulumi.Input[str]]:
        """
        Output schema file content in String format
        """
        return pulumi.get(self, "output_schema")

    @output_schema.setter
    def output_schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_schema", value)

    @property
    @pulumi.getter(name="retentionSetting")
    def retention_setting(self) -> Optional[pulumi.Input['ModelRetentionSettingArgs']]:
        """
        (Updatable) Retention setting details of the model.
        """
        return pulumi.get(self, "retention_setting")

    @retention_setting.setter
    def retention_setting(self, value: Optional[pulumi.Input['ModelRetentionSettingArgs']]):
        pulumi.set(self, "retention_setting", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the model.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version label can add an additional description of the lifecycle state of the model or the application using/training the model.
        """
        return pulumi.get(self, "version_label")

    @version_label.setter
    def version_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_label", value)


@pulumi.input_type
class _ModelState:
    def __init__(__self__, *,
                 artifact_content_disposition: Optional[pulumi.Input[str]] = None,
                 artifact_content_length: Optional[pulumi.Input[str]] = None,
                 artifact_content_md5: Optional[pulumi.Input[str]] = None,
                 artifact_last_modified: Optional[pulumi.Input[str]] = None,
                 backup_operation_details: Optional[pulumi.Input[Sequence[pulumi.Input['ModelBackupOperationDetailArgs']]]] = None,
                 backup_setting: Optional[pulumi.Input['ModelBackupSettingArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 custom_metadata_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ModelCustomMetadataListArgs']]]] = None,
                 defined_metadata_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ModelDefinedMetadataListArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 empty_model: Optional[pulumi.Input[bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input_schema: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 model_artifact: Optional[pulumi.Input[str]] = None,
                 model_version_set_id: Optional[pulumi.Input[str]] = None,
                 model_version_set_name: Optional[pulumi.Input[str]] = None,
                 output_schema: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 retention_operation_details: Optional[pulumi.Input[Sequence[pulumi.Input['ModelRetentionOperationDetailArgs']]]] = None,
                 retention_setting: Optional[pulumi.Input['ModelRetentionSettingArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 version_label: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Model resources.
        :param pulumi.Input[str] artifact_content_disposition: This allows to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=model-artifact.zip`
        :param pulumi.Input[str] artifact_content_length: The content length of the model_artifact.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['ModelBackupOperationDetailArgs']]] backup_operation_details: Backup operation details of the model.
        :param pulumi.Input['ModelBackupSettingArgs'] backup_setting: (Updatable) Back up setting details of the model.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the model in.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the model.
        :param pulumi.Input[Sequence[pulumi.Input['ModelCustomMetadataListArgs']]] custom_metadata_lists: (Updatable) An array of custom metadata details for the model.
        :param pulumi.Input[Sequence[pulumi.Input['ModelDefinedMetadataListArgs']]] defined_metadata_lists: (Updatable) An array of defined metadata details for the model.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My Model`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] input_schema: Input schema file content in String format
        :param pulumi.Input[str] lifecycle_details: Details about the lifecycle state of the model.
        :param pulumi.Input[str] model_artifact: The model artifact to upload. It is a ZIP archive of the files necessary to run the model. This can be done in a separate step or using cli/sdk. The Model will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input[str] model_version_set_id: The OCID of the model version set that the model is associated to.
        :param pulumi.Input[str] model_version_set_name: The name of the model version set that the model is associated to.
        :param pulumi.Input[str] output_schema: Output schema file content in String format
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input[Sequence[pulumi.Input['ModelRetentionOperationDetailArgs']]] retention_operation_details: Retention operation details for the model.
        :param pulumi.Input['ModelRetentionSettingArgs'] retention_setting: (Updatable) Retention setting details of the model.
        :param pulumi.Input[str] state: The state of the model.
        :param pulumi.Input[str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        :param pulumi.Input[str] version_label: (Updatable) The version label can add an additional description of the lifecycle state of the model or the application using/training the model.
        """
        if artifact_content_disposition is not None:
            pulumi.set(__self__, "artifact_content_disposition", artifact_content_disposition)
        if artifact_content_length is not None:
            pulumi.set(__self__, "artifact_content_length", artifact_content_length)
        if artifact_content_md5 is not None:
            pulumi.set(__self__, "artifact_content_md5", artifact_content_md5)
        if artifact_last_modified is not None:
            pulumi.set(__self__, "artifact_last_modified", artifact_last_modified)
        if backup_operation_details is not None:
            pulumi.set(__self__, "backup_operation_details", backup_operation_details)
        if backup_setting is not None:
            pulumi.set(__self__, "backup_setting", backup_setting)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if custom_metadata_lists is not None:
            pulumi.set(__self__, "custom_metadata_lists", custom_metadata_lists)
        if defined_metadata_lists is not None:
            pulumi.set(__self__, "defined_metadata_lists", defined_metadata_lists)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if empty_model is not None:
            pulumi.set(__self__, "empty_model", empty_model)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if input_schema is not None:
            pulumi.set(__self__, "input_schema", input_schema)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if model_artifact is not None:
            pulumi.set(__self__, "model_artifact", model_artifact)
        if model_version_set_id is not None:
            pulumi.set(__self__, "model_version_set_id", model_version_set_id)
        if model_version_set_name is not None:
            pulumi.set(__self__, "model_version_set_name", model_version_set_name)
        if output_schema is not None:
            pulumi.set(__self__, "output_schema", output_schema)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if retention_operation_details is not None:
            pulumi.set(__self__, "retention_operation_details", retention_operation_details)
        if retention_setting is not None:
            pulumi.set(__self__, "retention_setting", retention_setting)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if version_label is not None:
            pulumi.set(__self__, "version_label", version_label)

    @property
    @pulumi.getter(name="artifactContentDisposition")
    def artifact_content_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        This allows to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=model-artifact.zip`
        """
        return pulumi.get(self, "artifact_content_disposition")

    @artifact_content_disposition.setter
    def artifact_content_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_content_disposition", value)

    @property
    @pulumi.getter(name="artifactContentLength")
    def artifact_content_length(self) -> Optional[pulumi.Input[str]]:
        """
        The content length of the model_artifact.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "artifact_content_length")

    @artifact_content_length.setter
    def artifact_content_length(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_content_length", value)

    @property
    @pulumi.getter(name="artifactContentMd5")
    def artifact_content_md5(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "artifact_content_md5")

    @artifact_content_md5.setter
    def artifact_content_md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_content_md5", value)

    @property
    @pulumi.getter(name="artifactLastModified")
    def artifact_last_modified(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "artifact_last_modified")

    @artifact_last_modified.setter
    def artifact_last_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_last_modified", value)

    @property
    @pulumi.getter(name="backupOperationDetails")
    def backup_operation_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelBackupOperationDetailArgs']]]]:
        """
        Backup operation details of the model.
        """
        return pulumi.get(self, "backup_operation_details")

    @backup_operation_details.setter
    def backup_operation_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelBackupOperationDetailArgs']]]]):
        pulumi.set(self, "backup_operation_details", value)

    @property
    @pulumi.getter(name="backupSetting")
    def backup_setting(self) -> Optional[pulumi.Input['ModelBackupSettingArgs']]:
        """
        (Updatable) Back up setting details of the model.
        """
        return pulumi.get(self, "backup_setting")

    @backup_setting.setter
    def backup_setting(self, value: Optional[pulumi.Input['ModelBackupSettingArgs']]):
        pulumi.set(self, "backup_setting", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the model in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the model.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="customMetadataLists")
    def custom_metadata_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelCustomMetadataListArgs']]]]:
        """
        (Updatable) An array of custom metadata details for the model.
        """
        return pulumi.get(self, "custom_metadata_lists")

    @custom_metadata_lists.setter
    def custom_metadata_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelCustomMetadataListArgs']]]]):
        pulumi.set(self, "custom_metadata_lists", value)

    @property
    @pulumi.getter(name="definedMetadataLists")
    def defined_metadata_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelDefinedMetadataListArgs']]]]:
        """
        (Updatable) An array of defined metadata details for the model.
        """
        return pulumi.get(self, "defined_metadata_lists")

    @defined_metadata_lists.setter
    def defined_metadata_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelDefinedMetadataListArgs']]]]):
        pulumi.set(self, "defined_metadata_lists", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My Model`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="emptyModel")
    def empty_model(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "empty_model")

    @empty_model.setter
    def empty_model(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "empty_model", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="inputSchema")
    def input_schema(self) -> Optional[pulumi.Input[str]]:
        """
        Input schema file content in String format
        """
        return pulumi.get(self, "input_schema")

    @input_schema.setter
    def input_schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_schema", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the lifecycle state of the model.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="modelArtifact")
    def model_artifact(self) -> Optional[pulumi.Input[str]]:
        """
        The model artifact to upload. It is a ZIP archive of the files necessary to run the model. This can be done in a separate step or using cli/sdk. The Model will remain in "Creating" state until its artifact is uploaded.
        """
        return pulumi.get(self, "model_artifact")

    @model_artifact.setter
    def model_artifact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_artifact", value)

    @property
    @pulumi.getter(name="modelVersionSetId")
    def model_version_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the model version set that the model is associated to.
        """
        return pulumi.get(self, "model_version_set_id")

    @model_version_set_id.setter
    def model_version_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version_set_id", value)

    @property
    @pulumi.getter(name="modelVersionSetName")
    def model_version_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the model version set that the model is associated to.
        """
        return pulumi.get(self, "model_version_set_name")

    @model_version_set_name.setter
    def model_version_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version_set_name", value)

    @property
    @pulumi.getter(name="outputSchema")
    def output_schema(self) -> Optional[pulumi.Input[str]]:
        """
        Output schema file content in String format
        """
        return pulumi.get(self, "output_schema")

    @output_schema.setter
    def output_schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_schema", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="retentionOperationDetails")
    def retention_operation_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelRetentionOperationDetailArgs']]]]:
        """
        Retention operation details for the model.
        """
        return pulumi.get(self, "retention_operation_details")

    @retention_operation_details.setter
    def retention_operation_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelRetentionOperationDetailArgs']]]]):
        pulumi.set(self, "retention_operation_details", value)

    @property
    @pulumi.getter(name="retentionSetting")
    def retention_setting(self) -> Optional[pulumi.Input['ModelRetentionSettingArgs']]:
        """
        (Updatable) Retention setting details of the model.
        """
        return pulumi.get(self, "retention_setting")

    @retention_setting.setter
    def retention_setting(self, value: Optional[pulumi.Input['ModelRetentionSettingArgs']]):
        pulumi.set(self, "retention_setting", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the model.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version label can add an additional description of the lifecycle state of the model or the application using/training the model.
        """
        return pulumi.get(self, "version_label")

    @version_label.setter
    def version_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_label", value)


class Model(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_content_disposition: Optional[pulumi.Input[str]] = None,
                 artifact_content_length: Optional[pulumi.Input[str]] = None,
                 backup_setting: Optional[pulumi.Input[Union['ModelBackupSettingArgs', 'ModelBackupSettingArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 custom_metadata_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelCustomMetadataListArgs', 'ModelCustomMetadataListArgsDict']]]]] = None,
                 defined_metadata_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelDefinedMetadataListArgs', 'ModelDefinedMetadataListArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input_schema: Optional[pulumi.Input[str]] = None,
                 model_artifact: Optional[pulumi.Input[str]] = None,
                 model_version_set_id: Optional[pulumi.Input[str]] = None,
                 model_version_set_name: Optional[pulumi.Input[str]] = None,
                 output_schema: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 retention_setting: Optional[pulumi.Input[Union['ModelRetentionSettingArgs', 'ModelRetentionSettingArgsDict']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 version_label: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model = oci.data_science.Model("test_model",
            compartment_id=compartment_id,
            project_id=test_project["id"],
            backup_setting={
                "backup_region": model_backup_setting_backup_region,
                "is_backup_enabled": model_backup_setting_is_backup_enabled,
                "customer_notification_type": model_backup_setting_customer_notification_type,
            },
            custom_metadata_lists=[{
                "category": model_custom_metadata_list_category,
                "description": model_custom_metadata_list_description,
                "key": model_custom_metadata_list_key,
                "value": model_custom_metadata_list_value,
            }],
            defined_metadata_lists=[{
                "category": model_defined_metadata_list_category,
                "description": model_defined_metadata_list_description,
                "key": model_defined_metadata_list_key,
                "value": model_defined_metadata_list_value,
            }],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=model_description,
            display_name=model_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            input_schema=model_input_schema,
            output_schema=model_output_schema,
            retention_setting={
                "archive_after_days": model_retention_setting_archive_after_days,
                "customer_notification_type": model_retention_setting_customer_notification_type,
                "delete_after_days": model_retention_setting_delete_after_days,
            },
            version_label=model_version_label)
        ```

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artifact_content_disposition: This allows to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=model-artifact.zip`
        :param pulumi.Input[str] artifact_content_length: The content length of the model_artifact.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['ModelBackupSettingArgs', 'ModelBackupSettingArgsDict']] backup_setting: (Updatable) Back up setting details of the model.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the model in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelCustomMetadataListArgs', 'ModelCustomMetadataListArgsDict']]]] custom_metadata_lists: (Updatable) An array of custom metadata details for the model.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelDefinedMetadataListArgs', 'ModelDefinedMetadataListArgsDict']]]] defined_metadata_lists: (Updatable) An array of defined metadata details for the model.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My Model`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] input_schema: Input schema file content in String format
        :param pulumi.Input[str] model_artifact: The model artifact to upload. It is a ZIP archive of the files necessary to run the model. This can be done in a separate step or using cli/sdk. The Model will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input[str] model_version_set_id: The OCID of the model version set that the model is associated to.
        :param pulumi.Input[str] model_version_set_name: The name of the model version set that the model is associated to.
        :param pulumi.Input[str] output_schema: Output schema file content in String format
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input[Union['ModelRetentionSettingArgs', 'ModelRetentionSettingArgsDict']] retention_setting: (Updatable) Retention setting details of the model.
        :param pulumi.Input[str] state: The state of the model.
        :param pulumi.Input[str] version_label: (Updatable) The version label can add an additional description of the lifecycle state of the model or the application using/training the model.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model = oci.data_science.Model("test_model",
            compartment_id=compartment_id,
            project_id=test_project["id"],
            backup_setting={
                "backup_region": model_backup_setting_backup_region,
                "is_backup_enabled": model_backup_setting_is_backup_enabled,
                "customer_notification_type": model_backup_setting_customer_notification_type,
            },
            custom_metadata_lists=[{
                "category": model_custom_metadata_list_category,
                "description": model_custom_metadata_list_description,
                "key": model_custom_metadata_list_key,
                "value": model_custom_metadata_list_value,
            }],
            defined_metadata_lists=[{
                "category": model_defined_metadata_list_category,
                "description": model_defined_metadata_list_description,
                "key": model_defined_metadata_list_key,
                "value": model_defined_metadata_list_value,
            }],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=model_description,
            display_name=model_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            input_schema=model_input_schema,
            output_schema=model_output_schema,
            retention_setting={
                "archive_after_days": model_retention_setting_archive_after_days,
                "customer_notification_type": model_retention_setting_customer_notification_type,
                "delete_after_days": model_retention_setting_delete_after_days,
            },
            version_label=model_version_label)
        ```

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param ModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_content_disposition: Optional[pulumi.Input[str]] = None,
                 artifact_content_length: Optional[pulumi.Input[str]] = None,
                 backup_setting: Optional[pulumi.Input[Union['ModelBackupSettingArgs', 'ModelBackupSettingArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 custom_metadata_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelCustomMetadataListArgs', 'ModelCustomMetadataListArgsDict']]]]] = None,
                 defined_metadata_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelDefinedMetadataListArgs', 'ModelDefinedMetadataListArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input_schema: Optional[pulumi.Input[str]] = None,
                 model_artifact: Optional[pulumi.Input[str]] = None,
                 model_version_set_id: Optional[pulumi.Input[str]] = None,
                 model_version_set_name: Optional[pulumi.Input[str]] = None,
                 output_schema: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 retention_setting: Optional[pulumi.Input[Union['ModelRetentionSettingArgs', 'ModelRetentionSettingArgsDict']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 version_label: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelArgs.__new__(ModelArgs)

            __props__.__dict__["artifact_content_disposition"] = artifact_content_disposition
            if artifact_content_length is None and not opts.urn:
                raise TypeError("Missing required property 'artifact_content_length'")
            __props__.__dict__["artifact_content_length"] = artifact_content_length
            __props__.__dict__["backup_setting"] = backup_setting
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["custom_metadata_lists"] = custom_metadata_lists
            __props__.__dict__["defined_metadata_lists"] = defined_metadata_lists
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["input_schema"] = input_schema
            if model_artifact is None and not opts.urn:
                raise TypeError("Missing required property 'model_artifact'")
            __props__.__dict__["model_artifact"] = model_artifact
            __props__.__dict__["model_version_set_id"] = model_version_set_id
            __props__.__dict__["model_version_set_name"] = model_version_set_name
            __props__.__dict__["output_schema"] = output_schema
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["retention_setting"] = retention_setting
            __props__.__dict__["state"] = state
            __props__.__dict__["version_label"] = version_label
            __props__.__dict__["artifact_content_md5"] = None
            __props__.__dict__["artifact_last_modified"] = None
            __props__.__dict__["backup_operation_details"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["empty_model"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["retention_operation_details"] = None
            __props__.__dict__["time_created"] = None
        super(Model, __self__).__init__(
            'oci:DataScience/model:Model',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artifact_content_disposition: Optional[pulumi.Input[str]] = None,
            artifact_content_length: Optional[pulumi.Input[str]] = None,
            artifact_content_md5: Optional[pulumi.Input[str]] = None,
            artifact_last_modified: Optional[pulumi.Input[str]] = None,
            backup_operation_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelBackupOperationDetailArgs', 'ModelBackupOperationDetailArgsDict']]]]] = None,
            backup_setting: Optional[pulumi.Input[Union['ModelBackupSettingArgs', 'ModelBackupSettingArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            custom_metadata_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelCustomMetadataListArgs', 'ModelCustomMetadataListArgsDict']]]]] = None,
            defined_metadata_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelDefinedMetadataListArgs', 'ModelDefinedMetadataListArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            empty_model: Optional[pulumi.Input[bool]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            input_schema: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            model_artifact: Optional[pulumi.Input[str]] = None,
            model_version_set_id: Optional[pulumi.Input[str]] = None,
            model_version_set_name: Optional[pulumi.Input[str]] = None,
            output_schema: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            retention_operation_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelRetentionOperationDetailArgs', 'ModelRetentionOperationDetailArgsDict']]]]] = None,
            retention_setting: Optional[pulumi.Input[Union['ModelRetentionSettingArgs', 'ModelRetentionSettingArgsDict']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            version_label: Optional[pulumi.Input[str]] = None) -> 'Model':
        """
        Get an existing Model resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artifact_content_disposition: This allows to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=model-artifact.zip`
        :param pulumi.Input[str] artifact_content_length: The content length of the model_artifact.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelBackupOperationDetailArgs', 'ModelBackupOperationDetailArgsDict']]]] backup_operation_details: Backup operation details of the model.
        :param pulumi.Input[Union['ModelBackupSettingArgs', 'ModelBackupSettingArgsDict']] backup_setting: (Updatable) Back up setting details of the model.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the model in.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the model.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelCustomMetadataListArgs', 'ModelCustomMetadataListArgsDict']]]] custom_metadata_lists: (Updatable) An array of custom metadata details for the model.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelDefinedMetadataListArgs', 'ModelDefinedMetadataListArgsDict']]]] defined_metadata_lists: (Updatable) An array of defined metadata details for the model.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My Model`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] input_schema: Input schema file content in String format
        :param pulumi.Input[str] lifecycle_details: Details about the lifecycle state of the model.
        :param pulumi.Input[str] model_artifact: The model artifact to upload. It is a ZIP archive of the files necessary to run the model. This can be done in a separate step or using cli/sdk. The Model will remain in "Creating" state until its artifact is uploaded.
        :param pulumi.Input[str] model_version_set_id: The OCID of the model version set that the model is associated to.
        :param pulumi.Input[str] model_version_set_name: The name of the model version set that the model is associated to.
        :param pulumi.Input[str] output_schema: Output schema file content in String format
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelRetentionOperationDetailArgs', 'ModelRetentionOperationDetailArgsDict']]]] retention_operation_details: Retention operation details for the model.
        :param pulumi.Input[Union['ModelRetentionSettingArgs', 'ModelRetentionSettingArgsDict']] retention_setting: (Updatable) Retention setting details of the model.
        :param pulumi.Input[str] state: The state of the model.
        :param pulumi.Input[str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        :param pulumi.Input[str] version_label: (Updatable) The version label can add an additional description of the lifecycle state of the model or the application using/training the model.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelState.__new__(_ModelState)

        __props__.__dict__["artifact_content_disposition"] = artifact_content_disposition
        __props__.__dict__["artifact_content_length"] = artifact_content_length
        __props__.__dict__["artifact_content_md5"] = artifact_content_md5
        __props__.__dict__["artifact_last_modified"] = artifact_last_modified
        __props__.__dict__["backup_operation_details"] = backup_operation_details
        __props__.__dict__["backup_setting"] = backup_setting
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["custom_metadata_lists"] = custom_metadata_lists
        __props__.__dict__["defined_metadata_lists"] = defined_metadata_lists
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["empty_model"] = empty_model
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["input_schema"] = input_schema
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["model_artifact"] = model_artifact
        __props__.__dict__["model_version_set_id"] = model_version_set_id
        __props__.__dict__["model_version_set_name"] = model_version_set_name
        __props__.__dict__["output_schema"] = output_schema
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["retention_operation_details"] = retention_operation_details
        __props__.__dict__["retention_setting"] = retention_setting
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["version_label"] = version_label
        return Model(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artifactContentDisposition")
    def artifact_content_disposition(self) -> pulumi.Output[str]:
        """
        This allows to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. Example: `attachment; filename=model-artifact.zip`
        """
        return pulumi.get(self, "artifact_content_disposition")

    @property
    @pulumi.getter(name="artifactContentLength")
    def artifact_content_length(self) -> pulumi.Output[str]:
        """
        The content length of the model_artifact.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "artifact_content_length")

    @property
    @pulumi.getter(name="artifactContentMd5")
    def artifact_content_md5(self) -> pulumi.Output[str]:
        return pulumi.get(self, "artifact_content_md5")

    @property
    @pulumi.getter(name="artifactLastModified")
    def artifact_last_modified(self) -> pulumi.Output[str]:
        return pulumi.get(self, "artifact_last_modified")

    @property
    @pulumi.getter(name="backupOperationDetails")
    def backup_operation_details(self) -> pulumi.Output[Sequence['outputs.ModelBackupOperationDetail']]:
        """
        Backup operation details of the model.
        """
        return pulumi.get(self, "backup_operation_details")

    @property
    @pulumi.getter(name="backupSetting")
    def backup_setting(self) -> pulumi.Output['outputs.ModelBackupSetting']:
        """
        (Updatable) Back up setting details of the model.
        """
        return pulumi.get(self, "backup_setting")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the model in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the model.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="customMetadataLists")
    def custom_metadata_lists(self) -> pulumi.Output[Sequence['outputs.ModelCustomMetadataList']]:
        """
        (Updatable) An array of custom metadata details for the model.
        """
        return pulumi.get(self, "custom_metadata_lists")

    @property
    @pulumi.getter(name="definedMetadataLists")
    def defined_metadata_lists(self) -> pulumi.Output[Sequence['outputs.ModelDefinedMetadataList']]:
        """
        (Updatable) An array of defined metadata details for the model.
        """
        return pulumi.get(self, "defined_metadata_lists")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A short description of the model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information. Example: `My Model`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="emptyModel")
    def empty_model(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "empty_model")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="inputSchema")
    def input_schema(self) -> pulumi.Output[str]:
        """
        Input schema file content in String format
        """
        return pulumi.get(self, "input_schema")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the lifecycle state of the model.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelArtifact")
    def model_artifact(self) -> pulumi.Output[str]:
        """
        The model artifact to upload. It is a ZIP archive of the files necessary to run the model. This can be done in a separate step or using cli/sdk. The Model will remain in "Creating" state until its artifact is uploaded.
        """
        return pulumi.get(self, "model_artifact")

    @property
    @pulumi.getter(name="modelVersionSetId")
    def model_version_set_id(self) -> pulumi.Output[str]:
        """
        The OCID of the model version set that the model is associated to.
        """
        return pulumi.get(self, "model_version_set_id")

    @property
    @pulumi.getter(name="modelVersionSetName")
    def model_version_set_name(self) -> pulumi.Output[str]:
        """
        The name of the model version set that the model is associated to.
        """
        return pulumi.get(self, "model_version_set_name")

    @property
    @pulumi.getter(name="outputSchema")
    def output_schema(self) -> pulumi.Output[str]:
        """
        Output schema file content in String format
        """
        return pulumi.get(self, "output_schema")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="retentionOperationDetails")
    def retention_operation_details(self) -> pulumi.Output[Sequence['outputs.ModelRetentionOperationDetail']]:
        """
        Retention operation details for the model.
        """
        return pulumi.get(self, "retention_operation_details")

    @property
    @pulumi.getter(name="retentionSetting")
    def retention_setting(self) -> pulumi.Output['outputs.ModelRetentionSetting']:
        """
        (Updatable) Retention setting details of the model.
        """
        return pulumi.get(self, "retention_setting")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the model.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> pulumi.Output[str]:
        """
        (Updatable) The version label can add an additional description of the lifecycle state of the model or the application using/training the model.
        """
        return pulumi.get(self, "version_label")

