# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RunbookArgs', 'Runbook']

@pulumi.input_type
class RunbookArgs:
    def __init__(__self__, *,
                 associations: pulumi.Input['RunbookAssociationsArgs'],
                 compartment_id: pulumi.Input[str],
                 operation: pulumi.Input[str],
                 os_type: pulumi.Input[str],
                 runbook_relevance: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 estimated_time: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 platform: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Runbook resource.
        :param pulumi.Input['RunbookAssociationsArgs'] associations: (Updatable) Associations for the runbook.
        :param pulumi.Input[str] operation: (Updatable) The lifecycle operation performed by the task.
        :param pulumi.Input[str] os_type: (Updatable) The OS type for the runbook.
        :param pulumi.Input[str] runbook_relevance: (Updatable) Type of runbook structure.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[str] estimated_time: (Updatable) Estimated time to successfully complete the runbook execution
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_default: (Updatable) Is the runbook default?
        :param pulumi.Input[str] platform: (Updatable) The platform of the runbook.
        """
        pulumi.set(__self__, "associations", associations)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "runbook_relevance", runbook_relevance)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if estimated_time is not None:
            pulumi.set(__self__, "estimated_time", estimated_time)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @property
    @pulumi.getter
    def associations(self) -> pulumi.Input['RunbookAssociationsArgs']:
        """
        (Updatable) Associations for the runbook.
        """
        return pulumi.get(self, "associations")

    @associations.setter
    def associations(self, value: pulumi.Input['RunbookAssociationsArgs']):
        pulumi.set(self, "associations", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[str]:
        """
        (Updatable) The lifecycle operation performed by the task.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[str]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The OS type for the runbook.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="runbookRelevance")
    def runbook_relevance(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of runbook structure.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "runbook_relevance")

    @runbook_relevance.setter
    def runbook_relevance(self, value: pulumi.Input[str]):
        pulumi.set(self, "runbook_relevance", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="estimatedTime")
    def estimated_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Estimated time to successfully complete the runbook execution
        """
        return pulumi.get(self, "estimated_time")

    @estimated_time.setter
    def estimated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "estimated_time", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Is the runbook default?
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The platform of the runbook.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)


@pulumi.input_type
class _RunbookState:
    def __init__(__self__, *,
                 associations: Optional[pulumi.Input['RunbookAssociationsArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 estimated_time: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 resource_region: Optional[pulumi.Input[str]] = None,
                 runbook_relevance: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Runbook resources.
        :param pulumi.Input['RunbookAssociationsArgs'] associations: (Updatable) Associations for the runbook.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[str] estimated_time: (Updatable) Estimated time to successfully complete the runbook execution
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_default: (Updatable) Is the runbook default?
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] operation: (Updatable) The lifecycle operation performed by the task.
        :param pulumi.Input[str] os_type: (Updatable) The OS type for the runbook.
        :param pulumi.Input[str] platform: (Updatable) The platform of the runbook.
        :param pulumi.Input[str] resource_region: Associated region
        :param pulumi.Input[str] runbook_relevance: (Updatable) Type of runbook structure.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the Runbook.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] type: The type of the runbook.
        """
        if associations is not None:
            pulumi.set(__self__, "associations", associations)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if estimated_time is not None:
            pulumi.set(__self__, "estimated_time", estimated_time)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if resource_region is not None:
            pulumi.set(__self__, "resource_region", resource_region)
        if runbook_relevance is not None:
            pulumi.set(__self__, "runbook_relevance", runbook_relevance)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def associations(self) -> Optional[pulumi.Input['RunbookAssociationsArgs']]:
        """
        (Updatable) Associations for the runbook.
        """
        return pulumi.get(self, "associations")

    @associations.setter
    def associations(self, value: Optional[pulumi.Input['RunbookAssociationsArgs']]):
        pulumi.set(self, "associations", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="estimatedTime")
    def estimated_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Estimated time to successfully complete the runbook execution
        """
        return pulumi.get(self, "estimated_time")

    @estimated_time.setter
    def estimated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "estimated_time", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Is the runbook default?
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The lifecycle operation performed by the task.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OS type for the runbook.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The platform of the runbook.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[pulumi.Input[str]]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @resource_region.setter
    def resource_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_region", value)

    @property
    @pulumi.getter(name="runbookRelevance")
    def runbook_relevance(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of runbook structure.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "runbook_relevance")

    @runbook_relevance.setter
    def runbook_relevance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runbook_relevance", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Runbook.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the runbook.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Runbook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associations: Optional[pulumi.Input[Union['RunbookAssociationsArgs', 'RunbookAssociationsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 estimated_time: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 runbook_relevance: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Runbook resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Creates a new Runbook.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_runbook = oci.fleet_apps_management.Runbook("test_runbook",
            associations={
                "execution_workflow_details": {
                    "workflows": [{
                        "group_name": test_group["name"],
                        "steps": [{
                            "type": runbook_associations_execution_workflow_details_workflow_steps_type,
                            "group_name": test_group["name"],
                            "step_name": runbook_associations_execution_workflow_details_workflow_steps_step_name,
                            "steps": runbook_associations_execution_workflow_details_workflow_steps_steps,
                        }],
                        "type": runbook_associations_execution_workflow_details_workflow_type,
                    }],
                },
                "groups": [{
                    "name": runbook_associations_groups_name,
                    "type": runbook_associations_groups_type,
                    "properties": {
                        "action_on_failure": runbook_associations_groups_properties_action_on_failure,
                        "condition": runbook_associations_groups_properties_condition,
                        "notification_preferences": {
                            "should_notify_on_pause": runbook_associations_groups_properties_notification_preferences_should_notify_on_pause,
                            "should_notify_on_task_failure": runbook_associations_groups_properties_notification_preferences_should_notify_on_task_failure,
                            "should_notify_on_task_success": runbook_associations_groups_properties_notification_preferences_should_notify_on_task_success,
                        },
                        "pause_details": {
                            "kind": runbook_associations_groups_properties_pause_details_kind,
                            "duration_in_minutes": runbook_associations_groups_properties_pause_details_duration_in_minutes,
                        },
                        "run_on": runbook_associations_groups_properties_run_on,
                    },
                }],
                "tasks": [{
                    "association_type": runbook_associations_tasks_association_type,
                    "step_name": runbook_associations_tasks_step_name,
                    "task_record_details": {
                        "scope": runbook_associations_tasks_task_record_details_scope,
                        "description": runbook_associations_tasks_task_record_details_description,
                        "execution_details": {
                            "execution_type": runbook_associations_tasks_task_record_details_execution_details_execution_type,
                            "command": runbook_associations_tasks_task_record_details_execution_details_command,
                            "content": {
                                "bucket": runbook_associations_tasks_task_record_details_execution_details_content_bucket,
                                "checksum": runbook_associations_tasks_task_record_details_execution_details_content_checksum,
                                "namespace": runbook_associations_tasks_task_record_details_execution_details_content_namespace,
                                "object": runbook_associations_tasks_task_record_details_execution_details_content_object,
                                "source_type": runbook_associations_tasks_task_record_details_execution_details_content_source_type,
                            },
                            "credentials": [{
                                "display_name": runbook_associations_tasks_task_record_details_execution_details_credentials_display_name,
                                "id": runbook_associations_tasks_task_record_details_execution_details_credentials_id,
                            }],
                            "endpoint": runbook_associations_tasks_task_record_details_execution_details_endpoint,
                            "variables": {
                                "input_variables": [{
                                    "description": runbook_associations_tasks_task_record_details_execution_details_variables_input_variables_description,
                                    "name": runbook_associations_tasks_task_record_details_execution_details_variables_input_variables_name,
                                    "type": runbook_associations_tasks_task_record_details_execution_details_variables_input_variables_type,
                                }],
                                "output_variables": runbook_associations_tasks_task_record_details_execution_details_variables_output_variables,
                            },
                        },
                        "is_apply_subject_task": runbook_associations_tasks_task_record_details_is_apply_subject_task,
                        "is_copy_to_library_enabled": runbook_associations_tasks_task_record_details_is_copy_to_library_enabled,
                        "is_discovery_output_task": runbook_associations_tasks_task_record_details_is_discovery_output_task,
                        "name": runbook_associations_tasks_task_record_details_name,
                        "os_type": runbook_associations_tasks_task_record_details_os_type,
                        "platform": runbook_associations_tasks_task_record_details_platform,
                        "properties": {
                            "num_retries": runbook_associations_tasks_task_record_details_properties_num_retries,
                            "timeout_in_seconds": runbook_associations_tasks_task_record_details_properties_timeout_in_seconds,
                        },
                        "task_record_id": test_task_record["id"],
                    },
                    "output_variable_mappings": [{
                        "name": runbook_associations_tasks_output_variable_mappings_name,
                        "output_variable_details": {
                            "output_variable_name": runbook_associations_tasks_output_variable_mappings_output_variable_details_output_variable_name,
                            "step_name": runbook_associations_tasks_output_variable_mappings_output_variable_details_step_name,
                        },
                    }],
                    "step_properties": {
                        "action_on_failure": runbook_associations_tasks_step_properties_action_on_failure,
                        "condition": runbook_associations_tasks_step_properties_condition,
                        "notification_preferences": {
                            "should_notify_on_pause": runbook_associations_tasks_step_properties_notification_preferences_should_notify_on_pause,
                            "should_notify_on_task_failure": runbook_associations_tasks_step_properties_notification_preferences_should_notify_on_task_failure,
                            "should_notify_on_task_success": runbook_associations_tasks_step_properties_notification_preferences_should_notify_on_task_success,
                        },
                        "pause_details": {
                            "kind": runbook_associations_tasks_step_properties_pause_details_kind,
                            "duration_in_minutes": runbook_associations_tasks_step_properties_pause_details_duration_in_minutes,
                        },
                        "run_on": runbook_associations_tasks_step_properties_run_on,
                    },
                }],
                "rollback_workflow_details": {
                    "scope": runbook_associations_rollback_workflow_details_scope,
                    "workflows": [{
                        "group_name": test_group["name"],
                        "steps": [{
                            "type": runbook_associations_rollback_workflow_details_workflow_steps_type,
                            "group_name": test_group["name"],
                            "step_name": runbook_associations_rollback_workflow_details_workflow_steps_step_name,
                            "steps": runbook_associations_rollback_workflow_details_workflow_steps_steps,
                        }],
                        "type": runbook_associations_rollback_workflow_details_workflow_type,
                    }],
                },
                "version": runbook_associations_version,
            },
            compartment_id=compartment_id,
            operation=runbook_operation,
            os_type=runbook_os_type,
            runbook_relevance=runbook_runbook_relevance,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=runbook_description,
            display_name=runbook_display_name,
            estimated_time=runbook_estimated_time,
            freeform_tags={
                "bar-key": "value",
            },
            is_default=runbook_is_default,
            platform=runbook_platform)
        ```

        ## Import

        Runbooks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/runbook:Runbook test_runbook "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RunbookAssociationsArgs', 'RunbookAssociationsArgsDict']] associations: (Updatable) Associations for the runbook.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[str] estimated_time: (Updatable) Estimated time to successfully complete the runbook execution
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_default: (Updatable) Is the runbook default?
        :param pulumi.Input[str] operation: (Updatable) The lifecycle operation performed by the task.
        :param pulumi.Input[str] os_type: (Updatable) The OS type for the runbook.
        :param pulumi.Input[str] platform: (Updatable) The platform of the runbook.
        :param pulumi.Input[str] runbook_relevance: (Updatable) Type of runbook structure.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RunbookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Runbook resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Creates a new Runbook.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_runbook = oci.fleet_apps_management.Runbook("test_runbook",
            associations={
                "execution_workflow_details": {
                    "workflows": [{
                        "group_name": test_group["name"],
                        "steps": [{
                            "type": runbook_associations_execution_workflow_details_workflow_steps_type,
                            "group_name": test_group["name"],
                            "step_name": runbook_associations_execution_workflow_details_workflow_steps_step_name,
                            "steps": runbook_associations_execution_workflow_details_workflow_steps_steps,
                        }],
                        "type": runbook_associations_execution_workflow_details_workflow_type,
                    }],
                },
                "groups": [{
                    "name": runbook_associations_groups_name,
                    "type": runbook_associations_groups_type,
                    "properties": {
                        "action_on_failure": runbook_associations_groups_properties_action_on_failure,
                        "condition": runbook_associations_groups_properties_condition,
                        "notification_preferences": {
                            "should_notify_on_pause": runbook_associations_groups_properties_notification_preferences_should_notify_on_pause,
                            "should_notify_on_task_failure": runbook_associations_groups_properties_notification_preferences_should_notify_on_task_failure,
                            "should_notify_on_task_success": runbook_associations_groups_properties_notification_preferences_should_notify_on_task_success,
                        },
                        "pause_details": {
                            "kind": runbook_associations_groups_properties_pause_details_kind,
                            "duration_in_minutes": runbook_associations_groups_properties_pause_details_duration_in_minutes,
                        },
                        "run_on": runbook_associations_groups_properties_run_on,
                    },
                }],
                "tasks": [{
                    "association_type": runbook_associations_tasks_association_type,
                    "step_name": runbook_associations_tasks_step_name,
                    "task_record_details": {
                        "scope": runbook_associations_tasks_task_record_details_scope,
                        "description": runbook_associations_tasks_task_record_details_description,
                        "execution_details": {
                            "execution_type": runbook_associations_tasks_task_record_details_execution_details_execution_type,
                            "command": runbook_associations_tasks_task_record_details_execution_details_command,
                            "content": {
                                "bucket": runbook_associations_tasks_task_record_details_execution_details_content_bucket,
                                "checksum": runbook_associations_tasks_task_record_details_execution_details_content_checksum,
                                "namespace": runbook_associations_tasks_task_record_details_execution_details_content_namespace,
                                "object": runbook_associations_tasks_task_record_details_execution_details_content_object,
                                "source_type": runbook_associations_tasks_task_record_details_execution_details_content_source_type,
                            },
                            "credentials": [{
                                "display_name": runbook_associations_tasks_task_record_details_execution_details_credentials_display_name,
                                "id": runbook_associations_tasks_task_record_details_execution_details_credentials_id,
                            }],
                            "endpoint": runbook_associations_tasks_task_record_details_execution_details_endpoint,
                            "variables": {
                                "input_variables": [{
                                    "description": runbook_associations_tasks_task_record_details_execution_details_variables_input_variables_description,
                                    "name": runbook_associations_tasks_task_record_details_execution_details_variables_input_variables_name,
                                    "type": runbook_associations_tasks_task_record_details_execution_details_variables_input_variables_type,
                                }],
                                "output_variables": runbook_associations_tasks_task_record_details_execution_details_variables_output_variables,
                            },
                        },
                        "is_apply_subject_task": runbook_associations_tasks_task_record_details_is_apply_subject_task,
                        "is_copy_to_library_enabled": runbook_associations_tasks_task_record_details_is_copy_to_library_enabled,
                        "is_discovery_output_task": runbook_associations_tasks_task_record_details_is_discovery_output_task,
                        "name": runbook_associations_tasks_task_record_details_name,
                        "os_type": runbook_associations_tasks_task_record_details_os_type,
                        "platform": runbook_associations_tasks_task_record_details_platform,
                        "properties": {
                            "num_retries": runbook_associations_tasks_task_record_details_properties_num_retries,
                            "timeout_in_seconds": runbook_associations_tasks_task_record_details_properties_timeout_in_seconds,
                        },
                        "task_record_id": test_task_record["id"],
                    },
                    "output_variable_mappings": [{
                        "name": runbook_associations_tasks_output_variable_mappings_name,
                        "output_variable_details": {
                            "output_variable_name": runbook_associations_tasks_output_variable_mappings_output_variable_details_output_variable_name,
                            "step_name": runbook_associations_tasks_output_variable_mappings_output_variable_details_step_name,
                        },
                    }],
                    "step_properties": {
                        "action_on_failure": runbook_associations_tasks_step_properties_action_on_failure,
                        "condition": runbook_associations_tasks_step_properties_condition,
                        "notification_preferences": {
                            "should_notify_on_pause": runbook_associations_tasks_step_properties_notification_preferences_should_notify_on_pause,
                            "should_notify_on_task_failure": runbook_associations_tasks_step_properties_notification_preferences_should_notify_on_task_failure,
                            "should_notify_on_task_success": runbook_associations_tasks_step_properties_notification_preferences_should_notify_on_task_success,
                        },
                        "pause_details": {
                            "kind": runbook_associations_tasks_step_properties_pause_details_kind,
                            "duration_in_minutes": runbook_associations_tasks_step_properties_pause_details_duration_in_minutes,
                        },
                        "run_on": runbook_associations_tasks_step_properties_run_on,
                    },
                }],
                "rollback_workflow_details": {
                    "scope": runbook_associations_rollback_workflow_details_scope,
                    "workflows": [{
                        "group_name": test_group["name"],
                        "steps": [{
                            "type": runbook_associations_rollback_workflow_details_workflow_steps_type,
                            "group_name": test_group["name"],
                            "step_name": runbook_associations_rollback_workflow_details_workflow_steps_step_name,
                            "steps": runbook_associations_rollback_workflow_details_workflow_steps_steps,
                        }],
                        "type": runbook_associations_rollback_workflow_details_workflow_type,
                    }],
                },
                "version": runbook_associations_version,
            },
            compartment_id=compartment_id,
            operation=runbook_operation,
            os_type=runbook_os_type,
            runbook_relevance=runbook_runbook_relevance,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=runbook_description,
            display_name=runbook_display_name,
            estimated_time=runbook_estimated_time,
            freeform_tags={
                "bar-key": "value",
            },
            is_default=runbook_is_default,
            platform=runbook_platform)
        ```

        ## Import

        Runbooks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/runbook:Runbook test_runbook "id"
        ```

        :param str resource_name: The name of the resource.
        :param RunbookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RunbookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associations: Optional[pulumi.Input[Union['RunbookAssociationsArgs', 'RunbookAssociationsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 estimated_time: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 runbook_relevance: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RunbookArgs.__new__(RunbookArgs)

            if associations is None and not opts.urn:
                raise TypeError("Missing required property 'associations'")
            __props__.__dict__["associations"] = associations
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["estimated_time"] = estimated_time
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_default"] = is_default
            if operation is None and not opts.urn:
                raise TypeError("Missing required property 'operation'")
            __props__.__dict__["operation"] = operation
            if os_type is None and not opts.urn:
                raise TypeError("Missing required property 'os_type'")
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["platform"] = platform
            if runbook_relevance is None and not opts.urn:
                raise TypeError("Missing required property 'runbook_relevance'")
            __props__.__dict__["runbook_relevance"] = runbook_relevance
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["resource_region"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["type"] = None
        super(Runbook, __self__).__init__(
            'oci:FleetAppsManagement/runbook:Runbook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associations: Optional[pulumi.Input[Union['RunbookAssociationsArgs', 'RunbookAssociationsArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            estimated_time: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            is_default: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            operation: Optional[pulumi.Input[str]] = None,
            os_type: Optional[pulumi.Input[str]] = None,
            platform: Optional[pulumi.Input[str]] = None,
            resource_region: Optional[pulumi.Input[str]] = None,
            runbook_relevance: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Runbook':
        """
        Get an existing Runbook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RunbookAssociationsArgs', 'RunbookAssociationsArgsDict']] associations: (Updatable) Associations for the runbook.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[str] estimated_time: (Updatable) Estimated time to successfully complete the runbook execution
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_default: (Updatable) Is the runbook default?
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] operation: (Updatable) The lifecycle operation performed by the task.
        :param pulumi.Input[str] os_type: (Updatable) The OS type for the runbook.
        :param pulumi.Input[str] platform: (Updatable) The platform of the runbook.
        :param pulumi.Input[str] resource_region: Associated region
        :param pulumi.Input[str] runbook_relevance: (Updatable) Type of runbook structure.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the Runbook.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] type: The type of the runbook.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RunbookState.__new__(_RunbookState)

        __props__.__dict__["associations"] = associations
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["estimated_time"] = estimated_time
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["operation"] = operation
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["platform"] = platform
        __props__.__dict__["resource_region"] = resource_region
        __props__.__dict__["runbook_relevance"] = runbook_relevance
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return Runbook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def associations(self) -> pulumi.Output['outputs.RunbookAssociations']:
        """
        (Updatable) Associations for the runbook.
        """
        return pulumi.get(self, "associations")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedTime")
    def estimated_time(self) -> pulumi.Output[str]:
        """
        (Updatable) Estimated time to successfully complete the runbook execution
        """
        return pulumi.get(self, "estimated_time")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[bool]:
        """
        (Updatable) Is the runbook default?
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Output[str]:
        """
        (Updatable) The lifecycle operation performed by the task.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The OS type for the runbook.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[str]:
        """
        (Updatable) The platform of the runbook.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> pulumi.Output[str]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="runbookRelevance")
    def runbook_relevance(self) -> pulumi.Output[str]:
        """
        (Updatable) Type of runbook structure.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "runbook_relevance")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Runbook.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the runbook.
        """
        return pulumi.get(self, "type")

