# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRedisClusterNodesResult',
    'AwaitableGetRedisClusterNodesResult',
    'get_redis_cluster_nodes',
    'get_redis_cluster_nodes_output',
]

@pulumi.output_type
class GetRedisClusterNodesResult:
    """
    A collection of values returned by getRedisClusterNodes.
    """
    def __init__(__self__, display_name=None, filters=None, id=None, redis_cluster_id=None, redis_node_collections=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if redis_cluster_id and not isinstance(redis_cluster_id, str):
            raise TypeError("Expected argument 'redis_cluster_id' to be a str")
        pulumi.set(__self__, "redis_cluster_id", redis_cluster_id)
        if redis_node_collections and not isinstance(redis_node_collections, list):
            raise TypeError("Expected argument 'redis_node_collections' to be a list")
        pulumi.set(__self__, "redis_node_collections", redis_node_collections)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name of a cluster node.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRedisClusterNodesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="redisClusterId")
    def redis_cluster_id(self) -> str:
        """
        The OCID of the cluster
        """
        return pulumi.get(self, "redis_cluster_id")

    @property
    @pulumi.getter(name="redisNodeCollections")
    def redis_node_collections(self) -> Sequence['outputs.GetRedisClusterNodesRedisNodeCollectionResult']:
        """
        The list of redis_node_collection.
        """
        return pulumi.get(self, "redis_node_collections")


class AwaitableGetRedisClusterNodesResult(GetRedisClusterNodesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRedisClusterNodesResult(
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            redis_cluster_id=self.redis_cluster_id,
            redis_node_collections=self.redis_node_collections)


def get_redis_cluster_nodes(display_name: Optional[str] = None,
                            filters: Optional[Sequence[Union['GetRedisClusterNodesFilterArgs', 'GetRedisClusterNodesFilterArgsDict']]] = None,
                            redis_cluster_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRedisClusterNodesResult:
    """
    This data source provides the list of Redis Cluster Nodes in Oracle Cloud Infrastructure Redis service.

    Gets the list of all nodes in a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_redis_cluster_nodes = oci.Redis.get_redis_cluster_nodes(redis_cluster_id=test_redis_cluster["id"],
        display_name=redis_cluster_node_display_name)
    ```


    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['redisClusterId'] = redis_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Redis/getRedisClusterNodes:getRedisClusterNodes', __args__, opts=opts, typ=GetRedisClusterNodesResult).value

    return AwaitableGetRedisClusterNodesResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        redis_cluster_id=pulumi.get(__ret__, 'redis_cluster_id'),
        redis_node_collections=pulumi.get(__ret__, 'redis_node_collections'))
def get_redis_cluster_nodes_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRedisClusterNodesFilterArgs', 'GetRedisClusterNodesFilterArgsDict']]]]] = None,
                                   redis_cluster_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRedisClusterNodesResult]:
    """
    This data source provides the list of Redis Cluster Nodes in Oracle Cloud Infrastructure Redis service.

    Gets the list of all nodes in a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_redis_cluster_nodes = oci.Redis.get_redis_cluster_nodes(redis_cluster_id=test_redis_cluster["id"],
        display_name=redis_cluster_node_display_name)
    ```


    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['redisClusterId'] = redis_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Redis/getRedisClusterNodes:getRedisClusterNodes', __args__, opts=opts, typ=GetRedisClusterNodesResult)
    return __ret__.apply(lambda __response__: GetRedisClusterNodesResult(
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        redis_cluster_id=pulumi.get(__response__, 'redis_cluster_id'),
        redis_node_collections=pulumi.get(__response__, 'redis_node_collections')))
