# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SubscriptionMappingArgs', 'SubscriptionMapping']

@pulumi.input_type
class SubscriptionMappingArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 subscription_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a SubscriptionMapping resource.
        :param pulumi.Input[str] compartment_id: OCID of the compartment. Always a tenancy OCID.
        :param pulumi.Input[str] subscription_id: OCID of Subscription.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        OCID of the compartment. Always a tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[str]:
        """
        OCID of Subscription.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class _SubscriptionMappingState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_explicitly_assigned: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_terminated: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SubscriptionMapping resources.
        :param pulumi.Input[str] compartment_id: OCID of the compartment. Always a tenancy OCID.
        :param pulumi.Input[bool] is_explicitly_assigned: Denotes if the subscription is explicity assigned to the root compartment or tenancy.
        :param pulumi.Input[str] state: Lifecycle state of the subscriptionMapping.
        :param pulumi.Input[str] subscription_id: OCID of Subscription.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: Date-time when subscription mapping was created.
        :param pulumi.Input[str] time_terminated: Date-time when subscription mapping was terminated.
        :param pulumi.Input[str] time_updated: Date-time when subscription mapping was updated.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if is_explicitly_assigned is not None:
            pulumi.set(__self__, "is_explicitly_assigned", is_explicitly_assigned)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_terminated is not None:
            pulumi.set(__self__, "time_terminated", time_terminated)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the compartment. Always a tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isExplicitlyAssigned")
    def is_explicitly_assigned(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes if the subscription is explicity assigned to the root compartment or tenancy.
        """
        return pulumi.get(self, "is_explicitly_assigned")

    @is_explicitly_assigned.setter
    def is_explicitly_assigned(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_explicitly_assigned", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Lifecycle state of the subscriptionMapping.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of Subscription.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Date-time when subscription mapping was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeTerminated")
    def time_terminated(self) -> Optional[pulumi.Input[str]]:
        """
        Date-time when subscription mapping was terminated.
        """
        return pulumi.get(self, "time_terminated")

    @time_terminated.setter
    def time_terminated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_terminated", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Date-time when subscription mapping was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class SubscriptionMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Subscription Mapping resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

        Assign the tenancy record identified by the compartment ID to the given subscription ID.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_subscription_mapping = oci.tenantmanagercontrolplane.SubscriptionMapping("test_subscription_mapping",
            compartment_id=compartment_id,
            subscription_id=test_subscription["id"])
        ```

        ## Import

        SubscriptionMappings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Tenantmanagercontrolplane/subscriptionMapping:SubscriptionMapping test_subscription_mapping "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: OCID of the compartment. Always a tenancy OCID.
        :param pulumi.Input[str] subscription_id: OCID of Subscription.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Subscription Mapping resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

        Assign the tenancy record identified by the compartment ID to the given subscription ID.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_subscription_mapping = oci.tenantmanagercontrolplane.SubscriptionMapping("test_subscription_mapping",
            compartment_id=compartment_id,
            subscription_id=test_subscription["id"])
        ```

        ## Import

        SubscriptionMappings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Tenantmanagercontrolplane/subscriptionMapping:SubscriptionMapping test_subscription_mapping "id"
        ```

        :param str resource_name: The name of the resource.
        :param SubscriptionMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionMappingArgs.__new__(SubscriptionMappingArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_id'")
            __props__.__dict__["subscription_id"] = subscription_id
            __props__.__dict__["is_explicitly_assigned"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_terminated"] = None
            __props__.__dict__["time_updated"] = None
        super(SubscriptionMapping, __self__).__init__(
            'oci:Tenantmanagercontrolplane/subscriptionMapping:SubscriptionMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            is_explicitly_assigned: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subscription_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_terminated: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'SubscriptionMapping':
        """
        Get an existing SubscriptionMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: OCID of the compartment. Always a tenancy OCID.
        :param pulumi.Input[bool] is_explicitly_assigned: Denotes if the subscription is explicity assigned to the root compartment or tenancy.
        :param pulumi.Input[str] state: Lifecycle state of the subscriptionMapping.
        :param pulumi.Input[str] subscription_id: OCID of Subscription.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: Date-time when subscription mapping was created.
        :param pulumi.Input[str] time_terminated: Date-time when subscription mapping was terminated.
        :param pulumi.Input[str] time_updated: Date-time when subscription mapping was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionMappingState.__new__(_SubscriptionMappingState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["is_explicitly_assigned"] = is_explicitly_assigned
        __props__.__dict__["state"] = state
        __props__.__dict__["subscription_id"] = subscription_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_terminated"] = time_terminated
        __props__.__dict__["time_updated"] = time_updated
        return SubscriptionMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        OCID of the compartment. Always a tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="isExplicitlyAssigned")
    def is_explicitly_assigned(self) -> pulumi.Output[bool]:
        """
        Denotes if the subscription is explicity assigned to the root compartment or tenancy.
        """
        return pulumi.get(self, "is_explicitly_assigned")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Lifecycle state of the subscriptionMapping.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[str]:
        """
        OCID of Subscription.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Date-time when subscription mapping was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeTerminated")
    def time_terminated(self) -> pulumi.Output[str]:
        """
        Date-time when subscription mapping was terminated.
        """
        return pulumi.get(self, "time_terminated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        Date-time when subscription mapping was updated.
        """
        return pulumi.get(self, "time_updated")

