"""
Alembic environment configuration.
"""
from sqlalchemy import engine_from_config, pool
from alembic import context
import os
import sys
from logging.config import fileConfig

# Insert the parent directory of env.py to sys.path
sys.path.insert(0, os.path.abspath(
    os.path.join(os.path.dirname(__file__), '..')))

try:
    from app.core.db.base import Base
    from app.core.config import settings
    from app.core.db.session import SessionLocal
    from app.auth.crud import create_superuser
except:
    raise

config = context.config
fileConfig(config.config_file_name or "")
config.set_main_option('sqlalchemy.url', settings.database_url)
target_metadata = Base.metadata


def run_migrations_offline() -> None:
    """Run migrations in 'offline' mode."""
    url = config.get_main_option('sqlalchemy.url')
    context.configure(
        url=url,
        target_metadata=target_metadata,
        literal_binds=True,
        dialect_opts={"paramstyle": "named"},
    )
    with context.begin_transaction():
        context.run_migrations()


def run_migrations_online() -> None:
    """Run migrations in 'online' mode."""
    connectable = engine_from_config(
        config.get_section(config.config_ini_section),  # type: ignore
        prefix='sqlalchemy.',
        poolclass=pool.NullPool,
    )
    with connectable.connect() as connection:
        context.configure(
            connection=connection,
            target_metadata=target_metadata,
        )
        with context.begin_transaction():
            context.run_migrations()


if context.is_offline_mode():
    run_migrations_offline()
else:
    run_migrations_online()
