# coding: utf-8

"""
    AHS Orchestrator
    AHS Orchestrator API's  # noqa: E501
    The version of the OpenAPI document: 1.0.0
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from ahs_orchestator_client.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]

Message: typing_extensions.TypeAlias = schemas.StrSchema
Inprogress: typing_extensions.TypeAlias = schemas.BoolSchema
TestbedId: typing_extensions.TypeAlias = schemas.IntSchema
BuildNumber: typing_extensions.TypeAlias = schemas.IntSchema
BuildDuration: typing_extensions.TypeAlias = schemas.IntSchema
TestbedHealthStatus: typing_extensions.TypeAlias = schemas.StrSchema

from ahs_orchestator_client.components.schema import testbed_status_enum
Properties = typing.TypedDict(
    'Properties',
    {
        "message": typing.Type[Message],
        "inprogress": typing.Type[Inprogress],
        "testbed_id": typing.Type[TestbedId],
        "build_number": typing.Type[BuildNumber],
        "build_duration": typing.Type[BuildDuration],
        "testbed_health_status": typing.Type[TestbedHealthStatus],
        "status": typing.Type[testbed_status_enum.TestbedStatusEnum],
    }
)


class BuildDetailsResponseModelDict(schemas.immutabledict[str, schemas.OUTPUT_BASE_TYPES]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
        "inprogress",
        "message",
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
        "testbed_id",
        "build_number",
        "build_duration",
        "testbed_health_status",
        "status",
    })
    
    def __new__(
        cls,
        *,
        inprogress: bool,
        message: str,
        testbed_id: typing.Union[
            int,
            schemas.Unset
        ] = schemas.unset,
        build_number: typing.Union[
            int,
            schemas.Unset
        ] = schemas.unset,
        build_duration: typing.Union[
            int,
            schemas.Unset
        ] = schemas.unset,
        testbed_health_status: typing.Union[
            str,
            schemas.Unset
        ] = schemas.unset,
        status: typing.Union[
            int,
            float,
            schemas.Unset
        ] = schemas.unset,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
        **kwargs: schemas.INPUT_TYPES_ALL,
    ):
        arg_: typing.Dict[str, typing.Any] = {
            "inprogress": inprogress,
            "message": message,
        }
        for key_, val in (
            ("testbed_id", testbed_id),
            ("build_number", build_number),
            ("build_duration", build_duration),
            ("testbed_health_status", testbed_health_status),
            ("status", status),
        ):
            if isinstance(val, schemas.Unset):
                continue
            arg_[key_] = val
        arg_.update(kwargs)
        used_arg_ = typing.cast(BuildDetailsResponseModelDictInput, arg_)
        return BuildDetailsResponseModel.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            BuildDetailsResponseModelDictInput,
            BuildDetailsResponseModelDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> BuildDetailsResponseModelDict:
        return BuildDetailsResponseModel.validate(arg, configuration=configuration)
    
    @property
    def inprogress(self) -> bool:
        return typing.cast(
            bool,
            self.__getitem__("inprogress")
        )
    
    @property
    def message(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("message")
        )
    
    @property
    def testbed_id(self) -> typing.Union[int, schemas.Unset]:
        val = self.get("testbed_id", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            int,
            val
        )
    
    @property
    def build_number(self) -> typing.Union[int, schemas.Unset]:
        val = self.get("build_number", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            int,
            val
        )
    
    @property
    def build_duration(self) -> typing.Union[int, schemas.Unset]:
        val = self.get("build_duration", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            int,
            val
        )
    
    @property
    def testbed_health_status(self) -> typing.Union[str, schemas.Unset]:
        val = self.get("testbed_health_status", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            str,
            val
        )
    
    @property
    def status(self) -> typing.Union[int, float, schemas.Unset]:
        val = self.get("status", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            typing.Union[int, float],
            val
        )
    
    def get_additional_property_(self, name: str) -> typing.Union[schemas.OUTPUT_BASE_TYPES, schemas.Unset]:
        schemas.raise_if_key_known(name, self.__required_keys__, self.__optional_keys__)
        return self.get(name, schemas.unset)
BuildDetailsResponseModelDictInput = typing.Mapping[str, schemas.INPUT_TYPES_ALL]


@dataclasses.dataclass(frozen=True)
class BuildDetailsResponseModel(
    schemas.Schema[BuildDetailsResponseModelDict, tuple]
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.
    """
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    required: typing.FrozenSet[str] = frozenset({
        "inprogress",
        "message",
    })
    properties: Properties = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties)) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: BuildDetailsResponseModelDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            BuildDetailsResponseModelDictInput,
            BuildDetailsResponseModelDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> BuildDetailsResponseModelDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

