/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeAccountsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/data-sources/accounts#id DataSnowflakeAccounts#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies an account name pattern. If a pattern is specified, only accounts matching the pattern are returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/data-sources/accounts#pattern DataSnowflakeAccounts#pattern}
    */
    readonly pattern?: string;
}
export interface DataSnowflakeAccountsAccounts {
}
export declare function dataSnowflakeAccountsAccountsToTerraform(struct?: DataSnowflakeAccountsAccounts): any;
export declare function dataSnowflakeAccountsAccountsToHclTerraform(struct?: DataSnowflakeAccountsAccounts): any;
export declare class DataSnowflakeAccountsAccountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeAccountsAccounts | undefined;
    set internalValue(value: DataSnowflakeAccountsAccounts | undefined);
    get accountLocator(): string;
    get accountLocatorUrl(): string;
    get accountName(): string;
    get accountUrl(): string;
    get comment(): string;
    get consumptionBillingEntityName(): string;
    get createdOn(): string;
    get edition(): string;
    get isOrgAdmin(): cdktf.IResolvable;
    get managedAccounts(): number;
    get marketplaceConsumerBillingEntityName(): string;
    get marketplaceProviderBillingEntityName(): string;
    get oldAccountUrl(): string;
    get organizationName(): string;
    get regionGroup(): string;
    get snowflakeRegion(): string;
}
export declare class DataSnowflakeAccountsAccountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeAccountsAccountsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/data-sources/accounts snowflake_accounts}
*/
export declare class DataSnowflakeAccounts extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_accounts";
    /**
    * Generates CDKTF code for importing a DataSnowflakeAccounts resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeAccounts to import
    * @param importFromId The id of the existing DataSnowflakeAccounts that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/data-sources/accounts#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeAccounts to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/data-sources/accounts snowflake_accounts} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeAccountsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeAccountsConfig);
    private _accounts;
    get accounts(): DataSnowflakeAccountsAccountsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
