/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExternalFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the API integration object that should be used to authenticate the call to the proxy service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#api_integration ExternalFunction#api_integration}
    */
    readonly apiIntegration: string;
    /**
    * A description of the external function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#comment ExternalFunction#comment}
    */
    readonly comment?: string;
    /**
    * If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#compression ExternalFunction#compression}
    */
    readonly compression?: string;
    /**
    * Binds Snowflake context function results to HTTP headers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#context_headers ExternalFunction#context_headers}
    */
    readonly contextHeaders?: string[];
    /**
    * The database in which to create the external function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#database ExternalFunction#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#id ExternalFunction#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * This specifies the maximum number of rows in each batch sent to the proxy service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#max_batch_rows ExternalFunction#max_batch_rows}
    */
    readonly maxBatchRows?: number;
    /**
    * Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#name ExternalFunction#name}
    */
    readonly name: string;
    /**
    * Specifies the behavior of the external function when called with null inputs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#null_input_behavior ExternalFunction#null_input_behavior}
    */
    readonly nullInputBehavior?: string;
    /**
    * This specifies the name of the request translator function
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#request_translator ExternalFunction#request_translator}
    */
    readonly requestTranslator?: string;
    /**
    * This specifies the name of the response translator function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#response_translator ExternalFunction#response_translator}
    */
    readonly responseTranslator?: string;
    /**
    * Specifies the behavior of the function when returning results
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#return_behavior ExternalFunction#return_behavior}
    */
    readonly returnBehavior: string;
    /**
    * Indicates whether the function can return NULL values (true) or must return only NON-NULL values (false).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#return_null_allowed ExternalFunction#return_null_allowed}
    */
    readonly returnNullAllowed?: boolean | cdktf.IResolvable;
    /**
    * Specifies the data type returned by the external function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#return_type ExternalFunction#return_type}
    */
    readonly returnType: string;
    /**
    * The schema in which to create the external function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#schema ExternalFunction#schema}
    */
    readonly schema: string;
    /**
    * This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#url_of_proxy_and_resource ExternalFunction#url_of_proxy_and_resource}
    */
    readonly urlOfProxyAndResource: string;
    /**
    * arg block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#arg ExternalFunction#arg}
    */
    readonly arg?: ExternalFunctionArg[] | cdktf.IResolvable;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#header ExternalFunction#header}
    */
    readonly header?: ExternalFunctionHeader[] | cdktf.IResolvable;
}
export interface ExternalFunctionArg {
    /**
    * Argument name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#name ExternalFunction#name}
    */
    readonly name: string;
    /**
    * Argument type, e.g. VARCHAR
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#type ExternalFunction#type}
    */
    readonly type: string;
}
export declare function externalFunctionArgToTerraform(struct?: ExternalFunctionArg | cdktf.IResolvable): any;
export declare function externalFunctionArgToHclTerraform(struct?: ExternalFunctionArg | cdktf.IResolvable): any;
export declare class ExternalFunctionArgOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalFunctionArg | cdktf.IResolvable | undefined;
    set internalValue(value: ExternalFunctionArg | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ExternalFunctionArgList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ExternalFunctionArg[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalFunctionArgOutputReference;
}
export interface ExternalFunctionHeader {
    /**
    * Header name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#name ExternalFunction#name}
    */
    readonly name: string;
    /**
    * Header value
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#value ExternalFunction#value}
    */
    readonly value: string;
}
export declare function externalFunctionHeaderToTerraform(struct?: ExternalFunctionHeader | cdktf.IResolvable): any;
export declare function externalFunctionHeaderToHclTerraform(struct?: ExternalFunctionHeader | cdktf.IResolvable): any;
export declare class ExternalFunctionHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalFunctionHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ExternalFunctionHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ExternalFunctionHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ExternalFunctionHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalFunctionHeaderOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function snowflake_external_function}
*/
export declare class ExternalFunction extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_external_function";
    /**
    * Generates CDKTF code for importing a ExternalFunction resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ExternalFunction to import
    * @param importFromId The id of the existing ExternalFunction that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ExternalFunction to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/external_function snowflake_external_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExternalFunctionConfig
    */
    constructor(scope: Construct, id: string, config: ExternalFunctionConfig);
    private _apiIntegration?;
    get apiIntegration(): string;
    set apiIntegration(value: string);
    get apiIntegrationInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _compression?;
    get compression(): string;
    set compression(value: string);
    resetCompression(): void;
    get compressionInput(): string | undefined;
    private _contextHeaders?;
    get contextHeaders(): string[];
    set contextHeaders(value: string[]);
    resetContextHeaders(): void;
    get contextHeadersInput(): string[] | undefined;
    get createdOn(): string;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxBatchRows?;
    get maxBatchRows(): number;
    set maxBatchRows(value: number);
    resetMaxBatchRows(): void;
    get maxBatchRowsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    get nullInputBehavior(): string;
    set nullInputBehavior(value: string);
    resetNullInputBehavior(): void;
    get nullInputBehaviorInput(): string | undefined;
    private _requestTranslator?;
    get requestTranslator(): string;
    set requestTranslator(value: string);
    resetRequestTranslator(): void;
    get requestTranslatorInput(): string | undefined;
    private _responseTranslator?;
    get responseTranslator(): string;
    set responseTranslator(value: string);
    resetResponseTranslator(): void;
    get responseTranslatorInput(): string | undefined;
    private _returnBehavior?;
    get returnBehavior(): string;
    set returnBehavior(value: string);
    get returnBehaviorInput(): string | undefined;
    private _returnNullAllowed?;
    get returnNullAllowed(): boolean | cdktf.IResolvable;
    set returnNullAllowed(value: boolean | cdktf.IResolvable);
    resetReturnNullAllowed(): void;
    get returnNullAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    get returnTypeInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _urlOfProxyAndResource?;
    get urlOfProxyAndResource(): string;
    set urlOfProxyAndResource(value: string);
    get urlOfProxyAndResourceInput(): string | undefined;
    private _arg;
    get arg(): ExternalFunctionArgList;
    putArg(value: ExternalFunctionArg[] | cdktf.IResolvable): void;
    resetArg(): void;
    get argInput(): cdktf.IResolvable | ExternalFunctionArg[] | undefined;
    private _header;
    get header(): ExternalFunctionHeaderList;
    putHeader(value: ExternalFunctionHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ExternalFunctionHeader[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
