/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantPrivilegesToAccountRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The fully qualified name of the account role to which privileges will be granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#account_role_name GrantPrivilegesToAccountRole#account_role_name}
    */
    readonly accountRoleName: string;
    /**
    * Grant all privileges on the account role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#all_privileges GrantPrivilegesToAccountRole#all_privileges}
    */
    readonly allPrivileges?: boolean | cdktf.IResolvable;
    /**
    * If true, the resource will always produce a “plan” and on “apply” it will re-grant defined privileges. It is supposed to be used only in “grant privileges on all X’s in database / schema Y” or “grant all privileges to X” scenarios to make sure that every new object in a given database / schema is granted by the account role and every new privilege is granted to the database role. Important note: this flag is not compliant with the Terraform assumptions of the config being eventually convergent (producing an empty plan).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#always_apply GrantPrivilegesToAccountRole#always_apply}
    */
    readonly alwaysApply?: boolean | cdktf.IResolvable;
    /**
    * This is a helper field and should not be set. Its main purpose is to help to achieve the functionality described by the always_apply field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#always_apply_trigger GrantPrivilegesToAccountRole#always_apply_trigger}
    */
    readonly alwaysApplyTrigger?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#id GrantPrivilegesToAccountRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If true, the privileges will be granted on the account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#on_account GrantPrivilegesToAccountRole#on_account}
    */
    readonly onAccount?: boolean | cdktf.IResolvable;
    /**
    * The privileges to grant on the account role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#privileges GrantPrivilegesToAccountRole#privileges}
    */
    readonly privileges?: string[];
    /**
    * Specifies whether the grantee can grant the privileges to other users.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#with_grant_option GrantPrivilegesToAccountRole#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
    /**
    * on_account_object block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#on_account_object GrantPrivilegesToAccountRole#on_account_object}
    */
    readonly onAccountObject?: GrantPrivilegesToAccountRoleOnAccountObject;
    /**
    * on_schema block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#on_schema GrantPrivilegesToAccountRole#on_schema}
    */
    readonly onSchema?: GrantPrivilegesToAccountRoleOnSchema;
    /**
    * on_schema_object block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#on_schema_object GrantPrivilegesToAccountRole#on_schema_object}
    */
    readonly onSchemaObject?: GrantPrivilegesToAccountRoleOnSchemaObject;
}
export interface GrantPrivilegesToAccountRoleOnAccountObject {
    /**
    * The fully qualified name of the object on which privileges will be granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#object_name GrantPrivilegesToAccountRole#object_name}
    */
    readonly objectName: string;
    /**
    * The object type of the account object on which privileges will be granted. Valid values are: USER | RESOURCE MONITOR | WAREHOUSE | COMPUTE POOL | DATABASE | INTEGRATION | FAILOVER GROUP | REPLICATION GROUP | EXTERNAL VOLUME
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#object_type GrantPrivilegesToAccountRole#object_type}
    */
    readonly objectType: string;
}
export declare function grantPrivilegesToAccountRoleOnAccountObjectToTerraform(struct?: GrantPrivilegesToAccountRoleOnAccountObjectOutputReference | GrantPrivilegesToAccountRoleOnAccountObject): any;
export declare function grantPrivilegesToAccountRoleOnAccountObjectToHclTerraform(struct?: GrantPrivilegesToAccountRoleOnAccountObjectOutputReference | GrantPrivilegesToAccountRoleOnAccountObject): any;
export declare class GrantPrivilegesToAccountRoleOnAccountObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToAccountRoleOnAccountObject | undefined;
    set internalValue(value: GrantPrivilegesToAccountRoleOnAccountObject | undefined);
    private _objectName?;
    get objectName(): string;
    set objectName(value: string);
    get objectNameInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    get objectTypeInput(): string | undefined;
}
export interface GrantPrivilegesToAccountRoleOnSchema {
    /**
    * The fully qualified name of the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#all_schemas_in_database GrantPrivilegesToAccountRole#all_schemas_in_database}
    */
    readonly allSchemasInDatabase?: string;
    /**
    * The fully qualified name of the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#future_schemas_in_database GrantPrivilegesToAccountRole#future_schemas_in_database}
    */
    readonly futureSchemasInDatabase?: string;
    /**
    * The fully qualified name of the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#schema_name GrantPrivilegesToAccountRole#schema_name}
    */
    readonly schemaName?: string;
}
export declare function grantPrivilegesToAccountRoleOnSchemaToTerraform(struct?: GrantPrivilegesToAccountRoleOnSchemaOutputReference | GrantPrivilegesToAccountRoleOnSchema): any;
export declare function grantPrivilegesToAccountRoleOnSchemaToHclTerraform(struct?: GrantPrivilegesToAccountRoleOnSchemaOutputReference | GrantPrivilegesToAccountRoleOnSchema): any;
export declare class GrantPrivilegesToAccountRoleOnSchemaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToAccountRoleOnSchema | undefined;
    set internalValue(value: GrantPrivilegesToAccountRoleOnSchema | undefined);
    private _allSchemasInDatabase?;
    get allSchemasInDatabase(): string;
    set allSchemasInDatabase(value: string);
    resetAllSchemasInDatabase(): void;
    get allSchemasInDatabaseInput(): string | undefined;
    private _futureSchemasInDatabase?;
    get futureSchemasInDatabase(): string;
    set futureSchemasInDatabase(value: string);
    resetFutureSchemasInDatabase(): void;
    get futureSchemasInDatabaseInput(): string | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    resetSchemaName(): void;
    get schemaNameInput(): string | undefined;
}
export interface GrantPrivilegesToAccountRoleOnSchemaObjectAll {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#in_database GrantPrivilegesToAccountRole#in_database}
    */
    readonly inDatabase?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#in_schema GrantPrivilegesToAccountRole#in_schema}
    */
    readonly inSchema?: string;
    /**
    * The plural object type of the schema object on which privileges will be granted. Valid values are: ALERTS | DYNAMIC TABLES | EVENT TABLES | FILE FORMATS | FUNCTIONS | PROCEDURES | SECRETS | SEQUENCES | PIPES | MASKING POLICIES | PASSWORD POLICIES | ROW ACCESS POLICIES | SESSION POLICIES | TAGS | STAGES | STREAMS | TABLES | EXTERNAL TABLES | TASKS | VIEWS | MATERIALIZED VIEWS | NETWORK RULES | PACKAGES POLICIES | ICEBERG TABLES
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#object_type_plural GrantPrivilegesToAccountRole#object_type_plural}
    */
    readonly objectTypePlural: string;
}
export declare function grantPrivilegesToAccountRoleOnSchemaObjectAllToTerraform(struct?: GrantPrivilegesToAccountRoleOnSchemaObjectAllOutputReference | GrantPrivilegesToAccountRoleOnSchemaObjectAll): any;
export declare function grantPrivilegesToAccountRoleOnSchemaObjectAllToHclTerraform(struct?: GrantPrivilegesToAccountRoleOnSchemaObjectAllOutputReference | GrantPrivilegesToAccountRoleOnSchemaObjectAll): any;
export declare class GrantPrivilegesToAccountRoleOnSchemaObjectAllOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToAccountRoleOnSchemaObjectAll | undefined;
    set internalValue(value: GrantPrivilegesToAccountRoleOnSchemaObjectAll | undefined);
    private _inDatabase?;
    get inDatabase(): string;
    set inDatabase(value: string);
    resetInDatabase(): void;
    get inDatabaseInput(): string | undefined;
    private _inSchema?;
    get inSchema(): string;
    set inSchema(value: string);
    resetInSchema(): void;
    get inSchemaInput(): string | undefined;
    private _objectTypePlural?;
    get objectTypePlural(): string;
    set objectTypePlural(value: string);
    get objectTypePluralInput(): string | undefined;
}
export interface GrantPrivilegesToAccountRoleOnSchemaObjectFuture {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#in_database GrantPrivilegesToAccountRole#in_database}
    */
    readonly inDatabase?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#in_schema GrantPrivilegesToAccountRole#in_schema}
    */
    readonly inSchema?: string;
    /**
    * The plural object type of the schema object on which privileges will be granted. Valid values are: ALERTS | DYNAMIC TABLES | EVENT TABLES | FILE FORMATS | FUNCTIONS | PROCEDURES | SECRETS | SEQUENCES | PIPES | MASKING POLICIES | PASSWORD POLICIES | ROW ACCESS POLICIES | SESSION POLICIES | TAGS | STAGES | STREAMS | TABLES | EXTERNAL TABLES | TASKS | VIEWS | MATERIALIZED VIEWS | NETWORK RULES | PACKAGES POLICIES | ICEBERG TABLES
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#object_type_plural GrantPrivilegesToAccountRole#object_type_plural}
    */
    readonly objectTypePlural: string;
}
export declare function grantPrivilegesToAccountRoleOnSchemaObjectFutureToTerraform(struct?: GrantPrivilegesToAccountRoleOnSchemaObjectFutureOutputReference | GrantPrivilegesToAccountRoleOnSchemaObjectFuture): any;
export declare function grantPrivilegesToAccountRoleOnSchemaObjectFutureToHclTerraform(struct?: GrantPrivilegesToAccountRoleOnSchemaObjectFutureOutputReference | GrantPrivilegesToAccountRoleOnSchemaObjectFuture): any;
export declare class GrantPrivilegesToAccountRoleOnSchemaObjectFutureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToAccountRoleOnSchemaObjectFuture | undefined;
    set internalValue(value: GrantPrivilegesToAccountRoleOnSchemaObjectFuture | undefined);
    private _inDatabase?;
    get inDatabase(): string;
    set inDatabase(value: string);
    resetInDatabase(): void;
    get inDatabaseInput(): string | undefined;
    private _inSchema?;
    get inSchema(): string;
    set inSchema(value: string);
    resetInSchema(): void;
    get inSchemaInput(): string | undefined;
    private _objectTypePlural?;
    get objectTypePlural(): string;
    set objectTypePlural(value: string);
    get objectTypePluralInput(): string | undefined;
}
export interface GrantPrivilegesToAccountRoleOnSchemaObject {
    /**
    * The fully qualified name of the object on which privileges will be granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#object_name GrantPrivilegesToAccountRole#object_name}
    */
    readonly objectName?: string;
    /**
    * The object type of the schema object on which privileges will be granted. Valid values are: ALERT | DYNAMIC TABLE | EVENT TABLE | FILE FORMAT | FUNCTION | PROCEDURE | SECRET | SEQUENCE | PIPE | MASKING POLICY | PASSWORD POLICY | ROW ACCESS POLICY | SESSION POLICY | TAG | STAGE | STREAM | TABLE | EXTERNAL TABLE | TASK | VIEW | MATERIALIZED VIEW | NETWORK RULE | PACKAGES POLICY | ICEBERG TABLE
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#object_type GrantPrivilegesToAccountRole#object_type}
    */
    readonly objectType?: string;
    /**
    * all block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#all GrantPrivilegesToAccountRole#all}
    */
    readonly all?: GrantPrivilegesToAccountRoleOnSchemaObjectAll;
    /**
    * future block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#future GrantPrivilegesToAccountRole#future}
    */
    readonly future?: GrantPrivilegesToAccountRoleOnSchemaObjectFuture;
}
export declare function grantPrivilegesToAccountRoleOnSchemaObjectToTerraform(struct?: GrantPrivilegesToAccountRoleOnSchemaObjectOutputReference | GrantPrivilegesToAccountRoleOnSchemaObject): any;
export declare function grantPrivilegesToAccountRoleOnSchemaObjectToHclTerraform(struct?: GrantPrivilegesToAccountRoleOnSchemaObjectOutputReference | GrantPrivilegesToAccountRoleOnSchemaObject): any;
export declare class GrantPrivilegesToAccountRoleOnSchemaObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrantPrivilegesToAccountRoleOnSchemaObject | undefined;
    set internalValue(value: GrantPrivilegesToAccountRoleOnSchemaObject | undefined);
    private _objectName?;
    get objectName(): string;
    set objectName(value: string);
    resetObjectName(): void;
    get objectNameInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    resetObjectType(): void;
    get objectTypeInput(): string | undefined;
    private _all;
    get all(): GrantPrivilegesToAccountRoleOnSchemaObjectAllOutputReference;
    putAll(value: GrantPrivilegesToAccountRoleOnSchemaObjectAll): void;
    resetAll(): void;
    get allInput(): GrantPrivilegesToAccountRoleOnSchemaObjectAll | undefined;
    private _future;
    get future(): GrantPrivilegesToAccountRoleOnSchemaObjectFutureOutputReference;
    putFuture(value: GrantPrivilegesToAccountRoleOnSchemaObjectFuture): void;
    resetFuture(): void;
    get futureInput(): GrantPrivilegesToAccountRoleOnSchemaObjectFuture | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role snowflake_grant_privileges_to_account_role}
*/
export declare class GrantPrivilegesToAccountRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_grant_privileges_to_account_role";
    /**
    * Generates CDKTF code for importing a GrantPrivilegesToAccountRole resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GrantPrivilegesToAccountRole to import
    * @param importFromId The id of the existing GrantPrivilegesToAccountRole that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GrantPrivilegesToAccountRole to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/grant_privileges_to_account_role snowflake_grant_privileges_to_account_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantPrivilegesToAccountRoleConfig
    */
    constructor(scope: Construct, id: string, config: GrantPrivilegesToAccountRoleConfig);
    private _accountRoleName?;
    get accountRoleName(): string;
    set accountRoleName(value: string);
    get accountRoleNameInput(): string | undefined;
    private _allPrivileges?;
    get allPrivileges(): boolean | cdktf.IResolvable;
    set allPrivileges(value: boolean | cdktf.IResolvable);
    resetAllPrivileges(): void;
    get allPrivilegesInput(): boolean | cdktf.IResolvable | undefined;
    private _alwaysApply?;
    get alwaysApply(): boolean | cdktf.IResolvable;
    set alwaysApply(value: boolean | cdktf.IResolvable);
    resetAlwaysApply(): void;
    get alwaysApplyInput(): boolean | cdktf.IResolvable | undefined;
    private _alwaysApplyTrigger?;
    get alwaysApplyTrigger(): string;
    set alwaysApplyTrigger(value: string);
    resetAlwaysApplyTrigger(): void;
    get alwaysApplyTriggerInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _onAccount?;
    get onAccount(): boolean | cdktf.IResolvable;
    set onAccount(value: boolean | cdktf.IResolvable);
    resetOnAccount(): void;
    get onAccountInput(): boolean | cdktf.IResolvable | undefined;
    private _privileges?;
    get privileges(): string[];
    set privileges(value: string[]);
    resetPrivileges(): void;
    get privilegesInput(): string[] | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    private _onAccountObject;
    get onAccountObject(): GrantPrivilegesToAccountRoleOnAccountObjectOutputReference;
    putOnAccountObject(value: GrantPrivilegesToAccountRoleOnAccountObject): void;
    resetOnAccountObject(): void;
    get onAccountObjectInput(): GrantPrivilegesToAccountRoleOnAccountObject | undefined;
    private _onSchema;
    get onSchema(): GrantPrivilegesToAccountRoleOnSchemaOutputReference;
    putOnSchema(value: GrantPrivilegesToAccountRoleOnSchema): void;
    resetOnSchema(): void;
    get onSchemaInput(): GrantPrivilegesToAccountRoleOnSchema | undefined;
    private _onSchemaObject;
    get onSchemaObject(): GrantPrivilegesToAccountRoleOnSchemaObjectOutputReference;
    putOnSchemaObject(value: GrantPrivilegesToAccountRoleOnSchemaObject): void;
    resetOnSchemaObject(): void;
    get onSchemaObjectInput(): GrantPrivilegesToAccountRoleOnSchemaObject | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
