/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MaskingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the masking policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#comment MaskingPolicy#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the masking policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#database MaskingPolicy#database}
    */
    readonly database: string;
    /**
    * Specifies whether the row access policy or conditional masking policy can reference a column that is already protected by a masking policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#exempt_other_policies MaskingPolicy#exempt_other_policies}
    */
    readonly exemptOtherPolicies?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#id MaskingPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Prevent overwriting a previous masking policy with the same name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#if_not_exists MaskingPolicy#if_not_exists}
    */
    readonly ifNotExists?: boolean | cdktf.IResolvable;
    /**
    * Specifies the SQL expression that transforms the data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#masking_expression MaskingPolicy#masking_expression}
    */
    readonly maskingExpression: string;
    /**
    * Specifies the identifier for the masking policy; must be unique for the database and schema in which the masking policy is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#name MaskingPolicy#name}
    */
    readonly name: string;
    /**
    * Whether to override a previous masking policy with the same name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#or_replace MaskingPolicy#or_replace}
    */
    readonly orReplace?: boolean | cdktf.IResolvable;
    /**
    * Specifies the data type to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#return_data_type MaskingPolicy#return_data_type}
    */
    readonly returnDataType: string;
    /**
    * The schema in which to create the masking policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#schema MaskingPolicy#schema}
    */
    readonly schema: string;
    /**
    * signature block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#signature MaskingPolicy#signature}
    */
    readonly signature: MaskingPolicySignature;
}
export interface MaskingPolicySignatureColumn {
    /**
    * Specifies the column name to mask.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#name MaskingPolicy#name}
    */
    readonly name: string;
    /**
    * Specifies the column type to mask.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#type MaskingPolicy#type}
    */
    readonly type: string;
}
export declare function maskingPolicySignatureColumnToTerraform(struct?: MaskingPolicySignatureColumn | cdktf.IResolvable): any;
export declare function maskingPolicySignatureColumnToHclTerraform(struct?: MaskingPolicySignatureColumn | cdktf.IResolvable): any;
export declare class MaskingPolicySignatureColumnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MaskingPolicySignatureColumn | cdktf.IResolvable | undefined;
    set internalValue(value: MaskingPolicySignatureColumn | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class MaskingPolicySignatureColumnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MaskingPolicySignatureColumn[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MaskingPolicySignatureColumnOutputReference;
}
export interface MaskingPolicySignature {
    /**
    * column block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#column MaskingPolicy#column}
    */
    readonly column: MaskingPolicySignatureColumn[] | cdktf.IResolvable;
}
export declare function maskingPolicySignatureToTerraform(struct?: MaskingPolicySignatureOutputReference | MaskingPolicySignature): any;
export declare function maskingPolicySignatureToHclTerraform(struct?: MaskingPolicySignatureOutputReference | MaskingPolicySignature): any;
export declare class MaskingPolicySignatureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MaskingPolicySignature | undefined;
    set internalValue(value: MaskingPolicySignature | undefined);
    private _column;
    get column(): MaskingPolicySignatureColumnList;
    putColumn(value: MaskingPolicySignatureColumn[] | cdktf.IResolvable): void;
    get columnInput(): cdktf.IResolvable | MaskingPolicySignatureColumn[] | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy snowflake_masking_policy}
*/
export declare class MaskingPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_masking_policy";
    /**
    * Generates CDKTF code for importing a MaskingPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MaskingPolicy to import
    * @param importFromId The id of the existing MaskingPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MaskingPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/masking_policy snowflake_masking_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MaskingPolicyConfig
    */
    constructor(scope: Construct, id: string, config: MaskingPolicyConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _exemptOtherPolicies?;
    get exemptOtherPolicies(): boolean | cdktf.IResolvable;
    set exemptOtherPolicies(value: boolean | cdktf.IResolvable);
    resetExemptOtherPolicies(): void;
    get exemptOtherPoliciesInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ifNotExists?;
    get ifNotExists(): boolean | cdktf.IResolvable;
    set ifNotExists(value: boolean | cdktf.IResolvable);
    resetIfNotExists(): void;
    get ifNotExistsInput(): boolean | cdktf.IResolvable | undefined;
    private _maskingExpression?;
    get maskingExpression(): string;
    set maskingExpression(value: string);
    get maskingExpressionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orReplace?;
    get orReplace(): boolean | cdktf.IResolvable;
    set orReplace(value: boolean | cdktf.IResolvable);
    resetOrReplace(): void;
    get orReplaceInput(): boolean | cdktf.IResolvable | undefined;
    get qualifiedName(): string;
    private _returnDataType?;
    get returnDataType(): string;
    set returnDataType(value: string);
    get returnDataTypeInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _signature;
    get signature(): MaskingPolicySignatureOutputReference;
    putSignature(value: MaskingPolicySignature): void;
    get signatureInput(): MaskingPolicySignature | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
