/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OauthIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of roles that a user cannot explicitly consent to using after authenticating. Do not include ACCOUNTADMIN, ORGADMIN or SECURITYADMIN as they are already implicitly enforced and will cause in-place updates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#blocked_roles_list OauthIntegration#blocked_roles_list}
    */
    readonly blockedRolesList?: string[];
    /**
    * Specifies a comment for the OAuth integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#comment OauthIntegration#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether this OAuth integration is enabled or disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#enabled OauthIntegration#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#id OauthIntegration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the name of the OAuth integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#name OauthIntegration#name}
    */
    readonly name: string;
    /**
    * Specifies the OAuth client type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#oauth_client OauthIntegration#oauth_client}
    */
    readonly oauthClient: string;
    /**
    * Specifies the type of client being registered. Snowflake supports both confidential and public clients.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#oauth_client_type OauthIntegration#oauth_client_type}
    */
    readonly oauthClientType?: string;
    /**
    * Specifies whether to allow the client to exchange a refresh token for an access token when the current access token has expired.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#oauth_issue_refresh_tokens OauthIntegration#oauth_issue_refresh_tokens}
    */
    readonly oauthIssueRefreshTokens?: boolean | cdktf.IResolvable;
    /**
    * Specifies the client URI. After a user is authenticated, the web browser is redirected to this URI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#oauth_redirect_uri OauthIntegration#oauth_redirect_uri}
    */
    readonly oauthRedirectUri?: string;
    /**
    * Specifies how long refresh tokens should be valid (in seconds). OAUTH_ISSUE_REFRESH_TOKENS must be set to TRUE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#oauth_refresh_token_validity OauthIntegration#oauth_refresh_token_validity}
    */
    readonly oauthRefreshTokenValidity?: number;
    /**
    * Specifies whether default secondary roles set in the user properties are activated by default in the session being opened.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#oauth_use_secondary_roles OauthIntegration#oauth_use_secondary_roles}
    */
    readonly oauthUseSecondaryRoles?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration snowflake_oauth_integration}
*/
export declare class OauthIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_oauth_integration";
    /**
    * Generates CDKTF code for importing a OauthIntegration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OauthIntegration to import
    * @param importFromId The id of the existing OauthIntegration that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OauthIntegration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/oauth_integration snowflake_oauth_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OauthIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: OauthIntegrationConfig);
    private _blockedRolesList?;
    get blockedRolesList(): string[];
    set blockedRolesList(value: string[]);
    resetBlockedRolesList(): void;
    get blockedRolesListInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    get createdOn(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oauthClient?;
    get oauthClient(): string;
    set oauthClient(value: string);
    get oauthClientInput(): string | undefined;
    private _oauthClientType?;
    get oauthClientType(): string;
    set oauthClientType(value: string);
    resetOauthClientType(): void;
    get oauthClientTypeInput(): string | undefined;
    private _oauthIssueRefreshTokens?;
    get oauthIssueRefreshTokens(): boolean | cdktf.IResolvable;
    set oauthIssueRefreshTokens(value: boolean | cdktf.IResolvable);
    resetOauthIssueRefreshTokens(): void;
    get oauthIssueRefreshTokensInput(): boolean | cdktf.IResolvable | undefined;
    private _oauthRedirectUri?;
    get oauthRedirectUri(): string;
    set oauthRedirectUri(value: string);
    resetOauthRedirectUri(): void;
    get oauthRedirectUriInput(): string | undefined;
    private _oauthRefreshTokenValidity?;
    get oauthRefreshTokenValidity(): number;
    set oauthRefreshTokenValidity(value: number);
    resetOauthRefreshTokenValidity(): void;
    get oauthRefreshTokenValidityInput(): number | undefined;
    private _oauthUseSecondaryRoles?;
    get oauthUseSecondaryRoles(): string;
    set oauthUseSecondaryRoles(value: string);
    resetOauthUseSecondaryRoles(): void;
    get oauthUseSecondaryRolesInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
