/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SnowflakeProviderConfig {
    /**
    * Specifies your Snowflake account identifier assigned, by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html). Can also be sourced from the `SNOWFLAKE_ACCOUNT` environment variable. Required unless using `profile`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#account SnowflakeProvider#account}
    */
    readonly account?: string;
    /**
    * Specifies the [authentication type](https://pkg.go.dev/github.com/snowflakedb/gosnowflake#AuthType) to use when connecting to Snowflake. Valid values include: Snowflake, OAuth, ExternalBrowser, Okta, JWT, TokenAccessor, UsernamePasswordMFA. Can also be sourced from the `SNOWFLAKE_AUTHENTICATOR` environment variable. It has to be set explicitly to JWT for private key authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#authenticator SnowflakeProvider#authenticator}
    */
    readonly authenticator?: string;
    /**
    * Required when `oauth_refresh_token` is used. Can also be sourced from `SNOWFLAKE_USE_BROWSER_AUTH` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#browser_auth SnowflakeProvider#browser_auth}
    */
    readonly browserAuth?: boolean | cdktf.IResolvable;
    /**
    * IP address for network checks. Can also be sourced from the `SNOWFLAKE_CLIENT_IP` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#client_ip SnowflakeProvider#client_ip}
    */
    readonly clientIp?: string;
    /**
    * When true the MFA token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_REQUEST_MFA_TOKEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#client_request_mfa_token SnowflakeProvider#client_request_mfa_token}
    */
    readonly clientRequestMfaToken?: boolean | cdktf.IResolvable;
    /**
    * When true the ID token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_STORE_TEMPORARY_CREDENTIAL` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#client_store_temporary_credential SnowflakeProvider#client_store_temporary_credential}
    */
    readonly clientStoreTemporaryCredential?: boolean | cdktf.IResolvable;
    /**
    * The timeout in seconds for the client to complete the authentication. Default is 900 seconds. Can also be sourced from the `SNOWFLAKE_CLIENT_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#client_timeout SnowflakeProvider#client_timeout}
    */
    readonly clientTimeout?: number;
    /**
    * Should HTAP query context cache be disabled. Can also be sourced from the `SNOWFLAKE_DISABLE_QUERY_CONTEXT_CACHE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#disable_query_context_cache SnowflakeProvider#disable_query_context_cache}
    */
    readonly disableQueryContextCache?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether to disable telemetry. Can also be sourced from the `SNOWFLAKE_DISABLE_TELEMETRY` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#disable_telemetry SnowflakeProvider#disable_telemetry}
    */
    readonly disableTelemetry?: boolean | cdktf.IResolvable;
    /**
    * The timeout in seconds for the external browser to complete the authentication. Default is 120 seconds. Can also be sourced from the `SNOWFLAKE_EXTERNAL_BROWSER_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#external_browser_timeout SnowflakeProvider#external_browser_timeout}
    */
    readonly externalBrowserTimeout?: number;
    /**
    * Supports passing in a custom host value to the snowflake go driver for use with privatelink. Can also be sourced from the `SNOWFLAKE_HOST` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#host SnowflakeProvider#host}
    */
    readonly host?: string;
    /**
    * If true, bypass the Online Certificate Status Protocol (OCSP) certificate revocation check. IMPORTANT: Change the default value for testing or emergency situations only. Can also be sourced from the `SNOWFLAKE_INSECURE_MODE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#insecure_mode SnowflakeProvider#insecure_mode}
    */
    readonly insecureMode?: boolean | cdktf.IResolvable;
    /**
    * The timeout in seconds for the JWT client to complete the authentication. Default is 10 seconds. Can also be sourced from the `SNOWFLAKE_JWT_CLIENT_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#jwt_client_timeout SnowflakeProvider#jwt_client_timeout}
    */
    readonly jwtClientTimeout?: number;
    /**
    * JWT expire after timeout in seconds. Can also be sourced from the `SNOWFLAKE_JWT_EXPIRE_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#jwt_expire_timeout SnowflakeProvider#jwt_expire_timeout}
    */
    readonly jwtExpireTimeout?: number;
    /**
    * Enables the session to persist even after the connection is closed. Can also be sourced from the `SNOWFLAKE_KEEP_SESSION_ALIVE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#keep_session_alive SnowflakeProvider#keep_session_alive}
    */
    readonly keepSessionAlive?: boolean | cdktf.IResolvable;
    /**
    * Login retry timeout EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_LOGIN_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#login_timeout SnowflakeProvider#login_timeout}
    */
    readonly loginTimeout?: number;
    /**
    * Token for use with OAuth. Generating the token is left to other tools. Cannot be used with `browser_auth`, `private_key_path`, `oauth_refresh_token` or `password`. Can also be sourced from `SNOWFLAKE_OAUTH_ACCESS_TOKEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#oauth_access_token SnowflakeProvider#oauth_access_token}
    */
    readonly oauthAccessToken?: string;
    /**
    * Required when `oauth_refresh_token` is used. Can also be sourced from `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#oauth_client_id SnowflakeProvider#oauth_client_id}
    */
    readonly oauthClientId?: string;
    /**
    * Required when `oauth_refresh_token` is used. Can also be sourced from `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#oauth_client_secret SnowflakeProvider#oauth_client_secret}
    */
    readonly oauthClientSecret?: string;
    /**
    * Required when `oauth_refresh_token` is used. Can also be sourced from `SNOWFLAKE_OAUTH_ENDPOINT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#oauth_endpoint SnowflakeProvider#oauth_endpoint}
    */
    readonly oauthEndpoint?: string;
    /**
    * Required when `oauth_refresh_token` is used. Can also be sourced from `SNOWFLAKE_OAUTH_REDIRECT_URL` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#oauth_redirect_url SnowflakeProvider#oauth_redirect_url}
    */
    readonly oauthRedirectUrl?: string;
    /**
    * Token for use with OAuth. Setup and generation of the token is left to other tools. Should be used in conjunction with `oauth_client_id`, `oauth_client_secret`, `oauth_endpoint`, `oauth_redirect_url`. Cannot be used with `browser_auth`, `private_key_path`, `oauth_access_token` or `password`. Can also be sourced from `SNOWFLAKE_OAUTH_REFRESH_TOKEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#oauth_refresh_token SnowflakeProvider#oauth_refresh_token}
    */
    readonly oauthRefreshToken?: string;
    /**
    * True represents OCSP fail open mode. False represents OCSP fail closed mode. Fail open true by default. Can also be sourced from the `SNOWFLAKE_OCSP_FAIL_OPEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#ocsp_fail_open SnowflakeProvider#ocsp_fail_open}
    */
    readonly ocspFailOpen?: boolean | cdktf.IResolvable;
    /**
    * The URL of the Okta server. e.g. https://example.okta.com. Can also be sourced from the `SNOWFLAKE_OKTA_URL` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#okta_url SnowflakeProvider#okta_url}
    */
    readonly oktaUrl?: string;
    /**
    * Sets other connection (i.e. session) parameters. [Parameters](https://docs.snowflake.com/en/sql-reference/parameters)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#params SnowflakeProvider#params}
    */
    readonly params?: {
        [key: string]: string;
    };
    /**
    * Specifies the passcode provided by Duo when using multi-factor authentication (MFA) for login. Can also be sourced from the `SNOWFLAKE_PASSCODE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#passcode SnowflakeProvider#passcode}
    */
    readonly passcode?: string;
    /**
    * False by default. Set to true if the MFA passcode is embedded in the login password. Appends the MFA passcode to the end of the password. Can also be sourced from the `SNOWFLAKE_PASSCODE_IN_PASSWORD` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#passcode_in_password SnowflakeProvider#passcode_in_password}
    */
    readonly passcodeInPassword?: boolean | cdktf.IResolvable;
    /**
    * Password for username+password auth. Cannot be used with `browser_auth` or `private_key_path`. Can also be sourced from the `SNOWFLAKE_PASSWORD` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#password SnowflakeProvider#password}
    */
    readonly password?: string;
    /**
    * Support custom port values to snowflake go driver for use with privatelink. Can also be sourced from the `SNOWFLAKE_PORT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#port SnowflakeProvider#port}
    */
    readonly port?: number;
    /**
    * Private Key for username+private-key auth. Cannot be used with `browser_auth` or `password`. Can also be sourced from `SNOWFLAKE_PRIVATE_KEY` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#private_key SnowflakeProvider#private_key}
    */
    readonly privateKey?: string;
    /**
    * Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and des-ede3-cbc. Can also be sourced from `SNOWFLAKE_PRIVATE_KEY_PASSPHRASE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#private_key_passphrase SnowflakeProvider#private_key_passphrase}
    */
    readonly privateKeyPassphrase?: string;
    /**
    * Path to a private key for using keypair authentication. Cannot be used with `browser_auth`, `oauth_access_token` or `password`. Can also be sourced from `SNOWFLAKE_PRIVATE_KEY_PATH` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#private_key_path SnowflakeProvider#private_key_path}
    */
    readonly privateKeyPath?: string;
    /**
    * Sets the profile to read from ~/.snowflake/config file. Can also be sourced from the `SNOWFLAKE_PROFILE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#profile SnowflakeProvider#profile}
    */
    readonly profile?: string;
    /**
    * Either http or https, defaults to https. Can also be sourced from the `SNOWFLAKE_PROTOCOL` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#protocol SnowflakeProvider#protocol}
    */
    readonly protocol?: string;
    /**
    * Snowflake region, such as "eu-central-1", with this parameter. However, since this parameter is deprecated, it is best to specify the region as part of the account parameter. For details, see the description of the account parameter. [Snowflake region](https://docs.snowflake.com/en/user-guide/intro-regions.html) to use.  Required if using the [legacy format for the `account` identifier](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#format-2-legacy-account-locator-in-a-region) in the form of `<cloud_region_id>.<cloud>`. Can also be sourced from the `SNOWFLAKE_REGION` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#region SnowflakeProvider#region}
    */
    readonly region?: string;
    /**
    * request retry timeout EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_REQUEST_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#request_timeout SnowflakeProvider#request_timeout}
    */
    readonly requestTimeout?: number;
    /**
    * Specifies the role to use by default for accessing Snowflake objects in the client session. Can also be sourced from the `SNOWFLAKE_ROLE` environment variable. .
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#role SnowflakeProvider#role}
    */
    readonly role?: string;
    /**
    * Sets session parameters. [Parameters](https://docs.snowflake.com/en/sql-reference/parameters)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#session_params SnowflakeProvider#session_params}
    */
    readonly sessionParams?: {
        [key: string]: string;
    };
    /**
    * Token to use for OAuth and other forms of token based auth. Can also be sourced from the `SNOWFLAKE_TOKEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#token SnowflakeProvider#token}
    */
    readonly token?: string;
    /**
    * Username. Can also be sourced from the `SNOWFLAKE_USER` environment variable. Required unless using `profile`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#user SnowflakeProvider#user}
    */
    readonly user?: string;
    /**
    * Username for username+password authentication. Can also be sourced from the `SNOWFLAKE_USERNAME` environment variable. Required unless using `profile`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#username SnowflakeProvider#username}
    */
    readonly username?: string;
    /**
    * True by default. If false, disables the validation checks for Database, Schema, Warehouse and Role at the time a connection is established. Can also be sourced from the `SNOWFLAKE_VALIDATE_DEFAULT_PARAMETERS` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#validate_default_parameters SnowflakeProvider#validate_default_parameters}
    */
    readonly validateDefaultParameters?: boolean | cdktf.IResolvable;
    /**
    * Specifies the virtual warehouse to use by default for queries, loading, etc. in the client session. Can also be sourced from the `SNOWFLAKE_WAREHOUSE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#warehouse SnowflakeProvider#warehouse}
    */
    readonly warehouse?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#alias SnowflakeProvider#alias}
    */
    readonly alias?: string;
    /**
    * token_accessor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#token_accessor SnowflakeProvider#token_accessor}
    */
    readonly tokenAccessor?: SnowflakeProviderTokenAccessor;
}
export interface SnowflakeProviderTokenAccessor {
    /**
    * The client ID for the OAuth provider when using a refresh token to renew access token. Can also be sourced from the `SNOWFLAKE_TOKEN_ACCESSOR_CLIENT_ID` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#client_id SnowflakeProvider#client_id}
    */
    readonly clientId: string;
    /**
    * The client secret for the OAuth provider when using a refresh token to renew access token. Can also be sourced from the `SNOWFLAKE_TOKEN_ACCESSOR_CLIENT_SECRET` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#client_secret SnowflakeProvider#client_secret}
    */
    readonly clientSecret: string;
    /**
    * The redirect URI for the OAuth provider when using a refresh token to renew access token. Can also be sourced from the `SNOWFLAKE_TOKEN_ACCESSOR_REDIRECT_URI` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#redirect_uri SnowflakeProvider#redirect_uri}
    */
    readonly redirectUri: string;
    /**
    * The refresh token for the OAuth provider when using a refresh token to renew access token. Can also be sourced from the `SNOWFLAKE_TOKEN_ACCESSOR_REFRESH_TOKEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#refresh_token SnowflakeProvider#refresh_token}
    */
    readonly refreshToken: string;
    /**
    * The token endpoint for the OAuth provider e.g. https://{yourDomain}/oauth/token when using a refresh token to renew access token. Can also be sourced from the `SNOWFLAKE_TOKEN_ACCESSOR_TOKEN_ENDPOINT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#token_endpoint SnowflakeProvider#token_endpoint}
    */
    readonly tokenEndpoint: string;
}
export declare function snowflakeProviderTokenAccessorToTerraform(struct?: SnowflakeProviderTokenAccessor): any;
export declare function snowflakeProviderTokenAccessorToHclTerraform(struct?: SnowflakeProviderTokenAccessor): any;
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs snowflake}
*/
export declare class SnowflakeProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "snowflake";
    /**
    * Generates CDKTF code for importing a SnowflakeProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SnowflakeProvider to import
    * @param importFromId The id of the existing SnowflakeProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SnowflakeProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs snowflake} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnowflakeProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SnowflakeProviderConfig);
    private _account?;
    get account(): string | undefined;
    set account(value: string | undefined);
    resetAccount(): void;
    get accountInput(): string | undefined;
    private _authenticator?;
    get authenticator(): string | undefined;
    set authenticator(value: string | undefined);
    resetAuthenticator(): void;
    get authenticatorInput(): string | undefined;
    private _browserAuth?;
    get browserAuth(): boolean | cdktf.IResolvable | undefined;
    set browserAuth(value: boolean | cdktf.IResolvable | undefined);
    resetBrowserAuth(): void;
    get browserAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _clientIp?;
    get clientIp(): string | undefined;
    set clientIp(value: string | undefined);
    resetClientIp(): void;
    get clientIpInput(): string | undefined;
    private _clientRequestMfaToken?;
    get clientRequestMfaToken(): boolean | cdktf.IResolvable | undefined;
    set clientRequestMfaToken(value: boolean | cdktf.IResolvable | undefined);
    resetClientRequestMfaToken(): void;
    get clientRequestMfaTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _clientStoreTemporaryCredential?;
    get clientStoreTemporaryCredential(): boolean | cdktf.IResolvable | undefined;
    set clientStoreTemporaryCredential(value: boolean | cdktf.IResolvable | undefined);
    resetClientStoreTemporaryCredential(): void;
    get clientStoreTemporaryCredentialInput(): boolean | cdktf.IResolvable | undefined;
    private _clientTimeout?;
    get clientTimeout(): number | undefined;
    set clientTimeout(value: number | undefined);
    resetClientTimeout(): void;
    get clientTimeoutInput(): number | undefined;
    private _disableQueryContextCache?;
    get disableQueryContextCache(): boolean | cdktf.IResolvable | undefined;
    set disableQueryContextCache(value: boolean | cdktf.IResolvable | undefined);
    resetDisableQueryContextCache(): void;
    get disableQueryContextCacheInput(): boolean | cdktf.IResolvable | undefined;
    private _disableTelemetry?;
    get disableTelemetry(): boolean | cdktf.IResolvable | undefined;
    set disableTelemetry(value: boolean | cdktf.IResolvable | undefined);
    resetDisableTelemetry(): void;
    get disableTelemetryInput(): boolean | cdktf.IResolvable | undefined;
    private _externalBrowserTimeout?;
    get externalBrowserTimeout(): number | undefined;
    set externalBrowserTimeout(value: number | undefined);
    resetExternalBrowserTimeout(): void;
    get externalBrowserTimeoutInput(): number | undefined;
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _insecureMode?;
    get insecureMode(): boolean | cdktf.IResolvable | undefined;
    set insecureMode(value: boolean | cdktf.IResolvable | undefined);
    resetInsecureMode(): void;
    get insecureModeInput(): boolean | cdktf.IResolvable | undefined;
    private _jwtClientTimeout?;
    get jwtClientTimeout(): number | undefined;
    set jwtClientTimeout(value: number | undefined);
    resetJwtClientTimeout(): void;
    get jwtClientTimeoutInput(): number | undefined;
    private _jwtExpireTimeout?;
    get jwtExpireTimeout(): number | undefined;
    set jwtExpireTimeout(value: number | undefined);
    resetJwtExpireTimeout(): void;
    get jwtExpireTimeoutInput(): number | undefined;
    private _keepSessionAlive?;
    get keepSessionAlive(): boolean | cdktf.IResolvable | undefined;
    set keepSessionAlive(value: boolean | cdktf.IResolvable | undefined);
    resetKeepSessionAlive(): void;
    get keepSessionAliveInput(): boolean | cdktf.IResolvable | undefined;
    private _loginTimeout?;
    get loginTimeout(): number | undefined;
    set loginTimeout(value: number | undefined);
    resetLoginTimeout(): void;
    get loginTimeoutInput(): number | undefined;
    private _oauthAccessToken?;
    get oauthAccessToken(): string | undefined;
    set oauthAccessToken(value: string | undefined);
    resetOauthAccessToken(): void;
    get oauthAccessTokenInput(): string | undefined;
    private _oauthClientId?;
    get oauthClientId(): string | undefined;
    set oauthClientId(value: string | undefined);
    resetOauthClientId(): void;
    get oauthClientIdInput(): string | undefined;
    private _oauthClientSecret?;
    get oauthClientSecret(): string | undefined;
    set oauthClientSecret(value: string | undefined);
    resetOauthClientSecret(): void;
    get oauthClientSecretInput(): string | undefined;
    private _oauthEndpoint?;
    get oauthEndpoint(): string | undefined;
    set oauthEndpoint(value: string | undefined);
    resetOauthEndpoint(): void;
    get oauthEndpointInput(): string | undefined;
    private _oauthRedirectUrl?;
    get oauthRedirectUrl(): string | undefined;
    set oauthRedirectUrl(value: string | undefined);
    resetOauthRedirectUrl(): void;
    get oauthRedirectUrlInput(): string | undefined;
    private _oauthRefreshToken?;
    get oauthRefreshToken(): string | undefined;
    set oauthRefreshToken(value: string | undefined);
    resetOauthRefreshToken(): void;
    get oauthRefreshTokenInput(): string | undefined;
    private _ocspFailOpen?;
    get ocspFailOpen(): boolean | cdktf.IResolvable | undefined;
    set ocspFailOpen(value: boolean | cdktf.IResolvable | undefined);
    resetOcspFailOpen(): void;
    get ocspFailOpenInput(): boolean | cdktf.IResolvable | undefined;
    private _oktaUrl?;
    get oktaUrl(): string | undefined;
    set oktaUrl(value: string | undefined);
    resetOktaUrl(): void;
    get oktaUrlInput(): string | undefined;
    private _params?;
    get params(): {
        [key: string]: string;
    } | undefined;
    set params(value: {
        [key: string]: string;
    } | undefined);
    resetParams(): void;
    get paramsInput(): {
        [key: string]: string;
    } | undefined;
    private _passcode?;
    get passcode(): string | undefined;
    set passcode(value: string | undefined);
    resetPasscode(): void;
    get passcodeInput(): string | undefined;
    private _passcodeInPassword?;
    get passcodeInPassword(): boolean | cdktf.IResolvable | undefined;
    set passcodeInPassword(value: boolean | cdktf.IResolvable | undefined);
    resetPasscodeInPassword(): void;
    get passcodeInPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _privateKey?;
    get privateKey(): string | undefined;
    set privateKey(value: string | undefined);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _privateKeyPassphrase?;
    get privateKeyPassphrase(): string | undefined;
    set privateKeyPassphrase(value: string | undefined);
    resetPrivateKeyPassphrase(): void;
    get privateKeyPassphraseInput(): string | undefined;
    private _privateKeyPath?;
    get privateKeyPath(): string | undefined;
    set privateKeyPath(value: string | undefined);
    resetPrivateKeyPath(): void;
    get privateKeyPathInput(): string | undefined;
    private _profile?;
    get profile(): string | undefined;
    set profile(value: string | undefined);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _protocol?;
    get protocol(): string | undefined;
    set protocol(value: string | undefined);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _requestTimeout?;
    get requestTimeout(): number | undefined;
    set requestTimeout(value: number | undefined);
    resetRequestTimeout(): void;
    get requestTimeoutInput(): number | undefined;
    private _role?;
    get role(): string | undefined;
    set role(value: string | undefined);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _sessionParams?;
    get sessionParams(): {
        [key: string]: string;
    } | undefined;
    set sessionParams(value: {
        [key: string]: string;
    } | undefined);
    resetSessionParams(): void;
    get sessionParamsInput(): {
        [key: string]: string;
    } | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _user?;
    get user(): string | undefined;
    set user(value: string | undefined);
    resetUser(): void;
    get userInput(): string | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _validateDefaultParameters?;
    get validateDefaultParameters(): boolean | cdktf.IResolvable | undefined;
    set validateDefaultParameters(value: boolean | cdktf.IResolvable | undefined);
    resetValidateDefaultParameters(): void;
    get validateDefaultParametersInput(): boolean | cdktf.IResolvable | undefined;
    private _warehouse?;
    get warehouse(): string | undefined;
    set warehouse(value: string | undefined);
    resetWarehouse(): void;
    get warehouseInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _tokenAccessor?;
    get tokenAccessor(): SnowflakeProviderTokenAccessor | undefined;
    set tokenAccessor(value: SnowflakeProviderTokenAccessor | undefined);
    resetTokenAccessor(): void;
    get tokenAccessorInput(): SnowflakeProviderTokenAccessor | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
