/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UnsafeExecuteConfig extends cdktf.TerraformMetaArguments {
    /**
    * SQL statement to execute. Forces recreation of resource on change.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/unsafe_execute#execute UnsafeExecute#execute}
    */
    readonly execute: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/unsafe_execute#id UnsafeExecute#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional SQL statement to do a read. Invoked after creation and every time it is changed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/unsafe_execute#query UnsafeExecute#query}
    */
    readonly query?: string;
    /**
    * SQL statement to revert the execute statement. Invoked when resource is being destroyed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/unsafe_execute#revert UnsafeExecute#revert}
    */
    readonly revert: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/unsafe_execute snowflake_unsafe_execute}
*/
export declare class UnsafeExecute extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_unsafe_execute";
    /**
    * Generates CDKTF code for importing a UnsafeExecute resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the UnsafeExecute to import
    * @param importFromId The id of the existing UnsafeExecute that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/unsafe_execute#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the UnsafeExecute to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.87.1/docs/resources/unsafe_execute snowflake_unsafe_execute} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UnsafeExecuteConfig
    */
    constructor(scope: Construct, id: string, config: UnsafeExecuteConfig);
    private _execute?;
    get execute(): string;
    set execute(value: string);
    get executeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    resetQuery(): void;
    get queryInput(): string | undefined;
    private _queryResults;
    get queryResults(): cdktf.StringMapList;
    private _revert?;
    get revert(): string;
    set revert(value: string);
    get revertInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
