/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.options;

import io.ray.api.placementgroup.PlacementStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PlacementGroupCreationOptions {
    private final String name;
    private final List<Map<String, Double>> bundles;
    private final PlacementStrategy strategy;

    public PlacementGroupCreationOptions(String name, List<Map<String, Double>> bundles, PlacementStrategy strategy) {
        if (bundles == null || bundles.isEmpty()) {
            throw new IllegalArgumentException("`Bundles` must be specified when creating a new placement group.");
        }
        boolean bundleResourceValid = bundles.stream().allMatch(bundle -> bundle.values().stream().allMatch(resource -> resource > 0.0));
        if (!bundleResourceValid) {
            throw new IllegalArgumentException("Bundles cannot be empty or bundle's resource must be positive.");
        }
        if (strategy == null) {
            throw new IllegalArgumentException("`PlacementStrategy` must be specified when creating a new placement group.");
        }
        this.name = name;
        this.bundles = Collections.unmodifiableList(bundles.stream().map(bundle -> Collections.unmodifiableMap(new HashMap(bundle))).collect(Collectors.toList()));
        this.strategy = strategy;
    }

    public String getName() {
        return this.name;
    }

    public List<Map<String, Double>> getBundles() {
        return this.bundles;
    }

    public PlacementStrategy getStrategy() {
        return this.strategy;
    }

    public static class Builder {
        private String name;
        private List<Map<String, Double>> bundles;
        private PlacementStrategy strategy;

        public Builder setName(String name) {
            if (this.name != null) {
                throw new IllegalArgumentException("Repeated assignment of the name is not allowed!");
            }
            this.name = name;
            return this;
        }

        public Builder setBundles(List<Map<String, Double>> bundles) {
            this.bundles = bundles;
            return this;
        }

        public Builder setStrategy(PlacementStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public PlacementGroupCreationOptions build() {
            return new PlacementGroupCreationOptions(this.name, this.bundles, this.strategy);
        }
    }
}

