from shops_payment_processing.models.order import PaymentTypes
from pydantic import BaseModel
class Metadata(BaseModel):
    key: str
    value: list[str]
class PaymentMethodModel(BaseModel):
    name: str
    type: PaymentTypes
    payment_data: str | None = None  # payment_token, TON address etc....
    meta: list[Metadata] | None = []
    class Config:
        use_enum_values = True


class PaymentMethodDBResponseModel(PaymentMethodModel):
    id: str

