# Generated by the protoc compiler with a custom plugin. DO NOT EDIT!
# sources: opentelemetry/proto/resource/v1/resource.proto
#
# Copyright (c) 2012-2024 Snowflake Inc. All rights reserved.
#
# Copyright 2019, OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# This file has been generated from the original proto schema at
#
#     https://github.com/open-telemetry/opentelemetry-proto
#
# using a custom protoc compiler plugin by Snowflake Inc.

from __future__ import annotations

import struct
from typing import List

from snowflake.telemetry._internal.opentelemetry.proto.common.v1.common_marshaler import *
from snowflake.telemetry._internal.serialize import (
    Enum,
    MessageMarshaler,
    Varint,
)


class Resource(MessageMarshaler):
    @property
    def attributes(self) -> List[KeyValue]:
        if self._attributes is None:
            self._attributes = list()
        return self._attributes

    dropped_attributes_count: int

    def __init__(
        self,
        attributes: List[KeyValue] = None,
        dropped_attributes_count: int = 0,
    ):
        self._attributes: List[KeyValue] = attributes
        self.dropped_attributes_count: int = dropped_attributes_count

    def calculate_size(self) -> int:
        size = 0
        if self._attributes:
            size += sum(
                message._get_size()
                + len(b"\n")
                + Varint.size_varint_u32(message._get_size())
                for message in self._attributes
            )
        if self.dropped_attributes_count:
            size += len(b"\x10") + Varint.size_varint_u32(self.dropped_attributes_count)
        return size

    def write_to(self, out: bytearray) -> None:
        if self._attributes:
            for v in self._attributes:
                out += b"\n"
                Varint.write_varint_u32(out, v._get_size())
                v.write_to(out)
        if self.dropped_attributes_count:
            out += b"\x10"
            Varint.write_varint_u32(out, self.dropped_attributes_count)
