# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    """
    A collection of values returned by getService.
    """
    def __init__(__self__, active_deployment=None, app_id=None, created_at=None, definitions=None, id=None, latest_deployment=None, messages=None, name=None, organization_id=None, paused_at=None, resumed_at=None, slug=None, status=None, terminated_at=None, updated_at=None, version=None):
        if active_deployment and not isinstance(active_deployment, str):
            raise TypeError("Expected argument 'active_deployment' to be a str")
        pulumi.set(__self__, "active_deployment", active_deployment)
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if definitions and not isinstance(definitions, list):
            raise TypeError("Expected argument 'definitions' to be a list")
        pulumi.set(__self__, "definitions", definitions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest_deployment and not isinstance(latest_deployment, str):
            raise TypeError("Expected argument 'latest_deployment' to be a str")
        pulumi.set(__self__, "latest_deployment", latest_deployment)
        if messages and not isinstance(messages, str):
            raise TypeError("Expected argument 'messages' to be a str")
        pulumi.set(__self__, "messages", messages)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if paused_at and not isinstance(paused_at, str):
            raise TypeError("Expected argument 'paused_at' to be a str")
        pulumi.set(__self__, "paused_at", paused_at)
        if resumed_at and not isinstance(resumed_at, str):
            raise TypeError("Expected argument 'resumed_at' to be a str")
        pulumi.set(__self__, "resumed_at", resumed_at)
        if slug and not isinstance(slug, str):
            raise TypeError("Expected argument 'slug' to be a str")
        pulumi.set(__self__, "slug", slug)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if terminated_at and not isinstance(terminated_at, str):
            raise TypeError("Expected argument 'terminated_at' to be a str")
        pulumi.set(__self__, "terminated_at", terminated_at)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="activeDeployment")
    def active_deployment(self) -> str:
        """
        The service active deployment id
        """
        return pulumi.get(self, "active_deployment")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> str:
        """
        The app id the service is assigned
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date and time of when the service was created
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def definitions(self) -> Sequence['outputs.GetServiceDefinitionResult']:
        """
        The service deployment definition
        """
        return pulumi.get(self, "definitions")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the service
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="latestDeployment")
    def latest_deployment(self) -> str:
        """
        The service latest deployment id
        """
        return pulumi.get(self, "latest_deployment")

    @property
    @pulumi.getter
    def messages(self) -> str:
        """
        The status messages of the service
        """
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the service
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The organization id owning the service
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="pausedAt")
    def paused_at(self) -> str:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "paused_at")

    @property
    @pulumi.getter(name="resumedAt")
    def resumed_at(self) -> str:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "resumed_at")

    @property
    @pulumi.getter
    def slug(self) -> str:
        """
        The service slug composed of the app and service name, for instance my-app/my-service
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the service
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="terminatedAt")
    def terminated_at(self) -> str:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "terminated_at")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the service
        """
        return pulumi.get(self, "version")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            active_deployment=self.active_deployment,
            app_id=self.app_id,
            created_at=self.created_at,
            definitions=self.definitions,
            id=self.id,
            latest_deployment=self.latest_deployment,
            messages=self.messages,
            name=self.name,
            organization_id=self.organization_id,
            paused_at=self.paused_at,
            resumed_at=self.resumed_at,
            slug=self.slug,
            status=self.status,
            terminated_at=self.terminated_at,
            updated_at=self.updated_at,
            version=self.version)


def get_service(messages: Optional[str] = None,
                slug: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_koyeb as koyeb

    my_service = koyeb.get_service(slug="my-app/my-service")
    ```


    :param str messages: The status messages of the service
    :param str slug: The service slug composed of the app and service name, for instance my-app/my-service
    """
    __args__ = dict()
    __args__['messages'] = messages
    __args__['slug'] = slug
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('koyeb:index/getService:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        active_deployment=pulumi.get(__ret__, 'active_deployment'),
        app_id=pulumi.get(__ret__, 'app_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        definitions=pulumi.get(__ret__, 'definitions'),
        id=pulumi.get(__ret__, 'id'),
        latest_deployment=pulumi.get(__ret__, 'latest_deployment'),
        messages=pulumi.get(__ret__, 'messages'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        paused_at=pulumi.get(__ret__, 'paused_at'),
        resumed_at=pulumi.get(__ret__, 'resumed_at'),
        slug=pulumi.get(__ret__, 'slug'),
        status=pulumi.get(__ret__, 'status'),
        terminated_at=pulumi.get(__ret__, 'terminated_at'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        version=pulumi.get(__ret__, 'version'))
def get_service_output(messages: Optional[pulumi.Input[Optional[str]]] = None,
                       slug: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServiceResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_koyeb as koyeb

    my_service = koyeb.get_service(slug="my-app/my-service")
    ```


    :param str messages: The status messages of the service
    :param str slug: The service slug composed of the app and service name, for instance my-app/my-service
    """
    __args__ = dict()
    __args__['messages'] = messages
    __args__['slug'] = slug
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('koyeb:index/getService:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        active_deployment=pulumi.get(__response__, 'active_deployment'),
        app_id=pulumi.get(__response__, 'app_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        definitions=pulumi.get(__response__, 'definitions'),
        id=pulumi.get(__response__, 'id'),
        latest_deployment=pulumi.get(__response__, 'latest_deployment'),
        messages=pulumi.get(__response__, 'messages'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        paused_at=pulumi.get(__response__, 'paused_at'),
        resumed_at=pulumi.get(__response__, 'resumed_at'),
        slug=pulumi.get(__response__, 'slug'),
        status=pulumi.get(__response__, 'status'),
        terminated_at=pulumi.get(__response__, 'terminated_at'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        version=pulumi.get(__response__, 'version')))
