# The file was automatically generated by Lark v1.1.7
__version__ = "1.1.7"

#
#
#   Lark Stand-alone Generator Tool
# ----------------------------------
# Generates a stand-alone LALR(1) parser
#
# Git:    https://github.com/erezsh/lark
# Author: Erez Shinan (erezshin@gmail.com)
#
#
#    >>> LICENSE
#
#    This tool and its generated code use a separate license from Lark,
#    and are subject to the terms of the Mozilla Public License, v. 2.0.
#    If a copy of the MPL was not distributed with this
#    file, You can obtain one at https://mozilla.org/MPL/2.0/.
#
#    If you wish to purchase a commercial license for this tool and its
#    generated code, you may contact me via email or otherwise.
#
#    If MPL2 is incompatible with your free or open-source project,
#    contact me and we'll work it out.
#
#

from abc import ABC, abstractmethod
from collections.abc import Sequence
from types import ModuleType
from typing import (
    TypeVar, Generic, Type, Tuple, List, Dict, Iterator, Collection, Callable, Optional, FrozenSet, Any,
    Union, Iterable, IO, TYPE_CHECKING, overload,
    Pattern as REPattern, ClassVar, Set, Mapping
)


class LarkError(Exception):
    pass


class ConfigurationError(LarkError, ValueError):
    pass


def assert_config(value, options: Collection, msg='Got %r, expected one of %s'):
    if value not in options:
        raise ConfigurationError(msg % (value, options))


class GrammarError(LarkError):
    pass


class ParseError(LarkError):
    pass


class LexError(LarkError):
    pass

T = TypeVar('T')

class UnexpectedInput(LarkError):
    #--
    line: int
    column: int
    pos_in_stream = None
    state: Any
    _terminals_by_name = None

    def get_context(self, text: str, span: int=40) -> str:
        #--
        assert self.pos_in_stream is not None, self
        pos = self.pos_in_stream
        start = max(pos - span, 0)
        end = pos + span
        if not isinstance(text, bytes):
            before = text[start:pos].rsplit('\n', 1)[-1]
            after = text[pos:end].split('\n', 1)[0]
            return before + after + '\n' + ' ' * len(before.expandtabs()) + '^\n'
        else:
            before = text[start:pos].rsplit(b'\n', 1)[-1]
            after = text[pos:end].split(b'\n', 1)[0]
            return (before + after + b'\n' + b' ' * len(before.expandtabs()) + b'^\n').decode("ascii", "backslashreplace")

    def match_examples(self, parse_fn: 'Callable[[str], Tree]',
                             examples: Union[Mapping[T, Iterable[str]], Iterable[Tuple[T, Iterable[str]]]],
                             token_type_match_fallback: bool=False,
                             use_accepts: bool=True
                         ) -> Optional[T]:
        #--
        assert self.state is not None, "Not supported for this exception"

        if isinstance(examples, Mapping):
            examples = examples.items()

        candidate = (None, False)
        for i, (label, example) in enumerate(examples):
            assert not isinstance(example, str), "Expecting a list"

            for j, malformed in enumerate(example):
                try:
                    parse_fn(malformed)
                except UnexpectedInput as ut:
                    if ut.state == self.state:
                        if (
                            use_accepts
                            and isinstance(self, UnexpectedToken)
                            and isinstance(ut, UnexpectedToken)
                            and ut.accepts != self.accepts
                        ):
                            logger.debug("Different accepts with same state[%d]: %s != %s at example [%s][%s]" %
                                         (self.state, self.accepts, ut.accepts, i, j))
                            continue
                        if (
                            isinstance(self, (UnexpectedToken, UnexpectedEOF))
                            and isinstance(ut, (UnexpectedToken, UnexpectedEOF))
                        ):
                            if ut.token == self.token:  ##

                                logger.debug("Exact Match at example [%s][%s]" % (i, j))
                                return label

                            if token_type_match_fallback:
                                ##

                                if (ut.token.type == self.token.type) and not candidate[-1]:
                                    logger.debug("Token Type Fallback at example [%s][%s]" % (i, j))
                                    candidate = label, True

                        if candidate[0] is None:
                            logger.debug("Same State match at example [%s][%s]" % (i, j))
                            candidate = label, False

        return candidate[0]

    def _format_expected(self, expected):
        if self._terminals_by_name:
            d = self._terminals_by_name
            expected = [d[t_name].user_repr() if t_name in d else t_name for t_name in expected]
        return "Expected one of: \n\t* %s\n" % '\n\t* '.join(expected)


class UnexpectedEOF(ParseError, UnexpectedInput):
    #--
    expected: 'List[Token]'

    def __init__(self, expected, state=None, terminals_by_name=None):
        super(UnexpectedEOF, self).__init__()

        self.expected = expected
        self.state = state
        from .lexer import Token
        self.token = Token("<EOF>", "")  ##

        self.pos_in_stream = -1
        self.line = -1
        self.column = -1
        self._terminals_by_name = terminals_by_name


    def __str__(self):
        message = "Unexpected end-of-input. "
        message += self._format_expected(self.expected)
        return message


class UnexpectedCharacters(LexError, UnexpectedInput):
    #--

    allowed: Set[str]
    considered_tokens: Set[Any]

    def __init__(self, seq, lex_pos, line, column, allowed=None, considered_tokens=None, state=None, token_history=None,
                 terminals_by_name=None, considered_rules=None):
        super(UnexpectedCharacters, self).__init__()

        ##

        self.line = line
        self.column = column
        self.pos_in_stream = lex_pos
        self.state = state
        self._terminals_by_name = terminals_by_name

        self.allowed = allowed
        self.considered_tokens = considered_tokens
        self.considered_rules = considered_rules
        self.token_history = token_history

        if isinstance(seq, bytes):
            self.char = seq[lex_pos:lex_pos + 1].decode("ascii", "backslashreplace")
        else:
            self.char = seq[lex_pos]
        self._context = self.get_context(seq)


    def __str__(self):
        message = "No terminal matches '%s' in the current parser context, at line %d col %d" % (self.char, self.line, self.column)
        message += '\n\n' + self._context
        if self.allowed:
            message += self._format_expected(self.allowed)
        if self.token_history:
            message += '\nPrevious tokens: %s\n' % ', '.join(repr(t) for t in self.token_history)
        return message


class UnexpectedToken(ParseError, UnexpectedInput):
    #--

    expected: Set[str]
    considered_rules: Set[str]
    interactive_parser: 'InteractiveParser'

    def __init__(self, token, expected, considered_rules=None, state=None, interactive_parser=None, terminals_by_name=None, token_history=None):
        super(UnexpectedToken, self).__init__()

        ##

        self.line = getattr(token, 'line', '?')
        self.column = getattr(token, 'column', '?')
        self.pos_in_stream = getattr(token, 'start_pos', None)
        self.state = state

        self.token = token
        self.expected = expected  ##

        self._accepts = NO_VALUE
        self.considered_rules = considered_rules
        self.interactive_parser = interactive_parser
        self._terminals_by_name = terminals_by_name
        self.token_history = token_history


    @property
    def accepts(self) -> Set[str]:
        if self._accepts is NO_VALUE:
            self._accepts = self.interactive_parser and self.interactive_parser.accepts()
        return self._accepts

    def __str__(self):
        message = ("Unexpected token %r at line %s, column %s.\n%s"
                   % (self.token, self.line, self.column, self._format_expected(self.accepts or self.expected)))
        if self.token_history:
            message += "Previous tokens: %r\n" % self.token_history

        return message



class VisitError(LarkError):
    #--

    obj: 'Union[Tree, Token]'
    orig_exc: Exception

    def __init__(self, rule, obj, orig_exc):
        message = 'Error trying to process rule "%s":\n\n%s' % (rule, orig_exc)
        super(VisitError, self).__init__(message)

        self.rule = rule
        self.obj = obj
        self.orig_exc = orig_exc


class MissingVariableError(LarkError):
    pass


import sys, re
import logging

logger: logging.Logger = logging.getLogger("lark")
logger.addHandler(logging.StreamHandler())
##

##

logger.setLevel(logging.CRITICAL)


NO_VALUE = object()

T = TypeVar("T")


def classify(seq: Iterable, key: Optional[Callable] = None, value: Optional[Callable] = None) -> Dict:
    d: Dict[Any, Any] = {}
    for item in seq:
        k = key(item) if (key is not None) else item
        v = value(item) if (value is not None) else item
        try:
            d[k].append(v)
        except KeyError:
            d[k] = [v]
    return d


def _deserialize(data: Any, namespace: Dict[str, Any], memo: Dict) -> Any:
    if isinstance(data, dict):
        if '__type__' in data:  ##

            class_ = namespace[data['__type__']]
            return class_.deserialize(data, memo)
        elif '@' in data:
            return memo[data['@']]
        return {key:_deserialize(value, namespace, memo) for key, value in data.items()}
    elif isinstance(data, list):
        return [_deserialize(value, namespace, memo) for value in data]
    return data


_T = TypeVar("_T", bound="Serialize")

class Serialize:
    #--

    def memo_serialize(self, types_to_memoize: List) -> Any:
        memo = SerializeMemoizer(types_to_memoize)
        return self.serialize(memo), memo.serialize()

    def serialize(self, memo = None) -> Dict[str, Any]:
        if memo and memo.in_types(self):
            return {'@': memo.memoized.get(self)}

        fields = getattr(self, '__serialize_fields__')
        res = {f: _serialize(getattr(self, f), memo) for f in fields}
        res['__type__'] = type(self).__name__
        if hasattr(self, '_serialize'):
            self._serialize(res, memo)  ##

        return res

    @classmethod
    def deserialize(cls: Type[_T], data: Dict[str, Any], memo: Dict[int, Any]) -> _T:
        namespace = getattr(cls, '__serialize_namespace__', [])
        namespace = {c.__name__:c for c in namespace}

        fields = getattr(cls, '__serialize_fields__')

        if '@' in data:
            return memo[data['@']]

        inst = cls.__new__(cls)
        for f in fields:
            try:
                setattr(inst, f, _deserialize(data[f], namespace, memo))
            except KeyError as e:
                raise KeyError("Cannot find key for class", cls, e)

        if hasattr(inst, '_deserialize'):
            inst._deserialize()  ##


        return inst


class SerializeMemoizer(Serialize):
    #--

    __serialize_fields__ = 'memoized',

    def __init__(self, types_to_memoize: List) -> None:
        self.types_to_memoize = tuple(types_to_memoize)
        self.memoized = Enumerator()

    def in_types(self, value: Serialize) -> bool:
        return isinstance(value, self.types_to_memoize)

    def serialize(self) -> Dict[int, Any]:  ##

        return _serialize(self.memoized.reversed(), None)

    @classmethod
    def deserialize(cls, data: Dict[int, Any], namespace: Dict[str, Any], memo: Dict[Any, Any]) -> Dict[int, Any]:  ##

        return _deserialize(data, namespace, memo)


try:
    import regex
    _has_regex = True
except ImportError:
    _has_regex = False

if sys.version_info >= (3, 11):
    import re._parser as sre_parse
    import re._constants as sre_constants
else:
    import sre_parse
    import sre_constants

categ_pattern = re.compile(r'\\p{[A-Za-z_]+}')

def get_regexp_width(expr: str) -> Union[Tuple[int, int], List[int]]:
    if _has_regex:
        ##

        ##

        ##

        regexp_final = re.sub(categ_pattern, 'A', expr)
    else:
        if re.search(categ_pattern, expr):
            raise ImportError('`regex` module must be installed in order to use Unicode categories.', expr)
        regexp_final = expr
    try:
        ##

        return [int(x) for x in sre_parse.parse(regexp_final).getwidth()]   ##

    except sre_constants.error:
        if not _has_regex:
            raise ValueError(expr)
        else:
            ##

            ##

            c = regex.compile(regexp_final)
            if c.match('') is None:
                ##

                return 1, int(sre_constants.MAXREPEAT)
            else:
                return 0, int(sre_constants.MAXREPEAT)


from collections import OrderedDict

class Meta:

    empty: bool
    line: int
    column: int
    start_pos: int
    end_line: int
    end_column: int
    end_pos: int
    orig_expansion: 'List[TerminalDef]'
    match_tree: bool

    def __init__(self):
        self.empty = True


_Leaf_T = TypeVar("_Leaf_T")
Branch = Union[_Leaf_T, 'Tree[_Leaf_T]']


class Tree(Generic[_Leaf_T]):
    #--

    data: str
    children: 'List[Branch[_Leaf_T]]'

    def __init__(self, data: str, children: 'List[Branch[_Leaf_T]]', meta: Optional[Meta]=None) -> None:
        self.data = data
        self.children = children
        self._meta = meta

    @property
    def meta(self) -> Meta:
        if self._meta is None:
            self._meta = Meta()
        return self._meta

    def __repr__(self):
        return 'Tree(%r, %r)' % (self.data, self.children)

    def _pretty_label(self):
        return self.data

    def _pretty(self, level, indent_str):
        yield f'{indent_str*level}{self._pretty_label()}'
        if len(self.children) == 1 and not isinstance(self.children[0], Tree):
            yield f'\t{self.children[0]}\n'
        else:
            yield '\n'
            for n in self.children:
                if isinstance(n, Tree):
                    yield from n._pretty(level+1, indent_str)
                else:
                    yield f'{indent_str*(level+1)}{n}\n'

    def pretty(self, indent_str: str='  ') -> str:
        #--
        return ''.join(self._pretty(0, indent_str))

    def __rich__(self, parent:Optional['rich.tree.Tree']=None) -> 'rich.tree.Tree':
        #--
        return self._rich(parent)

    def _rich(self, parent):
        if parent:
            tree = parent.add(f'[bold]{self.data}[/bold]')
        else:
            import rich.tree
            tree = rich.tree.Tree(self.data)

        for c in self.children:
            if isinstance(c, Tree):
                c._rich(tree)
            else:
                tree.add(f'[green]{c}[/green]')

        return tree

    def __eq__(self, other):
        try:
            return self.data == other.data and self.children == other.children
        except AttributeError:
            return False

    def __ne__(self, other):
        return not (self == other)

    def __hash__(self) -> int:
        return hash((self.data, tuple(self.children)))

    def iter_subtrees(self) -> 'Iterator[Tree[_Leaf_T]]':
        #--
        queue = [self]
        subtrees = OrderedDict()
        for subtree in queue:
            subtrees[id(subtree)] = subtree
            ##

            queue += [c for c in reversed(subtree.children)  ##

                      if isinstance(c, Tree) and id(c) not in subtrees]

        del queue
        return reversed(list(subtrees.values()))

    def iter_subtrees_topdown(self):
        #--
        stack = [self]
        stack_append = stack.append
        stack_pop = stack.pop
        while stack:
            node = stack_pop()
            if not isinstance(node, Tree):
                continue
            yield node
            for child in reversed(node.children):
                stack_append(child)

    def find_pred(self, pred: 'Callable[[Tree[_Leaf_T]], bool]') -> 'Iterator[Tree[_Leaf_T]]':
        #--
        return filter(pred, self.iter_subtrees())

    def find_data(self, data: str) -> 'Iterator[Tree[_Leaf_T]]':
        #--
        return self.find_pred(lambda t: t.data == data)


from functools import wraps, update_wrapper
from inspect import getmembers, getmro

_Return_T = TypeVar('_Return_T')
_Return_V = TypeVar('_Return_V')
_Leaf_T = TypeVar('_Leaf_T')
_Leaf_U = TypeVar('_Leaf_U')
_R = TypeVar('_R')
_FUNC = Callable[..., _Return_T]
_DECORATED = Union[_FUNC, type]

class _DiscardType:
    #--

    def __repr__(self):
        return "lark.visitors.Discard"

Discard = _DiscardType()

##


class _Decoratable:
    #--

    @classmethod
    def _apply_v_args(cls, visit_wrapper):
        mro = getmro(cls)
        assert mro[0] is cls
        libmembers = {name for _cls in mro[1:] for name, _ in getmembers(_cls)}
        for name, value in getmembers(cls):

            ##

            if name.startswith('_') or (name in libmembers and name not in cls.__dict__):
                continue
            if not callable(value):
                continue

            ##

            if isinstance(cls.__dict__[name], _VArgsWrapper):
                continue

            setattr(cls, name, _VArgsWrapper(cls.__dict__[name], visit_wrapper))
        return cls

    def __class_getitem__(cls, _):
        return cls


class Transformer(_Decoratable, ABC, Generic[_Leaf_T, _Return_T]):
    #--
    __visit_tokens__ = True   ##


    def __init__(self,  visit_tokens: bool=True) -> None:
        self.__visit_tokens__ = visit_tokens

    def _call_userfunc(self, tree, new_children=None):
        ##

        children = new_children if new_children is not None else tree.children
        try:
            f = getattr(self, tree.data)
        except AttributeError:
            return self.__default__(tree.data, children, tree.meta)
        else:
            try:
                wrapper = getattr(f, 'visit_wrapper', None)
                if wrapper is not None:
                    return f.visit_wrapper(f, tree.data, children, tree.meta)
                else:
                    return f(children)
            except GrammarError:
                raise
            except Exception as e:
                raise VisitError(tree.data, tree, e)

    def _call_userfunc_token(self, token):
        try:
            f = getattr(self, token.type)
        except AttributeError:
            return self.__default_token__(token)
        else:
            try:
                return f(token)
            except GrammarError:
                raise
            except Exception as e:
                raise VisitError(token.type, token, e)

    def _transform_children(self, children):
        for c in children:
            if isinstance(c, Tree):
                res = self._transform_tree(c)
            elif self.__visit_tokens__ and isinstance(c, Token):
                res = self._call_userfunc_token(c)
            else:
                res = c

            if res is not Discard:
                yield res

    def _transform_tree(self, tree):
        children = list(self._transform_children(tree.children))
        return self._call_userfunc(tree, children)

    def transform(self, tree: Tree[_Leaf_T]) -> _Return_T:
        #--
        return self._transform_tree(tree)

    def __mul__(
            self: 'Transformer[_Leaf_T, Tree[_Leaf_U]]',
            other: 'Union[Transformer[_Leaf_U, _Return_V], TransformerChain[_Leaf_U, _Return_V,]]'
    ) -> 'TransformerChain[_Leaf_T, _Return_V]':
        #--
        return TransformerChain(self, other)

    def __default__(self, data, children, meta):
        #--
        return Tree(data, children, meta)

    def __default_token__(self, token):
        #--
        return token


def merge_transformers(base_transformer=None, **transformers_to_merge):
    #--
    if base_transformer is None:
        base_transformer = Transformer()
    for prefix, transformer in transformers_to_merge.items():
        for method_name in dir(transformer):
            method = getattr(transformer, method_name)
            if not callable(method):
                continue
            if method_name.startswith("_") or method_name == "transform":
                continue
            prefixed_method = prefix + "__" + method_name
            if hasattr(base_transformer, prefixed_method):
                raise AttributeError("Cannot merge: method '%s' appears more than once" % prefixed_method)

            setattr(base_transformer, prefixed_method, method)

    return base_transformer


class InlineTransformer(Transformer):   ##

    def _call_userfunc(self, tree, new_children=None):
        ##

        children = new_children if new_children is not None else tree.children
        try:
            f = getattr(self, tree.data)
        except AttributeError:
            return self.__default__(tree.data, children, tree.meta)
        else:
            return f(*children)


class TransformerChain(Generic[_Leaf_T, _Return_T]):

    transformers: 'Tuple[Union[Transformer, TransformerChain], ...]'

    def __init__(self, *transformers: 'Union[Transformer, TransformerChain]') -> None:
        self.transformers = transformers

    def transform(self, tree: Tree[_Leaf_T]) -> _Return_T:
        for t in self.transformers:
            tree = t.transform(tree)
        return cast(_Return_T, tree)

    def __mul__(
            self: 'TransformerChain[_Leaf_T, Tree[_Leaf_U]]',
            other: 'Union[Transformer[_Leaf_U, _Return_V], TransformerChain[_Leaf_U, _Return_V]]'
    ) -> 'TransformerChain[_Leaf_T, _Return_V]':
        return TransformerChain(*self.transformers + (other,))


class Transformer_InPlace(Transformer):
    #--
    def _transform_tree(self, tree):           ##

        return self._call_userfunc(tree)

    def transform(self, tree: Tree[_Leaf_T]) -> _Return_T:
        for subtree in tree.iter_subtrees():
            subtree.children = list(self._transform_children(subtree.children))

        return self._transform_tree(tree)


class Transformer_NonRecursive(Transformer):
    #--

    def transform(self, tree: Tree[_Leaf_T]) -> _Return_T:
        ##

        rev_postfix = []
        q: List[Branch[_Leaf_T]] = [tree]
        while q:
            t = q.pop()
            rev_postfix.append(t)
            if isinstance(t, Tree):
                q += t.children

        ##

        stack: List = []
        for x in reversed(rev_postfix):
            if isinstance(x, Tree):
                size = len(x.children)
                if size:
                    args = stack[-size:]
                    del stack[-size:]
                else:
                    args = []

                res = self._call_userfunc(x, args)
                if res is not Discard:
                    stack.append(res)

            elif self.__visit_tokens__ and isinstance(x, Token):
                res = self._call_userfunc_token(x)
                if res is not Discard:
                    stack.append(res)
            else:
                stack.append(x)

        result, = stack  ##

        ##

        ##

        ##

        return cast(_Return_T, result)


class Transformer_InPlaceRecursive(Transformer):
    #--
    def _transform_tree(self, tree):
        tree.children = list(self._transform_children(tree.children))
        return self._call_userfunc(tree)


##


class VisitorBase:
    def _call_userfunc(self, tree):
        return getattr(self, tree.data, self.__default__)(tree)

    def __default__(self, tree):
        #--
        return tree

    def __class_getitem__(cls, _):
        return cls


class Visitor(VisitorBase, ABC, Generic[_Leaf_T]):
    #--

    def visit(self, tree: Tree[_Leaf_T]) -> Tree[_Leaf_T]:
        #--
        for subtree in tree.iter_subtrees():
            self._call_userfunc(subtree)
        return tree

    def visit_topdown(self, tree: Tree[_Leaf_T]) -> Tree[_Leaf_T]:
        #--
        for subtree in tree.iter_subtrees_topdown():
            self._call_userfunc(subtree)
        return tree


class Visitor_Recursive(VisitorBase, Generic[_Leaf_T]):
    #--

    def visit(self, tree: Tree[_Leaf_T]) -> Tree[_Leaf_T]:
        #--
        for child in tree.children:
            if isinstance(child, Tree):
                self.visit(child)

        self._call_userfunc(tree)
        return tree

    def visit_topdown(self,tree: Tree[_Leaf_T]) -> Tree[_Leaf_T]:
        #--
        self._call_userfunc(tree)

        for child in tree.children:
            if isinstance(child, Tree):
                self.visit_topdown(child)

        return tree


class Interpreter(_Decoratable, ABC, Generic[_Leaf_T, _Return_T]):
    #--

    def visit(self, tree: Tree[_Leaf_T]) -> _Return_T:
        ##

        ##

        ##

        return self._visit_tree(tree)

    def _visit_tree(self, tree: Tree[_Leaf_T]):
        f = getattr(self, tree.data)
        wrapper = getattr(f, 'visit_wrapper', None)
        if wrapper is not None:
            return f.visit_wrapper(f, tree.data, tree.children, tree.meta)
        else:
            return f(tree)

    def visit_children(self, tree: Tree[_Leaf_T]) -> List:
        return [self._visit_tree(child) if isinstance(child, Tree) else child
                for child in tree.children]

    def __getattr__(self, name):
        return self.__default__

    def __default__(self, tree):
        return self.visit_children(tree)


_InterMethod = Callable[[Type[Interpreter], _Return_T], _R]

def visit_children_decor(func: _InterMethod) -> _InterMethod:
    #--
    @wraps(func)
    def inner(cls, tree):
        values = cls.visit_children(tree)
        return func(cls, values)
    return inner

##


def _apply_v_args(obj, visit_wrapper):
    try:
        _apply = obj._apply_v_args
    except AttributeError:
        return _VArgsWrapper(obj, visit_wrapper)
    else:
        return _apply(visit_wrapper)


class _VArgsWrapper:
    #--
    base_func: Callable

    def __init__(self, func: Callable, visit_wrapper: Callable[[Callable, str, list, Any], Any]):
        if isinstance(func, _VArgsWrapper):
            func = func.base_func
        ##

        self.base_func = func  ##

        self.visit_wrapper = visit_wrapper
        update_wrapper(self, func)

    def __call__(self, *args, **kwargs):
        return self.base_func(*args, **kwargs)

    def __get__(self, instance, owner=None):
        try:
            ##

            ##

            g = type(self.base_func).__get__
        except AttributeError:
            return self
        else:
            return _VArgsWrapper(g(self.base_func, instance, owner), self.visit_wrapper)

    def __set_name__(self, owner, name):
        try:
            f = type(self.base_func).__set_name__
        except AttributeError:
            return
        else:
            f(self.base_func, owner, name)


def _vargs_inline(f, _data, children, _meta):
    return f(*children)
def _vargs_meta_inline(f, _data, children, meta):
    return f(meta, *children)
def _vargs_meta(f, _data, children, meta):
    return f(meta, children)
def _vargs_tree(f, data, children, meta):
    return f(Tree(data, children, meta))


def v_args(inline: bool = False, meta: bool = False, tree: bool = False, wrapper: Optional[Callable] = None) -> Callable[[_DECORATED], _DECORATED]:
    #--
    if tree and (meta or inline):
        raise ValueError("Visitor functions cannot combine 'tree' with 'meta' or 'inline'.")

    func = None
    if meta:
        if inline:
            func = _vargs_meta_inline
        else:
            func = _vargs_meta
    elif inline:
        func = _vargs_inline
    elif tree:
        func = _vargs_tree

    if wrapper is not None:
        if func is not None:
            raise ValueError("Cannot use 'wrapper' along with 'tree', 'meta' or 'inline'.")
        func = wrapper

    def _visitor_args_dec(obj):
        return _apply_v_args(obj, func)
    return _visitor_args_dec



TOKEN_DEFAULT_PRIORITY = 0


class Symbol(Serialize):
    __slots__ = ('name',)

    name: str
    is_term: ClassVar[bool] = NotImplemented

    def __init__(self, name: str) -> None:
        self.name = name

    def __eq__(self, other):
        assert isinstance(other, Symbol), other
        return self.is_term == other.is_term and self.name == other.name

    def __ne__(self, other):
        return not (self == other)

    def __hash__(self):
        return hash(self.name)

    def __repr__(self):
        return '%s(%r)' % (type(self).__name__, self.name)

    fullrepr = property(__repr__)

    def renamed(self, f):
        return type(self)(f(self.name))


class Terminal(Symbol):
    __serialize_fields__ = 'name', 'filter_out'

    is_term: ClassVar[bool] = True

    def __init__(self, name, filter_out=False):
        self.name = name
        self.filter_out = filter_out

    @property
    def fullrepr(self):
        return '%s(%r, %r)' % (type(self).__name__, self.name, self.filter_out)

    def renamed(self, f):
        return type(self)(f(self.name), self.filter_out)


class NonTerminal(Symbol):
    __serialize_fields__ = 'name',

    is_term: ClassVar[bool] = False


class RuleOptions(Serialize):
    __serialize_fields__ = 'keep_all_tokens', 'expand1', 'priority', 'template_source', 'empty_indices'

    keep_all_tokens: bool
    expand1: bool
    priority: Optional[int]
    template_source: Optional[str]
    empty_indices: Tuple[bool, ...]

    def __init__(self, keep_all_tokens: bool=False, expand1: bool=False, priority: Optional[int]=None, template_source: Optional[str]=None, empty_indices: Tuple[bool, ...]=()) -> None:
        self.keep_all_tokens = keep_all_tokens
        self.expand1 = expand1
        self.priority = priority
        self.template_source = template_source
        self.empty_indices = empty_indices

    def __repr__(self):
        return 'RuleOptions(%r, %r, %r, %r)' % (
            self.keep_all_tokens,
            self.expand1,
            self.priority,
            self.template_source
        )


class Rule(Serialize):
    #--
    __slots__ = ('origin', 'expansion', 'alias', 'options', 'order', '_hash')

    __serialize_fields__ = 'origin', 'expansion', 'order', 'alias', 'options'
    __serialize_namespace__ = Terminal, NonTerminal, RuleOptions

    def __init__(self, origin, expansion, order=0, alias=None, options=None):
        self.origin = origin
        self.expansion = expansion
        self.alias = alias
        self.order = order
        self.options = options or RuleOptions()
        self._hash = hash((self.origin, tuple(self.expansion)))

    def _deserialize(self):
        self._hash = hash((self.origin, tuple(self.expansion)))

    def __str__(self):
        return '<%s : %s>' % (self.origin.name, ' '.join(x.name for x in self.expansion))

    def __repr__(self):
        return 'Rule(%r, %r, %r, %r)' % (self.origin, self.expansion, self.alias, self.options)

    def __hash__(self):
        return self._hash

    def __eq__(self, other):
        if not isinstance(other, Rule):
            return False
        return self.origin == other.origin and self.expansion == other.expansion



from copy import copy

try:  ##

    has_interegular = bool(interegular)
except NameError:
    has_interegular = False

class Pattern(Serialize, ABC):

    value: str
    flags: Collection[str]
    raw: Optional[str]
    type: ClassVar[str]

    def __init__(self, value: str, flags: Collection[str] = (), raw: Optional[str] = None) -> None:
        self.value = value
        self.flags = frozenset(flags)
        self.raw = raw

    def __repr__(self):
        return repr(self.to_regexp())

    ##

    def __hash__(self):
        return hash((type(self), self.value, self.flags))

    def __eq__(self, other):
        return type(self) == type(other) and self.value == other.value and self.flags == other.flags

    @abstractmethod
    def to_regexp(self) -> str:
        raise NotImplementedError()

    @property
    @abstractmethod
    def min_width(self) -> int:
        raise NotImplementedError()

    @property
    @abstractmethod
    def max_width(self) -> int:
        raise NotImplementedError()

    def _get_flags(self, value):
        for f in self.flags:
            value = ('(?%s:%s)' % (f, value))
        return value


class PatternStr(Pattern):
    __serialize_fields__ = 'value', 'flags', 'raw'

    type: ClassVar[str] = "str"

    def to_regexp(self) -> str:
        return self._get_flags(re.escape(self.value))

    @property
    def min_width(self) -> int:
        return len(self.value)

    @property
    def max_width(self) -> int:
        return len(self.value)


class PatternRE(Pattern):
    __serialize_fields__ = 'value', 'flags', 'raw', '_width'

    type: ClassVar[str] = "re"

    def to_regexp(self) -> str:
        return self._get_flags(self.value)

    _width = None
    def _get_width(self):
        if self._width is None:
            self._width = get_regexp_width(self.to_regexp())
        return self._width

    @property
    def min_width(self) -> int:
        return self._get_width()[0]

    @property
    def max_width(self) -> int:
        return self._get_width()[1]


class TerminalDef(Serialize):
    __serialize_fields__ = 'name', 'pattern', 'priority'
    __serialize_namespace__ = PatternStr, PatternRE

    name: str
    pattern: Pattern
    priority: int

    def __init__(self, name: str, pattern: Pattern, priority: int = TOKEN_DEFAULT_PRIORITY) -> None:
        assert isinstance(pattern, Pattern), pattern
        self.name = name
        self.pattern = pattern
        self.priority = priority

    def __repr__(self):
        return '%s(%r, %r)' % (type(self).__name__, self.name, self.pattern)

    def user_repr(self) -> str:
        if self.name.startswith('__'):  ##

            return self.pattern.raw or self.name
        else:
            return self.name

_T = TypeVar('_T', bound="Token")

class Token(str):
    #--
    __slots__ = ('type', 'start_pos', 'value', 'line', 'column', 'end_line', 'end_column', 'end_pos')

    __match_args__ = ('type', 'value')

    type: str
    start_pos: Optional[int]
    value: Any
    line: Optional[int]
    column: Optional[int]
    end_line: Optional[int]
    end_column: Optional[int]
    end_pos: Optional[int]


    @overload
    def __new__(
            cls,
            type: str,
            value: Any,
            start_pos: Optional[int] = None,
            line: Optional[int] = None,
            column: Optional[int] = None,
            end_line: Optional[int] = None,
            end_column: Optional[int] = None,
            end_pos: Optional[int] = None
    ) -> 'Token':
        ...

    @overload
    def __new__(
            cls,
            type_: str,
            value: Any,
            start_pos: Optional[int] = None,
            line: Optional[int] = None,
            column: Optional[int] = None,
            end_line: Optional[int] = None,
            end_column: Optional[int] = None,
            end_pos: Optional[int] = None
    ) -> 'Token':        ...

    def __new__(cls, *args, **kwargs):
        if "type_" in kwargs:
            warnings.warn("`type_` is deprecated use `type` instead", DeprecationWarning)

            if "type" in kwargs:
                raise TypeError("Error: using both 'type' and the deprecated 'type_' as arguments.")
            kwargs["type"] = kwargs.pop("type_")

        return cls._future_new(*args, **kwargs)


    @classmethod
    def _future_new(cls, type, value, start_pos=None, line=None, column=None, end_line=None, end_column=None, end_pos=None):
        inst = super(Token, cls).__new__(cls, value)

        inst.type = type
        inst.start_pos = start_pos
        inst.value = value
        inst.line = line
        inst.column = column
        inst.end_line = end_line
        inst.end_column = end_column
        inst.end_pos = end_pos
        return inst

    @overload
    def update(self, type: Optional[str] = None, value: Optional[Any] = None) -> 'Token':
        ...

    @overload
    def update(self, type_: Optional[str] = None, value: Optional[Any] = None) -> 'Token':
        ...

    def update(self, *args, **kwargs):
        if "type_" in kwargs:
            warnings.warn("`type_` is deprecated use `type` instead", DeprecationWarning)

            if "type" in kwargs:
                raise TypeError("Error: using both 'type' and the deprecated 'type_' as arguments.")
            kwargs["type"] = kwargs.pop("type_")

        return self._future_update(*args, **kwargs)

    def _future_update(self, type: Optional[str] = None, value: Optional[Any] = None) -> 'Token':
        return Token.new_borrow_pos(
            type if type is not None else self.type,
            value if value is not None else self.value,
            self
        )

    @classmethod
    def new_borrow_pos(cls: Type[_T], type_: str, value: Any, borrow_t: 'Token') -> _T:
        return cls(type_, value, borrow_t.start_pos, borrow_t.line, borrow_t.column, borrow_t.end_line, borrow_t.end_column, borrow_t.end_pos)

    def __reduce__(self):
        return (self.__class__, (self.type, self.value, self.start_pos, self.line, self.column))

    def __repr__(self):
        return 'Token(%r, %r)' % (self.type, self.value)

    def __deepcopy__(self, memo):
        return Token(self.type, self.value, self.start_pos, self.line, self.column)

    def __eq__(self, other):
        if isinstance(other, Token) and self.type != other.type:
            return False

        return str.__eq__(self, other)

    __hash__ = str.__hash__


class LineCounter:
    __slots__ = 'char_pos', 'line', 'column', 'line_start_pos', 'newline_char'

    def __init__(self, newline_char):
        self.newline_char = newline_char
        self.char_pos = 0
        self.line = 1
        self.column = 1
        self.line_start_pos = 0

    def __eq__(self, other):
        if not isinstance(other, LineCounter):
            return NotImplemented

        return self.char_pos == other.char_pos and self.newline_char == other.newline_char

    def feed(self, token: Token, test_newline=True):
        #--
        if test_newline:
            newlines = token.count(self.newline_char)
            if newlines:
                self.line += newlines
                self.line_start_pos = self.char_pos + token.rindex(self.newline_char) + 1

        self.char_pos += len(token)
        self.column = self.char_pos - self.line_start_pos + 1


class UnlessCallback:
    def __init__(self, scanner):
        self.scanner = scanner

    def __call__(self, t):
        res = self.scanner.match(t.value, 0)
        if res:
            _value, t.type = res
        return t


class CallChain:
    def __init__(self, callback1, callback2, cond):
        self.callback1 = callback1
        self.callback2 = callback2
        self.cond = cond

    def __call__(self, t):
        t2 = self.callback1(t)
        return self.callback2(t) if self.cond(t2) else t2


def _get_match(re_, regexp, s, flags):
    m = re_.match(regexp, s, flags)
    if m:
        return m.group(0)

def _create_unless(terminals, g_regex_flags, re_, use_bytes):
    tokens_by_type = classify(terminals, lambda t: type(t.pattern))
    assert len(tokens_by_type) <= 2, tokens_by_type.keys()
    embedded_strs = set()
    callback = {}
    for retok in tokens_by_type.get(PatternRE, []):
        unless = []
        for strtok in tokens_by_type.get(PatternStr, []):
            if strtok.priority != retok.priority:
                continue
            s = strtok.pattern.value
            if s == _get_match(re_, retok.pattern.to_regexp(), s, g_regex_flags):
                unless.append(strtok)
                if strtok.pattern.flags <= retok.pattern.flags:
                    embedded_strs.add(strtok)
        if unless:
            callback[retok.name] = UnlessCallback(Scanner(unless, g_regex_flags, re_, match_whole=True, use_bytes=use_bytes))

    new_terminals = [t for t in terminals if t not in embedded_strs]
    return new_terminals, callback


class Scanner:
    def __init__(self, terminals, g_regex_flags, re_, use_bytes, match_whole=False):
        self.terminals = terminals
        self.g_regex_flags = g_regex_flags
        self.re_ = re_
        self.use_bytes = use_bytes
        self.match_whole = match_whole

        self.allowed_types = {t.name for t in self.terminals}

        self._mres = self._build_mres(terminals, len(terminals))

    def _build_mres(self, terminals, max_size):
        ##

        ##

        ##

        postfix = '$' if self.match_whole else ''
        mres = []
        while terminals:
            pattern = u'|'.join(u'(?P<%s>%s)' % (t.name, t.pattern.to_regexp() + postfix) for t in terminals[:max_size])
            if self.use_bytes:
                pattern = pattern.encode('latin-1')
            try:
                mre = self.re_.compile(pattern, self.g_regex_flags)
            except AssertionError:  ##

                return self._build_mres(terminals, max_size // 2)

            mres.append(mre)
            terminals = terminals[max_size:]
        return mres

    def match(self, text, pos):
        for mre in self._mres:
            m = mre.match(text, pos)
            if m:
                return m.group(0), m.lastgroup


def _regexp_has_newline(r: str):
    #--
    return '\n' in r or '\\n' in r or '\\s' in r or '[^' in r or ('(?s' in r and '.' in r)


class LexerState:
    #--

    __slots__ = 'text', 'line_ctr', 'last_token'

    text: str
    line_ctr: LineCounter
    last_token: Optional[Token]

    def __init__(self, text: str, line_ctr: Optional[LineCounter]=None, last_token: Optional[Token]=None):
        self.text = text
        self.line_ctr = line_ctr or LineCounter(b'\n' if isinstance(text, bytes) else '\n')
        self.last_token = last_token

    def __eq__(self, other):
        if not isinstance(other, LexerState):
            return NotImplemented

        return self.text is other.text and self.line_ctr == other.line_ctr and self.last_token == other.last_token

    def __copy__(self):
        return type(self)(self.text, copy(self.line_ctr), self.last_token)


class LexerThread:
    #--

    def __init__(self, lexer: 'Lexer', lexer_state: LexerState):
        self.lexer = lexer
        self.state = lexer_state

    @classmethod
    def from_text(cls, lexer: 'Lexer', text: str):
        return cls(lexer, LexerState(text))

    def lex(self, parser_state):
        return self.lexer.lex(self.state, parser_state)

    def __copy__(self):
        return type(self)(self.lexer, copy(self.state))

    _Token = Token


_Callback = Callable[[Token], Token]

class Lexer(ABC):
    #--
    @abstractmethod
    def lex(self, lexer_state: LexerState, parser_state: Any) -> Iterator[Token]:
        return NotImplemented

    def make_lexer_state(self, text):
        #--
        return LexerState(text)


def _check_regex_collisions(terminal_to_regexp: Dict[TerminalDef, str], comparator, strict_mode, max_collisions_to_show=8):
    if not comparator:
        comparator = interegular.Comparator.from_regexes(terminal_to_regexp)

    ##

    ##

    max_time = 2 if strict_mode else 0.2

    ##

    if comparator.count_marked_pairs() >= max_collisions_to_show:
        return
    for group in classify(terminal_to_regexp, lambda t: t.priority).values():
        for a, b in comparator.check(group, skip_marked=True):
            assert a.priority == b.priority
            ##

            comparator.mark(a, b)

            ##

            message = f"Collision between Terminals {a.name} and {b.name}. "
            try:
                example = comparator.get_example_overlap(a, b, max_time).format_multiline()
            except ValueError:
                ##

                example = "No example could be found fast enough. However, the collision does still exists"
            if strict_mode:
                raise LexError(f"{message}\n{example}")
            logger.warning("%s The lexer will choose between them arbitrarily.\n%s", message, example)
            if comparator.count_marked_pairs() >= max_collisions_to_show:
                logger.warning("Found 8 regex collisions, will not check for more.")
                return


class BasicLexer(Lexer):
    terminals: Collection[TerminalDef]
    ignore_types: FrozenSet[str]
    newline_types: FrozenSet[str]
    user_callbacks: Dict[str, _Callback]
    callback: Dict[str, _Callback]
    re: ModuleType

    def __init__(self, conf: 'LexerConf', comparator=None) -> None:
        terminals = list(conf.terminals)
        assert all(isinstance(t, TerminalDef) for t in terminals), terminals

        self.re = conf.re_module

        if not conf.skip_validation:
            ##

            terminal_to_regexp = {}
            for t in terminals:
                regexp = t.pattern.to_regexp()
                try:
                    self.re.compile(regexp, conf.g_regex_flags)
                except self.re.error:
                    raise LexError("Cannot compile token %s: %s" % (t.name, t.pattern))

                if t.pattern.min_width == 0:
                    raise LexError("Lexer does not allow zero-width terminals. (%s: %s)" % (t.name, t.pattern))
                if t.pattern.type == "re":
                    terminal_to_regexp[t] = regexp

            if not (set(conf.ignore) <= {t.name for t in terminals}):
                raise LexError("Ignore terminals are not defined: %s" % (set(conf.ignore) - {t.name for t in terminals}))

            if has_interegular:
                _check_regex_collisions(terminal_to_regexp, comparator, conf.strict)
            elif conf.strict:
                raise LexError("interegular must be installed for strict mode. Use `pip install 'lark[interegular]'`.")

        ##

        self.newline_types = frozenset(t.name for t in terminals if _regexp_has_newline(t.pattern.to_regexp()))
        self.ignore_types = frozenset(conf.ignore)

        terminals.sort(key=lambda x: (-x.priority, -x.pattern.max_width, -len(x.pattern.value), x.name))
        self.terminals = terminals
        self.user_callbacks = conf.callbacks
        self.g_regex_flags = conf.g_regex_flags
        self.use_bytes = conf.use_bytes
        self.terminals_by_name = conf.terminals_by_name

        self._scanner = None

    def _build_scanner(self):
        terminals, self.callback = _create_unless(self.terminals, self.g_regex_flags, self.re, self.use_bytes)
        assert all(self.callback.values())

        for type_, f in self.user_callbacks.items():
            if type_ in self.callback:
                ##

                self.callback[type_] = CallChain(self.callback[type_], f, lambda t: t.type == type_)
            else:
                self.callback[type_] = f

        self._scanner = Scanner(terminals, self.g_regex_flags, self.re, self.use_bytes)

    @property
    def scanner(self):
        if self._scanner is None:
            self._build_scanner()
        return self._scanner

    def match(self, text, pos):
        return self.scanner.match(text, pos)

    def lex(self, state: LexerState, parser_state: Any) -> Iterator[Token]:
        with suppress(EOFError):
            while True:
                yield self.next_token(state, parser_state)

    def next_token(self, lex_state: LexerState, parser_state: Any = None) -> Token:
        line_ctr = lex_state.line_ctr
        while line_ctr.char_pos < len(lex_state.text):
            res = self.match(lex_state.text, line_ctr.char_pos)
            if not res:
                allowed = self.scanner.allowed_types - self.ignore_types
                if not allowed:
                    allowed = {"<END-OF-FILE>"}
                raise UnexpectedCharacters(lex_state.text, line_ctr.char_pos, line_ctr.line, line_ctr.column,
                                           allowed=allowed, token_history=lex_state.last_token and [lex_state.last_token],
                                           state=parser_state, terminals_by_name=self.terminals_by_name)

            value, type_ = res

            if type_ not in self.ignore_types:
                t = Token(type_, value, line_ctr.char_pos, line_ctr.line, line_ctr.column)
                line_ctr.feed(value, type_ in self.newline_types)
                t.end_line = line_ctr.line
                t.end_column = line_ctr.column
                t.end_pos = line_ctr.char_pos
                if t.type in self.callback:
                    t = self.callback[t.type](t)
                    if not isinstance(t, Token):
                        raise LexError("Callbacks must return a token (returned %r)" % t)
                lex_state.last_token = t
                return t
            else:
                if type_ in self.callback:
                    t2 = Token(type_, value, line_ctr.char_pos, line_ctr.line, line_ctr.column)
                    self.callback[type_](t2)
                line_ctr.feed(value, type_ in self.newline_types)

        ##

        raise EOFError(self)


class ContextualLexer(Lexer):

    lexers: Dict[str, BasicLexer]
    root_lexer: BasicLexer

    def __init__(self, conf: 'LexerConf', states: Dict[str, Collection[str]], always_accept: Collection[str]=()) -> None:
        terminals = list(conf.terminals)
        terminals_by_name = conf.terminals_by_name

        trad_conf = copy(conf)
        trad_conf.terminals = terminals

        if has_interegular and not conf.skip_validation:
            comparator = interegular.Comparator.from_regexes({t: t.pattern.to_regexp() for t in terminals})
        else:
            comparator = None
        lexer_by_tokens: Dict[FrozenSet[str], BasicLexer] = {}
        self.lexers = {}
        for state, accepts in states.items():
            key = frozenset(accepts)
            try:
                lexer = lexer_by_tokens[key]
            except KeyError:
                accepts = set(accepts) | set(conf.ignore) | set(always_accept)
                lexer_conf = copy(trad_conf)
                lexer_conf.terminals = [terminals_by_name[n] for n in accepts if n in terminals_by_name]
                lexer = BasicLexer(lexer_conf, comparator)
                lexer_by_tokens[key] = lexer

            self.lexers[state] = lexer

        assert trad_conf.terminals is terminals
        trad_conf.skip_validation = True  ##

        self.root_lexer = BasicLexer(trad_conf, comparator)

    def lex(self, lexer_state: LexerState, parser_state: Any) -> Iterator[Token]:
        try:
            while True:
                lexer = self.lexers[parser_state.position]
                yield lexer.next_token(lexer_state, parser_state)
        except EOFError:
            pass
        except UnexpectedCharacters as e:
            ##

            ##

            try:
                last_token = lexer_state.last_token  ##

                token = self.root_lexer.next_token(lexer_state, parser_state)
                raise UnexpectedToken(token, e.allowed, state=parser_state, token_history=[last_token], terminals_by_name=self.root_lexer.terminals_by_name)
            except UnexpectedCharacters:
                raise e  ##




_ParserArgType: 'TypeAlias' = 'Literal["earley", "lalr", "cyk", "auto"]'
_LexerArgType: 'TypeAlias' = 'Union[Literal["auto", "basic", "contextual", "dynamic", "dynamic_complete"], Type[Lexer]]'
_Callback = Callable[[Token], Token]

class LexerConf(Serialize):
    __serialize_fields__ = 'terminals', 'ignore', 'g_regex_flags', 'use_bytes', 'lexer_type'
    __serialize_namespace__ = TerminalDef,

    terminals: Collection[TerminalDef]
    re_module: ModuleType
    ignore: Collection[str]
    postlex: 'Optional[PostLex]'
    callbacks: Dict[str, _Callback]
    g_regex_flags: int
    skip_validation: bool
    use_bytes: bool
    lexer_type: Optional[_LexerArgType]
    strict: bool

    def __init__(self, terminals: Collection[TerminalDef], re_module: ModuleType, ignore: Collection[str]=(), postlex: 'Optional[PostLex]'=None,
                 callbacks: Optional[Dict[str, _Callback]]=None, g_regex_flags: int=0, skip_validation: bool=False, use_bytes: bool=False, strict: bool=False):
        self.terminals = terminals
        self.terminals_by_name = {t.name: t for t in self.terminals}
        assert len(self.terminals) == len(self.terminals_by_name)
        self.ignore = ignore
        self.postlex = postlex
        self.callbacks = callbacks or {}
        self.g_regex_flags = g_regex_flags
        self.re_module = re_module
        self.skip_validation = skip_validation
        self.use_bytes = use_bytes
        self.strict = strict
        self.lexer_type = None

    def _deserialize(self):
        self.terminals_by_name = {t.name: t for t in self.terminals}

    def __deepcopy__(self, memo=None):
        return type(self)(
            deepcopy(self.terminals, memo),
            self.re_module,
            deepcopy(self.ignore, memo),
            deepcopy(self.postlex, memo),
            deepcopy(self.callbacks, memo),
            deepcopy(self.g_regex_flags, memo),
            deepcopy(self.skip_validation, memo),
            deepcopy(self.use_bytes, memo),
        )


class ParserConf(Serialize):
    __serialize_fields__ = 'rules', 'start', 'parser_type'

    def __init__(self, rules, callbacks, start):
        assert isinstance(start, list)
        self.rules = rules
        self.callbacks = callbacks
        self.start = start

        self.parser_type = None


from functools import partial, wraps
from itertools import product


class ExpandSingleChild:
    def __init__(self, node_builder):
        self.node_builder = node_builder

    def __call__(self, children):
        if len(children) == 1:
            return children[0]
        else:
            return self.node_builder(children)



class PropagatePositions:
    def __init__(self, node_builder, node_filter=None):
        self.node_builder = node_builder
        self.node_filter = node_filter

    def __call__(self, children):
        res = self.node_builder(children)

        if isinstance(res, Tree):
            ##

            ##

            ##

            ##


            res_meta = res.meta

            first_meta = self._pp_get_meta(children)
            if first_meta is not None:
                if not hasattr(res_meta, 'line'):
                    ##

                    res_meta.line = getattr(first_meta, 'container_line', first_meta.line)
                    res_meta.column = getattr(first_meta, 'container_column', first_meta.column)
                    res_meta.start_pos = getattr(first_meta, 'container_start_pos', first_meta.start_pos)
                    res_meta.empty = False

                res_meta.container_line = getattr(first_meta, 'container_line', first_meta.line)
                res_meta.container_column = getattr(first_meta, 'container_column', first_meta.column)
                res_meta.container_start_pos = getattr(first_meta, 'container_start_pos', first_meta.start_pos)

            last_meta = self._pp_get_meta(reversed(children))
            if last_meta is not None:
                if not hasattr(res_meta, 'end_line'):
                    res_meta.end_line = getattr(last_meta, 'container_end_line', last_meta.end_line)
                    res_meta.end_column = getattr(last_meta, 'container_end_column', last_meta.end_column)
                    res_meta.end_pos = getattr(last_meta, 'container_end_pos', last_meta.end_pos)
                    res_meta.empty = False

                res_meta.container_end_line = getattr(last_meta, 'container_end_line', last_meta.end_line)
                res_meta.container_end_column = getattr(last_meta, 'container_end_column', last_meta.end_column)
                res_meta.container_end_pos = getattr(last_meta, 'container_end_pos', last_meta.end_pos)

        return res

    def _pp_get_meta(self, children):
        for c in children:
            if self.node_filter is not None and not self.node_filter(c):
                continue
            if isinstance(c, Tree):
                if not c.meta.empty:
                    return c.meta
            elif isinstance(c, Token):
                return c
            elif hasattr(c, '__lark_meta__'):
                return c.__lark_meta__()

def make_propagate_positions(option):
    if callable(option):
        return partial(PropagatePositions, node_filter=option)
    elif option is True:
        return PropagatePositions
    elif option is False:
        return None

    raise ConfigurationError('Invalid option for propagate_positions: %r' % option)


class ChildFilter:
    def __init__(self, to_include, append_none, node_builder):
        self.node_builder = node_builder
        self.to_include = to_include
        self.append_none = append_none

    def __call__(self, children):
        filtered = []

        for i, to_expand, add_none in self.to_include:
            if add_none:
                filtered += [None] * add_none
            if to_expand:
                filtered += children[i].children
            else:
                filtered.append(children[i])

        if self.append_none:
            filtered += [None] * self.append_none

        return self.node_builder(filtered)


class ChildFilterLALR(ChildFilter):
    #--

    def __call__(self, children):
        filtered = []
        for i, to_expand, add_none in self.to_include:
            if add_none:
                filtered += [None] * add_none
            if to_expand:
                if filtered:
                    filtered += children[i].children
                else:   ##

                    filtered = children[i].children
            else:
                filtered.append(children[i])

        if self.append_none:
            filtered += [None] * self.append_none

        return self.node_builder(filtered)


class ChildFilterLALR_NoPlaceholders(ChildFilter):
    #--
    def __init__(self, to_include, node_builder):
        self.node_builder = node_builder
        self.to_include = to_include

    def __call__(self, children):
        filtered = []
        for i, to_expand in self.to_include:
            if to_expand:
                if filtered:
                    filtered += children[i].children
                else:   ##

                    filtered = children[i].children
            else:
                filtered.append(children[i])
        return self.node_builder(filtered)


def _should_expand(sym):
    return not sym.is_term and sym.name.startswith('_')


def maybe_create_child_filter(expansion, keep_all_tokens, ambiguous, _empty_indices: List[bool]):
    ##

    if _empty_indices:
        assert _empty_indices.count(False) == len(expansion)
        s = ''.join(str(int(b)) for b in _empty_indices)
        empty_indices = [len(ones) for ones in s.split('0')]
        assert len(empty_indices) == len(expansion)+1, (empty_indices, len(expansion))
    else:
        empty_indices = [0] * (len(expansion)+1)

    to_include = []
    nones_to_add = 0
    for i, sym in enumerate(expansion):
        nones_to_add += empty_indices[i]
        if keep_all_tokens or not (sym.is_term and sym.filter_out):
            to_include.append((i, _should_expand(sym), nones_to_add))
            nones_to_add = 0

    nones_to_add += empty_indices[len(expansion)]

    if _empty_indices or len(to_include) < len(expansion) or any(to_expand for i, to_expand,_ in to_include):
        if _empty_indices or ambiguous:
            return partial(ChildFilter if ambiguous else ChildFilterLALR, to_include, nones_to_add)
        else:
            ##

            return partial(ChildFilterLALR_NoPlaceholders, [(i, x) for i,x,_ in to_include])


class AmbiguousExpander:
    #--
    def __init__(self, to_expand, tree_class, node_builder):
        self.node_builder = node_builder
        self.tree_class = tree_class
        self.to_expand = to_expand

    def __call__(self, children):
        def _is_ambig_tree(t):
            return hasattr(t, 'data') and t.data == '_ambig'

        ##

        ##

        ##

        ##

        ambiguous = []
        for i, child in enumerate(children):
            if _is_ambig_tree(child):
                if i in self.to_expand:
                    ambiguous.append(i)

                child.expand_kids_by_data('_ambig')

        if not ambiguous:
            return self.node_builder(children)

        expand = [child.children if i in ambiguous else (child,) for i, child in enumerate(children)]
        return self.tree_class('_ambig', [self.node_builder(list(f)) for f in product(*expand)])


def maybe_create_ambiguous_expander(tree_class, expansion, keep_all_tokens):
    to_expand = [i for i, sym in enumerate(expansion)
                 if keep_all_tokens or ((not (sym.is_term and sym.filter_out)) and _should_expand(sym))]
    if to_expand:
        return partial(AmbiguousExpander, to_expand, tree_class)


class AmbiguousIntermediateExpander:
    #--

    def __init__(self, tree_class, node_builder):
        self.node_builder = node_builder
        self.tree_class = tree_class

    def __call__(self, children):
        def _is_iambig_tree(child):
            return hasattr(child, 'data') and child.data == '_iambig'

        def _collapse_iambig(children):
            #--

            ##

            ##

            if children and _is_iambig_tree(children[0]):
                iambig_node = children[0]
                result = []
                for grandchild in iambig_node.children:
                    collapsed = _collapse_iambig(grandchild.children)
                    if collapsed:
                        for child in collapsed:
                            child.children += children[1:]
                        result += collapsed
                    else:
                        new_tree = self.tree_class('_inter', grandchild.children + children[1:])
                        result.append(new_tree)
                return result

        collapsed = _collapse_iambig(children)
        if collapsed:
            processed_nodes = [self.node_builder(c.children) for c in collapsed]
            return self.tree_class('_ambig', processed_nodes)

        return self.node_builder(children)



def inplace_transformer(func):
    @wraps(func)
    def f(children):
        ##

        tree = Tree(func.__name__, children)
        return func(tree)
    return f


def apply_visit_wrapper(func, name, wrapper):
    if wrapper is _vargs_meta or wrapper is _vargs_meta_inline:
        raise NotImplementedError("Meta args not supported for internal transformer")

    @wraps(func)
    def f(children):
        return wrapper(func, name, children, None)
    return f


class ParseTreeBuilder:
    def __init__(self, rules, tree_class, propagate_positions=False, ambiguous=False, maybe_placeholders=False):
        self.tree_class = tree_class
        self.propagate_positions = propagate_positions
        self.ambiguous = ambiguous
        self.maybe_placeholders = maybe_placeholders

        self.rule_builders = list(self._init_builders(rules))

    def _init_builders(self, rules):
        propagate_positions = make_propagate_positions(self.propagate_positions)

        for rule in rules:
            options = rule.options
            keep_all_tokens = options.keep_all_tokens
            expand_single_child = options.expand1

            wrapper_chain = list(filter(None, [
                (expand_single_child and not rule.alias) and ExpandSingleChild,
                maybe_create_child_filter(rule.expansion, keep_all_tokens, self.ambiguous, options.empty_indices if self.maybe_placeholders else None),
                propagate_positions,
                self.ambiguous and maybe_create_ambiguous_expander(self.tree_class, rule.expansion, keep_all_tokens),
                self.ambiguous and partial(AmbiguousIntermediateExpander, self.tree_class)
            ]))

            yield rule, wrapper_chain

    def create_callback(self, transformer=None):
        callbacks = {}

        default_handler = getattr(transformer, '__default__', None)
        if default_handler:
            def default_callback(data, children):
                return default_handler(data, children, None)
        else:
            default_callback = self.tree_class

        for rule, wrapper_chain in self.rule_builders:

            user_callback_name = rule.alias or rule.options.template_source or rule.origin.name
            try:
                f = getattr(transformer, user_callback_name)
                wrapper = getattr(f, 'visit_wrapper', None)
                if wrapper is not None:
                    f = apply_visit_wrapper(f, user_callback_name, wrapper)
                elif isinstance(transformer, Transformer_InPlace):
                    f = inplace_transformer(f)
            except AttributeError:
                f = partial(default_callback, user_callback_name)

            for w in wrapper_chain:
                f = w(f)

            if rule in callbacks:
                raise GrammarError("Rule '%s' already exists" % (rule,))

            callbacks[rule] = f

        return callbacks



class LALR_Parser(Serialize):
    def __init__(self, parser_conf, debug=False, strict=False):
        analysis = LALR_Analyzer(parser_conf, debug=debug, strict=strict)
        analysis.compute_lalr()
        callbacks = parser_conf.callbacks

        self._parse_table = analysis.parse_table
        self.parser_conf = parser_conf
        self.parser = _Parser(analysis.parse_table, callbacks, debug)

    @classmethod
    def deserialize(cls, data, memo, callbacks, debug=False):
        inst = cls.__new__(cls)
        inst._parse_table = IntParseTable.deserialize(data, memo)
        inst.parser = _Parser(inst._parse_table, callbacks, debug)
        return inst

    def serialize(self, memo: Any = None) -> Dict[str, Any]:
        return self._parse_table.serialize(memo)

    def parse_interactive(self, lexer, start):
        return self.parser.parse(lexer, start, start_interactive=True)

    def parse(self, lexer, start, on_error=None):
        try:
            return self.parser.parse(lexer, start)
        except UnexpectedInput as e:
            if on_error is None:
                raise

            while True:
                if isinstance(e, UnexpectedCharacters):
                    s = e.interactive_parser.lexer_thread.state
                    p = s.line_ctr.char_pos

                if not on_error(e):
                    raise e

                if isinstance(e, UnexpectedCharacters):
                    ##

                    if p == s.line_ctr.char_pos:
                        s.line_ctr.feed(s.text[p:p+1])

                try:
                    return e.interactive_parser.resume_parse()
                except UnexpectedToken as e2:
                    if (isinstance(e, UnexpectedToken)
                        and e.token.type == e2.token.type == '$END'
                        and e.interactive_parser == e2.interactive_parser):
                        ##

                        raise e2
                    e = e2
                except UnexpectedCharacters as e2:
                    e = e2


class ParseConf:
    __slots__ = 'parse_table', 'callbacks', 'start', 'start_state', 'end_state', 'states'

    def __init__(self, parse_table, callbacks, start):
        self.parse_table = parse_table

        self.start_state = self.parse_table.start_states[start]
        self.end_state = self.parse_table.end_states[start]
        self.states = self.parse_table.states

        self.callbacks = callbacks
        self.start = start


class ParserState:
    __slots__ = 'parse_conf', 'lexer', 'state_stack', 'value_stack'

    def __init__(self, parse_conf, lexer, state_stack=None, value_stack=None):
        self.parse_conf = parse_conf
        self.lexer = lexer
        self.state_stack = state_stack or [self.parse_conf.start_state]
        self.value_stack = value_stack or []

    @property
    def position(self):
        return self.state_stack[-1]

    ##

    def __eq__(self, other):
        if not isinstance(other, ParserState):
            return NotImplemented
        return len(self.state_stack) == len(other.state_stack) and self.position == other.position

    def __copy__(self):
        return type(self)(
            self.parse_conf,
            self.lexer, ##

            copy(self.state_stack),
            deepcopy(self.value_stack),
        )

    def copy(self):
        return copy(self)

    def feed_token(self, token, is_end=False):
        state_stack = self.state_stack
        value_stack = self.value_stack
        states = self.parse_conf.states
        end_state = self.parse_conf.end_state
        callbacks = self.parse_conf.callbacks

        while True:
            state = state_stack[-1]
            try:
                action, arg = states[state][token.type]
            except KeyError:
                expected = {s for s in states[state].keys() if s.isupper()}
                raise UnexpectedToken(token, expected, state=self, interactive_parser=None)

            assert arg != end_state

            if action is Shift:
                ##

                assert not is_end
                state_stack.append(arg)
                value_stack.append(token if token.type not in callbacks else callbacks[token.type](token))
                return
            else:
                ##

                rule = arg
                size = len(rule.expansion)
                if size:
                    s = value_stack[-size:]
                    del state_stack[-size:]
                    del value_stack[-size:]
                else:
                    s = []

                value = callbacks[rule](s)

                _action, new_state = states[state_stack[-1]][rule.origin.name]
                assert _action is Shift
                state_stack.append(new_state)
                value_stack.append(value)

                if is_end and state_stack[-1] == end_state:
                    return value_stack[-1]

class _Parser:
    def __init__(self, parse_table, callbacks, debug=False):
        self.parse_table = parse_table
        self.callbacks = callbacks
        self.debug = debug

    def parse(self, lexer, start, value_stack=None, state_stack=None, start_interactive=False):
        parse_conf = ParseConf(self.parse_table, self.callbacks, start)
        parser_state = ParserState(parse_conf, lexer, state_stack, value_stack)
        if start_interactive:
            return InteractiveParser(self, parser_state, parser_state.lexer)
        return self.parse_from_state(parser_state)


    def parse_from_state(self, state, last_token=None):
        #--
        try:
            token = last_token
            for token in state.lexer.lex(state):
                state.feed_token(token)

            end_token = Token.new_borrow_pos('$END', '', token) if token else Token('$END', '', 0, 1, 1)
            return state.feed_token(end_token, True)
        except UnexpectedInput as e:
            try:
                e.interactive_parser = InteractiveParser(self, state, state.lexer)
            except NameError:
                pass
            raise e
        except Exception as e:
            if self.debug:
                print("")
                print("STATE STACK DUMP")
                print("----------------")
                for i, s in enumerate(state.state_stack):
                    print('%d)' % i , s)
                print("")

            raise


class Action:
    def __init__(self, name):
        self.name = name
    def __str__(self):
        return self.name
    def __repr__(self):
        return str(self)

Shift = Action('Shift')
Reduce = Action('Reduce')


class ParseTable:
    def __init__(self, states, start_states, end_states):
        self.states = states
        self.start_states = start_states
        self.end_states = end_states

    def serialize(self, memo):
        tokens = Enumerator()

        states = {
            state: {tokens.get(token): ((1, arg.serialize(memo)) if action is Reduce else (0, arg))
                    for token, (action, arg) in actions.items()}
            for state, actions in self.states.items()
        }

        return {
            'tokens': tokens.reversed(),
            'states': states,
            'start_states': self.start_states,
            'end_states': self.end_states,
        }

    @classmethod
    def deserialize(cls, data, memo):
        tokens = data['tokens']
        states = {
            state: {tokens[token]: ((Reduce, Rule.deserialize(arg, memo)) if action==1 else (Shift, arg))
                    for token, (action, arg) in actions.items()}
            for state, actions in data['states'].items()
        }
        return cls(states, data['start_states'], data['end_states'])


class IntParseTable(ParseTable):

    @classmethod
    def from_ParseTable(cls, parse_table):
        enum = list(parse_table.states)
        state_to_idx = {s:i for i,s in enumerate(enum)}
        int_states = {}

        for s, la in parse_table.states.items():
            la = {k:(v[0], state_to_idx[v[1]]) if v[0] is Shift else v
                  for k,v in la.items()}
            int_states[ state_to_idx[s] ] = la


        start_states = {start:state_to_idx[s] for start, s in parse_table.start_states.items()}
        end_states = {start:state_to_idx[s] for start, s in parse_table.end_states.items()}
        return cls(int_states, start_states, end_states)



def _wrap_lexer(lexer_class):
    future_interface = getattr(lexer_class, '__future_interface__', False)
    if future_interface:
        return lexer_class
    else:
        class CustomLexerWrapper(Lexer):
            def __init__(self, lexer_conf):
                self.lexer = lexer_class(lexer_conf)
            def lex(self, lexer_state, parser_state):
                return self.lexer.lex(lexer_state.text)
        return CustomLexerWrapper


def _deserialize_parsing_frontend(data, memo, lexer_conf, callbacks, options):
    parser_conf = ParserConf.deserialize(data['parser_conf'], memo)
    cls = (options and options._plugins.get('LALR_Parser')) or LALR_Parser
    parser = cls.deserialize(data['parser'], memo, callbacks, options.debug)
    parser_conf.callbacks = callbacks
    return ParsingFrontend(lexer_conf, parser_conf, options, parser=parser)


_parser_creators: 'Dict[str, Callable[[LexerConf, Any, Any], Any]]' = {}


class ParsingFrontend(Serialize):
    __serialize_fields__ = 'lexer_conf', 'parser_conf', 'parser'

    lexer_conf: LexerConf
    parser_conf: ParserConf
    options: Any

    def __init__(self, lexer_conf: LexerConf, parser_conf: ParserConf, options, parser=None):
        self.parser_conf = parser_conf
        self.lexer_conf = lexer_conf
        self.options = options

        ##

        if parser:  ##

            self.parser = parser
        else:
            create_parser = _parser_creators.get(parser_conf.parser_type)
            assert create_parser is not None, "{} is not supported in standalone mode".format(
                    parser_conf.parser_type
                )
            self.parser = create_parser(lexer_conf, parser_conf, options)

        ##

        lexer_type = lexer_conf.lexer_type
        self.skip_lexer = False
        if lexer_type in ('dynamic', 'dynamic_complete'):
            assert lexer_conf.postlex is None
            self.skip_lexer = True
            return

        if isinstance(lexer_type, type):
            assert issubclass(lexer_type, Lexer)
            self.lexer = _wrap_lexer(lexer_type)(lexer_conf)
        elif isinstance(lexer_type, str):
            create_lexer = {
                'basic': create_basic_lexer,
                'contextual': create_contextual_lexer,
            }[lexer_type]
            self.lexer = create_lexer(lexer_conf, self.parser, lexer_conf.postlex, options)
        else:
            raise TypeError("Bad value for lexer_type: {lexer_type}")

        if lexer_conf.postlex:
            self.lexer = PostLexConnector(self.lexer, lexer_conf.postlex)

    def _verify_start(self, start=None):
        if start is None:
            start_decls = self.parser_conf.start
            if len(start_decls) > 1:
                raise ConfigurationError("Lark initialized with more than 1 possible start rule. Must specify which start rule to parse", start_decls)
            start ,= start_decls
        elif start not in self.parser_conf.start:
            raise ConfigurationError("Unknown start rule %s. Must be one of %r" % (start, self.parser_conf.start))
        return start

    def _make_lexer_thread(self, text: str):
        cls = (self.options and self.options._plugins.get('LexerThread')) or LexerThread
        return text if self.skip_lexer else cls.from_text(self.lexer, text)

    def parse(self, text: str, start=None, on_error=None):
        chosen_start = self._verify_start(start)
        kw = {} if on_error is None else {'on_error': on_error}
        stream = self._make_lexer_thread(text)
        return self.parser.parse(stream, chosen_start, **kw)

    def parse_interactive(self, text: Optional[str]=None, start=None):
        ##

        ##

        chosen_start = self._verify_start(start)
        if self.parser_conf.parser_type != 'lalr':
            raise ConfigurationError("parse_interactive() currently only works with parser='lalr' ")
        stream = self._make_lexer_thread(text)  ##

        return self.parser.parse_interactive(stream, chosen_start)


def _validate_frontend_args(parser, lexer) -> None:
    assert_config(parser, ('lalr', 'earley', 'cyk'))
    if not isinstance(lexer, type):     ##

        expected = {
            'lalr': ('basic', 'contextual'),
            'earley': ('basic', 'dynamic', 'dynamic_complete'),
            'cyk': ('basic', ),
         }[parser]
        assert_config(lexer, expected, 'Parser %r does not support lexer %%r, expected one of %%s' % parser)


def _get_lexer_callbacks(transformer, terminals):
    result = {}
    for terminal in terminals:
        callback = getattr(transformer, terminal.name, None)
        if callback is not None:
            result[terminal.name] = callback
    return result

class PostLexConnector:
    def __init__(self, lexer, postlexer):
        self.lexer = lexer
        self.postlexer = postlexer

    def lex(self, lexer_state, parser_state):
        i = self.lexer.lex(lexer_state, parser_state)
        return self.postlexer.process(i)



def create_basic_lexer(lexer_conf, parser, postlex, options) -> BasicLexer:
    cls = (options and options._plugins.get('BasicLexer')) or BasicLexer
    return cls(lexer_conf)

def create_contextual_lexer(lexer_conf: LexerConf, parser, postlex, options) -> ContextualLexer:
    cls = (options and options._plugins.get('ContextualLexer')) or ContextualLexer
    states: Dict[str, Collection[str]] = {idx:list(t.keys()) for idx, t in parser._parse_table.states.items()}
    always_accept: Collection[str] = postlex.always_accept if postlex else ()
    return cls(lexer_conf, states, always_accept=always_accept)

def create_lalr_parser(lexer_conf: LexerConf, parser_conf: ParserConf, options=None) -> LALR_Parser:
    debug = options.debug if options else False
    strict = options.strict if options else False
    cls = (options and options._plugins.get('LALR_Parser')) or LALR_Parser
    return cls(parser_conf, debug=debug, strict=strict)

_parser_creators['lalr'] = create_lalr_parser




class PostLex(ABC):
    @abstractmethod
    def process(self, stream: Iterator[Token]) -> Iterator[Token]:
        return stream

    always_accept: Iterable[str] = ()

class LarkOptions(Serialize):
    #--

    start: List[str]
    debug: bool
    strict: bool
    transformer: 'Optional[Transformer]'
    propagate_positions: Union[bool, str]
    maybe_placeholders: bool
    cache: Union[bool, str]
    regex: bool
    g_regex_flags: int
    keep_all_tokens: bool
    tree_class: Any
    parser: _ParserArgType
    lexer: _LexerArgType
    ambiguity: 'Literal["auto", "resolve", "explicit", "forest"]'
    postlex: Optional[PostLex]
    priority: 'Optional[Literal["auto", "normal", "invert"]]'
    lexer_callbacks: Dict[str, Callable[[Token], Token]]
    use_bytes: bool
    edit_terminals: Optional[Callable[[TerminalDef], TerminalDef]]
    import_paths: 'List[Union[str, Callable[[Union[None, str, PackageResource], str], Tuple[str, str]]]]'
    source_path: Optional[str]

    OPTIONS_DOC = """
    **===  General Options  ===**

    start
            The start symbol. Either a string, or a list of strings for multiple possible starts (Default: "start")
    debug
            Display debug information and extra warnings. Use only when debugging (Default: ``False``)
            When used with Earley, it generates a forest graph as "sppf.png", if 'dot' is installed.
    strict
            Throw an exception on any potential ambiguity, including shift/reduce conflicts, and regex collisions.
    transformer
            Applies the transformer to every parse tree (equivalent to applying it after the parse, but faster)
    propagate_positions
            Propagates positional attributes into the 'meta' attribute of all tree branches.
            Sets attributes: (line, column, end_line, end_column, start_pos, end_pos,
                              container_line, container_column, container_end_line, container_end_column)
            Accepts ``False``, ``True``, or a callable, which will filter which nodes to ignore when propagating.
    maybe_placeholders
            When ``True``, the ``[]`` operator returns ``None`` when not matched.
            When ``False``,  ``[]`` behaves like the ``?`` operator, and returns no value at all.
            (default= ``True``)
    cache
            Cache the results of the Lark grammar analysis, for x2 to x3 faster loading. LALR only for now.

            - When ``False``, does nothing (default)
            - When ``True``, caches to a temporary file in the local directory
            - When given a string, caches to the path pointed by the string
    regex
            When True, uses the ``regex`` module instead of the stdlib ``re``.
    g_regex_flags
            Flags that are applied to all terminals (both regex and strings)
    keep_all_tokens
            Prevent the tree builder from automagically removing "punctuation" tokens (Default: ``False``)
    tree_class
            Lark will produce trees comprised of instances of this class instead of the default ``lark.Tree``.

    **=== Algorithm Options ===**

    parser
            Decides which parser engine to use. Accepts "earley" or "lalr". (Default: "earley").
            (there is also a "cyk" option for legacy)
    lexer
            Decides whether or not to use a lexer stage

            - "auto" (default): Choose for me based on the parser
            - "basic": Use a basic lexer
            - "contextual": Stronger lexer (only works with parser="lalr")
            - "dynamic": Flexible and powerful (only with parser="earley")
            - "dynamic_complete": Same as dynamic, but tries *every* variation of tokenizing possible.
    ambiguity
            Decides how to handle ambiguity in the parse. Only relevant if parser="earley"

            - "resolve": The parser will automatically choose the simplest derivation
              (it chooses consistently: greedy for tokens, non-greedy for rules)
            - "explicit": The parser will return all derivations wrapped in "_ambig" tree nodes (i.e. a forest).
            - "forest": The parser will return the root of the shared packed parse forest.

    **=== Misc. / Domain Specific Options ===**

    postlex
            Lexer post-processing (Default: ``None``) Only works with the basic and contextual lexers.
    priority
            How priorities should be evaluated - "auto", ``None``, "normal", "invert" (Default: "auto")
    lexer_callbacks
            Dictionary of callbacks for the lexer. May alter tokens during lexing. Use with caution.
    use_bytes
            Accept an input of type ``bytes`` instead of ``str``.
    edit_terminals
            A callback for editing the terminals before parse.
    import_paths
            A List of either paths or loader functions to specify from where grammars are imported
    source_path
            Override the source of from where the grammar was loaded. Useful for relative imports and unconventional grammar loading
    **=== End of Options ===**
    """
    if __doc__:
        __doc__ += OPTIONS_DOC


    ##

    ##

    ##

    ##

    ##

    ##

    _defaults: Dict[str, Any] = {
        'debug': False,
        'strict': False,
        'keep_all_tokens': False,
        'tree_class': None,
        'cache': False,
        'postlex': None,
        'parser': 'earley',
        'lexer': 'auto',
        'transformer': None,
        'start': 'start',
        'priority': 'auto',
        'ambiguity': 'auto',
        'regex': False,
        'propagate_positions': False,
        'lexer_callbacks': {},
        'maybe_placeholders': True,
        'edit_terminals': None,
        'g_regex_flags': 0,
        'use_bytes': False,
        'import_paths': [],
        'source_path': None,
        '_plugins': {},
    }

    def __init__(self, options_dict: Dict[str, Any]) -> None:
        o = dict(options_dict)

        options = {}
        for name, default in self._defaults.items():
            if name in o:
                value = o.pop(name)
                if isinstance(default, bool) and name not in ('cache', 'use_bytes', 'propagate_positions'):
                    value = bool(value)
            else:
                value = default

            options[name] = value

        if isinstance(options['start'], str):
            options['start'] = [options['start']]

        self.__dict__['options'] = options


        assert_config(self.parser, ('earley', 'lalr', 'cyk', None))

        if self.parser == 'earley' and self.transformer:
            raise ConfigurationError('Cannot specify an embedded transformer when using the Earley algorithm. '
                             'Please use your transformer on the resulting parse tree, or use a different algorithm (i.e. LALR)')

        if o:
            raise ConfigurationError("Unknown options: %s" % o.keys())

    def __getattr__(self, name: str) -> Any:
        try:
            return self.__dict__['options'][name]
        except KeyError as e:
            raise AttributeError(e)

    def __setattr__(self, name: str, value: str) -> None:
        assert_config(name, self.options.keys(), "%r isn't a valid option. Expected one of: %s")
        self.options[name] = value

    def serialize(self, memo = None) -> Dict[str, Any]:
        return self.options

    @classmethod
    def deserialize(cls, data: Dict[str, Any], memo: Dict[int, Union[TerminalDef, Rule]]) -> "LarkOptions":
        return cls(data)


##

##

_LOAD_ALLOWED_OPTIONS = {'postlex', 'transformer', 'lexer_callbacks', 'use_bytes', 'debug', 'g_regex_flags', 'regex', 'propagate_positions', 'tree_class', '_plugins'}

_VALID_PRIORITY_OPTIONS = ('auto', 'normal', 'invert', None)
_VALID_AMBIGUITY_OPTIONS = ('auto', 'resolve', 'explicit', 'forest')


_T = TypeVar('_T', bound="Lark")

class Lark(Serialize):
    #--

    source_path: str
    source_grammar: str
    grammar: 'Grammar'
    options: LarkOptions
    lexer: Lexer
    parser: 'ParsingFrontend'
    terminals: Collection[TerminalDef]

    def __init__(self, grammar: 'Union[Grammar, str, IO[str]]', **options) -> None:
        self.options = LarkOptions(options)
        re_module: types.ModuleType

        ##

        use_regex = self.options.regex
        if use_regex:
            if _has_regex:
                re_module = regex
            else:
                raise ImportError('`regex` module must be installed if calling `Lark(regex=True)`.')
        else:
            re_module = re

        ##

        if self.options.source_path is None:
            try:
                self.source_path = grammar.name  ##

            except AttributeError:
                self.source_path = '<string>'
        else:
            self.source_path = self.options.source_path

        ##

        try:
            read = grammar.read  ##

        except AttributeError:
            pass
        else:
            grammar = read()

        cache_fn = None
        cache_sha256 = None
        if isinstance(grammar, str):
            self.source_grammar = grammar
            if self.options.use_bytes:
                if not isascii(grammar):
                    raise ConfigurationError("Grammar must be ascii only, when use_bytes=True")

            if self.options.cache:
                if self.options.parser != 'lalr':
                    raise ConfigurationError("cache only works with parser='lalr' for now")

                unhashable = ('transformer', 'postlex', 'lexer_callbacks', 'edit_terminals', '_plugins')
                options_str = ''.join(k+str(v) for k, v in options.items() if k not in unhashable)
                from . import __version__
                s = grammar + options_str + __version__ + str(sys.version_info[:2])
                cache_sha256 = sha256_digest(s)

                if isinstance(self.options.cache, str):
                    cache_fn = self.options.cache
                else:
                    if self.options.cache is not True:
                        raise ConfigurationError("cache argument must be bool or str")

                    try:
                        username = getpass.getuser()
                    except Exception:
                        ##

                        ##

                        ##

                        username = "unknown"

                    cache_fn = tempfile.gettempdir() + "/.lark_cache_%s_%s_%s_%s.tmp" % (username, cache_sha256, *sys.version_info[:2])

                old_options = self.options
                try:
                    with FS.open(cache_fn, 'rb') as f:
                        logger.debug('Loading grammar from cache: %s', cache_fn)
                        ##

                        for name in (set(options) - _LOAD_ALLOWED_OPTIONS):
                            del options[name]
                        file_sha256 = f.readline().rstrip(b'\n')
                        cached_used_files = pickle.load(f)
                        if file_sha256 == cache_sha256.encode('utf8') and verify_used_files(cached_used_files):
                            cached_parser_data = pickle.load(f)
                            self._load(cached_parser_data, **options)
                            return
                except FileNotFoundError:
                    ##

                    pass
                except Exception: ##

                    logger.exception("Failed to load Lark from cache: %r. We will try to carry on.", cache_fn)

                    ##

                    ##

                    self.options = old_options


            ##

            self.grammar, used_files = load_grammar(grammar, self.source_path, self.options.import_paths, self.options.keep_all_tokens)
        else:
            assert isinstance(grammar, Grammar)
            self.grammar = grammar


        if self.options.lexer == 'auto':
            if self.options.parser == 'lalr':
                self.options.lexer = 'contextual'
            elif self.options.parser == 'earley':
                if self.options.postlex is not None:
                    logger.info("postlex can't be used with the dynamic lexer, so we use 'basic' instead. "
                                "Consider using lalr with contextual instead of earley")
                    self.options.lexer = 'basic'
                else:
                    self.options.lexer = 'dynamic'
            elif self.options.parser == 'cyk':
                self.options.lexer = 'basic'
            else:
                assert False, self.options.parser
        lexer = self.options.lexer
        if isinstance(lexer, type):
            assert issubclass(lexer, Lexer)     ##

        else:
            assert_config(lexer, ('basic', 'contextual', 'dynamic', 'dynamic_complete'))
            if self.options.postlex is not None and 'dynamic' in lexer:
                raise ConfigurationError("Can't use postlex with a dynamic lexer. Use basic or contextual instead")

        if self.options.ambiguity == 'auto':
            if self.options.parser == 'earley':
                self.options.ambiguity = 'resolve'
        else:
            assert_config(self.options.parser, ('earley', 'cyk'), "%r doesn't support disambiguation. Use one of these parsers instead: %s")

        if self.options.priority == 'auto':
            self.options.priority = 'normal'

        if self.options.priority not in _VALID_PRIORITY_OPTIONS:
            raise ConfigurationError("invalid priority option: %r. Must be one of %r" % (self.options.priority, _VALID_PRIORITY_OPTIONS))
        if self.options.ambiguity not in _VALID_AMBIGUITY_OPTIONS:
            raise ConfigurationError("invalid ambiguity option: %r. Must be one of %r" % (self.options.ambiguity, _VALID_AMBIGUITY_OPTIONS))

        if self.options.parser is None:
            terminals_to_keep = '*'
        elif self.options.postlex is not None:
            terminals_to_keep = set(self.options.postlex.always_accept)
        else:
            terminals_to_keep = set()

        ##

        self.terminals, self.rules, self.ignore_tokens = self.grammar.compile(self.options.start, terminals_to_keep)

        if self.options.edit_terminals:
            for t in self.terminals:
                self.options.edit_terminals(t)

        self._terminals_dict = {t.name: t for t in self.terminals}

        ##

        if self.options.priority == 'invert':
            for rule in self.rules:
                if rule.options.priority is not None:
                    rule.options.priority = -rule.options.priority
            for term in self.terminals:
                term.priority = -term.priority
        ##

        ##

        ##

        elif self.options.priority is None:
            for rule in self.rules:
                if rule.options.priority is not None:
                    rule.options.priority = None
            for term in self.terminals:
                term.priority = 0

        ##

        self.lexer_conf = LexerConf(
                self.terminals, re_module, self.ignore_tokens, self.options.postlex,
                self.options.lexer_callbacks, self.options.g_regex_flags, use_bytes=self.options.use_bytes, strict=self.options.strict
            )

        if self.options.parser:
            self.parser = self._build_parser()
        elif lexer:
            self.lexer = self._build_lexer()

        if cache_fn:
            logger.debug('Saving grammar to cache: %s', cache_fn)
            try:
                with FS.open(cache_fn, 'wb') as f:
                    assert cache_sha256 is not None
                    f.write(cache_sha256.encode('utf8') + b'\n')
                    pickle.dump(used_files, f)
                    self.save(f, _LOAD_ALLOWED_OPTIONS)
            except IOError as e:
                logger.exception("Failed to save Lark to cache: %r.", cache_fn, e)

    if __doc__:
        __doc__ += "\n\n" + LarkOptions.OPTIONS_DOC

    __serialize_fields__ = 'parser', 'rules', 'options'

    def _build_lexer(self, dont_ignore: bool=False) -> BasicLexer:
        lexer_conf = self.lexer_conf
        if dont_ignore:
            from copy import copy
            lexer_conf = copy(lexer_conf)
            lexer_conf.ignore = ()
        return BasicLexer(lexer_conf)

    def _prepare_callbacks(self) -> None:
        self._callbacks = {}
        ##

        if self.options.ambiguity != 'forest':
            self._parse_tree_builder = ParseTreeBuilder(
                    self.rules,
                    self.options.tree_class or Tree,
                    self.options.propagate_positions,
                    self.options.parser != 'lalr' and self.options.ambiguity == 'explicit',
                    self.options.maybe_placeholders
                )
            self._callbacks = self._parse_tree_builder.create_callback(self.options.transformer)
        self._callbacks.update(_get_lexer_callbacks(self.options.transformer, self.terminals))

    def _build_parser(self) -> "ParsingFrontend":
        self._prepare_callbacks()
        _validate_frontend_args(self.options.parser, self.options.lexer)
        parser_conf = ParserConf(self.rules, self._callbacks, self.options.start)
        return _construct_parsing_frontend(
            self.options.parser,
            self.options.lexer,
            self.lexer_conf,
            parser_conf,
            options=self.options
        )

    def save(self, f, exclude_options: Collection[str] = ()) -> None:
        #--
        data, m = self.memo_serialize([TerminalDef, Rule])
        if exclude_options:
            data["options"] = {n: v for n, v in data["options"].items() if n not in exclude_options}
        pickle.dump({'data': data, 'memo': m}, f, protocol=pickle.HIGHEST_PROTOCOL)

    @classmethod
    def load(cls: Type[_T], f) -> _T:
        #--
        inst = cls.__new__(cls)
        return inst._load(f)

    def _deserialize_lexer_conf(self, data: Dict[str, Any], memo: Dict[int, Union[TerminalDef, Rule]], options: LarkOptions) -> LexerConf:
        lexer_conf = LexerConf.deserialize(data['lexer_conf'], memo)
        lexer_conf.callbacks = options.lexer_callbacks or {}
        lexer_conf.re_module = regex if options.regex else re
        lexer_conf.use_bytes = options.use_bytes
        lexer_conf.g_regex_flags = options.g_regex_flags
        lexer_conf.skip_validation = True
        lexer_conf.postlex = options.postlex
        return lexer_conf

    def _load(self: _T, f: Any, **kwargs) -> _T:
        if isinstance(f, dict):
            d = f
        else:
            d = pickle.load(f)
        memo_json = d['memo']
        data = d['data']

        assert memo_json
        memo = SerializeMemoizer.deserialize(memo_json, {'Rule': Rule, 'TerminalDef': TerminalDef}, {})
        options = dict(data['options'])
        if (set(kwargs) - _LOAD_ALLOWED_OPTIONS) & set(LarkOptions._defaults):
            raise ConfigurationError("Some options are not allowed when loading a Parser: {}"
                             .format(set(kwargs) - _LOAD_ALLOWED_OPTIONS))
        options.update(kwargs)
        self.options = LarkOptions.deserialize(options, memo)
        self.rules = [Rule.deserialize(r, memo) for r in data['rules']]
        self.source_path = '<deserialized>'
        _validate_frontend_args(self.options.parser, self.options.lexer)
        self.lexer_conf = self._deserialize_lexer_conf(data['parser'], memo, self.options)
        self.terminals = self.lexer_conf.terminals
        self._prepare_callbacks()
        self._terminals_dict = {t.name: t for t in self.terminals}
        self.parser = _deserialize_parsing_frontend(
            data['parser'],
            memo,
            self.lexer_conf,
            self._callbacks,
            self.options,  ##

        )
        return self

    @classmethod
    def _load_from_dict(cls, data, memo, **kwargs):
        inst = cls.__new__(cls)
        return inst._load({'data': data, 'memo': memo}, **kwargs)

    @classmethod
    def open(cls: Type[_T], grammar_filename: str, rel_to: Optional[str]=None, **options) -> _T:
        #--
        if rel_to:
            basepath = os.path.dirname(rel_to)
            grammar_filename = os.path.join(basepath, grammar_filename)
        with open(grammar_filename, encoding='utf8') as f:
            return cls(f, **options)

    @classmethod
    def open_from_package(cls: Type[_T], package: str, grammar_path: str, search_paths: 'Sequence[str]'=[""], **options) -> _T:
        #--
        package_loader = FromPackageLoader(package, search_paths)
        full_path, text = package_loader(None, grammar_path)
        options.setdefault('source_path', full_path)
        options.setdefault('import_paths', [])
        options['import_paths'].append(package_loader)
        return cls(text, **options)

    def __repr__(self):
        return 'Lark(open(%r), parser=%r, lexer=%r, ...)' % (self.source_path, self.options.parser, self.options.lexer)


    def lex(self, text: str, dont_ignore: bool=False) -> Iterator[Token]:
        #--
        lexer: Lexer
        if not hasattr(self, 'lexer') or dont_ignore:
            lexer = self._build_lexer(dont_ignore)
        else:
            lexer = self.lexer
        lexer_thread = LexerThread.from_text(lexer, text)
        stream = lexer_thread.lex(None)
        if self.options.postlex:
            return self.options.postlex.process(stream)
        return stream

    def get_terminal(self, name: str) -> TerminalDef:
        #--
        return self._terminals_dict[name]

    def parse_interactive(self, text: Optional[str]=None, start: Optional[str]=None) -> 'InteractiveParser':
        #--
        return self.parser.parse_interactive(text, start=start)

    def parse(self, text: str, start: Optional[str]=None, on_error: 'Optional[Callable[[UnexpectedInput], bool]]'=None) -> 'ParseTree':
        #--
        return self.parser.parse(text, start=start, on_error=on_error)




class DedentError(LarkError):
    pass

class Indenter(PostLex, ABC):
    paren_level: int
    indent_level: List[int]

    def __init__(self) -> None:
        self.paren_level = 0
        self.indent_level = [0]
        assert self.tab_len > 0

    def handle_NL(self, token: Token) -> Iterator[Token]:
        if self.paren_level > 0:
            return

        yield token

        indent_str = token.rsplit('\n', 1)[1] ##

        indent = indent_str.count(' ') + indent_str.count('\t') * self.tab_len

        if indent > self.indent_level[-1]:
            self.indent_level.append(indent)
            yield Token.new_borrow_pos(self.INDENT_type, indent_str, token)
        else:
            while indent < self.indent_level[-1]:
                self.indent_level.pop()
                yield Token.new_borrow_pos(self.DEDENT_type, indent_str, token)

            if indent != self.indent_level[-1]:
                raise DedentError('Unexpected dedent to column %s. Expected dedent to %s' % (indent, self.indent_level[-1]))

    def _process(self, stream):
        for token in stream:
            if token.type == self.NL_type:
                yield from self.handle_NL(token)
            else:
                yield token

            if token.type in self.OPEN_PAREN_types:
                self.paren_level += 1
            elif token.type in self.CLOSE_PAREN_types:
                self.paren_level -= 1
                assert self.paren_level >= 0

        while len(self.indent_level) > 1:
            self.indent_level.pop()
            yield Token(self.DEDENT_type, '')

        assert self.indent_level == [0], self.indent_level

    def process(self, stream):
        self.paren_level = 0
        self.indent_level = [0]
        return self._process(stream)

    ##

    @property
    def always_accept(self):
        return (self.NL_type,)

    @property
    @abstractmethod
    def NL_type(self) -> str:
        raise NotImplementedError()

    @property
    @abstractmethod
    def OPEN_PAREN_types(self) -> List[str]:
        raise NotImplementedError()

    @property
    @abstractmethod
    def CLOSE_PAREN_types(self) -> List[str]:
        raise NotImplementedError()

    @property
    @abstractmethod
    def INDENT_type(self) -> str:
        raise NotImplementedError()

    @property
    @abstractmethod
    def DEDENT_type(self) -> str:
        raise NotImplementedError()

    @property
    @abstractmethod
    def tab_len(self) -> int:
        raise NotImplementedError()


class PythonIndenter(Indenter):
    NL_type = '_NEWLINE'
    OPEN_PAREN_types = ['LPAR', 'LSQB', 'LBRACE']
    CLOSE_PAREN_types = ['RPAR', 'RSQB', 'RBRACE']
    INDENT_type = '_INDENT'
    DEDENT_type = '_DEDENT'
    tab_len = 8


import pickle, zlib, base64
DATA = (
{'parser': {'lexer_conf': {'terminals': [{'@': 0}, {'@': 1}, {'@': 2}, {'@': 3}, {'@': 4}, {'@': 5}, {'@': 6}, {'@': 7}, {'@': 8}, {'@': 9}, {'@': 10}, {'@': 11}, {'@': 12}, {'@': 13}, {'@': 14}, {'@': 15}, {'@': 16}, {'@': 17}, {'@': 18}, {'@': 19}, {'@': 20}, {'@': 21}, {'@': 22}, {'@': 23}, {'@': 24}, {'@': 25}, {'@': 26}, {'@': 27}, {'@': 28}, {'@': 29}, {'@': 30}], 'ignore': [], 'g_regex_flags': 0, 'use_bytes': False, 'lexer_type': 'contextual', '__type__': 'LexerConf'}, 'parser_conf': {'rules': [{'@': 31}, {'@': 32}, {'@': 33}, {'@': 34}, {'@': 35}, {'@': 36}, {'@': 37}, {'@': 38}, {'@': 39}, {'@': 40}, {'@': 41}, {'@': 42}, {'@': 43}, {'@': 44}, {'@': 45}, {'@': 46}, {'@': 47}, {'@': 48}, {'@': 49}, {'@': 50}, {'@': 51}, {'@': 52}, {'@': 53}, {'@': 54}, {'@': 55}, {'@': 56}, {'@': 57}, {'@': 58}, {'@': 59}, {'@': 60}, {'@': 61}, {'@': 62}, {'@': 63}, {'@': 64}, {'@': 65}, {'@': 66}, {'@': 67}, {'@': 68}, {'@': 69}, {'@': 70}, {'@': 71}, {'@': 72}, {'@': 73}, {'@': 74}, {'@': 75}, {'@': 76}, {'@': 77}, {'@': 78}, {'@': 79}, {'@': 80}, {'@': 81}, {'@': 82}, {'@': 83}, {'@': 84}, {'@': 85}, {'@': 86}, {'@': 87}, {'@': 88}, {'@': 89}, {'@': 90}, {'@': 91}, {'@': 92}, {'@': 93}, {'@': 94}, {'@': 95}, {'@': 96}, {'@': 97}, {'@': 98}, {'@': 99}, {'@': 100}, {'@': 101}, {'@': 102}, {'@': 103}, {'@': 104}, {'@': 105}, {'@': 106}, {'@': 107}, {'@': 108}, {'@': 109}, {'@': 110}, {'@': 111}, {'@': 112}, {'@': 113}, {'@': 114}, {'@': 115}, {'@': 116}, {'@': 117}, {'@': 118}, {'@': 119}, {'@': 120}, {'@': 121}, {'@': 122}, {'@': 123}, {'@': 124}, {'@': 125}, {'@': 126}, {'@': 127}, {'@': 128}, {'@': 129}, {'@': 130}, {'@': 131}, {'@': 132}, {'@': 133}, {'@': 134}, {'@': 135}, {'@': 136}, {'@': 137}, {'@': 138}, {'@': 139}, {'@': 140}, {'@': 141}, {'@': 142}, {'@': 143}, {'@': 144}, {'@': 145}, {'@': 146}, {'@': 147}, {'@': 148}, {'@': 149}, {'@': 150}, {'@': 151}, {'@': 152}, {'@': 153}, {'@': 154}, {'@': 155}, {'@': 156}, {'@': 157}, {'@': 158}, {'@': 159}, {'@': 160}, {'@': 161}, {'@': 162}, {'@': 163}, {'@': 164}, {'@': 165}, {'@': 166}, {'@': 167}, {'@': 168}, {'@': 169}, {'@': 170}, {'@': 171}, {'@': 172}, {'@': 173}, {'@': 174}, {'@': 175}, {'@': 176}, {'@': 177}, {'@': 178}, {'@': 179}, {'@': 180}, {'@': 181}, {'@': 182}, {'@': 183}, {'@': 184}, {'@': 185}, {'@': 186}, {'@': 187}, {'@': 188}, {'@': 189}, {'@': 190}, {'@': 191}, {'@': 192}, {'@': 193}, {'@': 194}, {'@': 195}, {'@': 196}, {'@': 197}, {'@': 198}, {'@': 199}, {'@': 200}, {'@': 201}, {'@': 202}, {'@': 203}, {'@': 204}, {'@': 205}, {'@': 206}, {'@': 207}, {'@': 208}, {'@': 209}, {'@': 210}, {'@': 211}, {'@': 212}, {'@': 213}, {'@': 214}, {'@': 215}, {'@': 216}, {'@': 217}, {'@': 218}], 'start': ['start'], 'parser_type': 'lalr', '__type__': 'ParserConf'}, 'parser': {'tokens': {0: 'PHANTOMS', 1: 'SLASH', 2: 'BOX_NAME', 3: 'PERCENT', 4: 'BREAK', 5: 'CONSTRAINT_LPAREN', 6: 'NL', 7: 'MINUS', 8: 'INDENT', 9: '$END', 10: 'PLUS', 11: 'RBRACKET', 12: 'seq{constraint_target}', 13: 'constraint_target', 14: 'box_name', 15: 'COLON', 16: 'CONSTRAINT_LEG', 17: 'SP', 18: 'constraint_leg', 19: 'box_name_ref', 20: '__constraint_target_star_1', 21: 'COMMA', 22: 'leg_arrow', 23: 'LBRACKET', 24: 'LEG_ARROW', 25: 'entity_name_ref', 26: 'inheritance_parent', 27: 'comment', 28: 'assoc_name_def', 29: 'box_def_prefix', 30: 'assoc_clause', 31: 'constraint_clause', 32: 'entity_clause', 33: 'entity_name_def', 34: 'inheritance_clause', 35: 'phantoms', 36: 'clause', 37: '__ANON_1', 38: 'seq{inheritance_child}', 39: 'inheritance_child', 40: 'ATTR', 41: 'HASHTAG', 42: 'inheritance_name', 43: 'BACKSLASH', 44: 'INHERITANCE_NAME', 45: 'indent', 46: 'start', 47: 'line', 48: '__start_star_0', 49: 'break_', 50: 'NUMBER', 51: 'constraint_coords', 52: '_constraint_coord', 53: 'CONSTRAINT_RPAREN', 54: 'constraint_name', 55: 'CONSTRAINT_NAME', 56: '__seq{inheritance_child}_star_7', 57: 'note', 58: '__ANON_0', 59: 'leg_note', 60: 'INHERITANCE_ARROW', 61: 'inheritance_arrow', 62: 'MORETHAN', 63: 'ID_MARK', 64: 'attr', 65: 'assoc_attr', 66: 'typed_attr', 67: 'seq{assoc_attr}', 68: '_id_symbols', 69: 'entity_or_table_attr', 70: 'id_mark', 71: 'ID_GROUPS', 72: 'id_groups', 73: 'that_table', 74: 'foreign_reference', 75: 'this_table_attr', 76: 'seq{entity_or_table_attr}', 77: 'CARD', 78: 'card', 79: 'seq{typed_attr}', 80: 'constraint_note', 81: '_assoc_card', 82: 'card_prefix', 83: 'assoc_leg', 84: 'card_hidden', 85: '__seq{typed_attr}_star_6', 86: 'seq{assoc_leg}', 87: '__seq{constraint_target}_star_5', 88: '__seq{assoc_attr}_star_2', 89: 'that_table_attr', 90: '__seq{entity_or_table_attr}_star_4', 91: 'datatype', 92: '__seq{assoc_leg}_star_3'}, 'states': {0: {0: (1, {'@': 119}), 1: (1, {'@': 119}), 2: (1, {'@': 119}), 3: (1, {'@': 119}), 4: (1, {'@': 119}), 5: (1, {'@': 119}), 6: (1, {'@': 119}), 7: (1, {'@': 119}), 8: (1, {'@': 119}), 9: (1, {'@': 119}), 10: (1, {'@': 119})}, 1: {11: (0, 173)}, 2: {12: (0, 310), 13: (0, 241), 14: (0, 215), 15: (0, 117), 2: (0, 60), 16: (0, 237), 6: (0, 126), 17: (0, 221), 18: (0, 239), 19: (0, 224), 20: (0, 232)}, 3: {6: (1, {'@': 68}), 15: (1, {'@': 68}), 21: (1, {'@': 68})}, 4: {0: (1, {'@': 43}), 1: (1, {'@': 43}), 2: (1, {'@': 43}), 5: (1, {'@': 43}), 3: (1, {'@': 43}), 4: (1, {'@': 43}), 6: (1, {'@': 43}), 7: (1, {'@': 43}), 8: (1, {'@': 43}), 9: (1, {'@': 43}), 10: (1, {'@': 43})}, 5: {21: (1, {'@': 59}), 15: (1, {'@': 99})}, 6: {0: (1, {'@': 50}), 2: (1, {'@': 50}), 3: (1, {'@': 50}), 6: (1, {'@': 50}), 7: (1, {'@': 50}), 1: (1, {'@': 50}), 4: (1, {'@': 50}), 5: (1, {'@': 50}), 8: (1, {'@': 50}), 9: (1, {'@': 50}), 10: (1, {'@': 50})}, 7: {17: (0, 249), 22: (0, 93), 23: (0, 70), 24: (0, 362), 25: (0, 79), 2: (0, 60), 14: (0, 341)}, 8: {17: (0, 323), 26: (0, 123), 2: (0, 60), 25: (0, 246), 14: (0, 341)}, 9: {6: (1, {'@': 82}), 15: (1, {'@': 82}), 21: (1, {'@': 82})}, 10: {0: (1, {'@': 49}), 2: (1, {'@': 49}), 3: (1, {'@': 49}), 6: (1, {'@': 49}), 7: (1, {'@': 49}), 1: (1, {'@': 49}), 4: (1, {'@': 49}), 5: (1, {'@': 49}), 8: (1, {'@': 49}), 9: (1, {'@': 49}), 10: (1, {'@': 49})}, 11: {15: (0, 228), 23: (0, 251), 12: (0, 250), 13: (0, 241), 14: (0, 215), 2: (0, 60), 6: (0, 218), 19: (0, 224), 20: (0, 232), 16: (0, 237), 17: (0, 221), 18: (0, 239)}, 12: {5: (0, 42), 14: (0, 5), 1: (0, 21), 2: (0, 60), 27: (0, 273), 28: (0, 82), 0: (0, 86), 6: (0, 284), 10: (0, 19), 29: (0, 26), 30: (0, 10), 31: (0, 36), 3: (0, 13), 32: (0, 6), 33: (0, 53), 34: (0, 34), 7: (0, 160), 35: (0, 297), 36: (0, 4)}, 13: {37: (0, 262)}, 14: {0: (1, {'@': 182}), 1: (1, {'@': 182}), 2: (1, {'@': 182}), 5: (1, {'@': 182}), 3: (1, {'@': 182}), 4: (1, {'@': 182}), 6: (1, {'@': 182}), 7: (1, {'@': 182}), 8: (1, {'@': 182}), 9: (1, {'@': 182}), 10: (1, {'@': 182})}, 15: {2: (0, 60), 38: (0, 302), 39: (0, 47), 25: (0, 38), 14: (0, 341)}, 16: {0: (1, {'@': 202}), 1: (1, {'@': 202}), 2: (1, {'@': 202}), 5: (1, {'@': 202}), 3: (1, {'@': 202}), 4: (1, {'@': 202}), 6: (1, {'@': 202}), 7: (1, {'@': 202}), 8: (1, {'@': 202}), 9: (1, {'@': 202}), 10: (1, {'@': 202})}, 17: {0: (1, {'@': 113}), 1: (1, {'@': 113}), 2: (1, {'@': 113}), 3: (1, {'@': 113}), 4: (1, {'@': 113}), 5: (1, {'@': 113}), 6: (1, {'@': 113}), 7: (1, {'@': 113}), 8: (1, {'@': 113}), 9: (1, {'@': 113}), 10: (1, {'@': 113})}, 18: {0: (1, {'@': 167}), 1: (1, {'@': 167}), 2: (1, {'@': 167}), 3: (1, {'@': 167}), 4: (1, {'@': 167}), 5: (1, {'@': 167}), 6: (1, {'@': 167}), 7: (1, {'@': 167}), 8: (1, {'@': 167}), 9: (1, {'@': 167}), 10: (1, {'@': 167})}, 19: {2: (1, {'@': 36})}, 20: {40: (1, {'@': 104}), 6: (1, {'@': 104}), 41: (1, {'@': 104}), 21: (1, {'@': 104})}, 21: {42: (0, 293), 43: (0, 274), 44: (0, 279)}, 22: {6: (0, 69)}, 23: {6: (1, {'@': 64}), 15: (1, {'@': 64}), 21: (1, {'@': 64})}, 24: {5: (0, 42), 4: (0, 14), 1: (0, 21), 45: (0, 12), 27: (0, 30), 14: (0, 5), 2: (0, 60), 46: (0, 50), 28: (0, 82), 0: (0, 86), 47: (0, 16), 10: (0, 19), 29: (0, 26), 48: (0, 29), 30: (0, 10), 31: (0, 36), 3: (0, 13), 35: (0, 40), 49: (0, 67), 8: (0, 89), 36: (0, 46), 32: (0, 6), 33: (0, 53), 34: (0, 34), 7: (0, 160), 6: (0, 268), 9: (1, {'@': 40})}, 25: {38: (0, 158), 2: (0, 60), 39: (0, 47), 25: (0, 38), 14: (0, 341)}, 26: {14: (0, 5), 2: (0, 60), 33: (0, 143), 28: (0, 105)}, 27: {0: (1, {'@': 158}), 1: (1, {'@': 158}), 2: (1, {'@': 158}), 3: (1, {'@': 158}), 4: (1, {'@': 158}), 5: (1, {'@': 158}), 6: (1, {'@': 158}), 7: (1, {'@': 158}), 8: (1, {'@': 158}), 9: (1, {'@': 158}), 10: (1, {'@': 158})}, 28: {0: (1, {'@': 161}), 1: (1, {'@': 161}), 2: (1, {'@': 161}), 3: (1, {'@': 161}), 4: (1, {'@': 161}), 5: (1, {'@': 161}), 6: (1, {'@': 161}), 7: (1, {'@': 161}), 8: (1, {'@': 161}), 9: (1, {'@': 161}), 10: (1, {'@': 161})}, 29: {5: (0, 42), 14: (0, 5), 1: (0, 21), 45: (0, 12), 27: (0, 30), 2: (0, 60), 28: (0, 82), 0: (0, 86), 10: (0, 19), 49: (0, 94), 29: (0, 26), 30: (0, 10), 31: (0, 36), 3: (0, 13), 35: (0, 40), 47: (0, 96), 8: (0, 89), 36: (0, 46), 32: (0, 6), 33: (0, 53), 34: (0, 34), 7: (0, 160), 6: (0, 268), 4: (0, 14), 9: (1, {'@': 39})}, 30: {0: (1, {'@': 46}), 1: (1, {'@': 46}), 2: (1, {'@': 46}), 5: (1, {'@': 46}), 3: (1, {'@': 46}), 4: (1, {'@': 46}), 6: (1, {'@': 46}), 7: (1, {'@': 46}), 8: (1, {'@': 46}), 9: (1, {'@': 46}), 10: (1, {'@': 46})}, 31: {0: (1, {'@': 163}), 1: (1, {'@': 163}), 2: (1, {'@': 163}), 3: (1, {'@': 163}), 4: (1, {'@': 163}), 5: (1, {'@': 163}), 6: (1, {'@': 163}), 7: (1, {'@': 163}), 8: (1, {'@': 163}), 9: (1, {'@': 163}), 10: (1, {'@': 163})}, 32: {39: (0, 47), 17: (0, 288), 2: (0, 60), 25: (0, 38), 38: (0, 182), 14: (0, 341)}, 33: {6: (0, 84)}, 34: {0: (1, {'@': 52}), 2: (1, {'@': 52}), 3: (1, {'@': 52}), 6: (1, {'@': 52}), 7: (1, {'@': 52}), 1: (1, {'@': 52}), 4: (1, {'@': 52}), 5: (1, {'@': 52}), 8: (1, {'@': 52}), 9: (1, {'@': 52}), 10: (1, {'@': 52})}, 35: {0: (1, {'@': 166}), 1: (1, {'@': 166}), 2: (1, {'@': 166}), 3: (1, {'@': 166}), 4: (1, {'@': 166}), 5: (1, {'@': 166}), 6: (1, {'@': 166}), 7: (1, {'@': 166}), 8: (1, {'@': 166}), 9: (1, {'@': 166}), 10: (1, {'@': 166})}, 36: {0: (1, {'@': 51}), 2: (1, {'@': 51}), 3: (1, {'@': 51}), 6: (1, {'@': 51}), 7: (1, {'@': 51}), 1: (1, {'@': 51}), 4: (1, {'@': 51}), 5: (1, {'@': 51}), 8: (1, {'@': 51}), 9: (1, {'@': 51}), 10: (1, {'@': 51})}, 37: {0: (1, {'@': 155}), 1: (1, {'@': 155}), 2: (1, {'@': 155}), 3: (1, {'@': 155}), 4: (1, {'@': 155}), 5: (1, {'@': 155}), 6: (1, {'@': 155}), 7: (1, {'@': 155}), 8: (1, {'@': 155}), 9: (1, {'@': 155}), 10: (1, {'@': 155})}, 38: {6: (1, {'@': 176}), 15: (1, {'@': 176}), 21: (1, {'@': 176})}, 39: {15: (0, 255), 6: (0, 259)}, 40: {0: (1, {'@': 45}), 1: (1, {'@': 45}), 2: (1, {'@': 45}), 5: (1, {'@': 45}), 3: (1, {'@': 45}), 4: (1, {'@': 45}), 6: (1, {'@': 45}), 7: (1, {'@': 45}), 8: (1, {'@': 45}), 9: (1, {'@': 45}), 10: (1, {'@': 45})}, 41: {50: (0, 312), 19: (0, 325), 2: (0, 60), 51: (0, 299), 14: (0, 215), 52: (0, 217)}, 42: {53: (0, 11), 54: (0, 83), 55: (0, 290)}, 43: {6: (0, 109), 15: (0, 189)}, 44: {11: (0, 153)}, 45: {0: (1, {'@': 149}), 1: (1, {'@': 149}), 2: (1, {'@': 149}), 3: (1, {'@': 149}), 4: (1, {'@': 149}), 5: (1, {'@': 149}), 6: (1, {'@': 149}), 7: (1, {'@': 149}), 8: (1, {'@': 149}), 9: (1, {'@': 149}), 10: (1, {'@': 149})}, 46: {0: (1, {'@': 47}), 1: (1, {'@': 47}), 2: (1, {'@': 47}), 5: (1, {'@': 47}), 3: (1, {'@': 47}), 4: (1, {'@': 47}), 6: (1, {'@': 47}), 7: (1, {'@': 47}), 8: (1, {'@': 47}), 9: (1, {'@': 47}), 10: (1, {'@': 47})}, 47: {21: (0, 104), 56: (0, 154), 6: (1, {'@': 200}), 15: (1, {'@': 200})}, 48: {57: (0, 170), 58: (0, 118), 59: (0, 194), 11: (0, 176)}, 49: {17: (0, 278), 39: (0, 47), 38: (0, 181), 2: (0, 60), 25: (0, 38), 14: (0, 341)}, 50: {}, 51: {25: (0, 246), 26: (0, 364), 2: (0, 60), 14: (0, 341)}, 52: {0: (1, {'@': 147}), 1: (1, {'@': 147}), 2: (1, {'@': 147}), 3: (1, {'@': 147}), 4: (1, {'@': 147}), 5: (1, {'@': 147}), 6: (1, {'@': 147}), 7: (1, {'@': 147}), 8: (1, {'@': 147}), 9: (1, {'@': 147}), 10: (1, {'@': 147})}, 53: {15: (0, 120)}, 54: {0: (1, {'@': 56}), 1: (1, {'@': 56}), 2: (1, {'@': 56}), 3: (1, {'@': 56}), 4: (1, {'@': 56}), 5: (1, {'@': 56}), 6: (1, {'@': 56}), 7: (1, {'@': 56}), 8: (1, {'@': 56}), 9: (1, {'@': 56}), 10: (1, {'@': 56})}, 55: {6: (1, {'@': 216}), 21: (1, {'@': 216})}, 56: {60: (0, 136), 17: (0, 111), 61: (0, 165)}, 57: {2: (0, 60), 38: (0, 289), 39: (0, 47), 25: (0, 38), 14: (0, 341)}, 58: {11: (0, 195)}, 59: {2: (0, 60), 39: (0, 47), 25: (0, 38), 38: (0, 172), 14: (0, 341)}, 60: {6: (1, {'@': 179}), 15: (1, {'@': 179}), 21: (1, {'@': 179}), 17: (1, {'@': 179}), 60: (1, {'@': 179}), 62: (1, {'@': 179})}, 61: {63: (1, {'@': 188})}, 62: {6: (1, {'@': 217}), 15: (1, {'@': 217}), 21: (1, {'@': 217})}, 63: {6: (1, {'@': 69}), 15: (1, {'@': 69}), 21: (1, {'@': 69})}, 64: {0: (1, {'@': 145}), 1: (1, {'@': 145}), 2: (1, {'@': 145}), 3: (1, {'@': 145}), 4: (1, {'@': 145}), 5: (1, {'@': 145}), 6: (1, {'@': 145}), 7: (1, {'@': 145}), 8: (1, {'@': 145}), 9: (1, {'@': 145}), 10: (1, {'@': 145})}, 65: {6: (1, {'@': 80}), 15: (1, {'@': 80}), 21: (1, {'@': 80})}, 66: {0: (1, {'@': 143}), 1: (1, {'@': 143}), 2: (1, {'@': 143}), 3: (1, {'@': 143}), 4: (1, {'@': 143}), 5: (1, {'@': 143}), 6: (1, {'@': 143}), 7: (1, {'@': 143}), 8: (1, {'@': 143}), 9: (1, {'@': 143}), 10: (1, {'@': 143})}, 67: {0: (1, {'@': 201}), 1: (1, {'@': 201}), 2: (1, {'@': 201}), 5: (1, {'@': 201}), 3: (1, {'@': 201}), 4: (1, {'@': 201}), 6: (1, {'@': 201}), 7: (1, {'@': 201}), 8: (1, {'@': 201}), 9: (1, {'@': 201}), 10: (1, {'@': 201})}, 68: {40: (0, 305), 64: (0, 110), 65: (0, 261), 66: (0, 266), 63: (0, 282), 67: (0, 80), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 69: {0: (1, {'@': 159}), 1: (1, {'@': 159}), 2: (1, {'@': 159}), 3: (1, {'@': 159}), 4: (1, {'@': 159}), 5: (1, {'@': 159}), 6: (1, {'@': 159}), 7: (1, {'@': 159}), 8: (1, {'@': 159}), 9: (1, {'@': 159}), 10: (1, {'@': 159})}, 70: {57: (0, 170), 58: (0, 118), 11: (0, 148), 59: (0, 352)}, 71: {6: (1, {'@': 32}), 21: (1, {'@': 32})}, 72: {6: (0, 164), 15: (0, 190)}, 73: {40: (1, {'@': 105}), 6: (1, {'@': 105}), 41: (1, {'@': 105}), 21: (1, {'@': 105})}, 74: {40: (0, 305), 68: (0, 295), 69: (0, 309), 66: (0, 348), 70: (0, 73), 71: (0, 61), 64: (0, 110), 41: (0, 90), 63: (0, 395), 72: (0, 334), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 75: {6: (0, 343)}, 76: {11: (1, {'@': 35})}, 77: {6: (0, 66)}, 78: {0: (1, {'@': 170}), 1: (1, {'@': 170}), 2: (1, {'@': 170}), 3: (1, {'@': 170}), 4: (1, {'@': 170}), 5: (1, {'@': 170}), 6: (1, {'@': 170}), 7: (1, {'@': 170}), 8: (1, {'@': 170}), 9: (1, {'@': 170}), 10: (1, {'@': 170})}, 79: {6: (1, {'@': 71}), 15: (1, {'@': 71}), 21: (1, {'@': 71})}, 80: {6: (0, 275)}, 81: {15: (0, 257), 6: (0, 167)}, 82: {21: (0, 277)}, 83: {53: (0, 264)}, 84: {0: (1, {'@': 151}), 1: (1, {'@': 151}), 2: (1, {'@': 151}), 3: (1, {'@': 151}), 4: (1, {'@': 151}), 5: (1, {'@': 151}), 6: (1, {'@': 151}), 7: (1, {'@': 151}), 8: (1, {'@': 151}), 9: (1, {'@': 151}), 10: (1, {'@': 151})}, 85: {6: (0, 236), 15: (0, 270)}, 86: {0: (1, {'@': 181}), 2: (1, {'@': 181}), 3: (1, {'@': 181}), 6: (1, {'@': 181}), 7: (1, {'@': 181}), 1: (1, {'@': 181}), 4: (1, {'@': 181}), 5: (1, {'@': 181}), 8: (1, {'@': 181}), 9: (1, {'@': 181}), 10: (1, {'@': 181})}, 87: {11: (0, 390)}, 88: {2: (0, 60), 25: (0, 391), 73: (0, 357), 14: (0, 341)}, 89: {0: (1, {'@': 53}), 1: (1, {'@': 53}), 2: (1, {'@': 53}), 5: (1, {'@': 53}), 3: (1, {'@': 53}), 6: (1, {'@': 53}), 7: (1, {'@': 53}), 10: (1, {'@': 53})}, 90: {40: (0, 305), 74: (0, 300), 64: (0, 333), 75: (0, 349)}, 91: {15: (0, 335), 13: (0, 241), 14: (0, 215), 12: (0, 306), 2: (0, 60), 16: (0, 237), 6: (0, 345), 17: (0, 221), 18: (0, 239), 19: (0, 224), 20: (0, 232)}, 92: {6: (0, 28)}, 93: {23: (0, 48), 17: (0, 260), 25: (0, 258), 2: (0, 60), 14: (0, 341)}, 94: {0: (1, {'@': 203}), 1: (1, {'@': 203}), 2: (1, {'@': 203}), 5: (1, {'@': 203}), 3: (1, {'@': 203}), 4: (1, {'@': 203}), 6: (1, {'@': 203}), 7: (1, {'@': 203}), 8: (1, {'@': 203}), 9: (1, {'@': 203}), 10: (1, {'@': 203})}, 95: {15: (0, 328), 6: (0, 0)}, 96: {0: (1, {'@': 204}), 1: (1, {'@': 204}), 2: (1, {'@': 204}), 5: (1, {'@': 204}), 3: (1, {'@': 204}), 4: (1, {'@': 204}), 6: (1, {'@': 204}), 7: (1, {'@': 204}), 8: (1, {'@': 204}), 9: (1, {'@': 204}), 10: (1, {'@': 204})}, 97: {6: (1, {'@': 137}), 15: (1, {'@': 137}), 21: (1, {'@': 137})}, 98: {0: (1, {'@': 160}), 1: (1, {'@': 160}), 2: (1, {'@': 160}), 3: (1, {'@': 160}), 4: (1, {'@': 160}), 5: (1, {'@': 160}), 6: (1, {'@': 160}), 7: (1, {'@': 160}), 8: (1, {'@': 160}), 9: (1, {'@': 160}), 10: (1, {'@': 160})}, 99: {60: (0, 136), 61: (0, 32)}, 100: {0: (1, {'@': 169}), 1: (1, {'@': 169}), 2: (1, {'@': 169}), 3: (1, {'@': 169}), 4: (1, {'@': 169}), 5: (1, {'@': 169}), 6: (1, {'@': 169}), 7: (1, {'@': 169}), 8: (1, {'@': 169}), 9: (1, {'@': 169}), 10: (1, {'@': 169})}, 101: {2: (0, 60), 38: (0, 81), 39: (0, 47), 25: (0, 38), 14: (0, 341)}, 102: {0: (1, {'@': 153}), 1: (1, {'@': 153}), 2: (1, {'@': 153}), 3: (1, {'@': 153}), 4: (1, {'@': 153}), 5: (1, {'@': 153}), 6: (1, {'@': 153}), 7: (1, {'@': 153}), 8: (1, {'@': 153}), 9: (1, {'@': 153}), 10: (1, {'@': 153})}, 103: {6: (1, {'@': 140})}, 104: {2: (0, 60), 39: (0, 62), 25: (0, 38), 14: (0, 341)}, 105: {21: (0, 234)}, 106: {0: (1, {'@': 171}), 1: (1, {'@': 171}), 2: (1, {'@': 171}), 3: (1, {'@': 171}), 4: (1, {'@': 171}), 5: (1, {'@': 171}), 6: (1, {'@': 171}), 7: (1, {'@': 171}), 8: (1, {'@': 171}), 9: (1, {'@': 171}), 10: (1, {'@': 171})}, 107: {6: (1, {'@': 101}), 21: (1, {'@': 101})}, 108: {0: (1, {'@': 152}), 1: (1, {'@': 152}), 2: (1, {'@': 152}), 3: (1, {'@': 152}), 4: (1, {'@': 152}), 5: (1, {'@': 152}), 6: (1, {'@': 152}), 7: (1, {'@': 152}), 8: (1, {'@': 152}), 9: (1, {'@': 152}), 10: (1, {'@': 152})}, 109: {0: (1, {'@': 174}), 1: (1, {'@': 174}), 2: (1, {'@': 174}), 3: (1, {'@': 174}), 4: (1, {'@': 174}), 5: (1, {'@': 174}), 6: (1, {'@': 174}), 7: (1, {'@': 174}), 8: (1, {'@': 174}), 9: (1, {'@': 174}), 10: (1, {'@': 174})}, 110: {23: (0, 319), 6: (1, {'@': 33}), 21: (1, {'@': 33})}, 111: {61: (0, 49), 60: (0, 136)}, 112: {6: (1, {'@': 70}), 15: (1, {'@': 70}), 21: (1, {'@': 70})}, 113: {40: (0, 305), 64: (0, 110), 66: (0, 55), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 114: {17: (0, 330), 2: (0, 60), 14: (0, 215), 19: (0, 381)}, 115: {50: (0, 312), 19: (0, 325), 2: (0, 60), 51: (0, 119), 14: (0, 215), 52: (0, 217)}, 116: {0: (1, {'@': 110}), 1: (1, {'@': 110}), 2: (1, {'@': 110}), 3: (1, {'@': 110}), 4: (1, {'@': 110}), 5: (1, {'@': 110}), 6: (1, {'@': 110}), 7: (1, {'@': 110}), 8: (1, {'@': 110}), 9: (1, {'@': 110}), 10: (1, {'@': 110})}, 117: {50: (0, 312), 19: (0, 325), 2: (0, 60), 51: (0, 370), 14: (0, 215), 52: (0, 217)}, 118: {11: (1, {'@': 38})}, 119: {6: (0, 192)}, 120: {68: (0, 295), 76: (0, 269), 70: (0, 73), 71: (0, 61), 64: (0, 110), 41: (0, 90), 69: (0, 318), 72: (0, 334), 40: (0, 305), 6: (0, 332), 66: (0, 348), 63: (0, 395), 21: (1, {'@': 34})}, 121: {6: (0, 31)}, 122: {14: (0, 215), 13: (0, 342), 2: (0, 60), 17: (0, 221), 16: (0, 237), 18: (0, 239), 19: (0, 224), 20: (0, 232)}, 123: {60: (0, 136), 17: (0, 353), 61: (0, 287)}, 124: {2: (0, 60), 39: (0, 47), 25: (0, 38), 38: (0, 219), 14: (0, 341)}, 125: {24: (1, {'@': 85}), 23: (1, {'@': 85}), 2: (1, {'@': 85}), 17: (1, {'@': 85})}, 126: {0: (1, {'@': 117}), 1: (1, {'@': 117}), 2: (1, {'@': 117}), 3: (1, {'@': 117}), 4: (1, {'@': 117}), 5: (1, {'@': 117}), 6: (1, {'@': 117}), 7: (1, {'@': 117}), 8: (1, {'@': 117}), 9: (1, {'@': 117}), 10: (1, {'@': 117})}, 127: {0: (1, {'@': 97}), 1: (1, {'@': 97}), 2: (1, {'@': 97}), 3: (1, {'@': 97}), 4: (1, {'@': 97}), 5: (1, {'@': 97}), 6: (1, {'@': 97}), 7: (1, {'@': 97}), 8: (1, {'@': 97}), 9: (1, {'@': 97}), 10: (1, {'@': 97})}, 128: {15: (0, 253), 6: (0, 35)}, 129: {0: (1, {'@': 144}), 1: (1, {'@': 144}), 2: (1, {'@': 144}), 3: (1, {'@': 144}), 4: (1, {'@': 144}), 5: (1, {'@': 144}), 6: (1, {'@': 144}), 7: (1, {'@': 144}), 8: (1, {'@': 144}), 9: (1, {'@': 144}), 10: (1, {'@': 144})}, 130: {6: (1, {'@': 79}), 15: (1, {'@': 79}), 21: (1, {'@': 79})}, 131: {77: (0, 356), 78: (0, 280)}, 132: {40: (0, 305), 66: (0, 233), 79: (0, 22), 64: (0, 110), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 133: {21: (0, 338), 6: (1, {'@': 195}), 15: (1, {'@': 195})}, 134: {6: (1, {'@': 215}), 21: (1, {'@': 215})}, 135: {6: (1, {'@': 136}), 15: (1, {'@': 136}), 21: (1, {'@': 136})}, 136: {2: (1, {'@': 186}), 17: (1, {'@': 186})}, 137: {6: (0, 18)}, 138: {6: (0, 37)}, 139: {11: (0, 2), 80: (0, 1), 57: (0, 389), 58: (0, 118)}, 140: {57: (0, 170), 59: (0, 44), 58: (0, 118), 11: (0, 296)}, 141: {11: (0, 142)}, 142: {2: (0, 60), 25: (0, 238), 14: (0, 341)}, 143: {15: (0, 243)}, 144: {40: (0, 305), 79: (0, 77), 66: (0, 233), 64: (0, 110), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 145: {40: (0, 305), 66: (0, 233), 64: (0, 110), 79: (0, 185), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 146: {6: (0, 64)}, 147: {0: (1, {'@': 130}), 1: (1, {'@': 130}), 2: (1, {'@': 130}), 3: (1, {'@': 130}), 4: (1, {'@': 130}), 5: (1, {'@': 130}), 6: (1, {'@': 130}), 7: (1, {'@': 130}), 8: (1, {'@': 130}), 9: (1, {'@': 130}), 10: (1, {'@': 130})}, 148: {2: (0, 60), 25: (0, 112), 14: (0, 341)}, 149: {15: (0, 145), 6: (0, 27)}, 150: {6: (0, 52)}, 151: {17: (0, 15), 39: (0, 47), 2: (0, 60), 25: (0, 38), 38: (0, 43), 14: (0, 341)}, 152: {0: (1, {'@': 121}), 1: (1, {'@': 121}), 2: (1, {'@': 121}), 3: (1, {'@': 121}), 4: (1, {'@': 121}), 5: (1, {'@': 121}), 6: (1, {'@': 121}), 7: (1, {'@': 121}), 8: (1, {'@': 121}), 9: (1, {'@': 121}), 10: (1, {'@': 121})}, 153: {2: (0, 60), 25: (0, 247), 14: (0, 341)}, 154: {21: (0, 248), 6: (1, {'@': 199}), 15: (1, {'@': 199})}, 155: {6: (1, {'@': 77}), 15: (1, {'@': 77}), 21: (1, {'@': 77})}, 156: {6: (1, {'@': 218}), 15: (1, {'@': 218}), 21: (1, {'@': 218})}, 157: {2: (0, 60), 14: (0, 341), 25: (0, 9)}, 158: {6: (0, 98), 15: (0, 132)}, 159: {50: (0, 312), 19: (0, 325), 2: (0, 60), 14: (0, 215), 52: (0, 217), 51: (0, 359)}, 160: {2: (1, {'@': 37})}, 161: {21: (0, 292), 6: (1, {'@': 191}), 15: (1, {'@': 191})}, 162: {6: (1, {'@': 214}), 15: (1, {'@': 214}), 21: (1, {'@': 214})}, 163: {39: (0, 47), 38: (0, 265), 17: (0, 59), 2: (0, 60), 25: (0, 38), 14: (0, 341)}, 164: {0: (1, {'@': 162}), 1: (1, {'@': 162}), 2: (1, {'@': 162}), 3: (1, {'@': 162}), 4: (1, {'@': 162}), 5: (1, {'@': 162}), 6: (1, {'@': 162}), 7: (1, {'@': 162}), 8: (1, {'@': 162}), 9: (1, {'@': 162}), 10: (1, {'@': 162})}, 165: {17: (0, 57), 39: (0, 47), 2: (0, 60), 25: (0, 38), 14: (0, 341), 38: (0, 85)}, 166: {0: (1, {'@': 127}), 1: (1, {'@': 127}), 2: (1, {'@': 127}), 3: (1, {'@': 127}), 4: (1, {'@': 127}), 5: (1, {'@': 127}), 6: (1, {'@': 127}), 7: (1, {'@': 127}), 8: (1, {'@': 127}), 9: (1, {'@': 127}), 10: (1, {'@': 127})}, 167: {0: (1, {'@': 156}), 1: (1, {'@': 156}), 2: (1, {'@': 156}), 3: (1, {'@': 156}), 4: (1, {'@': 156}), 5: (1, {'@': 156}), 6: (1, {'@': 156}), 7: (1, {'@': 156}), 8: (1, {'@': 156}), 9: (1, {'@': 156}), 10: (1, {'@': 156})}, 168: {0: (1, {'@': 172}), 1: (1, {'@': 172}), 2: (1, {'@': 172}), 3: (1, {'@': 172}), 4: (1, {'@': 172}), 5: (1, {'@': 172}), 6: (1, {'@': 172}), 7: (1, {'@': 172}), 8: (1, {'@': 172}), 9: (1, {'@': 172}), 10: (1, {'@': 172})}, 169: {81: (0, 7), 82: (0, 360), 2: (0, 60), 1: (0, 331), 17: (0, 374), 22: (0, 315), 7: (0, 347), 83: (0, 276), 84: (0, 368), 77: (0, 356), 24: (0, 362), 23: (0, 369), 78: (0, 337), 25: (0, 386), 14: (0, 341), 63: (0, 327)}, 170: {11: (1, {'@': 92})}, 171: {15: (0, 303), 6: (0, 313)}, 172: {15: (0, 366), 6: (0, 108)}, 173: {12: (0, 39), 13: (0, 241), 14: (0, 215), 15: (0, 41), 2: (0, 60), 6: (0, 17), 16: (0, 237), 17: (0, 221), 18: (0, 239), 19: (0, 224), 20: (0, 232)}, 174: {50: (0, 312), 19: (0, 325), 2: (0, 60), 51: (0, 324), 14: (0, 215), 52: (0, 217)}, 175: {2: (0, 60), 23: (0, 256), 14: (0, 341), 25: (0, 285)}, 176: {2: (0, 60), 14: (0, 341), 25: (0, 23)}, 177: {59: (0, 58), 57: (0, 170), 58: (0, 118), 11: (0, 294)}, 178: {39: (0, 47), 17: (0, 25), 38: (0, 72), 2: (0, 60), 25: (0, 38), 14: (0, 341)}, 179: {2: (0, 60), 14: (0, 341), 25: (0, 203)}, 180: {6: (1, {'@': 211}), 21: (1, {'@': 211})}, 181: {15: (0, 212), 6: (0, 210)}, 182: {6: (0, 78), 15: (0, 214)}, 183: {0: (1, {'@': 125}), 1: (1, {'@': 125}), 2: (1, {'@': 125}), 3: (1, {'@': 125}), 4: (1, {'@': 125}), 5: (1, {'@': 125}), 6: (1, {'@': 125}), 7: (1, {'@': 125}), 8: (1, {'@': 125}), 9: (1, {'@': 125}), 10: (1, {'@': 125})}, 184: {6: (1, {'@': 73}), 15: (1, {'@': 73}), 21: (1, {'@': 73})}, 185: {6: (0, 206)}, 186: {0: (1, {'@': 154}), 1: (1, {'@': 154}), 2: (1, {'@': 154}), 3: (1, {'@': 154}), 4: (1, {'@': 154}), 5: (1, {'@': 154}), 6: (1, {'@': 154}), 7: (1, {'@': 154}), 8: (1, {'@': 154}), 9: (1, {'@': 154}), 10: (1, {'@': 154})}, 187: {6: (1, {'@': 100}), 21: (1, {'@': 100})}, 188: {57: (0, 170), 59: (0, 141), 58: (0, 118), 11: (0, 179)}, 189: {40: (0, 305), 79: (0, 245), 66: (0, 233), 64: (0, 110), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 190: {40: (0, 305), 79: (0, 92), 66: (0, 233), 64: (0, 110), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 191: {2: (0, 60), 14: (0, 341), 25: (0, 63)}, 192: {0: (1, {'@': 120}), 1: (1, {'@': 120}), 2: (1, {'@': 120}), 3: (1, {'@': 120}), 4: (1, {'@': 120}), 5: (1, {'@': 120}), 6: (1, {'@': 120}), 7: (1, {'@': 120}), 8: (1, {'@': 120}), 9: (1, {'@': 120}), 10: (1, {'@': 120})}, 193: {6: (1, {'@': 60}), 15: (1, {'@': 60}), 21: (1, {'@': 60})}, 194: {11: (0, 227)}, 195: {2: (0, 60), 25: (0, 220), 14: (0, 341)}, 196: {0: (1, {'@': 58}), 1: (1, {'@': 58}), 2: (1, {'@': 58}), 3: (1, {'@': 58}), 4: (1, {'@': 58}), 5: (1, {'@': 58}), 6: (1, {'@': 58}), 7: (1, {'@': 58}), 8: (1, {'@': 58}), 9: (1, {'@': 58}), 10: (1, {'@': 58})}, 197: {6: (1, {'@': 72}), 15: (1, {'@': 72}), 21: (1, {'@': 72})}, 198: {6: (1, {'@': 108}), 21: (1, {'@': 108})}, 199: {0: (1, {'@': 114}), 1: (1, {'@': 114}), 2: (1, {'@': 114}), 3: (1, {'@': 114}), 4: (1, {'@': 114}), 5: (1, {'@': 114}), 6: (1, {'@': 114}), 7: (1, {'@': 114}), 8: (1, {'@': 114}), 9: (1, {'@': 114}), 10: (1, {'@': 114})}, 200: {0: (1, {'@': 122}), 1: (1, {'@': 122}), 2: (1, {'@': 122}), 3: (1, {'@': 122}), 4: (1, {'@': 122}), 5: (1, {'@': 122}), 6: (1, {'@': 122}), 7: (1, {'@': 122}), 8: (1, {'@': 122}), 9: (1, {'@': 122}), 10: (1, {'@': 122})}, 201: {6: (0, 45)}, 202: {6: (1, {'@': 208}), 21: (1, {'@': 208})}, 203: {6: (1, {'@': 67}), 15: (1, {'@': 67}), 21: (1, {'@': 67})}, 204: {6: (1, {'@': 106}), 21: (1, {'@': 106})}, 205: {6: (0, 102)}, 206: {0: (1, {'@': 157}), 1: (1, {'@': 157}), 2: (1, {'@': 157}), 3: (1, {'@': 157}), 4: (1, {'@': 157}), 5: (1, {'@': 157}), 6: (1, {'@': 157}), 7: (1, {'@': 157}), 8: (1, {'@': 157}), 9: (1, {'@': 157}), 10: (1, {'@': 157})}, 207: {0: (1, {'@': 112}), 1: (1, {'@': 112}), 2: (1, {'@': 112}), 3: (1, {'@': 112}), 4: (1, {'@': 112}), 5: (1, {'@': 112}), 6: (1, {'@': 112}), 7: (1, {'@': 112}), 8: (1, {'@': 112}), 9: (1, {'@': 112}), 10: (1, {'@': 112})}, 208: {6: (0, 129), 15: (0, 144)}, 209: {39: (0, 47), 38: (0, 128), 2: (0, 60), 25: (0, 38), 17: (0, 124), 14: (0, 341)}, 210: {0: (1, {'@': 146}), 1: (1, {'@': 146}), 2: (1, {'@': 146}), 3: (1, {'@': 146}), 4: (1, {'@': 146}), 5: (1, {'@': 146}), 6: (1, {'@': 146}), 7: (1, {'@': 146}), 8: (1, {'@': 146}), 9: (1, {'@': 146}), 10: (1, {'@': 146})}, 211: {6: (0, 116)}, 212: {40: (0, 305), 66: (0, 233), 64: (0, 110), 79: (0, 146), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 213: {0: (1, {'@': 148}), 1: (1, {'@': 148}), 2: (1, {'@': 148}), 3: (1, {'@': 148}), 4: (1, {'@': 148}), 5: (1, {'@': 148}), 6: (1, {'@': 148}), 7: (1, {'@': 148}), 8: (1, {'@': 148}), 9: (1, {'@': 148}), 10: (1, {'@': 148})}, 214: {40: (0, 305), 79: (0, 326), 66: (0, 233), 64: (0, 110), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 215: {6: (1, {'@': 139}), 15: (1, {'@': 139}), 21: (1, {'@': 139})}, 216: {25: (0, 387), 2: (0, 60), 14: (0, 341)}, 217: {21: (0, 316)}, 218: {0: (1, {'@': 133}), 1: (1, {'@': 133}), 2: (1, {'@': 133}), 3: (1, {'@': 133}), 4: (1, {'@': 133}), 5: (1, {'@': 133}), 6: (1, {'@': 133}), 7: (1, {'@': 133}), 8: (1, {'@': 133}), 9: (1, {'@': 133}), 10: (1, {'@': 133})}, 219: {6: (0, 244), 15: (0, 392)}, 220: {6: (1, {'@': 75}), 15: (1, {'@': 75}), 21: (1, {'@': 75})}, 221: {2: (1, {'@': 205}), 17: (1, {'@': 205})}, 222: {40: (0, 305), 79: (0, 371), 66: (0, 233), 64: (0, 110), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 223: {60: (0, 136), 17: (0, 99), 61: (0, 151)}, 224: {6: (1, {'@': 138}), 15: (1, {'@': 138}), 21: (1, {'@': 138})}, 225: {24: (1, {'@': 86}), 23: (1, {'@': 86}), 2: (1, {'@': 86}), 17: (1, {'@': 86})}, 226: {0: (1, {'@': 168}), 1: (1, {'@': 168}), 2: (1, {'@': 168}), 3: (1, {'@': 168}), 4: (1, {'@': 168}), 5: (1, {'@': 168}), 6: (1, {'@': 168}), 7: (1, {'@': 168}), 8: (1, {'@': 168}), 9: (1, {'@': 168}), 10: (1, {'@': 168})}, 227: {2: (0, 60), 25: (0, 304), 14: (0, 341)}, 228: {50: (0, 312), 19: (0, 325), 2: (0, 60), 14: (0, 215), 52: (0, 217), 51: (0, 384)}, 229: {0: (1, {'@': 55}), 1: (1, {'@': 55}), 2: (1, {'@': 55}), 3: (1, {'@': 55}), 4: (1, {'@': 55}), 5: (1, {'@': 55}), 6: (1, {'@': 55}), 7: (1, {'@': 55}), 8: (1, {'@': 55}), 9: (1, {'@': 55}), 10: (1, {'@': 55})}, 230: {6: (0, 226), 15: (0, 367)}, 231: {0: (1, {'@': 124}), 1: (1, {'@': 124}), 2: (1, {'@': 124}), 3: (1, {'@': 124}), 4: (1, {'@': 124}), 5: (1, {'@': 124}), 6: (1, {'@': 124}), 7: (1, {'@': 124}), 8: (1, {'@': 124}), 9: (1, {'@': 124}), 10: (1, {'@': 124})}, 232: {17: (0, 330), 2: (0, 60), 14: (0, 215), 19: (0, 97)}, 233: {21: (0, 383), 85: (0, 344), 6: (1, {'@': 198})}, 234: {81: (0, 7), 82: (0, 360), 2: (0, 60), 1: (0, 331), 17: (0, 374), 22: (0, 315), 7: (0, 347), 84: (0, 368), 77: (0, 356), 24: (0, 362), 23: (0, 369), 86: (0, 380), 83: (0, 378), 78: (0, 337), 25: (0, 386), 14: (0, 341), 63: (0, 327)}, 235: {11: (0, 301)}, 236: {0: (1, {'@': 150}), 1: (1, {'@': 150}), 2: (1, {'@': 150}), 3: (1, {'@': 150}), 4: (1, {'@': 150}), 5: (1, {'@': 150}), 6: (1, {'@': 150}), 7: (1, {'@': 150}), 8: (1, {'@': 150}), 9: (1, {'@': 150}), 10: (1, {'@': 150})}, 237: {2: (1, {'@': 177}), 17: (1, {'@': 177})}, 238: {6: (1, {'@': 66}), 15: (1, {'@': 66}), 21: (1, {'@': 66})}, 239: {2: (0, 60), 20: (0, 114), 17: (0, 221), 14: (0, 215), 19: (0, 135)}, 240: {2: (0, 60), 25: (0, 197), 14: (0, 341)}, 241: {87: (0, 133), 21: (0, 122), 6: (1, {'@': 196}), 15: (1, {'@': 196})}, 242: {40: (0, 305), 65: (0, 202), 64: (0, 110), 66: (0, 266), 63: (0, 282), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 243: {68: (0, 295), 70: (0, 73), 71: (0, 61), 64: (0, 110), 41: (0, 90), 69: (0, 318), 72: (0, 334), 40: (0, 305), 6: (0, 320), 66: (0, 348), 76: (0, 373), 63: (0, 395), 21: (1, {'@': 34})}, 244: {0: (1, {'@': 164}), 1: (1, {'@': 164}), 2: (1, {'@': 164}), 3: (1, {'@': 164}), 4: (1, {'@': 164}), 5: (1, {'@': 164}), 6: (1, {'@': 164}), 7: (1, {'@': 164}), 8: (1, {'@': 164}), 9: (1, {'@': 164}), 10: (1, {'@': 164})}, 245: {6: (0, 317)}, 246: {17: (1, {'@': 175}), 60: (1, {'@': 175})}, 247: {6: (1, {'@': 78}), 15: (1, {'@': 78}), 21: (1, {'@': 78})}, 248: {2: (0, 60), 25: (0, 38), 14: (0, 341), 39: (0, 156)}, 249: {2: (0, 60), 23: (0, 188), 14: (0, 341), 25: (0, 3)}, 250: {15: (0, 308), 6: (0, 351)}, 251: {80: (0, 358), 57: (0, 389), 11: (0, 91), 58: (0, 118)}, 252: {40: (0, 305), 66: (0, 233), 64: (0, 110), 79: (0, 205), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 253: {40: (0, 305), 66: (0, 233), 64: (0, 110), 79: (0, 354), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 254: {0: (1, {'@': 116}), 1: (1, {'@': 116}), 2: (1, {'@': 116}), 3: (1, {'@': 116}), 4: (1, {'@': 116}), 5: (1, {'@': 116}), 6: (1, {'@': 116}), 7: (1, {'@': 116}), 8: (1, {'@': 116}), 9: (1, {'@': 116}), 10: (1, {'@': 116})}, 255: {50: (0, 312), 19: (0, 325), 51: (0, 211), 2: (0, 60), 14: (0, 215), 52: (0, 217)}, 256: {57: (0, 170), 59: (0, 340), 58: (0, 118), 11: (0, 385)}, 257: {40: (0, 305), 79: (0, 138), 66: (0, 233), 64: (0, 110), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 258: {6: (1, {'@': 65}), 15: (1, {'@': 65}), 21: (1, {'@': 65})}, 259: {0: (1, {'@': 111}), 1: (1, {'@': 111}), 2: (1, {'@': 111}), 3: (1, {'@': 111}), 4: (1, {'@': 111}), 5: (1, {'@': 111}), 6: (1, {'@': 111}), 7: (1, {'@': 111}), 8: (1, {'@': 111}), 9: (1, {'@': 111}), 10: (1, {'@': 111})}, 260: {23: (0, 379), 2: (0, 60), 25: (0, 322), 14: (0, 341)}, 261: {88: (0, 311), 21: (0, 329), 6: (1, {'@': 190})}, 262: {0: (1, {'@': 54}), 2: (1, {'@': 54}), 3: (1, {'@': 54}), 6: (1, {'@': 54}), 7: (1, {'@': 54}), 1: (1, {'@': 54}), 4: (1, {'@': 54}), 5: (1, {'@': 54}), 8: (1, {'@': 54}), 9: (1, {'@': 54}), 10: (1, {'@': 54})}, 263: {6: (1, {'@': 207}), 21: (1, {'@': 207})}, 264: {23: (0, 139), 13: (0, 241), 12: (0, 95), 14: (0, 215), 2: (0, 60), 19: (0, 224), 20: (0, 232), 6: (0, 152), 16: (0, 237), 17: (0, 221), 18: (0, 239), 15: (0, 115)}, 265: {15: (0, 252), 6: (0, 186)}, 266: {6: (1, {'@': 94}), 21: (1, {'@': 94})}, 267: {40: (0, 305), 67: (0, 394), 64: (0, 110), 65: (0, 261), 66: (0, 266), 63: (0, 282), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 268: {0: (1, {'@': 48}), 1: (1, {'@': 48}), 2: (1, {'@': 48}), 5: (1, {'@': 48}), 3: (1, {'@': 48}), 4: (1, {'@': 48}), 6: (1, {'@': 48}), 7: (1, {'@': 48}), 8: (1, {'@': 48}), 9: (1, {'@': 48}), 10: (1, {'@': 48})}, 269: {6: (0, 127)}, 270: {40: (0, 305), 66: (0, 233), 64: (0, 110), 79: (0, 201), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 271: {6: (0, 363)}, 272: {6: (0, 199)}, 273: {0: (1, {'@': 42}), 1: (1, {'@': 42}), 2: (1, {'@': 42}), 5: (1, {'@': 42}), 3: (1, {'@': 42}), 4: (1, {'@': 42}), 6: (1, {'@': 42}), 7: (1, {'@': 42}), 8: (1, {'@': 42}), 9: (1, {'@': 42}), 10: (1, {'@': 42})}, 274: {17: (0, 51), 26: (0, 223), 2: (0, 60), 25: (0, 246), 14: (0, 341)}, 275: {0: (1, {'@': 57}), 1: (1, {'@': 57}), 2: (1, {'@': 57}), 3: (1, {'@': 57}), 4: (1, {'@': 57}), 5: (1, {'@': 57}), 6: (1, {'@': 57}), 7: (1, {'@': 57}), 8: (1, {'@': 57}), 9: (1, {'@': 57}), 10: (1, {'@': 57})}, 276: {6: (1, {'@': 209}), 15: (1, {'@': 209}), 21: (1, {'@': 209})}, 277: {81: (0, 7), 82: (0, 360), 2: (0, 60), 1: (0, 331), 17: (0, 374), 22: (0, 315), 7: (0, 347), 84: (0, 368), 77: (0, 356), 24: (0, 362), 23: (0, 369), 83: (0, 378), 78: (0, 337), 25: (0, 386), 86: (0, 355), 14: (0, 341), 63: (0, 327)}, 278: {2: (0, 60), 39: (0, 47), 25: (0, 38), 14: (0, 341), 38: (0, 208)}, 279: {43: (1, {'@': 183})}, 280: {24: (1, {'@': 84}), 23: (1, {'@': 84}), 2: (1, {'@': 84}), 17: (1, {'@': 84})}, 281: {6: (0, 200)}, 282: {40: (0, 305), 64: (0, 110), 66: (0, 377), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 283: {89: (0, 204), 64: (0, 198), 40: (0, 305)}, 284: {0: (1, {'@': 44}), 1: (1, {'@': 44}), 2: (1, {'@': 44}), 5: (1, {'@': 44}), 3: (1, {'@': 44}), 4: (1, {'@': 44}), 6: (1, {'@': 44}), 7: (1, {'@': 44}), 8: (1, {'@': 44}), 9: (1, {'@': 44}), 10: (1, {'@': 44})}, 285: {6: (1, {'@': 74}), 15: (1, {'@': 74}), 21: (1, {'@': 74})}, 286: {0: (1, {'@': 126}), 1: (1, {'@': 126}), 2: (1, {'@': 126}), 3: (1, {'@': 126}), 4: (1, {'@': 126}), 5: (1, {'@': 126}), 6: (1, {'@': 126}), 7: (1, {'@': 126}), 8: (1, {'@': 126}), 9: (1, {'@': 126}), 10: (1, {'@': 126})}, 287: {17: (0, 101), 39: (0, 47), 38: (0, 149), 2: (0, 60), 25: (0, 38), 14: (0, 341)}, 288: {2: (0, 60), 38: (0, 230), 39: (0, 47), 25: (0, 38), 14: (0, 341)}, 289: {15: (0, 350), 6: (0, 213)}, 290: {53: (1, {'@': 184})}, 291: {11: (0, 298)}, 292: {81: (0, 7), 82: (0, 360), 2: (0, 60), 1: (0, 331), 17: (0, 374), 22: (0, 315), 7: (0, 347), 84: (0, 368), 77: (0, 356), 24: (0, 362), 23: (0, 369), 83: (0, 307), 78: (0, 337), 25: (0, 386), 14: (0, 341), 63: (0, 327)}, 293: {43: (0, 8)}, 294: {25: (0, 375), 2: (0, 60), 14: (0, 341)}, 295: {40: (0, 305), 64: (0, 110), 66: (0, 187), 41: (0, 393), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 296: {2: (0, 60), 14: (0, 341), 25: (0, 130)}, 297: {0: (1, {'@': 41}), 1: (1, {'@': 41}), 2: (1, {'@': 41}), 5: (1, {'@': 41}), 3: (1, {'@': 41}), 4: (1, {'@': 41}), 6: (1, {'@': 41}), 7: (1, {'@': 41}), 8: (1, {'@': 41}), 9: (1, {'@': 41}), 10: (1, {'@': 41})}, 298: {2: (0, 60), 25: (0, 336), 14: (0, 341)}, 299: {6: (0, 207)}, 300: {6: (1, {'@': 103}), 21: (1, {'@': 103})}, 301: {2: (0, 60), 25: (0, 193), 14: (0, 341)}, 302: {6: (0, 168), 15: (0, 222)}, 303: {50: (0, 312), 19: (0, 325), 2: (0, 60), 51: (0, 281), 14: (0, 215), 52: (0, 217)}, 304: {6: (1, {'@': 63}), 15: (1, {'@': 63}), 21: (1, {'@': 63})}, 305: {6: (1, {'@': 185}), 23: (1, {'@': 185}), 21: (1, {'@': 185}), 62: (1, {'@': 185})}, 306: {15: (0, 174), 6: (0, 166)}, 307: {6: (1, {'@': 210}), 15: (1, {'@': 210}), 21: (1, {'@': 210})}, 308: {50: (0, 312), 19: (0, 325), 2: (0, 60), 51: (0, 346), 14: (0, 215), 52: (0, 217)}, 309: {6: (1, {'@': 212}), 21: (1, {'@': 212})}, 310: {6: (0, 321), 15: (0, 382)}, 311: {21: (0, 242), 6: (1, {'@': 189})}, 312: {21: (1, {'@': 141}), 6: (1, {'@': 141})}, 313: {0: (1, {'@': 123}), 1: (1, {'@': 123}), 2: (1, {'@': 123}), 3: (1, {'@': 123}), 4: (1, {'@': 123}), 5: (1, {'@': 123}), 6: (1, {'@': 123}), 7: (1, {'@': 123}), 8: (1, {'@': 123}), 9: (1, {'@': 123}), 10: (1, {'@': 123})}, 314: {13: (0, 241), 6: (0, 183), 14: (0, 215), 15: (0, 159), 12: (0, 171), 2: (0, 60), 16: (0, 237), 17: (0, 221), 18: (0, 239), 19: (0, 224), 20: (0, 232)}, 315: {25: (0, 155), 17: (0, 175), 2: (0, 60), 23: (0, 177), 14: (0, 341)}, 316: {50: (0, 312), 19: (0, 325), 2: (0, 60), 52: (0, 103), 14: (0, 215)}, 317: {0: (1, {'@': 173}), 1: (1, {'@': 173}), 2: (1, {'@': 173}), 3: (1, {'@': 173}), 4: (1, {'@': 173}), 5: (1, {'@': 173}), 6: (1, {'@': 173}), 7: (1, {'@': 173}), 8: (1, {'@': 173}), 9: (1, {'@': 173}), 10: (1, {'@': 173})}, 318: {90: (0, 388), 21: (0, 339), 6: (1, {'@': 194})}, 319: {91: (0, 87), 57: (0, 76), 58: (0, 118), 11: (0, 71)}, 320: {0: (1, {'@': 96}), 1: (1, {'@': 96}), 2: (1, {'@': 96}), 3: (1, {'@': 96}), 4: (1, {'@': 96}), 5: (1, {'@': 96}), 6: (1, {'@': 96}), 7: (1, {'@': 96}), 8: (1, {'@': 96}), 9: (1, {'@': 96}), 10: (1, {'@': 96})}, 321: {0: (1, {'@': 115}), 1: (1, {'@': 115}), 2: (1, {'@': 115}), 3: (1, {'@': 115}), 4: (1, {'@': 115}), 5: (1, {'@': 115}), 6: (1, {'@': 115}), 7: (1, {'@': 115}), 8: (1, {'@': 115}), 9: (1, {'@': 115}), 10: (1, {'@': 115})}, 322: {6: (1, {'@': 62}), 15: (1, {'@': 62}), 21: (1, {'@': 62})}, 323: {25: (0, 246), 26: (0, 56), 2: (0, 60), 14: (0, 341)}, 324: {6: (0, 286)}, 325: {21: (1, {'@': 142}), 6: (1, {'@': 142})}, 326: {6: (0, 100)}, 327: {77: (1, {'@': 90})}, 328: {50: (0, 312), 19: (0, 325), 2: (0, 60), 51: (0, 75), 14: (0, 215), 52: (0, 217)}, 329: {40: (0, 305), 65: (0, 263), 64: (0, 110), 66: (0, 266), 63: (0, 282), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 330: {2: (1, {'@': 206}), 17: (1, {'@': 206})}, 331: {77: (1, {'@': 91})}, 332: {0: (1, {'@': 98}), 1: (1, {'@': 98}), 2: (1, {'@': 98}), 3: (1, {'@': 98}), 4: (1, {'@': 98}), 5: (1, {'@': 98}), 6: (1, {'@': 98}), 7: (1, {'@': 98}), 8: (1, {'@': 98}), 9: (1, {'@': 98}), 10: (1, {'@': 98})}, 333: {62: (1, {'@': 107})}, 334: {63: (0, 395), 70: (0, 20)}, 335: {50: (0, 312), 19: (0, 325), 2: (0, 60), 14: (0, 215), 52: (0, 217), 51: (0, 271)}, 336: {6: (1, {'@': 81}), 15: (1, {'@': 81}), 21: (1, {'@': 81})}, 337: {24: (1, {'@': 87}), 23: (1, {'@': 87}), 2: (1, {'@': 87}), 17: (1, {'@': 87})}, 338: {18: (0, 239), 14: (0, 215), 2: (0, 60), 17: (0, 221), 16: (0, 237), 13: (0, 162), 19: (0, 224), 20: (0, 232)}, 339: {40: (0, 305), 68: (0, 295), 69: (0, 180), 66: (0, 348), 70: (0, 73), 71: (0, 61), 64: (0, 110), 41: (0, 90), 63: (0, 395), 72: (0, 334), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 340: {11: (0, 240)}, 341: {6: (1, {'@': 88}), 15: (1, {'@': 88}), 21: (1, {'@': 88}), 17: (1, {'@': 88}), 60: (1, {'@': 88}), 62: (1, {'@': 88})}, 342: {6: (1, {'@': 213}), 15: (1, {'@': 213}), 21: (1, {'@': 213})}, 343: {0: (1, {'@': 118}), 1: (1, {'@': 118}), 2: (1, {'@': 118}), 3: (1, {'@': 118}), 4: (1, {'@': 118}), 5: (1, {'@': 118}), 6: (1, {'@': 118}), 7: (1, {'@': 118}), 8: (1, {'@': 118}), 9: (1, {'@': 118}), 10: (1, {'@': 118})}, 344: {21: (0, 113), 6: (1, {'@': 197})}, 345: {0: (1, {'@': 129}), 1: (1, {'@': 129}), 2: (1, {'@': 129}), 3: (1, {'@': 129}), 4: (1, {'@': 129}), 5: (1, {'@': 129}), 6: (1, {'@': 129}), 7: (1, {'@': 129}), 8: (1, {'@': 129}), 9: (1, {'@': 129}), 10: (1, {'@': 129})}, 346: {6: (0, 147)}, 347: {63: (1, {'@': 89}), 1: (1, {'@': 89}), 77: (1, {'@': 89})}, 348: {6: (1, {'@': 102}), 21: (1, {'@': 102})}, 349: {62: (0, 88)}, 350: {40: (0, 305), 66: (0, 233), 64: (0, 110), 79: (0, 150), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 351: {0: (1, {'@': 131}), 1: (1, {'@': 131}), 2: (1, {'@': 131}), 3: (1, {'@': 131}), 4: (1, {'@': 131}), 5: (1, {'@': 131}), 6: (1, {'@': 131}), 7: (1, {'@': 131}), 8: (1, {'@': 131}), 9: (1, {'@': 131}), 10: (1, {'@': 131})}, 352: {11: (0, 191)}, 353: {60: (0, 136), 61: (0, 163)}, 354: {6: (0, 361)}, 355: {15: (0, 68), 6: (0, 196)}, 356: {23: (1, {'@': 178}), 2: (1, {'@': 178}), 24: (1, {'@': 178}), 17: (1, {'@': 178})}, 357: {62: (0, 283)}, 358: {11: (0, 314)}, 359: {6: (0, 231)}, 360: {77: (0, 356), 78: (0, 225)}, 361: {0: (1, {'@': 165}), 1: (1, {'@': 165}), 2: (1, {'@': 165}), 3: (1, {'@': 165}), 4: (1, {'@': 165}), 5: (1, {'@': 165}), 6: (1, {'@': 165}), 7: (1, {'@': 165}), 8: (1, {'@': 165}), 9: (1, {'@': 165}), 10: (1, {'@': 165})}, 362: {23: (1, {'@': 180}), 2: (1, {'@': 180}), 17: (1, {'@': 180})}, 363: {0: (1, {'@': 128}), 1: (1, {'@': 128}), 2: (1, {'@': 128}), 3: (1, {'@': 128}), 4: (1, {'@': 128}), 5: (1, {'@': 128}), 6: (1, {'@': 128}), 7: (1, {'@': 128}), 8: (1, {'@': 128}), 9: (1, {'@': 128}), 10: (1, {'@': 128})}, 364: {17: (0, 372), 60: (0, 136), 61: (0, 209)}, 365: {0: (1, {'@': 95}), 1: (1, {'@': 95}), 2: (1, {'@': 95}), 3: (1, {'@': 95}), 4: (1, {'@': 95}), 5: (1, {'@': 95}), 6: (1, {'@': 95}), 7: (1, {'@': 95}), 8: (1, {'@': 95}), 9: (1, {'@': 95}), 10: (1, {'@': 95})}, 366: {40: (0, 305), 79: (0, 33), 66: (0, 233), 64: (0, 110), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 367: {40: (0, 305), 66: (0, 233), 79: (0, 137), 64: (0, 110), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 368: {77: (0, 356), 78: (0, 125), 1: (0, 331), 63: (0, 327), 82: (0, 131)}, 369: {59: (0, 291), 58: (0, 118), 11: (0, 157), 57: (0, 170)}, 370: {6: (0, 254)}, 371: {6: (0, 106)}, 372: {60: (0, 136), 61: (0, 178)}, 373: {6: (0, 365)}, 374: {23: (0, 140), 2: (0, 60), 25: (0, 65), 14: (0, 341)}, 375: {6: (1, {'@': 76}), 15: (1, {'@': 76}), 21: (1, {'@': 76})}, 376: {0: (1, {'@': 132}), 1: (1, {'@': 132}), 2: (1, {'@': 132}), 3: (1, {'@': 132}), 4: (1, {'@': 132}), 5: (1, {'@': 132}), 6: (1, {'@': 132}), 7: (1, {'@': 132}), 8: (1, {'@': 132}), 9: (1, {'@': 132}), 10: (1, {'@': 132})}, 377: {6: (1, {'@': 93}), 21: (1, {'@': 93})}, 378: {92: (0, 161), 21: (0, 169), 6: (1, {'@': 192}), 15: (1, {'@': 192})}, 379: {57: (0, 170), 58: (0, 118), 59: (0, 235), 11: (0, 216)}, 380: {15: (0, 267), 6: (0, 54)}, 381: {6: (1, {'@': 135}), 15: (1, {'@': 135}), 21: (1, {'@': 135})}, 382: {50: (0, 312), 19: (0, 325), 2: (0, 60), 51: (0, 272), 14: (0, 215), 52: (0, 217)}, 383: {40: (0, 305), 64: (0, 110), 66: (0, 134), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 384: {6: (0, 376)}, 385: {2: (0, 60), 14: (0, 341), 25: (0, 184)}, 386: {6: (1, {'@': 83}), 15: (1, {'@': 83}), 21: (1, {'@': 83})}, 387: {6: (1, {'@': 61}), 15: (1, {'@': 61}), 21: (1, {'@': 61})}, 388: {21: (0, 74), 6: (1, {'@': 193})}, 389: {11: (1, {'@': 134})}, 390: {6: (1, {'@': 31}), 21: (1, {'@': 31})}, 391: {62: (1, {'@': 109})}, 392: {40: (0, 305), 66: (0, 233), 64: (0, 110), 79: (0, 121), 6: (1, {'@': 34}), 21: (1, {'@': 34})}, 393: {74: (0, 107), 64: (0, 333), 75: (0, 349), 40: (0, 305)}, 394: {6: (0, 229)}, 395: {40: (1, {'@': 187}), 6: (1, {'@': 187}), 41: (1, {'@': 187}), 21: (1, {'@': 187})}}, 'start_states': {'start': 24}, 'end_states': {'start': 50}}, '__type__': 'ParsingFrontend'}, 'rules': [{'@': 31}, {'@': 32}, {'@': 33}, {'@': 34}, {'@': 35}, {'@': 36}, {'@': 37}, {'@': 38}, {'@': 39}, {'@': 40}, {'@': 41}, {'@': 42}, {'@': 43}, {'@': 44}, {'@': 45}, {'@': 46}, {'@': 47}, {'@': 48}, {'@': 49}, {'@': 50}, {'@': 51}, {'@': 52}, {'@': 53}, {'@': 54}, {'@': 55}, {'@': 56}, {'@': 57}, {'@': 58}, {'@': 59}, {'@': 60}, {'@': 61}, {'@': 62}, {'@': 63}, {'@': 64}, {'@': 65}, {'@': 66}, {'@': 67}, {'@': 68}, {'@': 69}, {'@': 70}, {'@': 71}, {'@': 72}, {'@': 73}, {'@': 74}, {'@': 75}, {'@': 76}, {'@': 77}, {'@': 78}, {'@': 79}, {'@': 80}, {'@': 81}, {'@': 82}, {'@': 83}, {'@': 84}, {'@': 85}, {'@': 86}, {'@': 87}, {'@': 88}, {'@': 89}, {'@': 90}, {'@': 91}, {'@': 92}, {'@': 93}, {'@': 94}, {'@': 95}, {'@': 96}, {'@': 97}, {'@': 98}, {'@': 99}, {'@': 100}, {'@': 101}, {'@': 102}, {'@': 103}, {'@': 104}, {'@': 105}, {'@': 106}, {'@': 107}, {'@': 108}, {'@': 109}, {'@': 110}, {'@': 111}, {'@': 112}, {'@': 113}, {'@': 114}, {'@': 115}, {'@': 116}, {'@': 117}, {'@': 118}, {'@': 119}, {'@': 120}, {'@': 121}, {'@': 122}, {'@': 123}, {'@': 124}, {'@': 125}, {'@': 126}, {'@': 127}, {'@': 128}, {'@': 129}, {'@': 130}, {'@': 131}, {'@': 132}, {'@': 133}, {'@': 134}, {'@': 135}, {'@': 136}, {'@': 137}, {'@': 138}, {'@': 139}, {'@': 140}, {'@': 141}, {'@': 142}, {'@': 143}, {'@': 144}, {'@': 145}, {'@': 146}, {'@': 147}, {'@': 148}, {'@': 149}, {'@': 150}, {'@': 151}, {'@': 152}, {'@': 153}, {'@': 154}, {'@': 155}, {'@': 156}, {'@': 157}, {'@': 158}, {'@': 159}, {'@': 160}, {'@': 161}, {'@': 162}, {'@': 163}, {'@': 164}, {'@': 165}, {'@': 166}, {'@': 167}, {'@': 168}, {'@': 169}, {'@': 170}, {'@': 171}, {'@': 172}, {'@': 173}, {'@': 174}, {'@': 175}, {'@': 176}, {'@': 177}, {'@': 178}, {'@': 179}, {'@': 180}, {'@': 181}, {'@': 182}, {'@': 183}, {'@': 184}, {'@': 185}, {'@': 186}, {'@': 187}, {'@': 188}, {'@': 189}, {'@': 190}, {'@': 191}, {'@': 192}, {'@': 193}, {'@': 194}, {'@': 195}, {'@': 196}, {'@': 197}, {'@': 198}, {'@': 199}, {'@': 200}, {'@': 201}, {'@': 202}, {'@': 203}, {'@': 204}, {'@': 205}, {'@': 206}, {'@': 207}, {'@': 208}, {'@': 209}, {'@': 210}, {'@': 211}, {'@': 212}, {'@': 213}, {'@': 214}, {'@': 215}, {'@': 216}, {'@': 217}, {'@': 218}], 'options': {'debug': False, 'strict': False, 'keep_all_tokens': False, 'tree_class': None, 'cache': False, 'postlex': None, 'parser': 'lalr', 'lexer': 'contextual', 'transformer': None, 'start': ['start'], 'priority': 'normal', 'ambiguity': 'auto', 'regex': False, 'propagate_positions': False, 'lexer_callbacks': {}, 'maybe_placeholders': False, 'edit_terminals': None, 'g_regex_flags': 0, 'use_bytes': False, 'import_paths': [], 'source_path': None, '_plugins': {}}, '__type__': 'Lark'}
)
MEMO = (
{0: {'name': 'NUMBER', 'pattern': {'value': '(?:(?:(?:[0-9])+(?:e|E)(?:(?:\\+|\\-))?(?:[0-9])+|(?:(?:[0-9])+\\.(?:(?:[0-9])+)?|\\.(?:[0-9])+)(?:(?:e|E)(?:(?:\\+|\\-))?(?:[0-9])+)?)|(?:[0-9])+)', 'flags': [], 'raw': None, '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 1: {'name': 'COMMA', 'pattern': {'value': '(?:[^\\S\r\n]+)?,(?:[^\\S\r\n]+)?', 'flags': [], 'raw': None, '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 2: {'name': 'COLON', 'pattern': {'value': '(?:[^\\S\r\n]+)?:(?:[^\\S\r\n]+)?', 'flags': [], 'raw': None, '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 3: {'name': 'NL', 'pattern': {'value': '[^\\S\r\n]*\r?\n', 'flags': [], 'raw': '/[^\\S\\r\\n]*\\r?\\n/', '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': -10, '__type__': 'TerminalDef'}, 4: {'name': 'SLASH', 'pattern': {'value': '/', 'flags': [], 'raw': '"/"', '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 5: {'name': 'BACKSLASH', 'pattern': {'value': '(?:\\\\)+', 'flags': [], 'raw': None, '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 6: {'name': 'CONSTRAINT_LPAREN', 'pattern': {'value': '(?:[^\\S\r\n]+)?\\(', 'flags': [], 'raw': None, '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 7: {'name': 'CONSTRAINT_RPAREN', 'pattern': {'value': '\\)(?:[^\\S\r\n]+)?', 'flags': [], 'raw': None, '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 8: {'name': 'LBRACKET', 'pattern': {'value': '(?:[^\\S\r\n]+)?\\[', 'flags': [], 'raw': None, '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 9: {'name': 'RBRACKET', 'pattern': {'value': '\\](?:[^\\S\r\n]+)?', 'flags': [], 'raw': None, '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 10: {'name': 'HASHTAG', 'pattern': {'value': '#', 'flags': [], 'raw': '"#"', '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 11: {'name': 'PERCENT', 'pattern': {'value': '%', 'flags': [], 'raw': '"%"', '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 12: {'name': 'SP', 'pattern': {'value': '[^\\S\r\n]+', 'flags': [], 'raw': '/[^\\S\\r\\n]+/', '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': -50, '__type__': 'TerminalDef'}, 13: {'name': 'BOX_NAME', 'pattern': {'value': '(?![\\W_\\d])[^=<>,:\n\\\\]*[^-\\[\\\\\\]=<>,:\\s\\\\]', 'flags': [], 'raw': '/(?![\\W_\\d])[^=<>,:\\n\\\\]*[^-\\[\\\\\\]=<>,:\\s\\\\]/', '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 14: {'name': 'ATTR', 'pattern': {'value': '(?=\\w)(?!_)[^\\[\\]>,\r\n!?]*[^\\[\\]>,\\s]', 'flags': [], 'raw': '/(?=\\w)(?!_)[^\\[\\]>,\\r\\n!?]*[^\\[\\]>,\\s]/', '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 15: {'name': 'BREAK', 'pattern': {'value': '^\n', 'flags': [], 'raw': '/^\\n/', '_width': [1, 1], '__type__': 'PatternRE'}, 'priority': 100, '__type__': 'TerminalDef'}, 16: {'name': 'PHANTOMS', 'pattern': {'value': '( *:)+ *[^\\S\r\n]*\r?\n', 'flags': [], 'raw': None, '_width': [2, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 17: {'name': 'INDENT', 'pattern': {'value': ' +|\t+', 'flags': [], 'raw': '/ +|\\t+/', '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 10, '__type__': 'TerminalDef'}, 18: {'name': 'CARD', 'pattern': {'value': '(?![-_\\/])(\\w|\\?){2}(?=[ \t]*[^\\w,\r\n:])', 'flags': [], 'raw': '/(?![-_\\/])(\\w|\\?){2}(?=[ \\t]*[^\\w,\\r\\n:])/', '_width': [2, 2], '__type__': 'PatternRE'}, 'priority': 2, '__type__': 'TerminalDef'}, 19: {'name': 'LEG_ARROW', 'pattern': {'value': '[<>]', 'flags': [], 'raw': '/[<>]/', '_width': [1, 1], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 20: {'name': 'ID_GROUPS', 'pattern': {'value': '\\d+(?=_)', 'flags': [], 'raw': '/\\d+(?=_)/', '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 10, '__type__': 'TerminalDef'}, 21: {'name': 'ID_MARK', 'pattern': {'value': '_', 'flags': [], 'raw': '"_"', '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 22: {'name': 'MORETHAN', 'pattern': {'value': '(?:[^\\S\r\n]+)?>(?:[^\\S\r\n]+)?', 'flags': [], 'raw': None, '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 23: {'name': 'CONSTRAINT_NAME', 'pattern': {'value': '[^)]{1,3}', 'flags': [], 'raw': '/[^)]{1,3}/', '_width': [1, 3], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 24: {'name': 'CONSTRAINT_LEG', 'pattern': {'value': '<?(\\.+|-+)>?', 'flags': [], 'raw': '/<?(\\.+|-+)>?/', '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 25: {'name': 'INHERITANCE_NAME', 'pattern': {'value': '(XT\\d?|TX\\d?|X\\d?|T\\d?|\\d)', 'flags': [], 'raw': '/(XT\\d?|TX\\d?|X\\d?|T\\d?|\\d)/', '_width': [1, 3], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 26: {'name': 'INHERITANCE_ARROW', 'pattern': {'value': '<==?|<--?|--?>|==?>', 'flags': [], 'raw': '/<==?|<--?|--?>|==?>/', '_width': [2, 3], '__type__': 'PatternRE'}, 'priority': -10, '__type__': 'TerminalDef'}, 27: {'name': 'PLUS', 'pattern': {'value': '+', 'flags': [], 'raw': '"+"', '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 28: {'name': 'MINUS', 'pattern': {'value': '-', 'flags': [], 'raw': '"-"', '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 29: {'name': '__ANON_0', 'pattern': {'value': '[^\r\n\\]]+', 'flags': [], 'raw': '/[^\\r\\n\\]]+/', '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 30: {'name': '__ANON_1', 'pattern': {'value': '.*\r?\n', 'flags': [], 'raw': '/.*\\r?\\n/', '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 31: {'origin': {'name': Token('RULE', 'typed_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'attr', '__type__': 'NonTerminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'datatype', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 32: {'origin': {'name': Token('RULE', 'typed_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'attr', '__type__': 'NonTerminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 33: {'origin': {'name': Token('RULE', 'typed_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'attr', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 34: {'origin': {'name': Token('RULE', 'typed_attr'), '__type__': 'NonTerminal'}, 'expansion': [], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 35: {'origin': {'name': Token('RULE', 'datatype'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'note', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 36: {'origin': {'name': Token('RULE', 'box_def_prefix'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'PLUS', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 37: {'origin': {'name': Token('RULE', 'box_def_prefix'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'MINUS', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 38: {'origin': {'name': Token('RULE', 'note'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_0', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': True, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 39: {'origin': {'name': Token('RULE', 'start'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__start_star_0', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 40: {'origin': {'name': Token('RULE', 'start'), '__type__': 'NonTerminal'}, 'expansion': [], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 41: {'origin': {'name': Token('RULE', 'line'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'indent', '__type__': 'NonTerminal'}, {'name': 'phantoms', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 42: {'origin': {'name': Token('RULE', 'line'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'indent', '__type__': 'NonTerminal'}, {'name': 'comment', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 43: {'origin': {'name': Token('RULE', 'line'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'indent', '__type__': 'NonTerminal'}, {'name': 'clause', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 44: {'origin': {'name': Token('RULE', 'line'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'indent', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 45: {'origin': {'name': Token('RULE', 'line'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'phantoms', '__type__': 'NonTerminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 46: {'origin': {'name': Token('RULE', 'line'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'comment', '__type__': 'NonTerminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 47: {'origin': {'name': Token('RULE', 'line'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'clause', '__type__': 'NonTerminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 48: {'origin': {'name': Token('RULE', 'line'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 49: {'origin': {'name': Token('RULE', 'clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'assoc_clause', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': True, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 50: {'origin': {'name': Token('RULE', 'clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'entity_clause', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': True, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 51: {'origin': {'name': Token('RULE', 'clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'constraint_clause', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': True, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 52: {'origin': {'name': Token('RULE', 'clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'inheritance_clause', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': True, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 53: {'origin': {'name': Token('RULE', 'indent'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'INDENT', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 54: {'origin': {'name': Token('RULE', 'comment'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'PERCENT', 'filter_out': False, '__type__': 'Terminal'}, {'name': '__ANON_1', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 55: {'origin': {'name': Token('RULE', 'assoc_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'box_def_prefix', '__type__': 'NonTerminal'}, {'name': 'assoc_name_def', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{assoc_leg}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{assoc_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 56: {'origin': {'name': Token('RULE', 'assoc_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'box_def_prefix', '__type__': 'NonTerminal'}, {'name': 'assoc_name_def', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{assoc_leg}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 57: {'origin': {'name': Token('RULE', 'assoc_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'assoc_name_def', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{assoc_leg}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{assoc_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 58: {'origin': {'name': Token('RULE', 'assoc_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'assoc_name_def', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{assoc_leg}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 59: {'origin': {'name': Token('RULE', 'assoc_name_def'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'box_name', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 60: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'leg_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 61: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 62: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 63: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'leg_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 64: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 65: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 66: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'leg_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 67: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 68: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 8, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 69: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'leg_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 9, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 70: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 10, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 71: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_assoc_card', '__type__': 'NonTerminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 11, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 72: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'leg_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 12, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 73: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 13, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 74: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 14, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 75: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'leg_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 15, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 76: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 16, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 77: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'leg_arrow', '__type__': 'NonTerminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 17, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 78: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'leg_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 18, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 79: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 19, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 80: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 20, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 81: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'leg_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 21, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 82: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 22, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 83: {'origin': {'name': Token('RULE', 'assoc_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 23, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 84: {'origin': {'name': Token('RULE', '_assoc_card'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'card_hidden', '__type__': 'NonTerminal'}, {'name': 'card_prefix', '__type__': 'NonTerminal'}, {'name': 'card', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 85: {'origin': {'name': Token('RULE', '_assoc_card'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'card_hidden', '__type__': 'NonTerminal'}, {'name': 'card', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 86: {'origin': {'name': Token('RULE', '_assoc_card'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'card_prefix', '__type__': 'NonTerminal'}, {'name': 'card', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 87: {'origin': {'name': Token('RULE', '_assoc_card'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'card', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 88: {'origin': {'name': Token('RULE', 'entity_name_ref'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'box_name', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 89: {'origin': {'name': Token('RULE', 'card_hidden'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'MINUS', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 90: {'origin': {'name': Token('RULE', 'card_prefix'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'ID_MARK', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 91: {'origin': {'name': Token('RULE', 'card_prefix'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 92: {'origin': {'name': Token('RULE', 'leg_note'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'note', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 93: {'origin': {'name': Token('RULE', 'assoc_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'ID_MARK', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'typed_attr', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 94: {'origin': {'name': Token('RULE', 'assoc_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'typed_attr', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 95: {'origin': {'name': Token('RULE', 'entity_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'box_def_prefix', '__type__': 'NonTerminal'}, {'name': 'entity_name_def', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{entity_or_table_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 96: {'origin': {'name': Token('RULE', 'entity_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'box_def_prefix', '__type__': 'NonTerminal'}, {'name': 'entity_name_def', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 97: {'origin': {'name': Token('RULE', 'entity_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'entity_name_def', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{entity_or_table_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 98: {'origin': {'name': Token('RULE', 'entity_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'entity_name_def', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 99: {'origin': {'name': Token('RULE', 'entity_name_def'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'box_name', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 100: {'origin': {'name': Token('RULE', 'entity_or_table_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_id_symbols', '__type__': 'NonTerminal'}, {'name': 'typed_attr', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 101: {'origin': {'name': Token('RULE', 'entity_or_table_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_id_symbols', '__type__': 'NonTerminal'}, {'name': 'HASHTAG', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'foreign_reference', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 102: {'origin': {'name': Token('RULE', 'entity_or_table_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'typed_attr', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 103: {'origin': {'name': Token('RULE', 'entity_or_table_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'HASHTAG', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'foreign_reference', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 104: {'origin': {'name': Token('RULE', '_id_symbols'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'id_groups', '__type__': 'NonTerminal'}, {'name': 'id_mark', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 105: {'origin': {'name': Token('RULE', '_id_symbols'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'id_mark', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 106: {'origin': {'name': Token('RULE', 'foreign_reference'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'this_table_attr', '__type__': 'NonTerminal'}, {'name': 'MORETHAN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'that_table', '__type__': 'NonTerminal'}, {'name': 'MORETHAN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'that_table_attr', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 107: {'origin': {'name': Token('RULE', 'this_table_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'attr', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 108: {'origin': {'name': Token('RULE', 'that_table_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'attr', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 109: {'origin': {'name': Token('RULE', 'that_table'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 110: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 111: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 112: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 113: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 114: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 115: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 116: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 117: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 118: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 8, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 119: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 9, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 120: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 10, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 121: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_name', '__type__': 'NonTerminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 11, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 122: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 12, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 123: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 13, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 124: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 14, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 125: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_note', '__type__': 'NonTerminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 15, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 126: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 16, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 127: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 17, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 128: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 18, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 129: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'LBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACKET', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 19, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 130: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 20, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 131: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 21, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 132: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_coords', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 22, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 133: {'origin': {'name': Token('RULE', 'constraint_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'CONSTRAINT_RPAREN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 23, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 134: {'origin': {'name': Token('RULE', 'constraint_note'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'note', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 135: {'origin': {'name': Token('RULE', 'constraint_target'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'constraint_leg', '__type__': 'NonTerminal'}, {'name': '__constraint_target_star_1', '__type__': 'NonTerminal'}, {'name': 'box_name_ref', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 136: {'origin': {'name': Token('RULE', 'constraint_target'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'constraint_leg', '__type__': 'NonTerminal'}, {'name': 'box_name_ref', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 137: {'origin': {'name': Token('RULE', 'constraint_target'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__constraint_target_star_1', '__type__': 'NonTerminal'}, {'name': 'box_name_ref', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 138: {'origin': {'name': Token('RULE', 'constraint_target'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'box_name_ref', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 139: {'origin': {'name': Token('RULE', 'box_name_ref'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'box_name', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 140: {'origin': {'name': Token('RULE', 'constraint_coords'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '_constraint_coord', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': '_constraint_coord', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 141: {'origin': {'name': Token('RULE', '_constraint_coord'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'NUMBER', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 142: {'origin': {'name': Token('RULE', '_constraint_coord'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'box_name_ref', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 143: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 144: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 145: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 146: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 147: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 148: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 149: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 150: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 151: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 8, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 152: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 9, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 153: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 10, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 154: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 11, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 155: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 12, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 156: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 13, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 157: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 14, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 158: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_name', '__type__': 'NonTerminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 15, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 159: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 16, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 160: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 17, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 161: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 18, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 162: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 19, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 163: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 20, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 164: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 21, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 165: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 22, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 166: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 23, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 167: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 24, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 168: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 25, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 169: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 26, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 170: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 27, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 171: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 28, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 172: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 29, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 173: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 30, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 174: {'origin': {'name': Token('RULE', 'inheritance_clause'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'BACKSLASH', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_parent', '__type__': 'NonTerminal'}, {'name': 'inheritance_arrow', '__type__': 'NonTerminal'}, {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, {'name': 'NL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 31, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 175: {'origin': {'name': Token('RULE', 'inheritance_parent'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 176: {'origin': {'name': Token('RULE', 'inheritance_child'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'entity_name_ref', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 177: {'origin': {'name': Token('RULE', 'constraint_leg'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_LEG', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 178: {'origin': {'name': Token('RULE', 'card'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CARD', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 179: {'origin': {'name': Token('RULE', 'box_name'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'BOX_NAME', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 180: {'origin': {'name': Token('RULE', 'leg_arrow'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LEG_ARROW', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 181: {'origin': {'name': Token('RULE', 'phantoms'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'PHANTOMS', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 182: {'origin': {'name': Token('RULE', 'break_'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'BREAK', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 183: {'origin': {'name': Token('RULE', 'inheritance_name'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'INHERITANCE_NAME', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 184: {'origin': {'name': Token('RULE', 'constraint_name'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'CONSTRAINT_NAME', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 185: {'origin': {'name': Token('RULE', 'attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'ATTR', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 186: {'origin': {'name': Token('RULE', 'inheritance_arrow'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'INHERITANCE_ARROW', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 187: {'origin': {'name': Token('RULE', 'id_mark'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'ID_MARK', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 188: {'origin': {'name': Token('RULE', 'id_groups'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'ID_GROUPS', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 189: {'origin': {'name': 'seq{assoc_attr}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'assoc_attr', '__type__': 'NonTerminal'}, {'name': '__seq{assoc_attr}_star_2', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 190: {'origin': {'name': 'seq{assoc_attr}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'assoc_attr', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 191: {'origin': {'name': 'seq{assoc_leg}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'assoc_leg', '__type__': 'NonTerminal'}, {'name': '__seq{assoc_leg}_star_3', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 192: {'origin': {'name': 'seq{assoc_leg}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'assoc_leg', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 193: {'origin': {'name': 'seq{entity_or_table_attr}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'entity_or_table_attr', '__type__': 'NonTerminal'}, {'name': '__seq{entity_or_table_attr}_star_4', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 194: {'origin': {'name': 'seq{entity_or_table_attr}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'entity_or_table_attr', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 195: {'origin': {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'constraint_target', '__type__': 'NonTerminal'}, {'name': '__seq{constraint_target}_star_5', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 196: {'origin': {'name': 'seq{constraint_target}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'constraint_target', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 197: {'origin': {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'typed_attr', '__type__': 'NonTerminal'}, {'name': '__seq{typed_attr}_star_6', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 198: {'origin': {'name': 'seq{typed_attr}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'typed_attr', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 199: {'origin': {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'inheritance_child', '__type__': 'NonTerminal'}, {'name': '__seq{inheritance_child}_star_7', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 200: {'origin': {'name': 'seq{inheritance_child}', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'inheritance_child', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': Token('RULE', 'seq'), 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 201: {'origin': {'name': '__start_star_0', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'break_', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 202: {'origin': {'name': '__start_star_0', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'line', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 203: {'origin': {'name': '__start_star_0', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__start_star_0', '__type__': 'NonTerminal'}, {'name': 'break_', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 204: {'origin': {'name': '__start_star_0', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__start_star_0', '__type__': 'NonTerminal'}, {'name': 'line', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 205: {'origin': {'name': '__constraint_target_star_1', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 206: {'origin': {'name': '__constraint_target_star_1', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__constraint_target_star_1', '__type__': 'NonTerminal'}, {'name': 'SP', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 207: {'origin': {'name': '__seq{assoc_attr}_star_2', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'assoc_attr', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 208: {'origin': {'name': '__seq{assoc_attr}_star_2', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__seq{assoc_attr}_star_2', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'assoc_attr', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 209: {'origin': {'name': '__seq{assoc_leg}_star_3', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'assoc_leg', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 210: {'origin': {'name': '__seq{assoc_leg}_star_3', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__seq{assoc_leg}_star_3', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'assoc_leg', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 211: {'origin': {'name': '__seq{entity_or_table_attr}_star_4', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_or_table_attr', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 212: {'origin': {'name': '__seq{entity_or_table_attr}_star_4', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__seq{entity_or_table_attr}_star_4', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'entity_or_table_attr', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 213: {'origin': {'name': '__seq{constraint_target}_star_5', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_target', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 214: {'origin': {'name': '__seq{constraint_target}_star_5', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__seq{constraint_target}_star_5', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'constraint_target', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 215: {'origin': {'name': '__seq{typed_attr}_star_6', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'typed_attr', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 216: {'origin': {'name': '__seq{typed_attr}_star_6', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__seq{typed_attr}_star_6', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'typed_attr', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 217: {'origin': {'name': '__seq{inheritance_child}_star_7', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_child', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 218: {'origin': {'name': '__seq{inheritance_child}_star_7', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__seq{inheritance_child}_star_7', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'inheritance_child', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}}
)
Shift = 0
Reduce = 1
def Lark_StandAlone(**kwargs):
  return Lark._load_from_dict(DATA, MEMO, **kwargs)
